/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.engine.pojo.OrgInfo;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;

public class AddressProcedure {
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date time;
    private String entityNumber;
    private String businessKey;
    private String billNo;
    private List<AlternativeProcess> alternativeProcesses;
    private AlternativeProcess enteredProcess;
    private String operate;
    private Boolean addressByOrgStatus;
    private Boolean findTheOnlyProcessStatus;
    private Long orgId;
    private List<Long> parentOrgIds;
    private Boolean allowNextParticipant = Boolean.FALSE;
    private Boolean unwanted = Boolean.FALSE;

    public AddressProcedure(String businessKey, String operate, DynamicObject bill, String entityNumber) {
        this.time = new Date(System.currentTimeMillis());
        this.businessKey = businessKey;
        this.operate = operate;
        this.entityNumber = entityNumber;
        if (bill.containsProperty("billno")) {
            this.billNo = bill.getString("billno");
        }
    }

    public void setItemsOrgName(List<OrgInfo> infos) {
        if (this.alternativeProcesses == null || this.alternativeProcesses.isEmpty() || infos == null || infos.isEmpty()) {
            return;
        }
        Map<Long, OrgInfo> orgInfoMap = infos.stream().collect(Collectors.toMap(OrgInfo::getId, item -> item));
        for (AlternativeProcess item2 : this.alternativeProcesses) {
            OrgInfo orgInfo = orgInfoMap.getOrDefault(item2.getOrgId(), new OrgInfo());
            item2.setOrgNumber(orgInfo.getNumber());
            item2.setOrgName(orgInfo.getName());
        }
    }

    public static boolean emptyData(AddressProcedure addressProcedure) {
        if (addressProcedure == null) {
            return true;
        }
        AlternativeProcess enteredProcess = addressProcedure.getEnteredProcess();
        List<AlternativeProcess> alternativeProcesses = addressProcedure.getAlternativeProcesses();
        boolean notEntered = enteredProcess == null || enteredProcess.isEmpty();
        boolean notAddressed = alternativeProcesses == null || alternativeProcesses.isEmpty();
        return notEntered && notAddressed;
    }

    public AddressProcedure() {
    }

    public List<Long> getParentOrgIds() {
        return this.parentOrgIds;
    }

    public void setParentOrgIds(List<Long> parentOrgIds) {
        this.parentOrgIds = parentOrgIds;
    }

    public Boolean getAllowNextParticipant() {
        return this.allowNextParticipant;
    }

    public void setAllowNextParticipant(Boolean allowNextParticipant) {
        this.allowNextParticipant = allowNextParticipant;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public Boolean getUnwanted() {
        return this.unwanted;
    }

    public AddressProcedure setUnwanted(Boolean unwanted) {
        this.unwanted = unwanted;
        return this;
    }

    public List<AlternativeProcess> getAlternativeProcesses() {
        return this.alternativeProcesses;
    }

    public void setAlternativeProcesses(List<AlternativeProcess> alternativeProcesses) {
        this.alternativeProcesses = alternativeProcesses;
    }

    public AlternativeProcess getEnteredProcess() {
        return this.enteredProcess;
    }

    public void setEnteredProcess(AlternativeProcess enteredProcess) {
        this.enteredProcess = enteredProcess;
    }

    public String getOperate() {
        return this.operate;
    }

    public void setOperate(String operate) {
        this.operate = operate;
    }

    public Boolean getAddressByOrgStatus() {
        return this.addressByOrgStatus;
    }

    public void setAddressByOrgStatus(Boolean addressByOrgStatus) {
        this.addressByOrgStatus = addressByOrgStatus;
    }

    public Boolean getFindTheOnlyProcessStatus() {
        return this.findTheOnlyProcessStatus;
    }

    public void setFindTheOnlyProcessStatus(Boolean findTheOnlyProcessStatus) {
        this.findTheOnlyProcessStatus = findTheOnlyProcessStatus;
    }

    public String toString() {
        return "AddressProcedure{time=" + this.time + ", entityNumber='" + this.entityNumber + '\'' + ", businessKey='" + this.businessKey + '\'' + ", billNo='" + this.billNo + '\'' + ", alternativeProcesses=" + this.alternativeProcesses + ", enteredProcess=" + this.enteredProcess + ", operate='" + this.operate + '\'' + ", addressByOrgStatus=" + this.addressByOrgStatus + ", findTheOnlyProcessStatus=" + this.findTheOnlyProcessStatus + ", orgId=" + this.orgId + ", parentOrgIds=" + this.parentOrgIds + ", allowNextParticipant=" + this.allowNextParticipant + ", unwanted=" + this.unwanted + '}';
    }
}

