/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Joiner;
import de.odysseus.el.context.WFElContext;
import java.util.List;
import javax.el.ELContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.FormatParsedConditionUtil;
import kd.bos.workflow.engine.pojo.LocalStringDeserializer;

public class SchemePathItem {
    private Long schemeId;
    private String schemeCondition;
    private String parsedCondition;
    private Boolean conditionStatus;
    private Boolean defaultScheme;
    private String showText;
    @JsonDeserialize(using=LocalStringDeserializer.class)
    private ILocaleString name;

    public SchemePathItem(DynamicConfigSchemeEntity tmp) {
        this.schemeId = tmp.getSchemeId();
        this.schemeCondition = tmp.getConditionExpression();
        this.showText = tmp.getConditionText().toString();
        boolean acquiescence = tmp.isAcquiescence();
        if (acquiescence) {
            this.defaultScheme = true;
            this.conditionStatus = true;
        } else {
            this.defaultScheme = false;
        }
        this.name = tmp.getName();
    }

    public SchemePathItem() {
    }

    public void setParsedCondition(VariableScope scope) {
        if (scope == null) {
            return;
        }
        if (!(scope instanceof BusinessModelVariableScope)) {
            return;
        }
        BusinessModelVariableScope bizScope = (BusinessModelVariableScope)scope;
        ELContext cachedElContext = bizScope.getCachedElContext();
        if (cachedElContext == null) {
            return;
        }
        if (!(cachedElContext instanceof WFElContext)) {
            return;
        }
        WFElContext wfElContext = (WFElContext)cachedElContext;
        this.parsedCondition = Joiner.on((String)"\n").join((Iterable)wfElContext.getLogMsg());
    }

    public ILocaleString getName() {
        return this.name;
    }

    public void setName(ILocaleString name) {
        this.name = name;
    }

    public Boolean getDefaultScheme() {
        return this.defaultScheme;
    }

    public void setDefaultScheme(Boolean defaultScheme) {
        this.defaultScheme = defaultScheme;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getSchemeCondition() {
        return this.schemeCondition;
    }

    public String getShowText() {
        return this.showText;
    }

    public SchemePathItem setShowText(String showText) {
        this.showText = showText;
        return this;
    }

    public void setSchemeCondition(String schemeCondition) {
        this.schemeCondition = schemeCondition;
    }

    public String getParsedCondition() {
        return this.parsedCondition;
    }

    @JsonIgnore
    public String getFormatParsedCondition() {
        List<String> strings = FormatParsedConditionUtil.format(this.parsedCondition);
        if (strings.isEmpty()) {
            return this.getParsedCondition();
        }
        return Joiner.on((String)"\n").join(strings);
    }

    public void setParsedCondition(String parsedCondition) {
        this.parsedCondition = parsedCondition;
    }

    public Boolean getConditionStatus() {
        return this.conditionStatus;
    }

    public void setConditionStatus(Boolean conditionStatus) {
        this.conditionStatus = conditionStatus;
    }

    public String toString() {
        return "SchemePathItem{schemeId=" + this.schemeId + ", schemeCondition='" + this.schemeCondition + '\'' + ", parsedCondition='" + this.parsedCondition + '\'' + ", conditionStatus=" + this.conditionStatus + ", defaultScheme=" + this.defaultScheme + ", showText='" + this.showText + '\'' + ", name=" + this.name + '}';
    }
}

