/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.pojo.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import de.odysseus.el.context.WFElContext;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.model.ProcessDefinitionStartInfo;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.FormatParsedConditionUtil;
import kd.bos.workflow.engine.pojo.ParentProcess;
import kd.bos.workflow.engine.pojo.SchemePathItem;

public class AlternativeProcess {
    private Long processDefinitionId;
    private String processKey;
    private String startCondition;
    private String parsedCondition;
    private String conditionShowText;
    private Boolean startConditionStatus;
    private ModelType processType;
    private Boolean subProcessStatus;
    private ParentProcess parentProcess;
    private Long orgId;
    private String orgName;
    private String OrgNumber;
    private String number;
    private String version;
    private List<SchemePathItem> schemePathItemList;
    private SchemePathItem targetScheme;
    public static final AlternativeProcess EMPTY = new AlternativeProcess();

    public AlternativeProcess setBy(ProcessDefinitionStartInfo info) {
        this.processDefinitionId = info.getId();
        this.processType = ModelType.AuditFlow;
        for (ModelType value : ModelType.values()) {
            if (!value.name().equals(info.getProcessType())) continue;
            this.processType = value;
        }
        this.orgId = info.getOrgId();
        this.startCondition = info.getStartCondition();
        this.number = info.getNumber();
        this.version = info.getVersion();
        return this;
    }

    public static AlternativeProcess build(ProcessDefinitionStartInfo info) {
        AlternativeProcess result = new AlternativeProcess();
        if (info == null) {
            return result;
        }
        result.setProcessKey(info.getNumber());
        result.setProcessDefinitionId(info.getId());
        result.setProcessType(ModelType.AuditFlow);
        for (ModelType value : ModelType.values()) {
            if (!value.name().equals(info.getProcessType())) continue;
            result.setProcessType(value);
        }
        result.setOrgId(info.getOrgId());
        result.setStartCondition(info.getStartCondition());
        result.setNumber(info.getNumber());
        result.setVersion(info.getVersion());
        return result;
    }

    public static AlternativeProcess build(ProcessDefinitionEntity entity) {
        AlternativeProcess result = new AlternativeProcess();
        if (entity == null) {
            return result;
        }
        result.setProcessKey(entity.getKey());
        result.setProcessType(ModelType.AuditFlow);
        for (ModelType value : ModelType.values()) {
            if (!value.name().equals(entity.getType())) continue;
            result.setProcessType(value);
        }
        result.setOrgId(entity.getOrgUnitId());
        result.setSubProcessStatus(true);
        result.setNumber(entity.getKey());
        result.setVersion(entity.getVersion());
        result.setProcessDefinitionId(entity.getId());
        return result;
    }

    public ParentProcess getParentProcess() {
        return this.parentProcess;
    }

    public void setParentProcess(Map<String, Object> variables) {
        this.parentProcess = ParentProcess.build(variables);
    }

    @JsonIgnore
    public String getFormatParsedCondition() {
        List<String> strings = FormatParsedConditionUtil.format(this.parsedCondition);
        if (strings.isEmpty()) {
            return this.getParsedCondition();
        }
        return Joiner.on((String)"\n").join(strings);
    }

    public List<SchemePathItem> getSchemePathItemList() {
        return this.schemePathItemList;
    }

    public AlternativeProcess setSchemePathItemList(List<SchemePathItem> schemePathItemList) {
        this.schemePathItemList = schemePathItemList;
        return this;
    }

    public SchemePathItem getTargetScheme() {
        return this.targetScheme;
    }

    public AlternativeProcess setTargetScheme(SchemePathItem targetScheme) {
        this.targetScheme = targetScheme;
        return this;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @JsonIgnore
    public String getProcessName() {
        return this.number + "/" + this.version;
    }

    @JsonIgnore
    public String getProcessNameWithScheme() {
        String processName = this.number + "/" + this.version + "/";
        if (this.targetScheme != null && this.targetScheme.getName() != null) {
            processName = processName + this.targetScheme.getName().toString();
        } else {
            String tips = ResManager.loadKDString((String)"%s\u9ed8\u8ba4\u65b9\u6848", (String)"CreateDynamicConfigSchemeCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            processName = String.format(tips, processName);
        }
        return processName;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(Long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(String startCondition) {
        this.startCondition = startCondition;
    }

    public String getParsedCondition() {
        return this.parsedCondition;
    }

    public void setParsedCondition(String parsedCondition) {
        this.parsedCondition = parsedCondition;
    }

    public void setParsedCondition(BusinessModelVariableScope bizScope) {
        if (bizScope == null) {
            return;
        }
        ELContext cachedElContext = bizScope.getCachedElContext();
        if (cachedElContext == null) {
            return;
        }
        if (!(cachedElContext instanceof WFElContext)) {
            return;
        }
        WFElContext wfElContext = (WFElContext)cachedElContext;
        List logMsg = wfElContext.getLogMsg();
        if (logMsg == null || logMsg.isEmpty()) {
            return;
        }
        this.parsedCondition = (String)logMsg.get(0);
    }

    public Boolean getStartConditionStatus() {
        return this.startConditionStatus;
    }

    public void setStartConditionStatus(Boolean startConditionStatus) {
        this.startConditionStatus = startConditionStatus;
    }

    public ModelType getProcessType() {
        return this.processType;
    }

    public void setProcessType(ModelType processType) {
        this.processType = processType;
    }

    public String getConditionShowText() {
        return this.conditionShowText;
    }

    public AlternativeProcess setConditionShowText(String conditionShowText) {
        this.conditionShowText = conditionShowText;
        return this;
    }

    @JsonSetter
    public AlternativeProcess setParentProcess(ParentProcess parentProcess) {
        this.parentProcess = parentProcess;
        return this;
    }

    public Boolean getSubProcessStatus() {
        return this.subProcessStatus;
    }

    public void setSubProcessStatus(Boolean subProcessStatus) {
        this.subProcessStatus = subProcessStatus;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public String getOrgNumber() {
        return this.OrgNumber;
    }

    public AlternativeProcess setOrgNumber(String orgNumber) {
        this.OrgNumber = orgNumber;
        return this;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getProcessKey() {
        return this.processKey;
    }

    public void setProcessKey(String processKey) {
        this.processKey = processKey;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    public String toString() {
        return "AlternativeProcess{processDefinitionId=" + this.processDefinitionId + ", processKey='" + this.processKey + '\'' + ", startCondition='" + this.startCondition + '\'' + ", parsedCondition='" + this.parsedCondition + '\'' + ", conditionShowText='" + this.conditionShowText + '\'' + ", startConditionStatus=" + this.startConditionStatus + ", processType=" + (Object)((Object)this.processType) + ", subProcessStatus=" + this.subProcessStatus + ", parentProcess=" + this.parentProcess + ", orgId=" + this.orgId + ", orgName='" + this.orgName + '\'' + ", OrgNumber='" + this.OrgNumber + '\'' + ", number='" + this.number + '\'' + ", version='" + this.version + '\'' + ", schemePathItemList=" + this.schemePathItemList + ", targetScheme=" + this.targetScheme + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlternativeProcess)) {
            return false;
        }
        AlternativeProcess that = (AlternativeProcess)o;
        return Objects.equal((Object)this.getProcessDefinitionId(), (Object)that.getProcessDefinitionId()) && Objects.equal((Object)this.getProcessKey(), (Object)that.getProcessKey()) && Objects.equal((Object)this.getStartCondition(), (Object)that.getStartCondition()) && Objects.equal((Object)this.getParsedCondition(), (Object)that.getParsedCondition()) && Objects.equal((Object)this.getConditionShowText(), (Object)that.getConditionShowText()) && Objects.equal((Object)this.getStartConditionStatus(), (Object)that.getStartConditionStatus()) && this.getProcessType() == that.getProcessType() && Objects.equal((Object)this.getSubProcessStatus(), (Object)that.getSubProcessStatus()) && Objects.equal((Object)this.getParentProcess(), (Object)that.getParentProcess()) && Objects.equal((Object)this.getOrgId(), (Object)that.getOrgId()) && Objects.equal((Object)this.getOrgName(), (Object)that.getOrgName()) && Objects.equal((Object)this.getOrgNumber(), (Object)that.getOrgNumber()) && Objects.equal((Object)this.getNumber(), (Object)that.getNumber()) && Objects.equal((Object)this.getVersion(), (Object)that.getVersion()) && Objects.equal(this.getSchemePathItemList(), that.getSchemePathItemList()) && Objects.equal((Object)this.getTargetScheme(), (Object)that.getTargetScheme());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getProcessDefinitionId(), this.getProcessKey(), this.getStartCondition(), this.getParsedCondition(), this.getConditionShowText(), this.getStartConditionStatus(), this.getProcessType(), this.getSubProcessStatus(), this.getParentProcess(), this.getOrgId(), this.getOrgName(), this.getOrgNumber(), this.getNumber(), this.getVersion(), this.getSchemePathItemList(), this.getTargetScheme()});
    }
}

