/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.ext.IExtExpressionParse;
import kd.bos.workflow.exception.WFErrorCode;

public abstract class AbstractOrgParseImpl
implements IExtExpressionParse {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected static final String ID = "id";
    protected static final String COMMA = ",";

    public Object parseExpression(AgentExecution execution, Object param) {
        if (param == null) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        if (param instanceof Long) {
            orgIds.add((Long)param);
        } else if (param instanceof DynamicObject) {
            orgIds.add(((DynamicObject)param).getLong(ID));
        } else if (param instanceof DynamicObjectCollection) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)param;
            orgs.forEach(org -> orgIds.add(org.getLong(ID)));
        } else if (param instanceof String) {
            if (WfUtils.isNotEmptyString(param)) {
                try {
                    String orgIdTmp = param.toString();
                    if (orgIdTmp.contains(COMMA)) {
                        String[] orgIdTmps = orgIdTmp.split(COMMA);
                        Arrays.stream(orgIdTmps).filter(WfUtils::isNotEmpty).forEach(id -> orgIds.add(Long.valueOf(id)));
                    }
                    orgIds.add(Long.valueOf(orgIdTmp));
                }
                catch (Exception e) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u5c5e\u4e8e\u7ec4\u7ec7\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u4f20\u5165\u7528\u6237ID\u4e0d\u80fd\u8f6c\u5316\u4e3a\u6b63\u786e\u7684Long\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BSOrgParseImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
        } else if (param instanceof List) {
            List params = (List)param;
            if (WfUtils.isEmptyForCollection(params)) {
                return null;
            }
            Object object = params.get(0);
            if (object instanceof DynamicObject) {
                params.forEach(p -> orgIds.add(((DynamicObject)p).getLong(ID)));
            } else if (object instanceof DynamicObjectCollection) {
                params.forEach(collect -> ((DynamicObjectCollection)collect).forEach(p -> orgIds.add(p.getLong(ID))));
            }
        } else {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u5c5e\u4e8e\u7ec4\u7ec7\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BSOrgParseImpl_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        Object result = this.getOrgIds("01", orgIds);
        return result;
    }

    protected abstract Object getOrgIds(String var1, List var2);
}

