/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.ext;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.ext.IExtExpressionParse;
import kd.bos.workflow.engine.rule.ext.OrgRelationUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class ManagerRoleImpl
implements IExtExpressionParse {
    private Log log = LogFactory.getLog(this.getClass());

    public Object parseExpression(AgentExecution execution, Object param) {
        Long orgId;
        if (param == null) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (param instanceof Long) {
            orgId = (Long)param;
            orgIds.add(orgId);
        } else if (param instanceof DynamicObject) {
            DynamicObject dynObj = (DynamicObject)param;
            Long orgId2 = dynObj.getLong("id");
            orgIds.add(orgId2);
        } else if (param instanceof String) {
            if (WfUtils.isNotEmptyString(param)) {
                try {
                    if (param.toString().contains(",")) {
                        String[] oidArr = param.toString().split(",");
                        for (int i = 0; i < oidArr.length; ++i) {
                            if (!WfUtils.isNotEmpty(oidArr[i])) continue;
                            orgIds.add(Long.parseLong(oidArr[i]));
                        }
                    }
                    orgId = Long.valueOf((String)param);
                    orgIds.add(orgId);
                }
                catch (Exception e) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u8d1f\u8d23\u4eba\u5de5\u4f5c\u6d41\u89d2\u8272\u89e3\u6790\u9519\u8bef\uff0c\u4f20\u5165\u7ec4\u7ec7ID\u201c%s\u201d\u4e0d\u80fd\u8f6c\u5316\u4e3a\u6b63\u786e\u7684Long\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManagerRoleImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), param)});
                }
            }
        } else if (param instanceof DynamicObjectCollection) {
            DynamicObjectCollection users = (DynamicObjectCollection)param;
            if (users != null) {
                for (int i = 0; i < users.size(); ++i) {
                    orgIds.add(((DynamicObject)users.get(i)).getLong("id"));
                }
            }
        } else if (param instanceof List) {
            if (((List)param).isEmpty()) {
                return null;
            }
            if (((List)param).get(0) instanceof DynamicObject) {
                for (DynamicObject d : (List)param) {
                    orgIds.add(d.getLong("id"));
                }
            } else if (((List)param).get(0) instanceof DynamicObjectCollection) {
                for (DynamicObjectCollection collection : (List)param) {
                    for (DynamicObject i : collection) {
                        orgIds.add(i.getLong("id"));
                    }
                }
            }
        } else {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u7ec4\u7ec7ID\u3002\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ManagerRoleImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        String resultForHelper = "";
        ArrayList userIds = new ArrayList();
        if (!orgIds.isEmpty()) {
            for (Long orgId3 : orgIds) {
                ArrayList ud = new ArrayList();
                resultForHelper = UserServiceHelper.getPerson((long)orgId3, (long)0L, (PersonQueryType)PersonQueryType.MANAGER_OF_ORG, ud);
                if (ud.isEmpty()) continue;
                userIds.addAll(ud);
            }
        }
        String ret = "";
        StringBuilder result = new StringBuilder();
        if (!userIds.isEmpty()) {
            for (Long id : userIds) {
                String role = OrgRelationUtil.getWfRoleIdByUid(id);
                if (!WfUtils.isNotEmpty(role)) continue;
                result.append(role).append(",");
            }
            if (result.length() > 1 && result.toString().endsWith(",")) {
                ret = result.substring(0, result.length() - 1);
            }
        }
        this.log.debug(String.format("ManagerRoleImpl resultForHelper[%s]:orgId[%s],userIds[%s],ret[%s]", resultForHelper, WfUtils.listToString(orgIds, ","), WfUtils.listToString(userIds, ","), ret));
        return ret;
    }
}

