/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.ext;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.org.model.OrgQueryType;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.ext.IExtExpressionParse;
import kd.bos.workflow.exception.WFErrorCode;

public class OrgParseImpl
implements IExtExpressionParse {
    public Object parseExpression(AgentExecution execution, Object param) {
        String result = null;
        if (param instanceof Long) {
            Long uid = (Long)param;
            result = this.getOrgIdsByUid(uid);
        } else if (param instanceof DynamicObject) {
            DynamicObject dynObj = (DynamicObject)param;
            Long uid = dynObj.getLong("id");
            result = this.getOrgIdsByUid(uid);
        } else if (param instanceof DynamicObjectCollection) {
            DynamicObjectCollection users = (DynamicObjectCollection)param;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < users.size(); ++i) {
                String orgIds = this.getOrgIdsByUid(((DynamicObject)users.get(i)).getLong("id"));
                if (!WfUtils.isNotEmpty(orgIds)) continue;
                sb.append(",").append(orgIds);
            }
            if (sb.length() > 1) {
                result = sb.substring(1);
            }
        } else if (param instanceof String) {
            if (WfUtils.isNotEmptyString(param)) {
                try {
                    if (param.toString().contains(",")) {
                        String[] uidArr = param.toString().split(",");
                        for (int i = 0; i < uidArr.length; ++i) {
                            if (!WfUtils.isNotEmpty(uidArr[i])) continue;
                            String t = this.getOrgIdsByUid(Long.parseLong(uidArr[i]));
                            result = WfUtils.isNotEmptyString(result) && WfUtils.isNotEmpty(t) ? result + "," + t : t;
                        }
                    }
                    Long uid = Long.parseLong(param.toString());
                    result = this.getOrgIdsByUid(uid);
                }
                catch (Exception e) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u5c5e\u4e8e\u7ec4\u7ec7\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u4f20\u5165\u7528\u6237ID\u4e0d\u80fd\u8f6c\u5316\u4e3a\u6b63\u786e\u7684Long\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgParseImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
        } else if (param instanceof List) {
            if (((List)param).isEmpty()) {
                return null;
            }
            if (((List)param).get(0) instanceof DynamicObject) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject d : (List)param) {
                    String orgIds = this.getOrgIdsByUid(d.getLong("id"));
                    if (!WfUtils.isNotEmpty(orgIds)) continue;
                    sb.append(",").append(orgIds);
                }
                if (sb.length() > 1) {
                    result = sb.substring(1);
                }
            } else if (((List)param).get(0) instanceof DynamicObjectCollection) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObjectCollection collection : (List)param) {
                    for (DynamicObject i : collection) {
                        String orgIds = this.getOrgIdsByUid(i.getLong("id"));
                        if (!WfUtils.isNotEmpty(orgIds)) continue;
                        sb.append(",").append(orgIds);
                    }
                }
                if (sb.length() > 1) {
                    result = sb.substring(1);
                }
            }
        } else {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u5c5e\u4e8e\u7ec4\u7ec7\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgParseImpl_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return result;
    }

    private String getOrgIdsByUid(Long uid) {
        String orgIds = null;
        ArrayList<Long> resultList = new ArrayList<Long>();
        Long orgId = 0L;
        OrgUnitServiceHelper.getOrg((long)orgId, (long)uid, (OrgQueryType)OrgQueryType.SUPERIOR_OF_USER_MAIN_JOB, resultList);
        resultList.sort(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return (int)(o1 - o2);
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Long i : resultList) {
            sb.append(i).append(',');
        }
        if (sb.length() > 0) {
            orgIds = sb.substring(0, sb.length() - 1);
        }
        return orgIds;
    }
}

