/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.ext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.rule.ext.IExtExpressionParse;
import kd.bos.workflow.exception.WFErrorCode;

public class ProcUserNameParseImpl
implements IExtExpressionParse {
    public Object parseExpression(AgentExecution execution, Object param) {
        QFilter[] filterUsers;
        String selectFileds;
        Map userInfo;
        Object userName;
        String result = null;
        String lang = this.getLang(execution);
        if (param == null) {
            return null;
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (param instanceof Long) {
            userIds.add((Long)param);
        } else if (param instanceof DynamicObject) {
            result = this.getNameByDynamicObject((DynamicObject)param, userIds, lang);
        } else if (param instanceof DynamicObjectCollection) {
            DynamicObjectCollection users = (DynamicObjectCollection)param;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < users.size(); ++i) {
                userName = this.getNameByDynamicObject((DynamicObject)users.get(i), userIds, lang);
                if (!WfUtils.isNotEmpty((String)userName)) continue;
                sb.append(',').append((String)userName);
            }
            if (sb.length() > 1) {
                result = sb.substring(1);
            }
        } else if (param instanceof String) {
            if (WfUtils.isNotEmptyString(param)) {
                try {
                    String paramStr = param.toString();
                    if (paramStr.contains(",")) {
                        String[] uidArr = paramStr.split(",");
                        for (int i = 0; i < uidArr.length; ++i) {
                            if (!WfUtils.isNotEmpty((String)uidArr[i])) continue;
                            userIds.add(Long.valueOf((String)uidArr[i]));
                        }
                    }
                    userIds.add(Long.valueOf(paramStr));
                }
                catch (Exception e) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"ProcUserNameParseImpl\u89e3\u6790\u51fa\u9519\uff0c\u53c2\u6570\u201c%s\u201d\u3002", (String)"ProcUserNameParseImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), param)});
                }
            }
        } else if (param instanceof List) {
            StringBuilder sb;
            if (((List)param).isEmpty()) {
                return null;
            }
            if (((List)param).get(0) instanceof DynamicObject) {
                sb = new StringBuilder();
                for (DynamicObject d : (List)param) {
                    userName = this.getNameByDynamicObject(d, userIds, lang);
                    if (!WfUtils.isNotEmpty((String)userName)) continue;
                    sb.append(',').append((String)userName);
                }
                if (sb.length() > 1) {
                    result = sb.substring(1);
                }
            } else if (((List)param).get(0) instanceof DynamicObjectCollection) {
                sb = new StringBuilder();
                for (DynamicObjectCollection collection : (List)param) {
                    for (DynamicObject d : collection) {
                        String userName2 = this.getNameByDynamicObject(d, userIds, lang);
                        if (!WfUtils.isNotEmpty(userName2)) continue;
                        sb.append(',').append(userName2);
                    }
                }
                if (sb.length() > 1) {
                    result = sb.substring(1);
                }
            }
        } else {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"ProcUserNameParseImpl\u89e3\u6790\u51fa\u9519\uff0c\u53c2\u6570\u201c%s\u201d\u3002", (String)"ProcUserNameParseImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), param)});
        }
        if (userIds.size() > 0 && (userInfo = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)(selectFileds = "id,name"), (QFilter[])(filterUsers = new QFilter[]{new QFilter("id", "in", userIds)}))) != null && userInfo.size() > 0) {
            StringBuilder names = new StringBuilder();
            for (DynamicObject obj : userInfo.values()) {
                String userName3 = WfMultiLangUtils.getCurrentLang(obj.getLocaleString("name"), lang);
                if (!WfUtils.isNotEmpty(userName3)) continue;
                names.append(',').append(userName3);
            }
            String re = names.toString();
            result = WfUtils.isNotEmpty(result) ? result + re : re.substring(1);
        }
        return result;
    }

    private String getNameByDynamicObject(DynamicObject dynamicObject, List<Long> userIds, String lang) {
        ILocaleString tmp = dynamicObject.getLocaleString("name");
        if (tmp != null) {
            return WfMultiLangUtils.getCurrentLang(tmp, lang);
        }
        userIds.add(dynamicObject.getLong("id"));
        return "";
    }

    private String getLang(AgentExecution execution) {
        String var;
        String lang = Optional.ofNullable(RequestContext.get()).map(RequestContext::getLang).map(Enum::toString).orElseGet(() -> Lang.zh_CN.toString());
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return lang;
        }
        Object o = Optional.ofNullable(execution).map(e -> e.getVariable("Lang")).orElseGet(Object::new);
        if (o instanceof String) {
            return (String)o;
        }
        if (execution.getCurrentTask() != null && WfUtils.isNotEmpty(var = (String)execution.getCurrentTask().getVariable("lang"))) {
            return var;
        }
        return lang;
    }

    private String getUserName(Long userId, String lang) {
        User user = WfUtils.findUserById(userId);
        if (user == null) {
            return "";
        }
        ILocaleString name = user.getName();
        if (name == null) {
            return "";
        }
        String nameItem = (String)name.getItem(lang);
        if (nameItem == null) {
            return "";
        }
        String localeValue = name.getLocaleValue();
        if (localeValue == null) {
            return "";
        }
        return localeValue;
    }
}

