/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.ext;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.ext.IExtExpressionParse;
import kd.bos.workflow.exception.WFErrorCode;

public class UserManagerImpl
implements IExtExpressionParse {
    protected Log log = LogFactory.getLog(this.getClass());

    public Object parseExpression(AgentExecution execution, Object param) {
        if (param == null) {
            return null;
        }
        ArrayList<Long> userId = new ArrayList<Long>();
        if (param instanceof Long) {
            userId.add((Long)param);
        } else if (param instanceof DynamicObject) {
            DynamicObject dynObj = (DynamicObject)param;
            Long val = dynObj.getLong("id");
            if (WfUtils.isNotEmpty(val)) {
                userId.add(val);
            } else {
                this.log.debug("no userId in dynamicObject");
            }
        } else if (param instanceof DynamicObjectCollection) {
            DynamicObjectCollection users = (DynamicObjectCollection)param;
            for (int i = 0; i < users.size(); ++i) {
                Long tmp = ((DynamicObject)users.get(i)).getLong("id");
                if (!WfUtils.isNotEmpty(tmp)) continue;
                userId.add(tmp);
            }
        } else if (param instanceof String) {
            if (WfUtils.isNotEmptyString(param)) {
                try {
                    String paramStr = param.toString();
                    if (paramStr.contains(",")) {
                        String[] uidArr = paramStr.split(",");
                        for (int i = 0; i < uidArr.length; ++i) {
                            if (!WfUtils.isNotEmpty(uidArr[i])) continue;
                            userId.add(Long.valueOf(uidArr[i]));
                        }
                    }
                    Long uid = Long.valueOf(paramStr);
                    userId.add(uid);
                }
                catch (Exception e) {
                    StringBuilder s = new StringBuilder();
                    s.append(String.format(ResManager.loadKDString((String)"\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u4f20\u5165\u7528\u6237ID\u4e0d\u80fd\u8f6c\u5316\u4e3a\u6b63\u786e\u7684Long\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\uff0cparam\uff1a%s\u3002", (String)"UserManagerImpl_1", (String)"bos-wf-engine", (Object[])new Object[0]), param));
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{s});
                }
            }
        } else if (param instanceof List) {
            if (((List)param).isEmpty()) {
                return "";
            }
            if (((List)param).get(0) instanceof DynamicObject) {
                for (DynamicObject d : (List)param) {
                    Long tmp = d.getLong("id");
                    if (!WfUtils.isNotEmpty(tmp)) continue;
                    userId.add(tmp);
                }
            } else if (((List)param).get(0) instanceof DynamicObjectCollection) {
                for (DynamicObjectCollection collection : (List)param) {
                    for (DynamicObject d : collection) {
                        Long tmp = d.getLong("id");
                        if (!WfUtils.isNotEmpty(tmp)) continue;
                        userId.add(tmp);
                    }
                }
            }
        } else {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UserManagerImpl_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        ArrayList<Long> ret = new ArrayList<Long>();
        if (userId.size() > 0) {
            for (Long id : userId) {
                List<Long> userIds = this.getManager(id);
                if (userIds.size() <= 0) continue;
                ret.addAll(userIds);
            }
        }
        String o = WfUtils.listToString(ret, ",");
        this.log.debug(String.format("lastResult:[%s]", o));
        return o;
    }

    protected List<Long> getManager(Long id) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String resultForHelper = UserServiceHelper.getPerson((long)0L, (long)id, (PersonQueryType)PersonQueryType.MANAGER_OF_SUPERIOR, userIds);
        this.log.debug(String.format("user direct manager resultForHelper[%s]:userId[%s],ret[%s]", resultForHelper, id, WfUtils.listToString(userIds, ",")));
        return userIds;
    }
}

