/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.ext;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.ext.IExtExpressionParse;
import kd.bos.workflow.engine.rule.ext.OrgRelationUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class WfRoleParseImpl
implements IExtExpressionParse {
    public Object parseExpression(AgentExecution execution, Object param) {
        if (param == null) {
            return null;
        }
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        if (param instanceof Long) {
            userIds.add((Long)param);
        } else if (param instanceof DynamicObject) {
            userIds.add(((DynamicObject)param).getLong("id"));
        } else if (param instanceof DynamicObjectCollection) {
            DynamicObjectCollection users = (DynamicObjectCollection)param;
            users.forEach(user -> userIds.add(user.getLong("id")));
        } else if (param instanceof String) {
            if (WfUtils.isNotEmptyString(param)) {
                try {
                    String paramStr = param.toString();
                    if (paramStr.contains(",")) {
                        String[] uidArr = paramStr.split(",");
                        for (int i = 0; i < uidArr.length; ++i) {
                            if (!WfUtils.isNotEmpty(uidArr[i])) continue;
                            userIds.add(Long.valueOf(uidArr[i]));
                        }
                    }
                    userIds.add(Long.valueOf(paramStr));
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(ResManager.loadKDString((String)"\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u4f20\u5165\u7528\u6237id\u4e0d\u80fd\u8f6c\u5316\u4e3a\u6b63\u786e\u7684Long\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5,param:", (String)"WfRoleParseImpl_1", (String)"bos-wf-engine", (Object[])new Object[0])).append(param);
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{sb});
                }
            }
        } else if (param instanceof List) {
            if (((List)param).isEmpty()) {
                return null;
            }
            if (((List)param).get(0) instanceof DynamicObject) {
                for (DynamicObject d : (List)param) {
                    userIds.add(d.getLong("id"));
                }
            } else if (((List)param).get(0) instanceof DynamicObjectCollection) {
                for (DynamicObjectCollection collection : (List)param) {
                    for (DynamicObject obj : collection) {
                        userIds.add(obj.getLong("id"));
                    }
                }
            }
        } else {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u5c5e\u4e8e\u5de5\u4f5c\u6d41\u6761\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WfRoleParseImpl_2", (String)"bos-wf-engine", (Object[])new Object[0])});
        }
        return OrgRelationUtil.getWfRoleIdByUids(userIds, Boolean.TRUE);
    }
}

