/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.model.AutoMicroServiceTask;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EventParam;
import kd.bos.workflow.bpmn.model.EventSupportTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Parameter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.rule.expression.property.ExpressionPropCache;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.expression.property.ExtExpressionRow;
import kd.bos.workflow.engine.rule.expression.property.ModelExpressionProp;
import kd.bos.workflow.engine.rule.expression.property.ProcessMarcoExpressionProp;
import kd.bos.workflow.engine.rule.util.WfFunctionConfigUtils;
import kd.bos.workflow.engine.rule.util.filter.PropertyFilter;
import kd.bos.workflow.engine.rule.util.filter.PropertyFilterFactory;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.relservice.BusinessObjectQueryHelper;
import kd.bos.workflow.validation.validator.util.ValidatorUtil;

public class ExpressionPropUtils {
    public static final String PROPSCACHEKEY = "propsCache";
    public static final String PROCMACROPROPS = "procMacroProps";
    private static Log logger = LogFactory.getLog(ExpressionPropUtils.class);
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String BPMNMODEL = "bpmnModel";
    public static final String RULETYPE = "ruleType";
    public static final String ACTIVITYID = "activityId";
    public static final String FROMSUBJECTMODELANDAPP = "fromSubjectModelAndApp";
    public static final String PROC = "proc";
    public static final String MODEL = "model";
    public static final String ISVAL = "isVal";
    public static final String LEFTENTRYPATH = "leftEntryPath";
    public static final String FILTER = "filter";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String F7 = "F7";
    public static final String F7NUMBER = "F7number";
    public static final String FILTERF7 = "filterF7";
    public static final String NUMBER = "number";
    public static final String LONG = "long";
    public static final String INT = "int";
    public static final String INTEGER = "Integer";
    public static final String DOUBLE = "double";
    public static final String STRING = "string";
    public static final String TEXT = "text";
    public static final String EVENTNUMBER = "eventnumber";
    public static final String EVENT = "event";
    public static final String DEFAULT = "default";
    public static final String HIDELASTASSIGNEEANDCOMMENTFLAG = "hideLastAssigneeAndCommentFlag";
    private static final Set<String> virtualNodeNumberSet = new HashSet<String>();
    private static final Map<String, Map<String, ExpressionProperty>> localeFunctionProps = new HashMap<String, Map<String, ExpressionProperty>>();
    private static final String MACRO_EXECUTERESULT = "${nodeId}ExecuteResult";
    private static final String MACRO_EXECUTIONTYPE = "${nodeId}ExecutionType";
    private static final String MACRO_EVENTPARAM = "${nodeId}EventParams";
    private static final String MACRO_EVENT = "${nodeId}Event";
    private static final String MACRO_FORKRESULT = "${forkId}ForkResult";
    private static final String MACRO_FORKRESULTPATH = "proc.forkResult";
    private static final String MACRO_AUDITNUMBER = "${nodeId}AuditNumber";
    private static final String MACRO_NODENAME = "${nodeId}NodeName";
    private static final String MACRO_COMMENT = "${nodeId}Comment";
    private static final String MACRO_ASSIGNEE = "${nodeId}Assignee";
    private static final String MACRO_BILL = "${nodeId}Bill";
    public static final String NODEID = "nodeId";
    private static final String STRINGFORMAT = "%s.%s";
    private static final String CURRENTPARTICIPANT = "currentParticipant";
    private static final String MACRO_CURRENTBILLTARGETBILLTYPE = "currentBillTargetBillType";
    private static final String EXPRESSIONPROPUTILS_6 = "ExpressionPropUtils_6";
    private static final String EXPRESSIONPROPUTILS_24 = "ExpressionPropUtils_24";
    private static final String AUDITNUMBER = "AuditNumber";
    private static final String COMPARETYPE = "comparetype";
    private static final String VALUETYPE = "valuetype";
    private static final String ORDERNUMBER = "orderNumber";
    private static final String HASQUOTES = "hasquotes";
    private static final String GROUPID = "groupid";
    private static final String DESCRIPTION = "description";
    private static final String STRUCTURENUMBER = "structurenumber";
    private static final String FNAME = "fname";
    private static final String FDESCRIPTION = "fdescription";
    private static final String SELECT = "SELECT ";
    private static final String SQL_NUMBER = "a.fnumber number,";
    private static final String SQL_CONTROLTYPE = "a.fcontroltype controltype,";
    private static final String SQL_COMPARETYPE = "a.fcomparetype comparetype,";
    private static final String SQL_HASQUOTES = "a.fhasquotes hasquotes,";
    private static final String SQL_VALUETYPE = "a.fvaluetype valuetype,";
    private static final String SQL_ORDERNUMBER = "a.forder orderNumber,";
    private static final String SQL_GROUPID = "a.fgroupid groupid,";
    private static final String FROM = "FROM ";
    private static final String SQL_TABLE_A = "t_wf_expressionext a ";
    private static final String SQL_LEFTJION = "LEFT JOIN t_wf_expressionext_l b ON a.FID = b.FID and b.FLOCALEID = ? ";
    private static final String WHERE = "WHERE ";
    private static final String QUERYEXECUTIONINFO = "ApprovalRecord.t_wf_execution.queryExecutionInfo";
    private static final String CONTROLTYPE = "controltype";
    private static final String FORDER = "forder";
    private static final String EXPRESSIONTEMPLATE = "expressiontemplate";
    private static final String BOS_USER = "bos_user";
    private static final String VALUEENTITYNUMBER = "valueentitynumber";
    private static final String DELEGATIONSTATE = "delegationstate";
    private static final String LASTASSIGNEEANDCOMMENT = "lastAssigneeAndComment";

    public static List<ExpressionProperty> getDefaultProps(Map<String, Object> params, AbstractFormPlugin plugin) {
        ExpressionProperty modelProp;
        ArrayList<ExpressionProperty> props = new ArrayList<ExpressionProperty>();
        if (WfUtils.isNotEmptyString(params.get(ENTITYNUMBER))) {
            modelProp = new ModelExpressionProp();
            String entityNumber = params.get(ENTITYNUMBER).toString();
            modelProp.setNumber(MODEL);
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            modelProp.setName(metadata.getName().getLocaleValue());
            modelProp.setParseType(MODEL);
            modelProp.setPath(MODEL);
            modelProp.setExpression(MODEL);
            modelProp.setParam(params.get(ENTITYNUMBER).toString());
            props.add(modelProp);
        }
        if (WfUtils.isNotEmptyString(params.get(BPMNMODEL)) && WfUtils.isNotEmptyString(params.get(RULETYPE))) {
            String json = params.get(BPMNMODEL).toString();
            Process process = ProcessDefinitionUtil.getBpmnModel(json).getMainProcess();
            Map<String, ExpressionProperty> marcoProps = ExpressionPropUtils.getProcMacroProp(process, params.get(RULETYPE).toString(), plugin);
            plugin.getPageCache().put(PROCMACROPROPS, SerializationUtils.toJsonString(marcoProps));
            props.add(marcoProps.get(PROC));
        }
        if ("EventConfig".equals(params.get(RULETYPE))) {
            modelProp = new ExpressionProperty();
            modelProp.setNumber(EVENT);
            modelProp.setName(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570", (String)EXPRESSIONPROPUTILS_24, (String)"bos-wf-engine", (Object[])new Object[0]));
            modelProp.setFullName(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570", (String)EXPRESSIONPROPUTILS_24, (String)"bos-wf-engine", (Object[])new Object[0]));
            modelProp.setParseType(EVENT);
            modelProp.setPath(EVENT);
            modelProp.setExpression(EVENT);
            modelProp.setPrefix(EVENT);
            modelProp.setParam(params.get(EVENTNUMBER).toString());
            props.add(modelProp);
        }
        return props;
    }

    public static List<ExpressionProperty> getNextProps(ExpressionProperty prop, AbstractFormPlugin plugin, String curNodeId) {
        String filterEntityNumber;
        ArrayList<ExpressionProperty> props = new ArrayList<ExpressionProperty>(0);
        if (prop == null) {
            return props;
        }
        if (plugin != null && WfUtils.isNotEmpty(filterEntityNumber = plugin.getPageCache().get(F7NUMBER)) && filterEntityNumber.equals(prop.getEntityNumber())) {
            return props;
        }
        if (plugin != null && PROC.equals(prop.getParseType())) {
            Map propsMap = (Map)SerializationUtils.fromJsonString((String)plugin.getPageCache().get(PROCMACROPROPS), Map.class);
            String structurenumber = prop.getStructurenumber();
            HashSet<String> nextPropNums = new HashSet<String>(propsMap.size());
            String forkPatchPrex = String.format("%s%s", MACRO_FORKRESULTPATH, ".");
            for (Map.Entry entry : propsMap.entrySet()) {
                String key = (String)entry.getKey();
                StringBuilder regex = new StringBuilder();
                regex.append(structurenumber).append(".");
                if (key.startsWith(forkPatchPrex) && WfUtils.isNotEmpty(curNodeId)) {
                    regex.append(curNodeId);
                }
                if (!key.startsWith(regex.toString()) || key.split(regex.toString())[1].contains(".")) continue;
                Map t = (Map)entry.getValue();
                ProcessMarcoExpressionProp p = new ProcessMarcoExpressionProp();
                if (MACRO_CURRENTBILLTARGETBILLTYPE.equalsIgnoreCase(ExpressionPropUtils.getVal(t.get(NUMBER)))) continue;
                ExpressionPropUtils.setPropValueFromMap(p, t);
                if (!virtualNodeNumberSet.contains(prop.getNumber())) {
                    if (WfUtils.isEmpty(prop.getFullName())) {
                        p.setFullName(prop.getName() + "." + p.getName());
                    } else {
                        p.setFullName(prop.getFullName() + "." + p.getName());
                    }
                }
                props.add(p);
                nextPropNums.add(p.getExpression());
            }
            List<ExpressionProperty> extps = ExpressionPropUtils.extProcMarcoProps(prop, plugin);
            for (ExpressionProperty e : extps) {
                String expression = e.getExpression();
                if (!nextPropNums.add(expression)) continue;
                props.add(e);
            }
            props.sort(new Comparator<ExpressionProperty>(){

                @Override
                public int compare(ExpressionProperty o1, ExpressionProperty o2) {
                    int i = o1.getOrder() == null ? 0 : o1.getOrder();
                    int j = o2.getOrder() == null ? 0 : o2.getOrder();
                    return i - j;
                }
            });
        } else if (MODEL.equals(prop.getParseType())) {
            if (plugin == null) {
                props.addAll(ExpressionPropUtils.getModelProps(prop, ""));
            } else {
                String leftPropEntryPath = WfUtils.isEmpty(plugin.getPageCache().get(LEFTENTRYPATH)) ? "" : plugin.getPageCache().get(LEFTENTRYPATH);
                props.addAll(ExpressionPropUtils.getModelProps(prop, leftPropEntryPath));
            }
        } else if (EVENT.equals(prop.getParseType())) {
            ExpressionPropUtils.getEventArgProp(prop, props, prop.getParam(), plugin);
        }
        String filter = DEFAULT;
        PropertyFilterFactory factory = new PropertyFilterFactory();
        if (plugin != null) {
            String tmp = plugin.getPageCache().get(FILTER);
            String filterNumber = plugin.getPageCache().get(F7NUMBER);
            if (WfUtils.isNotEmpty(tmp) && tmp.contains(",")) {
                String[] filters = tmp.split(",");
                LinkedHashSet<ExpressionProperty> linkedHashSet = new LinkedHashSet<ExpressionProperty>(props.size());
                for (String filterEle : filters) {
                    PropertyFilter propertyFilter = factory.getPropertyFilter(filterEle);
                    linkedHashSet.addAll(propertyFilter.propFilter(props));
                }
                return new ArrayList<ExpressionProperty>(linkedHashSet);
            }
            filter = WfUtils.isNotEmpty(filterNumber) ? String.format(STRINGFORMAT, tmp, filterNumber) : tmp;
        }
        PropertyFilter propertyFilter = factory.getPropertyFilter(WfUtils.isEmpty(filter) ? DEFAULT : filter);
        return propertyFilter.propFilter(props);
    }

    private static List<ExpressionProperty> extProcMarcoProps(ExpressionProperty prop, AbstractFormPlugin plugin) {
        ArrayList<ExpressionProperty> props = new ArrayList<ExpressionProperty>();
        if (EVENT.equals(prop.getType()) && WfUtils.isNotEmpty(prop.getParam())) {
            ExpressionPropUtils.getEventArgProp(prop, props, prop.getParam(), null);
        } else {
            String leftPropEntryPath = plugin == null || WfUtils.isEmpty(plugin.getPageCache().get(LEFTENTRYPATH)) ? "" : plugin.getPageCache().get(LEFTENTRYPATH);
            String structureNumber = prop.getStructurenumber();
            if (WfUtils.isNotEmpty(structureNumber) && structureNumber.startsWith("proc.user.") && structureNumber.split("\\.").length == 4) {
                prop.setMultiPropKey(0);
            } else {
                prop.setMultiPropKey(1);
            }
            props.addAll(ExpressionPropUtils.getModelProps(prop, leftPropEntryPath));
            prop.setMultiPropKey(0);
            props.sort(new Comparator<ExpressionProperty>(){

                @Override
                public int compare(ExpressionProperty o1, ExpressionProperty o2) {
                    int i = o1.getOrder() == null ? 0 : o1.getOrder();
                    int j = o2.getOrder() == null ? 0 : o2.getOrder();
                    return i - j;
                }
            });
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ExpressionProperty getPropByExpression(String expression, EntityMetadata metadata, Process process, Map<String, Object> params) {
        String[] taskNumbers;
        int index;
        int i;
        ExpressionProperty tmpProp;
        String tmp;
        Map<String, ExpressionProperty> marcoProps;
        ExpressionProperty prop;
        block36: {
            prop = null;
            if (expression.startsWith("model.")) {
                if (metadata != null && WfUtils.isNotEmptyString(params.get(ENTITYNUMBER))) {
                    boolean hasProperty;
                    ModelExpressionProp modelProp = new ModelExpressionProp();
                    modelProp.setNumber(MODEL);
                    modelProp.setName(metadata.getName().getLocaleValue());
                    modelProp.setParseType(MODEL);
                    modelProp.setPath(MODEL);
                    modelProp.setExpression(MODEL);
                    modelProp.setParam(String.valueOf(params.get(ENTITYNUMBER)));
                    if (expression.endsWith(".id")) {
                        expression = expression.substring(0, expression.length() - 3);
                    }
                    expression = expression.substring(6);
                    prop = modelProp;
                    block0: do {
                        if (expression.length() <= 0) return prop;
                        List<ExpressionProperty> props = ExpressionPropUtils.getNextProps(prop, null, null);
                        Collections.sort(props, new Comparator<ExpressionProperty>(){

                            @Override
                            public int compare(ExpressionProperty p1, ExpressionProperty p2) {
                                if (p1.getNumber().length() == p2.getNumber().length()) {
                                    return 0;
                                }
                                if (p1.getNumber().length() < p2.getNumber().length()) {
                                    return 1;
                                }
                                return -1;
                            }
                        });
                        if (props.isEmpty()) {
                            String info = String.format(ResManager.loadKDString((String)"getPropByExpression\u89e3\u6790number\u4e3a\u201c%s\u201d\u7684\u5c5e\u6027\u65f6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExpressionPropUtils_3", (String)"bos-wf-engine", (Object[])new Object[0]), prop.getNumber());
                            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{info});
                        }
                        hasProperty = false;
                        for (ExpressionProperty i2 : props) {
                            String num = i2.getNumber();
                            if (!WfUtils.isNotEmpty(num) || !expression.startsWith(num)) continue;
                            hasProperty = true;
                            prop = i2;
                            if ((expression = expression.substring(num.length())).isEmpty()) continue block0;
                            expression = expression.substring(1);
                            continue block0;
                        }
                    } while (hasProperty);
                    String info = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4e0d\u5230number\u4e3a\u201c%s\u201d\u7684\u5c5e\u6027\u3002", (String)"ExpressionPropUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), expression);
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{info});
                }
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\uff08ENTITYNUMBER\uff09\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u89e3\u6790\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExpressionPropUtils_5", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
            if (expression.startsWith("proc.") || expression.startsWith(CURRENTPARTICIPANT)) {
                if (process != null && WfUtils.isNotEmptyString(params.get(RULETYPE))) {
                    marcoProps = null;
                    marcoProps = params.containsKey("procMacro") ? (Map<String, ExpressionProperty>)params.get("procMacro") : ExpressionPropUtils.getProcMacroProp(process, params.get(RULETYPE).toString(), null);
                    tmp = expression;
                    tmpProp = null;
                    i = 0;
                    index = 0;
                    break block36;
                } else {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\uff08BPMNMODEL\uff0cRULETYPE\uff09\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u89e3\u6790\u3002", (String)"ExpressionPropUtils_8", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
            }
            if (expression.startsWith("event.")) {
                boolean hasProperty;
                if (!WfUtils.isNotEmptyString(params.get(EVENTNUMBER))) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570\uff08EVENTNUMBER\uff09\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u89e3\u6790\uff0c\u8bf7\u68c0\u67e5", (String)"ExpressionPropUtils_5_1", (String)"bos-wf-engine", (Object[])new Object[0])});
                }
                ExpressionProperty modelProp = new ExpressionProperty();
                modelProp.setNumber(EVENT);
                modelProp.setName(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570", (String)EXPRESSIONPROPUTILS_24, (String)"bos-wf-engine", (Object[])new Object[0]));
                modelProp.setFullName(ResManager.loadKDString((String)"\u4e8b\u4ef6\u53c2\u6570", (String)EXPRESSIONPROPUTILS_24, (String)"bos-wf-engine", (Object[])new Object[0]));
                modelProp.setParseType(EVENT);
                modelProp.setPath(EVENT);
                modelProp.setExpression(EVENT);
                modelProp.setParam(String.valueOf(params.get(EVENTNUMBER)));
                if (expression.endsWith(".id")) {
                    expression = expression.substring(0, expression.length() - 3);
                }
                expression = expression.substring(6);
                prop = modelProp;
                block2: do {
                    if (expression.length() <= 0) return prop;
                    List<ExpressionProperty> props = ExpressionPropUtils.getNextProps(prop, null, null);
                    Collections.sort(props, new Comparator<ExpressionProperty>(){

                        @Override
                        public int compare(ExpressionProperty p1, ExpressionProperty p2) {
                            if (p1.getNumber().length() == p2.getNumber().length()) {
                                return 0;
                            }
                            if (p1.getNumber().length() < p2.getNumber().length()) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    if (props.isEmpty()) {
                        String info = String.format(ResManager.loadKDString((String)"getPropByExpression\u89e3\u6790number\u4e3a\u201c%s\u201d\u7684\u5c5e\u6027\u65f6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExpressionPropUtils_3", (String)"bos-wf-engine", (Object[])new Object[0]), prop.getNumber());
                        throw new KDException(WFErrorCode.conditionParseError(), new Object[]{info});
                    }
                    hasProperty = false;
                    for (ExpressionProperty i3 : props) {
                        String num = i3.getNumber();
                        if (!WfUtils.isNotEmpty(num) || !expression.startsWith(num)) continue;
                        hasProperty = true;
                        prop = i3;
                        if ((expression = expression.substring(num.length())).isEmpty()) continue block2;
                        expression = expression.substring(1);
                        continue block2;
                    }
                } while (hasProperty);
                String info = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4e0d\u5230number\u4e3a\u201c%s\u201d\u7684\u5c5e\u6027\u3002", (String)"ExpressionPropUtils_1", (String)"bos-wf-engine", (Object[])new Object[0]), expression);
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{info});
            }
            if (expression.contains("(") && expression.endsWith(")")) {
                String[] functions = expression.split("\\(");
                List<ExpressionProperty> functionProps = ExpressionPropUtils.getFunctionProps();
                for (ExpressionProperty t : functionProps) {
                    if (!functions[0].equals(t.getNumber())) continue;
                    prop = WfFunctionConfigUtils.buildFuncExpressionProp(t);
                    break;
                }
                String withoutFunctionExpression = expression;
                for (int i4 = 0; i4 < functions.length; ++i4) {
                    String function = functions[i4];
                    if (!withoutFunctionExpression.startsWith(function + "(") || !withoutFunctionExpression.endsWith(")")) continue;
                    withoutFunctionExpression = withoutFunctionExpression.substring(function.length() + 1, withoutFunctionExpression.length() - 1);
                }
                if (!WfUtils.isNotEmpty(withoutFunctionExpression)) return prop;
                ExpressionProperty tmp2 = ExpressionPropUtils.getPropByExpression(withoutFunctionExpression, metadata, process, params);
                if (prop != null) {
                    WfFunctionConfigUtils.setFuncPropValues(prop, tmp2);
                    prop.setName(String.format(WfFunctionConfigUtils.getSubjectSuffixByFuncNumber(prop.getNumber()), tmp2.getName()));
                    prop.setFullName(String.format(WfFunctionConfigUtils.getSubjectSuffixByFuncNumber(prop.getNumber()), tmp2.getFullName()));
                    return prop;
                }
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230expression\u4e3a\uff1a%1$s\u7684ExpressionProperty", (String)EXPRESSIONPROPUTILS_6, (String)"bos-wf-engine", (Object[])new Object[0]), expression)});
            }
            Map<String, ExpressionProperty> props = ExpressionPropUtils.getProcMacroProp(process, "", null);
            String warpExpression = String.format("proc.variable.%s", expression);
            prop = props.get(warpExpression);
            if (prop != null) return prop;
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230expression\u4e3a\uff1a%1$s\u7684ExpressionProperty", (String)EXPRESSIONPROPUTILS_6, (String)"bos-wf-engine", (Object[])new Object[0]), expression)});
        }
        while (tmpProp == null && i < 20) {
            ++i;
            for (ExpressionProperty p : marcoProps.values()) {
                if (!tmp.equals(p.getExpression())) continue;
                tmpProp = p;
                break;
            }
            if (tmpProp != null) continue;
            index = tmp.lastIndexOf(".");
            if (index == -1) break;
            tmp = tmp.substring(0, index);
        }
        if (tmpProp != null && index > 0) {
            String extStr = expression.substring(index + 1);
            tmpProp.setMultiPropKey(1);
            List<ExpressionProperty> props = ExpressionPropUtils.extProcMarcoProps(tmpProp, null);
            Collections.sort(props, new Comparator<ExpressionProperty>(){

                @Override
                public int compare(ExpressionProperty p1, ExpressionProperty p2) {
                    if (p1.getNumber().length() == p2.getNumber().length()) {
                        return 0;
                    }
                    if (p1.getNumber().length() < p2.getNumber().length()) {
                        return 1;
                    }
                    return -1;
                }
            });
            while (extStr.length() > 1 && i < 20 && !"id".equals(extStr)) {
                ++i;
                boolean find = false;
                for (ExpressionProperty p : props) {
                    if (!extStr.startsWith(p.getNumber())) continue;
                    tmpProp = p;
                    if (!(extStr = extStr.substring(p.getNumber().length())).isEmpty()) {
                        extStr = extStr.substring(1);
                    }
                    find = true;
                    break;
                }
                if (!find) {
                    throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230expression\u4e3a\uff1a%1$s\u7684ExpressionProperty", (String)EXPRESSIONPROPUTILS_6, (String)"bos-wf-engine", (Object[])new Object[0]), expression)});
                }
                if (!WfUtils.isNotEmpty(extStr) || !WfUtils.isNotEmpty(tmpProp.getParam())) continue;
                props = ExpressionPropUtils.getModelProps(tmpProp, "");
            }
        }
        if ((prop = tmpProp) == null) {
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230expression\u4e3a\uff1a%1$s\u7684ExpressionProperty", (String)EXPRESSIONPROPUTILS_6, (String)"bos-wf-engine", (Object[])new Object[0]), expression)});
        }
        Object validateFlag = params.get("validateFlag");
        if (null == validateFlag) return prop;
        if ((Boolean)validateFlag == false) return prop;
        Set<String> allFlowElementIds = ValidatorUtil.getAllFlowElementIds(process);
        String numberStr = prop.getNumber();
        String procNumber = process.getNumber();
        if (!WfUtils.isNotEmpty(numberStr)) return prop;
        if (numberStr.indexOf(procNumber) < 0) return prop;
        if (numberStr.endsWith("Assignee")) {
            numberStr = numberStr.substring(0, numberStr.length() - 8);
        }
        if (numberStr.endsWith(AUDITNUMBER)) {
            numberStr = numberStr.substring(0, numberStr.length() - 11);
        }
        if (numberStr.endsWith("ExecutionType")) {
            numberStr = numberStr.substring(0, numberStr.length() - 13);
        }
        if (numberStr.endsWith("Comment")) {
            numberStr = numberStr.substring(0, numberStr.length() - 7);
        }
        if (numberStr.endsWith("ForkResult")) {
            numberStr = numberStr.substring(0, numberStr.length() - 10);
        }
        if (numberStr.endsWith("SubProcessResult")) {
            numberStr = numberStr.substring(0, numberStr.length() - 16);
        }
        if (!numberStr.contains("$")) {
            if (allFlowElementIds.contains(numberStr)) return prop;
            String missTaskNumber = numberStr.replace(procNumber + "_", "");
            String info = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8282\u70b9\u7f16\u7801\u4e3a%s\u7684ExpressionProperty", (String)"ExpressionPropUtils_25", (String)"bos-wf-engine", (Object[])new Object[0]), missTaskNumber);
            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{info});
        }
        String[] stringArray = taskNumbers = numberStr.split("\\$");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!allFlowElementIds.contains(s)) {
                String missTaskNumber = s.replace(procNumber + "_", "");
                String info = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8282\u70b9\u7f16\u7801\u4e3a%s\u7684ExpressionProperty", (String)"ExpressionPropUtils_25", (String)"bos-wf-engine", (Object[])new Object[0]), missTaskNumber);
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{info});
            }
            ++n2;
        }
        return prop;
    }

    public static ExpressionProperty filterPropByNumber(List<ExpressionProperty> props, String number) {
        for (ExpressionProperty p : props) {
            if (!number.equals(p.getNumber())) continue;
            return p;
        }
        return null;
    }

    public static ProcessMarcoExpressionProp getPropByExpression(String expression, AbstractFormPlugin plugin) {
        Map propsMap = (Map)SerializationUtils.fromJsonString((String)plugin.getPageCache().get(PROCMACROPROPS), Map.class);
        for (Map t : propsMap.values()) {
            if (!expression.equals(t.get("expression"))) continue;
            ProcessMarcoExpressionProp p = new ProcessMarcoExpressionProp();
            ExpressionPropUtils.setPropValueFromMap(p, t);
            return p;
        }
        return null;
    }

    private static void setPropValueFromMap(ProcessMarcoExpressionProp p, Map<String, Object> t) {
        p.setName(ExpressionPropUtils.getVal(t.get("name")));
        p.setNumber(ExpressionPropUtils.getVal(t.get(NUMBER)));
        p.setParseType(ExpressionPropUtils.getVal(t.get("parseType")));
        p.setComparetype(ExpressionPropUtils.getVal(t.get(COMPARETYPE)));
        p.setValuetype(ExpressionPropUtils.getVal(t.get(VALUETYPE)));
        p.setControlType(ExpressionPropUtils.getVal(t.get("controlType")));
        p.setParam(ExpressionPropUtils.getVal(t.get("param")));
        p.setPath(ExpressionPropUtils.getVal(t.get("path")));
        p.setType(ExpressionPropUtils.getVal(t.get("type")));
        p.setMultiPropKey(Integer.parseInt(ExpressionPropUtils.getVal(t.get("multiPropKey"))));
        int order = 0;
        if (t.get("order") != null) {
            order = (Integer)t.get("order");
        }
        p.setOrder(order);
        if (t.get(HASQUOTES) != null) {
            p.setHasquotes((Boolean)t.get(HASQUOTES));
        } else {
            p.setHasquotes(true);
        }
        p.setPrefix(ExpressionPropUtils.getVal(t.get("prefix")));
        p.setExpression(ExpressionPropUtils.getVal(t.get("expression")));
        p.setStructurenumber(ExpressionPropUtils.getVal(t.get(STRUCTURENUMBER)));
        p.setEntityNumber(ExpressionPropUtils.getVal(t.get(ENTITYNUMBER)));
        if (t.get("items") != null) {
            List list = (List)t.get("items");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(list.size());
            for (Map i : list) {
                ComboItem item = new ComboItem();
                item.setId(ExpressionPropUtils.getVal(i.get("id")));
                item.setValue(ExpressionPropUtils.getVal(i.get("value")));
                if (i.get("caption") != null) {
                    Map cap = (Map)i.get("caption");
                    String lang = RequestContext.get().getLang().toString();
                    item.setCaption(new LocaleString((String)cap.get(lang)));
                }
                items.add(item);
            }
            p.setItems(items);
        }
    }

    private static String getVal(Object o) {
        if (WfUtils.isNullObject(o)) {
            return "";
        }
        return o.toString();
    }

    private static List<ExtExpressionRow> getCachedData(String sql, String[] params) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return null;
        }
        Object value = commandContext.getAttribute(PROPSCACHEKEY);
        if (value instanceof ExpressionPropCache) {
            ExpressionPropCache cache = (ExpressionPropCache)value;
            return cache.getCachedValue(sql, params);
        }
        return null;
    }

    private static void addCachedData(String sql, String[] params, List<ExtExpressionRow> rows) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            return;
        }
        Object value = commandContext.getAttribute(PROPSCACHEKEY);
        if (value instanceof ExpressionPropCache) {
            ExpressionPropCache cache = (ExpressionPropCache)value;
            cache.addCache(sql, params, rows);
        }
    }

    public static Map<String, ExpressionProperty> getProcMacroProp(Process process, String type, AbstractFormPlugin plugin) {
        Object[] params;
        boolean flag = false;
        if (ConditionalRuleType.skip.toString().equals(type) || ConditionalRuleType.autoApproval.toString().equals(type) || "expiresendmsg".equals(type)) {
            flag = true;
        }
        String lang = RequestContext.get().getLang().toString();
        HashMap<String, ExpressionProperty> marcoProps = new HashMap<String, ExpressionProperty>();
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_expressionext", "a", "b", FNAME, "name", "name");
        String sql = "SELECT a.fexpressiontemplate expressiontemplate,a.fstructurenumber structurenumber,a.fnumber number,a.fcontroltype controltype,a.fcomparetype comparetype,a.fhasquotes hasquotes,a.fvaluetype valuetype,a.fvalueentitynumber valueentitynumber, a.forder forder, " + nameSQL + " " + FROM + SQL_TABLE_A + SQL_LEFTJION + WHERE + "fentitynumber = ?";
        List<ExtExpressionRow> rows = ExpressionPropUtils.getCachedData(sql, (String[])(params = new String[]{lang, "process"}));
        if (rows == null) {
            try (DataSet ds = DB.queryDataSet((String)QUERYEXECUTIONINFO, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
                rows = new ArrayList<ExtExpressionRow>();
                Iterator iterator = ds.iterator();
                RowMeta rowMeta = ds.getRowMeta();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    rows.add(new ExtExpressionRow(rowMeta, row));
                }
                ExpressionPropUtils.addCachedData(sql, (String[])params, rows);
            }
        }
        for (ExtExpressionRow row : rows) {
            String number = row.getString(NUMBER);
            if (LASTASSIGNEEANDCOMMENT.equals(number) && (ProcessType.BizFlow.name().equals(process.getProcessType()) || plugin != null && WfUtils.isNotEmpty(plugin.getPageCache().get(HIDELASTASSIGNEEANDCOMMENTFLAG))) || CURRENTPARTICIPANT.equals(number) && plugin != null && (StringUtils.isBlank((CharSequence)((CharSequence)plugin.getView().getFormShowParameter().getCustomParam("participantExpScene"))) || "partRelation".equals(plugin.getView().getFormShowParameter().getCustomParam("participantExpScene"))) && (!flag || flag && plugin != null && process.getFlowElement((String)plugin.getView().getFormShowParameter().getCustomParam(NODEID)) instanceof CallActivity) || MACRO_FORKRESULT.equals(number) && (!flag || flag && plugin != null && process.getFlowElement((String)plugin.getView().getFormShowParameter().getCustomParam(NODEID)) instanceof CallActivity) || plugin != null && "forkResult".equals(number) && WfUtils.isNotEmpty(plugin.getPageCache().get(FROMSUBJECTMODELANDAPP)) || ("bill".equals(number) || "eventParam".equals(number)) && ProcessType.AuditFlow.name().equals(process.getProcessType()) || ("executionType".equals(number) || "nodeName".equals(number) || "auditNumber".equals(number) || "forkResult".equals(number) || "executeResult".equals(number) || "other".equals(number)) && plugin != null && "partRelation".equals(plugin.getView().getFormShowParameter().getCustomParam("participantExpScene"))) continue;
            if (number.contains("${")) {
                Map<String, ExpressionProperty> ret = ExpressionPropUtils.matchSpecialProp(row, process, plugin);
                if (ret == null || ret.isEmpty()) continue;
                marcoProps.putAll(ret);
                continue;
            }
            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
            prop.setName(row.getString("name"));
            prop.setParseType(PROC);
            prop.setNumber(row.getString(NUMBER));
            prop.setPath(row.getString(NUMBER));
            prop.setComparetype(row.getString(COMPARETYPE));
            prop.setControlType(row.getString(CONTROLTYPE));
            prop.setHasquotes(row.getBoolean(HASQUOTES));
            prop.setValuetype(row.getString(VALUETYPE));
            prop.setOrder(row.getInteger(FORDER));
            prop.setExpression(row.getString(EXPRESSIONTEMPLATE));
            String structurenumber = row.getString(STRUCTURENUMBER);
            prop.setStructurenumber(structurenumber);
            if ("initiator".equals(number) || "lastAssignee".equals(number)) {
                prop.setEntityNumber(BOS_USER);
                prop.setParam(BOS_USER);
            } else if ("entrabill".equals(number)) {
                prop.setEntityNumber("bos_entitymeta");
            } else if (MACRO_CURRENTBILLTARGETBILLTYPE.equals(number)) {
                prop.setEntityNumber("bos_entityobject");
            } else if (CURRENTPARTICIPANT.equals(number)) {
                prop.setEntityNumber(BOS_USER);
                prop.setParam(BOS_USER);
                Optional.ofNullable(plugin).ifPresent(p -> Optional.ofNullable(plugin.getView().getFormShowParameter().getCustomParam("participantExpScene")).ifPresent(scene -> {
                    prop.setName("taskReceived".equals(scene) ? ResManager.loadKDString((String)"\u4efb\u52a1\u63a5\u6536\u4eba", (String)"ExpressionPropUtils_33", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba", (String)"ExpressionPropUtils_34", (String)"bos-wf-engine", (Object[])new Object[0]));
                    prop.setExpression("proc.currentParticipant");
                }));
            }
            marcoProps.put(structurenumber, prop);
            String valueentitynumber = row.getString(VALUEENTITYNUMBER);
            if (!WfUtils.isNotEmpty(valueentitynumber)) continue;
            List<ExpressionProperty> extProps = ExpressionPropUtils.getCustomPropsByType(valueentitynumber, prop);
            for (ExpressionProperty i : extProps) {
                String extStructurenumber = structurenumber + "." + i.getNumber();
                marcoProps.put(extStructurenumber, i);
            }
        }
        return marcoProps;
    }

    private static Map<String, ExpressionProperty> matchSpecialProp(ExtExpressionRow row, Process process, AbstractFormPlugin plugin) {
        HashMap<String, ExpressionProperty> props;
        block29: {
            String number;
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block28: {
                                                    props = new HashMap<String, ExpressionProperty>();
                                                    number = row.getString(NUMBER);
                                                    if (!MACRO_AUDITNUMBER.equalsIgnoreCase(number)) break block28;
                                                    List<Macro> macros = process.getMacros();
                                                    int sort = 0;
                                                    for (Macro m : macros) {
                                                        String structurenumber;
                                                        String expression;
                                                        ProcessMarcoExpressionProp prop;
                                                        String macroNumber = m.getName();
                                                        if (macroNumber.endsWith(AUDITNUMBER)) {
                                                            ++sort;
                                                            prop = new ProcessMarcoExpressionProp();
                                                            prop.setName(m.getDescription());
                                                            prop.setParseType(PROC);
                                                            prop.setComparetype(row.getString(COMPARETYPE));
                                                            prop.setControlType(row.getString(CONTROLTYPE));
                                                            prop.setHasquotes(row.getBoolean(HASQUOTES));
                                                            prop.setValuetype(row.getString(VALUETYPE));
                                                            prop.setOrder(row.getInteger(FORDER) + sort);
                                                            prop.setNumber(macroNumber);
                                                            expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_AUDITNUMBER, macroNumber);
                                                            prop.setExpression(expression);
                                                            structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_AUDITNUMBER, macroNumber);
                                                            prop.setStructurenumber(structurenumber);
                                                            String activityName = macroNumber.split(AUDITNUMBER)[0];
                                                            UserTask task = (UserTask)process.getFlowElement(activityName);
                                                            List<DecisionOption> options = task.getDecisionOptions();
                                                            ArrayList<ComboItem> items = new ArrayList<ComboItem>(options.size());
                                                            for (DecisionOption d : options) {
                                                                ComboItem item = new ComboItem();
                                                                item.setCaption(new LocaleString(d.getName()));
                                                                item.setValue(d.getNumber());
                                                                items.add(item);
                                                            }
                                                            prop.setItems(items);
                                                            props.put(structurenumber, prop);
                                                            String valueentitynumber = row.getString(VALUEENTITYNUMBER);
                                                            if (!WfUtils.isNotEmpty(valueentitynumber)) continue;
                                                            List<ExpressionProperty> extProps = ExpressionPropUtils.getCustomPropsByType(valueentitynumber, prop);
                                                            for (ExpressionProperty i : extProps) {
                                                                String extStructurenumber = structurenumber + "." + i.getNumber();
                                                                props.put(extStructurenumber, i);
                                                            }
                                                            continue;
                                                        }
                                                        if (!macroNumber.endsWith("SubProcessResult")) continue;
                                                        ++sort;
                                                        prop = new ProcessMarcoExpressionProp();
                                                        prop.setName(m.getDescription());
                                                        prop.setParseType(PROC);
                                                        prop.setComparetype(row.getString(COMPARETYPE));
                                                        prop.setControlType(row.getString(CONTROLTYPE));
                                                        prop.setHasquotes(row.getBoolean(HASQUOTES));
                                                        prop.setValuetype(row.getString(VALUETYPE));
                                                        prop.setOrder(row.getInteger(FORDER) + sort);
                                                        prop.setNumber(macroNumber);
                                                        expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_AUDITNUMBER, macroNumber);
                                                        prop.setExpression(expression);
                                                        structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_AUDITNUMBER, macroNumber);
                                                        prop.setStructurenumber(structurenumber);
                                                        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                                                        ComboItem approvalItem = new ComboItem();
                                                        approvalItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"ExpressionPropUtils_22", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        approvalItem.setValue("approve");
                                                        items.add(approvalItem);
                                                        ComboItem rejectItem = new ComboItem();
                                                        rejectItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7", (String)"ExpressionPropUtils_32", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        rejectItem.setValue("reject");
                                                        items.add(rejectItem);
                                                        ComboItem auditAbortItem = new ComboItem();
                                                        auditAbortItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6279\u7ec8\u6b62", (String)"ExpressionPropUtils_27", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        auditAbortItem.setValue("30");
                                                        items.add(auditAbortItem);
                                                        ComboItem forceAbortItem = new ComboItem();
                                                        forceAbortItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec8\u6b62", (String)"ExpressionPropUtils_28", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        forceAbortItem.setValue("40");
                                                        items.add(forceAbortItem);
                                                        ComboItem billExcItem = new ComboItem();
                                                        billExcItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u4f8b\u5916\u7ec8\u6b62", (String)"ExpressionPropUtils_29", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        billExcItem.setValue("50");
                                                        ComboItem billAbortItem = new ComboItem();
                                                        billAbortItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6574\u5355\u64a4\u56de", (String)"ExpressionPropUtils_30", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        billAbortItem.setValue("60");
                                                        ComboItem withdrawItem = new ComboItem();
                                                        withdrawItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u64a4\u56de\u5220\u9664", (String)"ExpressionPropUtils_31", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                        withdrawItem.setValue("20");
                                                        prop.setItems(items);
                                                        props.put(structurenumber, prop);
                                                        String valueentitynumber = row.getString(VALUEENTITYNUMBER);
                                                        if (!WfUtils.isNotEmpty(valueentitynumber)) continue;
                                                        List<ExpressionProperty> extProps = ExpressionPropUtils.getCustomPropsByType(valueentitynumber, prop);
                                                        for (ExpressionProperty i : extProps) {
                                                            String extStructurenumber = structurenumber + "." + i.getNumber();
                                                            props.put(extStructurenumber, i);
                                                        }
                                                    }
                                                    break block29;
                                                }
                                                if (!MACRO_COMMENT.equalsIgnoreCase(number)) break block30;
                                                List<Macro> macros = process.getMacros();
                                                int sort = 0;
                                                for (Macro m : macros) {
                                                    String macroNumber = m.getName();
                                                    if (!macroNumber.endsWith("Comment") || LASTASSIGNEEANDCOMMENT.equals(macroNumber)) continue;
                                                    ++sort;
                                                    ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
                                                    prop.setName(m.getDescription());
                                                    prop.setParseType(PROC);
                                                    prop.setComparetype(row.getString(COMPARETYPE));
                                                    prop.setControlType(row.getString(CONTROLTYPE));
                                                    prop.setHasquotes(row.getBoolean(HASQUOTES));
                                                    prop.setValuetype(row.getString(VALUETYPE));
                                                    prop.setOrder(row.getInteger(FORDER) + sort);
                                                    prop.setNumber(macroNumber);
                                                    String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_COMMENT, macroNumber);
                                                    prop.setExpression(expression);
                                                    String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_COMMENT, macroNumber);
                                                    prop.setStructurenumber(structurenumber);
                                                    props.put(structurenumber, prop);
                                                }
                                                break block29;
                                            }
                                            if (!"${nodeId}SubProcessResult".equalsIgnoreCase(number)) break block31;
                                            List<Macro> macros = process.getMacros();
                                            boolean sort = false;
                                            for (Macro m : macros) {
                                                String macroNumber = m.getName();
                                            }
                                            break block29;
                                        }
                                        if (!MACRO_ASSIGNEE.equalsIgnoreCase(number)) break block32;
                                        List<Macro> macros = process.getMacros();
                                        int sort = 0;
                                        for (Macro m : macros) {
                                            String macroNumber = m.getName();
                                            if (!macroNumber.endsWith("Assignee") || macroNumber.equals("lastAssignee")) continue;
                                            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
                                            ++sort;
                                            prop.setName(m.getDescription());
                                            prop.setParseType(PROC);
                                            prop.setComparetype(row.getString(COMPARETYPE));
                                            prop.setControlType(row.getString(CONTROLTYPE));
                                            prop.setHasquotes(row.getBoolean(HASQUOTES));
                                            prop.setValuetype(row.getString(VALUETYPE));
                                            prop.setOrder(row.getInteger(FORDER) + sort);
                                            String activityName = macroNumber.split(AUDITNUMBER)[0];
                                            if (activityName.contains("YunzhijiaTask")) {
                                                prop.setComparetype("collection");
                                            }
                                            prop.setNumber(macroNumber);
                                            String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_ASSIGNEE, macroNumber);
                                            prop.setExpression(expression);
                                            String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_ASSIGNEE, macroNumber);
                                            prop.setStructurenumber(structurenumber);
                                            prop.setEntityNumber(BOS_USER);
                                            prop.setParam(BOS_USER);
                                            props.put(structurenumber, prop);
                                            String valueentitynumber = row.getString(VALUEENTITYNUMBER);
                                            if (!WfUtils.isNotEmpty(valueentitynumber)) continue;
                                            List<ExpressionProperty> extProps = ExpressionPropUtils.getCustomPropsByType(valueentitynumber, prop);
                                            for (ExpressionProperty i : extProps) {
                                                String extStructurenumber = structurenumber + "." + i.getNumber();
                                                props.put(extStructurenumber, i);
                                            }
                                        }
                                        break block29;
                                    }
                                    if (!"${var}".equals(number)) break block33;
                                    List<Variable> variables = process.getVariables();
                                    int sort = 0;
                                    for (Variable v : variables) {
                                        String type;
                                        ++sort;
                                        ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
                                        String varNumber = v.getName();
                                        if (!WfUtils.isNotEmpty(varNumber)) continue;
                                        prop.setName(v.getDescription());
                                        prop.setNumber(varNumber);
                                        prop.setOrder(row.getInteger(FORDER) + sort);
                                        switch (type = v.getType()) {
                                            case "string": {
                                                prop.setControlType(TEXT);
                                                prop.setComparetype("String");
                                                prop.setValuetype("String");
                                                prop.setHasquotes(true);
                                                break;
                                            }
                                            case "date": {
                                                prop.setControlType(DATE);
                                                prop.setComparetype(DATE);
                                                prop.setValuetype(DATE);
                                                prop.setHasquotes(true);
                                                break;
                                            }
                                            case "number": {
                                                prop.setControlType("decimal");
                                                prop.setComparetype(NUMBER);
                                                prop.setValuetype(NUMBER);
                                                prop.setHasquotes(false);
                                                break;
                                            }
                                            case "boolean": {
                                                prop.setControlType("enum");
                                                prop.setComparetype("boolean");
                                                prop.setValuetype("boolean");
                                                prop.setHasquotes(false);
                                                ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                                                ComboItem item = new ComboItem();
                                                item.setValue("1");
                                                item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"ExpressionPropUtils_9", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                items.add(item);
                                                ComboItem nitem = new ComboItem();
                                                nitem.setValue("0");
                                                nitem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"ExpressionPropUtils_10", (String)"bos-wf-engine", (Object[])new Object[0])));
                                                items.add(nitem);
                                                prop.setItems(items);
                                                break;
                                            }
                                        }
                                        prop.setPath(varNumber);
                                        prop.setExpression(varNumber);
                                        String structurenumber = row.getString(STRUCTURENUMBER).replace("${var}", varNumber);
                                        prop.setStructurenumber(structurenumber);
                                        props.put(structurenumber, prop);
                                        String valueentitynumber = row.getString(VALUEENTITYNUMBER);
                                        if (!WfUtils.isNotEmpty(valueentitynumber)) continue;
                                        List<ExpressionProperty> extProps = ExpressionPropUtils.getCustomPropsByType(valueentitynumber, prop);
                                        for (ExpressionProperty i : extProps) {
                                            String extStructurenumber = structurenumber + "." + i.getNumber();
                                            props.put(extStructurenumber, i);
                                        }
                                    }
                                    break block29;
                                }
                                if (!MACRO_NODENAME.equals(number)) break block34;
                                ExpressionPropUtils.putNodeNameMacroProps(props, row, process);
                                break block29;
                            }
                            if (!MACRO_EXECUTIONTYPE.equals(number)) break block35;
                            ExpressionPropUtils.putExecutionTypeMacroProps(props, row, process);
                            break block29;
                        }
                        if (!MACRO_EXECUTERESULT.equals(number)) break block36;
                        ExpressionPropUtils.putExecuteResultMacroProps(props, row, process);
                        break block29;
                    }
                    if (!MACRO_EVENTPARAM.equals(number)) break block37;
                    ExpressionPropUtils.putEventParamMacroProps(props, row, process);
                    break block29;
                }
                if (!MACRO_FORKRESULT.equals(number)) break block38;
                if (plugin != null && !WfUtils.isEmpty(plugin.getPageCache().get(FROMSUBJECTMODELANDAPP))) break block29;
                ExpressionPropUtils.putForkResultMacroProps(props, row, process);
                break block29;
            }
            if (MACRO_EVENT.equals(number)) {
                ExpressionPropUtils.putEventMacroProps(props, row, process);
            } else if (MACRO_BILL.equals(number)) {
                List<Macro> macros = process.getMacros();
                int sort = 0;
                for (Macro m : macros) {
                    String macroNumber = m.getName();
                    if (!macroNumber.endsWith("Bill")) continue;
                    ++sort;
                    ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
                    prop.setName(m.getDescription());
                    prop.setParseType(PROC);
                    prop.setComparetype(row.getString(COMPARETYPE));
                    prop.setControlType(row.getString(CONTROLTYPE));
                    prop.setHasquotes(row.getBoolean(HASQUOTES));
                    prop.setValuetype(row.getString(VALUETYPE));
                    prop.setOrder(row.getInteger(FORDER) + sort);
                    prop.setNumber(macroNumber);
                    String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_BILL, macroNumber);
                    prop.setExpression(expression);
                    String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_BILL, macroNumber);
                    prop.setStructurenumber(structurenumber);
                    props.put(structurenumber, prop);
                }
            }
        }
        return props;
    }

    private static void putNodeNameMacroProps(Map<String, ExpressionProperty> props, ExtExpressionRow row, Process process) {
        List<Macro> macros = process.getMacros();
        String NODENAME = "NodeName";
        int sort = 0;
        for (Macro macro : macros) {
            String macroNumber = macro.getName();
            if (!macroNumber.endsWith("NodeName")) continue;
            ++sort;
            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
            prop.setName(macro.getDescription());
            prop.setParseType(PROC);
            prop.setComparetype(row.getString(COMPARETYPE));
            prop.setControlType(row.getString(CONTROLTYPE));
            prop.setHasquotes(row.getBoolean(HASQUOTES));
            prop.setValuetype(row.getString(VALUETYPE));
            prop.setOrder(row.getInteger(FORDER) + sort);
            prop.setNumber(macroNumber);
            String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_NODENAME, macroNumber);
            prop.setExpression(expression);
            String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_NODENAME, macroNumber);
            prop.setStructurenumber(structurenumber);
            props.put(structurenumber, prop);
        }
    }

    private static void putExecuteResultMacroProps(Map<String, ExpressionProperty> props, ExtExpressionRow row, Process process) {
        List<Macro> macros = process.getMacros();
        int sort = 0;
        String suffix = MACRO_EXECUTERESULT.replace("${nodeId}", "");
        for (Macro macro : macros) {
            String macroNumber = macro.getName();
            if (!macroNumber.endsWith(suffix)) continue;
            ++sort;
            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
            prop.setName(macro.getDescription());
            prop.setParseType(PROC);
            prop.setComparetype(row.getString(COMPARETYPE));
            prop.setControlType(row.getString(CONTROLTYPE));
            prop.setHasquotes(row.getBoolean(HASQUOTES));
            prop.setValuetype(row.getString(VALUETYPE));
            prop.setOrder(row.getInteger(FORDER) + sort);
            prop.setNumber(macroNumber);
            String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_EXECUTERESULT, macroNumber);
            prop.setExpression(expression);
            String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_EXECUTERESULT, macroNumber);
            prop.setStructurenumber(structurenumber);
            props.put(structurenumber, prop);
            String nodeId = macroNumber.replace(suffix, "");
            FlowElement element = process.getFlowElement(nodeId);
            ExpressionPropUtils.putExecuteResultMacro(props, element, prop.getOrder(), expression, structurenumber);
        }
    }

    private static void putExecuteResultMacro(Map<String, ExpressionProperty> props, FlowElement element, int sort, String expression, String structurenumber) {
        List<Parameter> outParams = null;
        if (element instanceof AutoMicroServiceTask) {
            AutoMicroServiceTask task = (AutoMicroServiceTask)element;
            outParams = task.getOutParams();
        }
        if (outParams == null || outParams.isEmpty()) {
            return;
        }
        for (int i = 0; i < outParams.size(); ++i) {
            Parameter param = outParams.get(i);
            ProcessMarcoExpressionProp p = new ProcessMarcoExpressionProp();
            p.setName(param.getName());
            p.setParseType(PROC);
            p.setComparetype("String");
            p.setControlType("String");
            p.setHasquotes(true);
            p.setValuetype("String");
            p.setOrder(sort + i + 1);
            p.setNumber(param.getNumber());
            p.setExpression(String.format(STRINGFORMAT, expression, param.getNumber()));
            String snumber = String.format(STRINGFORMAT, structurenumber, param.getNumber());
            p.setStructurenumber(snumber);
            props.put(snumber, p);
        }
    }

    private static void putEventMacroProps(Map<String, ExpressionProperty> props, ExtExpressionRow row, Process process) {
        List<Macro> macros = process.getMacros();
        int sort = 0;
        for (Macro m : macros) {
            String macroNumber = m.getName();
            if (!macroNumber.endsWith("Event")) continue;
            String nodeId = macroNumber.substring(0, macroNumber.lastIndexOf("Event"));
            WaitTask wtask = (WaitTask)process.getFlowElement(nodeId);
            String evNumber = "";
            if (wtask == null || wtask.getTimingModel() == null || !WfUtils.isNotEmpty(evNumber = wtask.getTimingModel().getEvent())) continue;
            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
            ++sort;
            prop.setName(m.getDescription());
            prop.setParseType(PROC);
            prop.setComparetype(row.getString(COMPARETYPE));
            prop.setControlType(row.getString(CONTROLTYPE));
            prop.setHasquotes(row.getBoolean(HASQUOTES));
            prop.setValuetype(row.getString(VALUETYPE));
            prop.setOrder(row.getInteger(FORDER) + sort);
            prop.setNumber(macroNumber);
            String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_EVENT, macroNumber);
            prop.setExpression(expression);
            String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_EVENT, macroNumber);
            prop.setStructurenumber(structurenumber);
            prop.setEntityNumber("");
            prop.setParam(evNumber);
            prop.setType(EVENT);
            props.put(structurenumber, prop);
            props.put(structurenumber, prop);
        }
    }

    public static void getEventArgProp(ExpressionProperty prop, List<ExpressionProperty> props, String evtNumber, AbstractFormPlugin plugin) {
        QFilter filter = new QFilter(NUMBER, "=", (Object)evtNumber);
        DynamicObjectCollection tmp = QueryServiceHelper.query((String)"evt_event", (String)"number,config.configname,config.confignumber,config.configtype,config.configdescription", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : tmp) {
            ExpressionProperty subProp = new ExpressionProperty();
            if (WfUtils.isEmpty(obj.getString("config.confignumber"))) continue;
            subProp.setName(obj.getString("config.configname"));
            subProp.setFullName(prop.getFullName() + "." + obj.getString("config.configname"));
            subProp.setNumber(obj.getString("config.confignumber"));
            subProp.setPrefix(EVENT);
            subProp.setParseType(MODEL);
            String cfgJson = obj.getString("config.configtype");
            if (WfUtils.isNotEmpty(cfgJson)) {
                Map argsCfg = (Map)SerializationUtils.fromJsonString((String)cfgJson, Map.class);
                String valueType = (String)argsCfg.get("type");
                subProp.setComparetype(valueType);
                subProp.setValuetype(valueType);
                subProp.setControlType(valueType);
                subProp.setHasquotes(true);
                String entityNumber = (String)argsCfg.get("entityid");
                String itemsStr = "";
                if (WfUtils.isNotEmpty(entityNumber)) {
                    subProp.setEntityNumber(entityNumber);
                    subProp.setParam(entityNumber);
                    subProp.setComparetype(F7);
                    subProp.setValuetype(F7);
                    subProp.setControlType(F7);
                    subProp.setHasquotes(false);
                    if (plugin != null && !"evt_participantplugin".equals(plugin.getView().getParentView().getEntityId())) {
                        String number = subProp.getNumber();
                        subProp.setNumber(number);
                    }
                } else if (NUMBER.equals(valueType)) {
                    subProp.setHasquotes(false);
                } else {
                    itemsStr = (String)argsCfg.get("attribute");
                    if (WfUtils.isNotEmpty(itemsStr)) {
                        List items = SerializationUtils.fromJsonStringToList((String)itemsStr, ComboItem.class);
                        subProp.setControlType("enum");
                        subProp.setItems(items);
                    } else if ("String".equals(valueType)) {
                        subProp.setControlType(TEXT);
                    }
                }
            }
            subProp.setStructurenumber(subProp.getNumber());
            subProp.setPath(subProp.getNumber());
            subProp.setExpression(prop.getExpression() + "." + subProp.getPath());
            subProp.setHasquotes(true);
            props.add(subProp);
        }
    }

    private static void putForkResultMacroProps(Map<String, ExpressionProperty> props, ExtExpressionRow row, Process process) {
        Map<String, NodeForkJoinModel> fk = process.getForkJoinModels();
        if (fk != null && !fk.isEmpty()) {
            int sort = 0;
            for (Map.Entry<String, NodeForkJoinModel> entry : fk.entrySet()) {
                List<SequenceFlow> seqs;
                NodeForkJoinModel fkModel = entry.getValue();
                if (fkModel == null || !fkModel.isJoinNode()) continue;
                String forkNodeId = fkModel.getPairForkNodeId();
                String joinNodeId = fkModel.getNodeId();
                FlowNode elem = (FlowNode)process.getFlowElement(forkNodeId);
                FlowNode joinElem = (FlowNode)process.getFlowElement(joinNodeId);
                if (elem == null || (seqs = elem.getOutgoingFlows()) == null || seqs.isEmpty()) continue;
                for (SequenceFlow seq : seqs) {
                    if (seq.getTargetFlowElement() == null) {
                        logger.warn(String.format("\u6d41\u8f6c\u7ebf[%s]\u7684\u8bbe\u8ba1\u6709\u6ca1\u6709\u51fa\u53e3\u8282\u70b9!", seq.getId()));
                        continue;
                    }
                    ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
                    if (WfUtils.isEmpty(seq.getName())) {
                        prop.setName(elem.getName() + "-" + seq.getTargetFlowElement().getName());
                    } else {
                        prop.setName(String.format(ResManager.loadKDString((String)"%1$s\u5206\u652f", (String)"ExpressionPropUtils_11", (String)"bos-wf-engine", (Object[])new Object[0]), seq.getName()));
                    }
                    prop.setParseType(PROC);
                    prop.setComparetype(row.getString(COMPARETYPE));
                    prop.setControlType(row.getString(CONTROLTYPE));
                    prop.setHasquotes(row.getBoolean(HASQUOTES));
                    prop.setValuetype(row.getString(VALUETYPE));
                    prop.setOrder(row.getInteger(FORDER) + sort);
                    prop.setNumber(joinElem.getId() + "$" + elem.getId() + "$" + seq.getTargetFlowElement().getId() + "ForkResult");
                    String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_FORKRESULT, prop.getNumber());
                    prop.setExpression(expression);
                    String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_FORKRESULT, prop.getNumber());
                    prop.setStructurenumber(structurenumber);
                    prop.setItems(ExpressionPropUtils.getForkResultItems());
                    props.put(structurenumber, prop);
                }
            }
        }
    }

    private static List<ComboItem> getForkResultItems() {
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        types.put("emptyVal", ResManager.loadKDString((String)"\u7a7a", (String)"ExpressionPropUtils_12", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("approve", ResManager.loadKDString((String)"\u540c\u610f", (String)"ExpressionPropUtils_13", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("reject", ResManager.loadKDString((String)"\u9a73\u56de", (String)"ExpressionPropUtils_14", (String)"bos-wf-engine", (Object[])new Object[0]));
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(types.size());
        for (Map.Entry entry : types.entrySet()) {
            String type = (String)entry.getKey();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString((String)entry.getValue()));
            item.setValue(type);
            items.add(item);
        }
        return items;
    }

    private static void putExecutionTypeMacroProps(Map<String, ExpressionProperty> props, ExtExpressionRow row, Process process) {
        List<Macro> macros = process.getMacros();
        String EXECUTIONTYPE = "ExecutionType";
        int sort = 0;
        for (Macro macro : macros) {
            String macroNumber = macro.getName();
            if (!macroNumber.endsWith("ExecutionType")) continue;
            ++sort;
            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
            prop.setName(macro.getDescription());
            prop.setParseType(PROC);
            prop.setComparetype(row.getString(COMPARETYPE));
            prop.setControlType(row.getString(CONTROLTYPE));
            prop.setHasquotes(row.getBoolean(HASQUOTES));
            prop.setValuetype(row.getString(VALUETYPE));
            prop.setOrder(row.getInteger(FORDER) + sort);
            prop.setNumber(macroNumber);
            String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_EXECUTIONTYPE, macroNumber);
            prop.setExpression(expression);
            String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_EXECUTIONTYPE, macroNumber);
            prop.setStructurenumber(structurenumber);
            prop.setItems(ExpressionPropUtils.getExecutionTypeItems());
            props.put(structurenumber, prop);
        }
    }

    private static void putEventParamMacroProps(Map<String, ExpressionProperty> props, ExtExpressionRow row, Process process) {
        List<Macro> macros = process.getMacros();
        int sort = 0;
        String suffix = MACRO_EVENTPARAM.replace("${nodeId}", "");
        for (Macro macro : macros) {
            String macroNumber = macro.getName();
            if (!macroNumber.endsWith(suffix)) continue;
            ++sort;
            ProcessMarcoExpressionProp prop = new ProcessMarcoExpressionProp();
            prop.setName(macro.getDescription());
            prop.setParseType(PROC);
            prop.setComparetype(row.getString(COMPARETYPE));
            prop.setControlType(row.getString(CONTROLTYPE));
            prop.setHasquotes(row.getBoolean(HASQUOTES));
            prop.setValuetype(row.getString(VALUETYPE));
            prop.setOrder(row.getInteger(FORDER) + sort);
            prop.setNumber(macroNumber);
            String expression = row.getString(EXPRESSIONTEMPLATE).replace(MACRO_EVENTPARAM, macroNumber);
            prop.setExpression(expression);
            String structurenumber = row.getString(STRUCTURENUMBER).replace(MACRO_EVENTPARAM, macroNumber);
            prop.setStructurenumber(structurenumber);
            props.put(structurenumber, prop);
            String nodeId = macroNumber.replace(suffix, "");
            FlowElement element = process.getFlowElement(nodeId);
            ExpressionPropUtils.putEventParamsMacro(props, element, prop.getOrder(), expression, structurenumber);
        }
    }

    private static void putEventParamsMacro(Map<String, ExpressionProperty> props, FlowElement element, int sort, String expression, String structurenumber) {
        BillTask billTask;
        BillCloseConfig config;
        List<EventParam> evtParams = null;
        if (element instanceof EventSupportTask) {
            EventSupportTask task = (EventSupportTask)element;
            evtParams = task.getEventParams();
        } else if (element instanceof BillTask && (config = (billTask = (BillTask)element).getBillCloseConfig()) != null && config.getWaitActions() != null && config.getWaitActions().getCloseEvent() != null) {
            evtParams = config.getWaitActions().getCloseEvent().getParams();
        }
        if (evtParams == null || evtParams.isEmpty()) {
            return;
        }
        for (int i = 0; i < evtParams.size(); ++i) {
            EventParam param = evtParams.get(i);
            ProcessMarcoExpressionProp p = new ProcessMarcoExpressionProp();
            p.setName(param.getName());
            p.setParseType(PROC);
            p.setComparetype("String");
            p.setControlType("String");
            p.setHasquotes(true);
            p.setValuetype("String");
            p.setOrder(sort + i + 1);
            p.setNumber(param.getNumber());
            p.setExpression(String.format(STRINGFORMAT, expression, param.getNumber()));
            String snumber = String.format(STRINGFORMAT, structurenumber, param.getNumber());
            p.setStructurenumber(snumber);
            props.put(snumber, p);
        }
    }

    private static List<ComboItem> getExecutionTypeItems() {
        LinkedHashMap<String, String> types = new LinkedHashMap<String, String>();
        types.put("byHand", ResManager.loadKDString((String)"\u4eba\u5de5", (String)"ExpressionPropUtils_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("byAuto", ResManager.loadKDString((String)"\u81ea\u52a8", (String)"ExpressionPropUtils_16", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("skip", ResManager.loadKDString((String)"\u8df3\u8fc7", (String)"ExpressionPropUtils_17", (String)"bos-wf-engine", (Object[])new Object[0]));
        types.put("jump", ResManager.loadKDString((String)"\u8df3\u8f6c", (String)"ExpressionPropUtils_18", (String)"bos-wf-engine", (Object[])new Object[0]));
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(types.size());
        for (Map.Entry entry : types.entrySet()) {
            String type = (String)entry.getKey();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString((String)entry.getValue()));
            item.setValue(type);
            items.add(item);
        }
        return items;
    }

    private static List<ExpressionProperty> getModelProps(ExpressionProperty parentProp, String leftPropEntryPath) {
        String entityNumber = parentProp.getParam();
        if (WfUtils.isEmpty(entityNumber) || EVENT.equals(entityNumber)) {
            return Collections.emptyList();
        }
        MainEntityType mainType = BusinessObjectQueryHelper.getDataEntityType((String)entityNumber);
        Collection values = mainType.getAllFields().values();
        ArrayList<ExpressionProperty> props = new ArrayList<ExpressionProperty>(values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            IDataEntityProperty fieldProp;
            ModelExpressionProp prop = new ModelExpressionProp();
            String parentEntryPath = parentProp.getEntryPath();
            if (WfUtils.isNotEmpty(parentEntryPath)) {
                prop.setEntryPath(parentEntryPath);
            }
            if ((fieldProp = (IDataEntityProperty)iter.next()) instanceof AttachmentProp || WfUtils.isEmpty(fieldProp.getAlias()) || entityNumber.equals("wf_hitaskinst") && DELEGATIONSTATE.equals(fieldProp.getName()) || TaskExtendFieldUtil.isSpecialPropNeedRemove(entityNumber, fieldProp).booleanValue()) continue;
            if (fieldProp instanceof IFieldHandle) {
                if (((IFieldHandle)fieldProp).getDisplayName() == null) continue;
                prop.setEntryCount(parentProp.getEntryCount());
                int parentMultiPropKey = parentProp.getMultiPropKey();
                prop.setMultiPropKey(parentMultiPropKey);
                if (WfUtils.isNotEmpty(fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName())) {
                    EntityType enType;
                    if (parentMultiPropKey >= 2 || parentProp.getEntryCount() >= 3) continue;
                    String entryPath = String.format(STRINGFORMAT, parentProp.getExpression(), fieldProp.getParent().getName());
                    prop.setEntryCount(parentProp.getEntryCount() + 1);
                    if (parentMultiPropKey > 0) {
                        prop.setMultiPropKey(parentMultiPropKey + 1);
                    }
                    if (fieldProp.getParent().getParent() != null && fieldProp.getParent().getParent().getParent() != null) {
                        entryPath = String.format("%s.%s.%s", parentProp.getExpression(), fieldProp.getParent().getParent().getName(), fieldProp.getParent().getName());
                        prop.setNumber(fieldProp.getParent().getParent().getName() + "." + fieldProp.getParent().getName() + "." + fieldProp.getName());
                        if (WfUtils.isNotEmpty(leftPropEntryPath) && !leftPropEntryPath.equals(entryPath)) continue;
                        prop.setEntryPath(entryPath);
                        if (!(fieldProp.getParent() instanceof EntryType) || !(fieldProp.getParent().getParent() instanceof EntryType)) continue;
                        enType = (EntityType)fieldProp.getParent();
                        EntityType pEnType = (EntityType)fieldProp.getParent().getParent();
                        if (WfUtils.isNotEmpty(enType.getDisplayName().toString()) && WfUtils.isNotEmpty(pEnType.getDisplayName().toString())) {
                            prop.setName(pEnType.getDisplayName().getLocaleValue() + "." + enType.getDisplayName().getLocaleValue() + "." + ((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                        }
                        prop.setEntryCount(parentProp.getEntryCount() + 2);
                        prop.setPath(prop.getNumber());
                    } else {
                        if (WfUtils.isNotEmpty(leftPropEntryPath) && !leftPropEntryPath.equals(entryPath)) continue;
                        prop.setEntryPath(entryPath);
                        if (fieldProp.getParent() instanceof EntryType && WfUtils.isNotEmpty((enType = (EntityType)fieldProp.getParent()).getDisplayName().toString())) {
                            prop.setName(enType.getDisplayName().getLocaleValue() + "." + ((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                        }
                        prop.setEntryPath(parentProp.getExpression() + "." + fieldProp.getParent().getName());
                        if (WfUtils.isNotEmpty(leftPropEntryPath) && !leftPropEntryPath.equals(prop.getEntryPath())) continue;
                        prop.setNumber(fieldProp.getParent().getName() + "." + fieldProp.getName());
                        prop.setPath(prop.getNumber());
                    }
                } else {
                    prop.setNumber(fieldProp.getName());
                    prop.setPath(fieldProp.getName());
                }
                if ("billno".equals(prop.getNumber())) {
                    prop.setSample("KD-JKD-20190102");
                }
                if (WfUtils.isEmpty(prop.getName())) {
                    prop.setName(((IFieldHandle)fieldProp).getDisplayName().getLocaleValue());
                }
                prop.setExpression(parentProp.getExpression() + "." + prop.getPath());
                if (WfUtils.isNotEmpty(parentProp.getSample()) && "name".equals(prop.getNumber())) {
                    prop.setSample(parentProp.getSample());
                }
                if (fieldProp instanceof BasedataProp || fieldProp instanceof MulBasedataProp) {
                    if (fieldProp instanceof UserProp) {
                        prop.setSample(ResManager.loadKDString((String)"\u5f20\u4e09", (String)"ExpressionPropUtils_19", (String)"bos-wf-engine", (Object[])new Object[0]));
                    } else if (fieldProp instanceof OrgProp) {
                        prop.setSample(ResManager.loadKDString((String)"\u73af\u7403\u516c\u53f8", (String)"ExpressionPropUtils_20", (String)"bos-wf-engine", (Object[])new Object[0]));
                        prop.setOrgFunc(((OrgProp)fieldProp).getOrgFunc());
                    }
                    prop.setParseType(MODEL);
                    if (fieldProp instanceof BasedataProp) {
                        prop.setParam(((BasedataProp)fieldProp).getBaseEntityId());
                    } else if (fieldProp instanceof MulBasedataProp) {
                        if (WfUtils.isNotEmpty(leftPropEntryPath)) continue;
                        prop.setMultiPropKey(1);
                        prop.setParam(((MulBasedataProp)fieldProp).getBaseEntityId());
                    }
                    prop.setEntityNumber(prop.getParam());
                    prop.setControlType(F7);
                    prop.setValuetype(F7);
                    if (WfUtils.isNotEmpty(prop.getComparetype())) {
                        prop.setComparetype(prop.getComparetype() + "." + F7);
                    } else {
                        prop.setComparetype(F7);
                    }
                    if (fieldProp instanceof MulBasedataProp && ((MulBasedataProp)fieldProp).getRefIdProp() instanceof VarcharProp) {
                        prop.setHasquotes(true);
                    } else if (fieldProp instanceof BasedataProp && ((BasedataProp)fieldProp).getRefIdProp() instanceof VarcharProp) {
                        prop.setHasquotes(true);
                    } else {
                        prop.setHasquotes(false);
                    }
                } else {
                    prop.setControlType(ExpressionPropUtils.getControlType(fieldProp));
                    String valueType = ExpressionPropUtils.getReturnType(fieldProp);
                    if (NUMBER.equals(valueType) || "boolean".equals(valueType)) {
                        prop.setHasquotes(false);
                    } else {
                        prop.setHasquotes(true);
                    }
                    prop.setValuetype(valueType);
                    if (WfUtils.isNotEmpty(prop.getComparetype())) {
                        prop.setComparetype(prop.getComparetype() + "." + F7);
                    } else {
                        prop.setComparetype(valueType);
                    }
                    if (fieldProp instanceof ComboProp) {
                        ComboProp c = (ComboProp)fieldProp;
                        List lists = c.getComboItems();
                        ArrayList<ComboItem> items = new ArrayList<ComboItem>(lists.size());
                        for (ValueMapItem i : lists) {
                            ComboItem item = new ComboItem();
                            item.setValue(i.getValue());
                            item.setCaption(i.getName());
                            items.add(item);
                        }
                        prop.setItems(items);
                    } else if (fieldProp instanceof BooleanProp) {
                        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                        ComboItem item = new ComboItem();
                        item.setValue("1");
                        item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"ExpressionPropUtils_9", (String)"bos-wf-engine", (Object[])new Object[0])));
                        items.add(item);
                        ComboItem nitem = new ComboItem();
                        nitem.setValue("0");
                        nitem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"ExpressionPropUtils_10", (String)"bos-wf-engine", (Object[])new Object[0])));
                        items.add(nitem);
                        prop.setItems(items);
                    }
                    prop.setControlType(ExpressionPropUtils.getControlType(fieldProp));
                }
            }
            if (WfUtils.isNotEmpty(parentProp.getFullName())) {
                prop.setFullName(parentProp.getFullName() + "." + prop.getName());
            } else {
                prop.setFullName(parentProp.getName() + "." + prop.getName());
            }
            props.add(prop);
        }
        props.addAll(ExpressionPropUtils.getCustomPropsByType(entityNumber, parentProp));
        return props;
    }

    private static List<ExpressionProperty> getCustomPropsByType(String entityNumber, ExpressionProperty parentProp) {
        ArrayList<ExpressionProperty> props;
        int multiKey = -1;
        String parentExpression = parentProp.getStructurenumber();
        if (WfUtils.isNotEmpty(parentExpression) && parentExpression.startsWith("proc.user.") && parentExpression.split("\\.").length < 4) {
            multiKey = parentProp.getMultiPropKey();
            parentProp.setMultiPropKey(0);
        }
        if ((props = null) == null || props.isEmpty()) {
            props = new ArrayList<ExpressionProperty>();
            String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_expressionext", "a", "b", FNAME, "name", "name");
            String sql = "SELECT a.fnumber number,a.fcontroltype controltype,a.fcomparetype comparetype,a.fhasquotes hasquotes,a.fvaluetype valuetype,a.fvalueentitynumber valueentitynumber,a.fvaluecomboitems valuecomboitems," + nameSQL + " " + FROM + SQL_TABLE_A + SQL_LEFTJION + WHERE + "fentitynumber = ?";
            String lang = RequestContext.get().getLang().toString();
            Object[] params = new String[]{lang, entityNumber};
            try {
                List<ExtExpressionRow> rows = ExpressionPropUtils.getCachedData(sql, (String[])params);
                if (rows == null) {
                    rows = new ArrayList<ExtExpressionRow>();
                    try (DataSet ds = DB.queryDataSet((String)QUERYEXECUTIONINFO, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
                        Iterator iterator = ds.iterator();
                        RowMeta rowMeta = ds.getRowMeta();
                        while (iterator.hasNext()) {
                            rows.add(new ExtExpressionRow(rowMeta, (Row)iterator.next()));
                        }
                        ExpressionPropUtils.addCachedData(sql, (String[])params, rows);
                    }
                }
                for (ExtExpressionRow r : rows) {
                    ExpressionProperty prop = new ExpressionProperty();
                    prop.setName(r.getString("name"));
                    if (WfUtils.isNotEmpty(parentProp.getFullName())) {
                        prop.setFullName(parentProp.getFullName() + "." + prop.getName());
                    } else {
                        prop.setFullName(parentProp.getName() + "." + prop.getName());
                    }
                    prop.setNumber(r.getString(NUMBER));
                    prop.setMultiPropKey(parentProp.getMultiPropKey());
                    prop.setPath(r.getString(NUMBER));
                    prop.setPrefix(parentProp.getPrefix());
                    prop.setExpression(parentProp.getExpression() + "." + prop.getPath());
                    prop.setComparetype(r.getString(COMPARETYPE));
                    prop.setControlType(r.getString(CONTROLTYPE));
                    prop.setValuetype(r.getString(VALUETYPE));
                    prop.setHasquotes(r.getBoolean(HASQUOTES));
                    prop.setEntityNumber(r.getString(VALUEENTITYNUMBER));
                    if (WfUtils.isNotEmpty(r.getString("valuecomboitems"))) {
                        List list = SerializationUtils.fromJsonStringToList((String)r.getString("valuecomboitems"), Map.class);
                        ArrayList<ComboItem> items = new ArrayList<ComboItem>(list.size());
                        for (Map i : list) {
                            ComboItem item = new ComboItem();
                            item.setId(ExpressionPropUtils.getVal(i.get("id")));
                            item.setValue(ExpressionPropUtils.getVal(i.get("id")));
                            item.setCaption(new LocaleString((String)i.get("name")));
                            items.add(item);
                        }
                        prop.setItems(items);
                    }
                    prop.setStructurenumber(parentProp.getStructurenumber() + "." + prop.getNumber());
                    if ("bos_org".equalsIgnoreCase(r.getString(VALUEENTITYNUMBER)) || BOS_USER.equalsIgnoreCase(r.getString(VALUEENTITYNUMBER))) {
                        prop.setParam(r.getString(VALUEENTITYNUMBER));
                        prop.setParseType(MODEL);
                    }
                    props.add(prop);
                }
            }
            catch (Exception e) {
                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b9e\u4f53\u7f16\u7801\u83b7\u53d6expression\u8868\u8fbe\u5f0f\u5c5e\u6027\u5f02\u5e38\uff0c\u5b9e\u4f53\u7f16\u7801\uff1a%1$s\u3002", (String)"ExpressionPropUtils_21", (String)"bos-wf-engine", (Object[])new Object[0]), entityNumber)});
            }
        }
        if (multiKey != -1) {
            parentProp.setMultiPropKey(multiKey);
        }
        return props;
    }

    public static List<Map<String, String>> getCustomPropsByType(String entityNumber, String valueentitynumber) {
        ArrayList<Map<String, String>> coustomProps = new ArrayList<Map<String, String>>();
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_expressionext", "a", "b", FNAME, "name", "name");
        String sql = "SELECT a.fnumber number,a.fcontroltype controltype,a.fcomparetype comparetype,a.fhasquotes hasquotes,a.fvaluetype valuetype,a.fvalueentitynumber valueentitynumber,a.fvaluecomboitems valuecomboitems," + nameSQL + " " + FROM + SQL_TABLE_A + SQL_LEFTJION + WHERE + "fentitynumber = ? AND fvalueentitynumber = ?";
        String lang = RequestContext.get().getLang().toString();
        Object[] params = new Object[]{lang, entityNumber, valueentitynumber};
        try (DataSet ds = DB.queryDataSet((String)QUERYEXECUTIONINFO, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            for (Row r : ds) {
                HashMap<String, String> prop = new HashMap<String, String>();
                prop.put("name", r.getString("name"));
                prop.put(NUMBER, r.getString(NUMBER));
                coustomProps.add(prop);
            }
        }
        return coustomProps;
    }

    public static synchronized List<ExpressionProperty> getFunctionProps() {
        String lang = RequestContext.get().getLang().toString();
        if (WfUtils.isEmptyForMap(localeFunctionProps.get(lang))) {
            HashMap<String, ExpressionProperty> functionProps = new HashMap<String, ExpressionProperty>();
            String nameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_expressionext", "a", "b", FNAME, "name", "name");
            String descSQL = WfMultiLangUtils.getGeneralLangSQL("wf_expressionext", "a", "b", FDESCRIPTION, DESCRIPTION, DESCRIPTION);
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append(SQL_NUMBER).append("a.fentityNumber entityNumber,").append(SQL_CONTROLTYPE).append(SQL_COMPARETYPE).append(SQL_HASQUOTES).append(SQL_VALUETYPE).append(SQL_ORDERNUMBER).append(SQL_GROUPID).append("a.fvalueentitynumber valueentitynumber, ").append(nameSQL).append(", ").append(descSQL).append(" from t_wf_expressionext a ").append(SQL_LEFTJION).append("where ").append("a.ftype = 'function'");
            try (DataSet ds = DB.queryDataSet((String)QUERYEXECUTIONINFO, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{lang});){
                for (Row r : ds) {
                    ExpressionProperty prop = new ExpressionProperty();
                    String number = r.getString(NUMBER);
                    prop.setNumber(number);
                    prop.setEntityNumber(r.getString(ENTITYNUMBER));
                    prop.setControlType(r.getString(CONTROLTYPE));
                    prop.setComparetype(r.getString(COMPARETYPE));
                    prop.setHasquotes(r.getBoolean(HASQUOTES));
                    prop.setValuetype(r.getString(VALUETYPE));
                    prop.setOrder(r.getInteger(ORDERNUMBER));
                    prop.setGroupId(r.getString(GROUPID));
                    prop.setName(r.getString("name"));
                    prop.setDescription(r.getString(DESCRIPTION));
                    prop.setType("function");
                    functionProps.put(number, prop);
                }
            }
            localeFunctionProps.put(lang, functionProps);
        }
        return new ArrayList<ExpressionProperty>(localeFunctionProps.get(lang).values());
    }

    private static String getReturnType(IDataEntityProperty fieldProp) {
        if (fieldProp instanceof BooleanProp) {
            return "boolean";
        }
        if (fieldProp instanceof BigIntProp || fieldProp instanceof IntegerProp || fieldProp instanceof AmountProp || fieldProp instanceof DecimalProp) {
            return NUMBER;
        }
        if (fieldProp instanceof TextProp || fieldProp instanceof MuliLangTextProp || fieldProp instanceof BillStatusProp || fieldProp instanceof MulComboProp || fieldProp instanceof ComboProp || fieldProp instanceof PictureProp) {
            return "String";
        }
        if (fieldProp instanceof CreateDateProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof DateProp || fieldProp instanceof DateTimeProp) {
            return DATE;
        }
        return "String";
    }

    private static String getControlType(IDataEntityProperty fieldProp) {
        if (fieldProp instanceof BooleanProp || fieldProp instanceof ComboProp || fieldProp instanceof MulComboProp || fieldProp instanceof BillStatusProp) {
            return "enum";
        }
        if (fieldProp instanceof BigIntProp || fieldProp instanceof IntegerProp) {
            return NUMBER;
        }
        if (fieldProp instanceof PriceProp || fieldProp instanceof AmountProp || fieldProp instanceof QtyProp || fieldProp instanceof ExchangeRateProp || fieldProp instanceof DecimalProp) {
            return "decimal";
        }
        if (fieldProp instanceof TextProp || fieldProp instanceof MuliLangTextProp) {
            return TEXT;
        }
        if (fieldProp instanceof CreateDateProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof DateProp || fieldProp instanceof DateTimeProp) {
            return DATE;
        }
        return TEXT;
    }

    public static boolean isExpressionValue(String value) {
        return value.startsWith("${") && value.matches("\\$\\{.+\\}");
    }

    public static boolean isProcUserProp(String expression) {
        if (WfUtils.isEmpty(expression)) {
            return false;
        }
        return expression.contains("proc.user.") && !expression.contains("_mc");
    }

    public static boolean isExpressionDateType(String expressionType) {
        return DATE.equals(expressionType) || DATETIME.equals(expressionType);
    }

    static {
        virtualNodeNumberSet.add(PROC);
        virtualNodeNumberSet.add("user");
        virtualNodeNumberSet.add("auditNumber");
        virtualNodeNumberSet.add("nodeName");
        virtualNodeNumberSet.add("executeResult");
        virtualNodeNumberSet.add("executionType");
        virtualNodeNumberSet.add("forkResult");
        virtualNodeNumberSet.add("variable");
        virtualNodeNumberSet.add("other");
    }
}

