/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.rule.util;

import de.odysseus.el.function.collection.CollectionFunctionType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;

public class WfFunctionConfigUtils {
    public static final String FUNCTION = "function";
    public static final String FUNCGROUP_ENUM = "Enum";
    public static final String FUNCGROUP_COLLECTION = "Collection";
    public static final String FUNCGROUP_CUSTOM = "Custom";
    public static final String EFFECTSCOPE_ALL = "all";
    public static final String EFFECTSCOPE_ALLENTRY = "allEntry";
    public static final String EFFECTSCOPE_ENTRY = "entry";
    public static final String DATATYPE_ALLTYPE = "allType";
    public static final String DATATYPE_NUMBERTYPE = "numberType";
    public static final String DATATYPE_ENUMTYPE = "enumType";
    public static final String FUNCNUMBER_FIRST = "first";
    public static final String FUNCNUMBER_SUM = "sum";
    public static final String FUNCNUMBER_MIN = "min";
    public static final String FUNCNUMBER_MAX = "max";
    public static final String FUNCNUMBER_COUNT = "count";
    public static final String FUNCNUMBER_AVG = "avg";
    public static final String FUNCNUMBER_ABSENUM = "absenum";
    public static final String DESCNAME_ABSENUM = "absenum(obj[])";
    public static final String RETURNVALTYPE_ABSENUM = "string";
    public static final String VALUETYPE_BOOLEAN = "boolean";
    public static final String PREFIXUP_EVENT = "Event.";
    public static final String PREFIXLOW_EVENT = "event.";

    public static LocaleString getEnumFuncGroupName() {
        return ResManager.getLocaleString((String)"\u679a\u4e3e\u51fd\u6570", (String)"WfFunctionConfigUtils_1", (String)"bos-wf-engine");
    }

    public static LocaleString getCollectionFuncGroupName() {
        return ResManager.getLocaleString((String)"\u96c6\u5408\u51fd\u6570", (String)"WfFunctionConfigUtils_2", (String)"bos-wf-engine");
    }

    public static LocaleString getCustomFuncGroupName() {
        return ResManager.getLocaleString((String)"\u81ea\u5b9a\u4e49\u51fd\u6570", (String)"WfFunctionConfigUtils_3", (String)"bos-wf-engine");
    }

    public static List<ExpressionProperty> getFuncPropsByCurProp(ExpressionProperty currentProp, Map<String, String> filterMap) {
        if (currentProp == null) {
            return null;
        }
        Set<String> entityLevelScopes = WfFunctionConfigUtils.getCurPropEntityLevels(currentProp);
        Set<String> entityDataTypes = WfFunctionConfigUtils.getFuncDataType(currentProp);
        if (entityLevelScopes == null || entityDataTypes == null || WfUtils.isEmptyForCollection(entityLevelScopes) || WfUtils.isEmptyForCollection(entityDataTypes)) {
            return null;
        }
        List<ExpressionProperty> allFuncProps = ExpressionPropUtils.getFunctionProps();
        ArrayList<ExpressionProperty> funcProps = new ArrayList<ExpressionProperty>(allFuncProps.size());
        if (WfUtils.isNotEmptyForCollection(allFuncProps)) {
            for (ExpressionProperty funcProp : allFuncProps) {
                String[] scopeAndType;
                if (FUNCNUMBER_COUNT.equals(funcProp.getNumber()) && WfUtils.isNotEmptyForMap(filterMap) && "filterF7".equals(filterMap.get("filter")) || (scopeAndType = funcProp.getEntityNumber().split("_")).length != 2) continue;
                String funcEffectScope = scopeAndType[0];
                String funcDataType = scopeAndType[1];
                if (!StringUtils.isNotBlank((CharSequence)funcEffectScope) || !StringUtils.isNotBlank((CharSequence)funcDataType) || !entityLevelScopes.contains(funcEffectScope) || !entityDataTypes.contains(funcDataType)) continue;
                funcProps.add(funcProp);
            }
        }
        return funcProps;
    }

    public static Set<String> getCurPropEntityLevels(ExpressionProperty currentProp) {
        HashSet<String> entityLevelScopes = null;
        if (currentProp != null) {
            entityLevelScopes = new HashSet<String>(3);
            entityLevelScopes.add(EFFECTSCOPE_ALL);
            int entryCount = currentProp.getEntryCount();
            String number = currentProp.getNumber();
            if (StringUtils.isNotBlank((CharSequence)currentProp.getEntryPath()) && entryCount > 0 && StringUtils.isNotBlank((CharSequence)number) && number.contains(".")) {
                entityLevelScopes.add(EFFECTSCOPE_ALLENTRY);
                entityLevelScopes.add(String.format("%s%s", EFFECTSCOPE_ENTRY, entryCount));
            }
        }
        return entityLevelScopes;
    }

    public static Set<String> getFuncDataType(ExpressionProperty currentProp) {
        HashSet<String> funcDataTypes = null;
        String controlType = currentProp.getControlType();
        String valueType = currentProp.getValuetype();
        String expression = currentProp.getExpression();
        if (StringUtils.isNotBlank((CharSequence)controlType) && StringUtils.isNotBlank((CharSequence)valueType) && StringUtils.isNotBlank((CharSequence)expression)) {
            funcDataTypes = new HashSet<String>(2);
            funcDataTypes.add(DATATYPE_ALLTYPE);
            switch (controlType) {
                case "enum": {
                    if (StringUtils.equals((CharSequence)VALUETYPE_BOOLEAN, (CharSequence)valueType) || expression.startsWith(PREFIXLOW_EVENT) || expression.startsWith(PREFIXUP_EVENT)) break;
                    funcDataTypes.add(DATATYPE_ENUMTYPE);
                    break;
                }
                case "number": 
                case "decimal": {
                    funcDataTypes.add(DATATYPE_NUMBERTYPE);
                }
            }
        }
        return funcDataTypes;
    }

    public static ExpressionProperty buildFuncExpressionProp(ExpressionProperty func) {
        ExpressionProperty funcProp = null;
        if (func != null) {
            funcProp = new ExpressionProperty();
            funcProp.setEntityNumber(func.getEntityNumber());
            funcProp.setNumber(func.getNumber());
            funcProp.setControlType(func.getControlType());
            funcProp.setValuetype(func.getValuetype());
            funcProp.setComparetype(func.getComparetype());
            funcProp.setHasquotes(func.isHasquotes());
            funcProp.setType(func.getType());
        }
        return funcProp;
    }

    public static void setFuncPropValues(ExpressionProperty funcProp, ExpressionProperty expProp) {
        if (funcProp != null && expProp != null) {
            String funcNumber = funcProp.getNumber();
            if (CollectionFunctionType.FIRST.getNumber().equals(funcNumber)) {
                funcProp.setControlType(expProp.getControlType());
                funcProp.setComparetype(expProp.getComparetype());
                funcProp.setValuetype(expProp.getValuetype());
                funcProp.setHasquotes(expProp.isHasquotes());
                funcProp.setEntityNumber(expProp.getEntityNumber());
                funcProp.setParam(expProp.getParam());
                funcProp.setItems(expProp.getItems());
                funcProp.setMultiPropKey(expProp.getMultiPropKey());
                funcProp.setParseType(expProp.getParseType());
            } else if (CollectionFunctionType.SUM.getNumber().equals(funcNumber) || CollectionFunctionType.MAX.getNumber().equals(funcNumber) || CollectionFunctionType.MIN.getNumber().equals(funcNumber) || CollectionFunctionType.AVG.getNumber().equals(funcNumber)) {
                funcProp.setControlType(expProp.getControlType());
            }
        }
    }

    public static String getSubjectSuffixByFuncNumber(String funcNumber) {
        if (StringUtils.isBlank((CharSequence)funcNumber)) {
            return "";
        }
        switch (funcNumber) {
            case "absenum": {
                return ResManager.loadKDString((String)"%s\u7684\u679a\u4e3e\u663e\u793a\u503c", (String)"WfFunctionConfigUtils_4", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "first": {
                return ResManager.loadKDString((String)"%s\u7684\u9996\u884c\u503c", (String)"WfFunctionConfigUtils_5", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "sum": {
                return ResManager.loadKDString((String)"%s\u7684\u5408\u8ba1\u503c", (String)"WfFunctionConfigUtils_6", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "min": {
                return ResManager.loadKDString((String)"%s\u7684\u6700\u5c0f\u503c", (String)"WfFunctionConfigUtils_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "max": {
                return ResManager.loadKDString((String)"%s\u7684\u6700\u5927\u503c", (String)"WfFunctionConfigUtils_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "count": {
                return ResManager.loadKDString((String)"%s\u7684\u4e2a\u6570", (String)"WfFunctionConfigUtils_9", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            case "avg": {
                return ResManager.loadKDString((String)"%s\u7684\u5e73\u5747\u503c", (String)"WfFunctionConfigUtils_10", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static String getDescNameByFuncNumber(String funcNumber) {
        return FUNCNUMBER_ABSENUM.equals(funcNumber) ? DESCNAME_ABSENUM : CollectionFunctionType.getDescNameByFuncNumber((String)funcNumber);
    }

    public static String getReturnValTypeByFuncNumber(String funcNumber) {
        return FUNCNUMBER_ABSENUM.equals(funcNumber) ? RETURNVALTYPE_ABSENUM : CollectionFunctionType.getReturnValTypeByFuncNumber((String)funcNumber);
    }
}

