/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.runtime;

import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.SaveOrUpdateByVerifySqlCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;

public class ExecuteJobManager {
    protected static Log logger = LogFactory.getLog(ExecuteJobManager.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ExecuteJobManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public void saveOrUpdate(ExecuteJob job) {
        if (Context.getCommandContext() != null) {
            new SaveEntityCmd<ExecuteJob>(job).execute(Context.getCommandContext());
        } else {
            this.processEngineConfiguration.getCommandExecutor().execute(new SaveEntityCmd<ExecuteJob>(job));
        }
    }

    public void saveOrUpdateByVerifySql(boolean ifWillInsert, ExecuteJob job) {
        if (Context.getCommandContext() != null) {
            new SaveOrUpdateByVerifySqlCmd(job, ifWillInsert).execute(Context.getCommandContext());
        } else {
            this.processEngineConfiguration.getCommandExecutor().execute(new SaveOrUpdateByVerifySqlCmd(job, ifWillInsert));
        }
    }

    public void delete(ExecuteJob job) {
        if (job instanceof EvtJobEntity) {
            this.processEngineConfiguration.getEvtJobEntityManager().delete((EvtJobEntity)job);
        } else if ("taskTimer".equalsIgnoreCase(job.getJobType()) || "taskMessage".equalsIgnoreCase(job.getJobType())) {
            this.processEngineConfiguration.getEntityManagerByEntityName("wf_taskjobrecord").delete(job);
        } else if (job instanceof JobEntity) {
            this.processEngineConfiguration.getJobEntityManager().delete((JobEntity)job);
        } else {
            logger.debug(String.format("delete job[%s] error ! ", job == null ? null : String.format("%s-%s", job.getId(), job.getClass())));
        }
    }
}

