/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ParticipantRangeUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.TaskInfo;

public class GetNextUseableUserTaskNodeUtil {
    public static List<Map<String, Object>> getNextUseableUserTaskNode(Long processDefinitionId, String taskdefinitionkey, DynamicObject model) {
        String businessKey = GetNextUseableUserTaskNodeUtil.getBusinessKeyFromBillModel(model);
        TaskInfo taskInfo = GetNextUseableUserTaskNodeUtil.getTaskInfo(businessKey, taskdefinitionkey);
        return GetNextUseableUserTaskNodeUtil.getNextNodeInfo(processDefinitionId, taskdefinitionkey, model, taskInfo);
    }

    public static String getBusinessKeyFromBillModel(DynamicObject model) {
        Object pkValue;
        String businessKey = null;
        if (null != model && WfUtils.isNotEmptyString(pkValue = model.getPkValue()) && !"0".equals(pkValue.toString())) {
            businessKey = pkValue.toString();
        }
        return businessKey;
    }

    private static TaskInfo getTaskInfo(String businessKey, String taskdefinitionkey) {
        TaskInfo taskInfo = null;
        if (WfUtils.isNotEmpty(businessKey)) {
            QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey), new QFilter("taskDefinitionKey", "=", (Object)taskdefinitionkey)};
            List<TaskEntity> taskInfos = WfUtils.getWfService().getTaskService().findTasksByFilter(filters);
            if (WfUtils.isNotEmptyForCollection(taskInfos)) {
                taskInfo = taskInfos.get(0);
            }
        }
        return taskInfo;
    }

    private static List<Map<String, Object>> getNextNodeInfo(Long processDefinitionId, String taskdefinitionkey, DynamicObject model, TaskInfo taskInfo) {
        List<Map<String, Object>> nodeInfo = null;
        Long processInstanceId = null == taskInfo ? null : taskInfo.getProcessInstanceId();
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(model);
        BpmnModel bpmnModel = ParticipantRangeUtil.getRealBpmnModel(processDefinitionId, processInstanceId, variableScope);
        UserTask userTask = ParticipantRangeUtil.getRealFlowElement(bpmnModel, taskdefinitionkey);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        nodeInfo = WfUtils.getWfService().getRuntimeService().getNextUseableUserTaskNodeForProcessStart(userTask, variables, model, bpmnModel, taskInfo);
        return nodeInfo;
    }
}

