/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.TrusteeInfo;
import kd.bos.workflow.engine.task.delegatesetting.TaskDelegateCalculateResult;

public class TaskDelegateCalculateUtil {
    protected static Log logger = LogFactory.getLog(TaskDelegateCalculateUtil.class);
    private static final char TRUSTNAMEFORMATSTR = '|';

    public static TaskDelegateCalculateResult getTrusteeIds(TaskEntity task, List<Long> nodeParticipantIds, List<Long> autoCoordinatorIds) {
        HashMap<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys = new HashMap<Long, List<DelegateSettingEntity>>();
        HashSet<Long> trustees = new HashSet<Long>();
        TaskDelegateCalculateResult taskDelegateCalculateResult = new TaskDelegateCalculateResult();
        if (nodeParticipantIds == null || nodeParticipantIds.isEmpty()) {
            taskDelegateCalculateResult.setTrustees(trustees);
            taskDelegateCalculateResult.setAssignorIdAndDelegateSettingEntitys(new HashMap<Long, List<DelegateSettingEntity>>());
            return taskDelegateCalculateResult;
        }
        try {
            List<TrusteeInfo> trusteeInfos = nodeParticipantIds.stream().map(participantId -> new TrusteeInfo((Long)participantId, (Long)participantId, null)).collect(Collectors.toList());
            TaskDelegateCalculateUtil.findTargetParticipants(nodeParticipantIds, trusteeInfos, task, trustees, assignorIdAndDelegateSettingEntitys, autoCoordinatorIds, 0);
            taskDelegateCalculateResult.setTrustees(trustees);
            taskDelegateCalculateResult.setAssignorIdAndDelegateSettingEntitys(assignorIdAndDelegateSettingEntitys);
        }
        catch (Exception e) {
            logger.error(String.format("Error in calculating Trustee Id for to-do task with id [%s], cause: %s", task.getId(), WfUtils.getExceptionStacktrace(e)));
        }
        return taskDelegateCalculateResult;
    }

    private static void findTargetParticipants(List<Long> nodeParticipantIds, List<TrusteeInfo> curLayerTrusteeInfos, TaskEntity task, Set<Long> trustees, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, List<Long> autoCoordinatorIds, int count) {
        boolean isNonRecursionFindTargetParticipant = WfConfigurationUtil.isNonRecursionFindTargetParticipant();
        if (isNonRecursionFindTargetParticipant && count > 0 || count > 50) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        DelegateSettingEntityManager delegateEntityManager = commandContext.getDelegateSettingEntityManager();
        List<Long> trusteeIds = curLayerTrusteeInfos.stream().map(trusteeInfo -> trusteeInfo.getTrusteeId()).collect(Collectors.toList());
        Map<Long, List<DelegateSettingEntity>> trusteeDelegates = delegateEntityManager.getEnableDelegateByAssignorIds(trusteeIds);
        if (isNonRecursionFindTargetParticipant) {
            TaskDelegateCalculateUtil.nonRecursionFindTargetParticipant(nodeParticipantIds, task, trustees, assignorIdAndDelegateSettingEntitys, autoCoordinatorIds, trusteeDelegates);
        } else {
            TaskDelegateCalculateUtil.recursionFindTargetParticipant(nodeParticipantIds, curLayerTrusteeInfos, task, trustees, assignorIdAndDelegateSettingEntitys, autoCoordinatorIds, count, trusteeDelegates);
        }
    }

    private static void nonRecursionFindTargetParticipant(List<Long> nodeParticipantIds, TaskEntity task, Set<Long> trustees, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, List<Long> autoCoordinatorIds, Map<Long, List<DelegateSettingEntity>> trusteeDelegates) {
        Set<Map.Entry<Long, List<DelegateSettingEntity>>> trusteeDelegateEntrySet = trusteeDelegates.entrySet();
        for (Map.Entry<Long, List<DelegateSettingEntity>> trusteeDelegate : trusteeDelegateEntrySet) {
            List<DelegateSettingEntity> delegateSettingEntitys = trusteeDelegate.getValue();
            Iterator<DelegateSettingEntity> delegateSettingEntityIterator = delegateSettingEntitys.iterator();
            while (delegateSettingEntityIterator.hasNext()) {
                DelegateSettingEntity delegateSettingEntity = delegateSettingEntityIterator.next();
                if (!TaskDelegateCalculateUtil.isComplianceDelegateSetting(nodeParticipantIds, delegateSettingEntity, task, autoCoordinatorIds)) {
                    delegateSettingEntityIterator.remove();
                    continue;
                }
                trustees.add(delegateSettingEntity.getTrusteeId());
            }
            assignorIdAndDelegateSettingEntitys.put(trusteeDelegate.getKey(), delegateSettingEntitys);
        }
    }

    private static void recursionFindTargetParticipant(List<Long> nodeParticipantIds, List<TrusteeInfo> curLayerTrusteeInfos, TaskEntity task, Set<Long> trustees, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, List<Long> autoCoordinatorIds, int count, Map<Long, List<DelegateSettingEntity>> trusteeDelegates) {
        Set<Map.Entry<Long, List<DelegateSettingEntity>>> trusteeDelegateEntrySet = trusteeDelegates.entrySet();
        for (Map.Entry<Long, List<DelegateSettingEntity>> trusteeDelegate : trusteeDelegateEntrySet) {
            ArrayList<DelegateSettingEntity> delegateSettingEntitys = trusteeDelegate.getValue();
            TrusteeInfo curTruestInfo = TaskDelegateCalculateUtil.findPreTrusteeInfo(curLayerTrusteeInfos, trusteeDelegate.getKey());
            if ((delegateSettingEntitys == null || delegateSettingEntitys.isEmpty()) && curTruestInfo != null) {
                TaskDelegateCalculateUtil.addResult(trustees, assignorIdAndDelegateSettingEntitys, curTruestInfo, trusteeDelegate.getKey());
                continue;
            }
            ArrayList<DelegateSettingEntity> arrayList = delegateSettingEntitys = delegateSettingEntitys == null ? new ArrayList<DelegateSettingEntity>(1) : delegateSettingEntitys;
            List<TrusteeInfo> nextLayerTrusteeInfo = TaskDelegateCalculateUtil.getAvailableTrusteeIds(nodeParticipantIds, curTruestInfo, autoCoordinatorIds, trusteeDelegate.getKey(), delegateSettingEntitys, trustees, assignorIdAndDelegateSettingEntitys, task);
            if (nextLayerTrusteeInfo == null || nextLayerTrusteeInfo.isEmpty()) continue;
            TaskDelegateCalculateUtil.findTargetParticipants(nodeParticipantIds, nextLayerTrusteeInfo, task, trustees, assignorIdAndDelegateSettingEntitys, autoCoordinatorIds, ++count);
        }
    }

    private static void addResult(Set<Long> trustees, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, TrusteeInfo trusteeInfo, Long trusteeId) {
        assignorIdAndDelegateSettingEntitys.putIfAbsent(trusteeInfo.getOrigianlTrusteeId(), new ArrayList());
        if (WfUtils.isNotEmpty(trusteeId) && WfUtils.isNotEmpty(trusteeInfo.getTrusteeId())) {
            assignorIdAndDelegateSettingEntitys.get(trusteeInfo.getOrigianlTrusteeId()).add(trusteeInfo.getDelegateSetting());
            trustees.add(trusteeId);
        }
    }

    private static List<TrusteeInfo> getAvailableTrusteeIds(List<Long> nodeParticipantIds, TrusteeInfo preTruestInfo, List<Long> autoCoordinatorIds, Long curTrustorId, List<DelegateSettingEntity> delegateSettingEntitys, Set<Long> trustees, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys, TaskEntity task) {
        ArrayList<TrusteeInfo> nextLayerTrusteeInfo = new ArrayList<TrusteeInfo>();
        Iterator<DelegateSettingEntity> delegateSettingEntityIterator = delegateSettingEntitys.iterator();
        while (delegateSettingEntityIterator.hasNext()) {
            if (TaskDelegateCalculateUtil.isComplianceDelegateSetting(nodeParticipantIds, delegateSettingEntityIterator.next(), task, autoCoordinatorIds)) continue;
            delegateSettingEntityIterator.remove();
        }
        if (preTruestInfo != null) {
            if (delegateSettingEntitys == null || delegateSettingEntitys.isEmpty()) {
                assignorIdAndDelegateSettingEntitys.putIfAbsent(preTruestInfo.getOrigianlTrusteeId(), new ArrayList());
                if (!preTruestInfo.getOrigianlTrusteeId().equals(curTrustorId)) {
                    TaskDelegateCalculateUtil.addResult(trustees, assignorIdAndDelegateSettingEntitys, preTruestInfo, curTrustorId);
                }
            } else {
                for (DelegateSettingEntity delegateSettingEntity : delegateSettingEntitys) {
                    nextLayerTrusteeInfo.add(new TrusteeInfo(preTruestInfo.getOrigianlTrusteeId(), delegateSettingEntity.getTrusteeId(), delegateSettingEntity));
                }
            }
        }
        return nextLayerTrusteeInfo;
    }

    private static TrusteeInfo findPreTrusteeInfo(List<TrusteeInfo> preLayerTrusteeInfos, Long curTrustorId) {
        for (TrusteeInfo trusteeInfo : preLayerTrusteeInfos) {
            if (!trusteeInfo.getTrusteeId().equals(curTrustorId)) continue;
            return trusteeInfo;
        }
        return null;
    }

    private static boolean isComplianceDelegateSetting(List<Long> nodeParticipantIds, DelegateSettingEntity delegateSettingEntity, TaskEntity task, List<Long> autoCoordinatorIds) {
        Long trusteeId = delegateSettingEntity.getTrusteeId();
        if (!UserServiceHelper.isUserEnable((long)trusteeId) || nodeParticipantIds != null && nodeParticipantIds.contains(trusteeId) || autoCoordinatorIds != null && autoCoordinatorIds.contains(trusteeId)) {
            return false;
        }
        if (!TaskDelegateCalculateUtil.hasTrueDelegateCondition(delegateSettingEntity, task)) {
            return false;
        }
        if (TaskDelegateCalculateUtil.hasTrueDelegateProcess(delegateSettingEntity, task)) {
            return true;
        }
        if (TaskDelegateCalculateUtil.hasTrueDelegateBill(delegateSettingEntity, task)) {
            return true;
        }
        return WfUtils.isEmpty(delegateSettingEntity.getProcessDefinitionId()) && WfUtils.isEmpty(delegateSettingEntity.getEntraBillId());
    }

    private static boolean hasTrueDelegateBill(DelegateSettingEntity delegateSettingEntity, TaskEntity task) {
        String entraBillId = MetadataDao.getIdByNumber((String)task.getEntityNumber(), (MetaCategory)MetaCategory.Entity);
        return entraBillId != null && entraBillId.equals(delegateSettingEntity.getEntraBillId());
    }

    private static boolean hasTrueDelegateProcess(DelegateSettingEntity delegateSettingEntity, TaskEntity task) {
        Long delegateProcDefId = delegateSettingEntity.getProcessDefinitionId();
        if (WfUtils.isEmpty(delegateProcDefId)) {
            return false;
        }
        Boolean isLatestVersion = delegateSettingEntity.isLatestVersion();
        if (isLatestVersion.booleanValue()) {
            DynamicObject procDef = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"modelid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)delegateProcDefId)});
            QFilter procDefsQFilter2 = new QFilter("modelid", "=", (Object)procDef.getLong("modelid"));
            QFilter[] procDefsQFilters = new QFilter[]{procDefsQFilter2};
            DynamicObjectCollection procDefs = QueryServiceHelper.query((String)"wf_processdefinition", (String)"id", (QFilter[])procDefsQFilters);
            ArrayList<Long> procDefIds = new ArrayList<Long>();
            for (DynamicObject procDefDynamicObject : procDefs) {
                procDefIds.add(procDefDynamicObject.getLong("id"));
            }
            if (WfUtils.isNotEmpty(delegateSettingEntity.getDelegateNodeId()) ? procDefIds.contains(task.getProcessDefinitionId()) && task.getTaskDefinitionKey().equals(delegateSettingEntity.getDelegateNodeId()) : procDefIds.contains(task.getProcessDefinitionId())) {
                return true;
            }
        } else {
            Long procDefId = task.getProcessDefinitionId();
            if (procDefId.equals(delegateProcDefId) && task.getTaskDefinitionKey().equals(delegateSettingEntity.getDelegateNodeId())) {
                return true;
            }
            if (WfUtils.isEmpty(delegateSettingEntity.getDelegateNodeId()) && procDefId.equals(delegateSettingEntity.getProcessDefinitionId())) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasTrueDelegateCondition(DelegateSettingEntity delegateSetting, TaskEntity task) {
        String delegateExpression = delegateSetting.getDelegateExpression();
        if (WfUtils.isEmpty(delegateExpression)) {
            return true;
        }
        try {
            String key = ConditionUtil.getConInstKey(task.getTaskDefinitionKey(), "delegateSetting");
            boolean ret = ConditionUtil.hasTrueCondition(delegateExpression, (VariableScope)task, key);
            logger.debug(String.format("delegateSetting[%s-%s] condition[%s],result[%s]", delegateSetting.getAssignorId(), delegateSetting.getTrusteeId(), delegateSetting.getDelegateExpression(), ret));
            return ret;
        }
        catch (Exception e) {
            logger.warn(String.format("Id\u4e3a[%s]\u7684\u5f85\u529e\u4efb\u52a1\u5728\u8fdb\u884c\u59d4\u6258\u6761\u4ef6\u7684\u89e3\u6790\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", task.getId(), WfUtils.getExceptionStacktrace(e)));
            logger.debug(String.format("delegateSetting[%s-%s] condition[%s],result is not match", delegateSetting.getAssignorId(), delegateSetting.getTrusteeId(), delegateSetting.getDelegateExpression()));
            return false;
        }
    }

    public static void taskDelegate(TaskEntity task, List<Long> nodeParticipantIds, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys) {
        CommandContext commandContext = Context.getCommandContext();
        Set<Long> yunzhijiaTrusteeIds = TaskDelegateCalculateUtil.getAlreadyYunzhijiaTrusteeIds(commandContext, task);
        TaskDelegateCalculateUtil.addUserIdentityAndUpdate(commandContext, task, assignorIdAndDelegateSettingEntitys);
        HashMap<Long, Set<Long>> assignorIdAndTrusteeIds = new HashMap<Long, Set<Long>>(assignorIdAndDelegateSettingEntitys.size());
        for (Map.Entry<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntity : assignorIdAndDelegateSettingEntitys.entrySet()) {
            HashSet<Long> trusteeIds = new HashSet<Long>();
            List<DelegateSettingEntity> delegateSettingEntitys = assignorIdAndDelegateSettingEntity.getValue();
            for (DelegateSettingEntity delegateSettingEntity : delegateSettingEntitys) {
                if (delegateSettingEntity == null) continue;
                trusteeIds.add(delegateSettingEntity.getTrusteeId());
            }
            assignorIdAndTrusteeIds.put(assignorIdAndDelegateSettingEntity.getKey(), trusteeIds);
        }
        TaskDelegateCalculateUtil.recordOpLogForTaskDelegate(task, assignorIdAndTrusteeIds);
        LocalVariables localVariables = LocalVariables.get();
        if (localVariables != null && localVariables.isViewOperate() && !assignorIdAndTrusteeIds.isEmpty()) {
            LocalVariables.putLocalVariables("delegate");
        }
    }

    private static Set<Long> getAlreadyYunzhijiaTrusteeIds(CommandContext commandContext, TaskEntity task) {
        HashSet<Long> yunzhijiaTrusteeIds = new HashSet<Long>();
        if (!"YunzhijiaTask".equals(task.getCategory())) {
            return yunzhijiaTrusteeIds;
        }
        Long parentTaskId = task.getParentTaskId();
        if (WfUtils.isEmpty(parentTaskId)) {
            return yunzhijiaTrusteeIds;
        }
        List<HistoricIdentityLinkEntity> hiIdentityLinks = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByParentTaskId(parentTaskId);
        for (HistoricIdentityLinkEntity hiIdentityLink : hiIdentityLinks) {
            if (WfUtils.isEmpty(hiIdentityLink.getDelegateId())) continue;
            yunzhijiaTrusteeIds.add(hiIdentityLink.getUserId());
        }
        return yunzhijiaTrusteeIds;
    }

    private static void addUserIdentityAndUpdate(CommandContext commandContext, TaskEntity task, Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSettingEntitys) {
        if (!assignorIdAndDelegateSettingEntitys.isEmpty()) {
            TaskDelegateCalculateUtil.addUserIdentityLink(commandContext, task, assignorIdAndDelegateSettingEntitys);
            TaskDelegateCalculateUtil.updateIdentityLink(commandContext, task, assignorIdAndDelegateSettingEntitys);
        }
    }

    private static void addUserIdentityLink(CommandContext commandContext, TaskEntity task, Map<Long, List<DelegateSettingEntity>> assignorIdAndTrusteeIds) {
        IdentityLinkEntityManager identityLinkManager = commandContext.getIdentityLinkEntityManager();
        HistoricIdentityLinkEntityManager hiIdentityLinkManager = commandContext.getHistoricIdentityLinkEntityManager();
        for (Map.Entry<Long, List<DelegateSettingEntity>> trusteeAndDelegate : assignorIdAndTrusteeIds.entrySet()) {
            Long ownerId = trusteeAndDelegate.getKey();
            List<DelegateSettingEntity> delegates = trusteeAndDelegate.getValue();
            IdentityLinkEntity identityLink = null;
            for (DelegateSettingEntity delegate : delegates) {
                if (delegate == null) continue;
                Long trusteeId = delegate.getTrusteeId();
                if (!WfUtils.isEmpty(trusteeId)) {
                    identityLink = task.addUserIdentityLink(trusteeId, "participant");
                }
                if (identityLink != null && delegate != null) {
                    Long delegateId = delegate.getId();
                    identityLink.setDelegateId(delegateId);
                    identityLink.setOwnerId(ownerId);
                    identityLinkManager.update(identityLink);
                    HistoricIdentityLinkEntity hiIdentityLink = (HistoricIdentityLinkEntity)hiIdentityLinkManager.findById(identityLink.getId());
                    if (hiIdentityLink != null) {
                        hiIdentityLink.setDelegateId(delegateId);
                        hiIdentityLink.setOwnerId(ownerId);
                        hiIdentityLinkManager.update(hiIdentityLink);
                    }
                }
                logger.debug(String.format("addUserIdentityLink[%s]", trusteeId));
                TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, task.getId(), trusteeId, "delegate");
            }
        }
    }

    public static List<Long> calcAutoCoordinatorIdsWithDelegation(CommandContext commandContext, ExecutionEntity execution, TaskEntity taskEntity, UserTask userTask) {
        List<Long> autoCoordinatorIds = TaskBehaviorUtil.calcAutoCoordinatorIds(commandContext, execution, taskEntity, userTask);
        if (autoCoordinatorIds == null || autoCoordinatorIds.isEmpty()) {
            return autoCoordinatorIds;
        }
        Iterator<Long> autoCoordinatorIdIterator = autoCoordinatorIds.iterator();
        HashSet<Long> trusteeIds = new HashSet<Long>();
        List<IdentityLinkEntity> identityLinks = taskEntity.getIdentityLinks();
        for (IdentityLinkEntity identityLink : identityLinks) {
            if (!WfUtils.isNotEmpty(identityLink.getDelegateId())) continue;
            trusteeIds.add(identityLink.getUserId());
        }
        while (autoCoordinatorIdIterator.hasNext()) {
            if (!trusteeIds.contains(autoCoordinatorIdIterator.next())) continue;
            autoCoordinatorIdIterator.remove();
        }
        return autoCoordinatorIds;
    }

    private static void updateIdentityLink(CommandContext commandContext, TaskEntity task, Map<Long, List<DelegateSettingEntity>> assignorIdAndTrusteeIds) {
        ArrayList<Long> trusteeIds = new ArrayList<Long>(assignorIdAndTrusteeIds.size());
        for (Map.Entry<Long, List<DelegateSettingEntity>> trusteeAndDelegate : assignorIdAndTrusteeIds.entrySet()) {
            List<DelegateSettingEntity> delegateSettingEntitys = trusteeAndDelegate.getValue();
            for (DelegateSettingEntity delegateSettingEntity : delegateSettingEntitys) {
                if (delegateSettingEntity == null) continue;
                trusteeIds.add(delegateSettingEntity.getTrusteeId());
            }
        }
        Map<Long, ILocaleString> trusteeFormat = ParticipantHelper.getParticipantDisplayInfo(task, trusteeIds);
        for (Map.Entry<Long, List<DelegateSettingEntity>> trusteeAndDelegate : assignorIdAndTrusteeIds.entrySet()) {
            List<DelegateSettingEntity> delegates = trusteeAndDelegate.getValue();
            Long participantId = trusteeAndDelegate.getKey();
            List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
            IdentityLinkEntity targetIdentityLink = null;
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (participantId == null || !participantId.equals(identityLink.getUserId())) continue;
                targetIdentityLink = identityLink;
                break;
            }
            if (targetIdentityLink == null) continue;
            for (DelegateSettingEntity delegate : delegates) {
                if (delegate == null) continue;
                Long trusteeId = delegate.getTrusteeId();
                ILocaleString origTrustName = targetIdentityLink.getTrustName();
                ILocaleString origTrustNameFormat = targetIdentityLink.getTrustNameFormat();
                ILocaleString trustName = WfUtils.findUserName(trusteeId);
                ILocaleString trustNameFormat = trusteeFormat.get(trusteeId);
                if (WfUtils.isNotEmpty(origTrustNameFormat)) {
                    if (WfUtils.isNotEmpty(trustNameFormat)) {
                        String trustNameFormatStr = trustNameFormat.toString();
                        if (trustNameFormatStr.indexOf(124) != -1) {
                            int i = trustNameFormatStr.lastIndexOf(124);
                            trustNameFormatStr = trustNameFormatStr.substring(0, i);
                        }
                        trustNameFormat = !origTrustNameFormat.toString().contains(trustNameFormatStr) ? WfMultiLangUtils.jointILocaleString(origTrustNameFormat, trustNameFormat, "\uff0c") : origTrustNameFormat;
                    } else {
                        trustNameFormat = origTrustNameFormat;
                    }
                }
                targetIdentityLink.setTrustNameFormat(trustNameFormat);
                if (WfUtils.isNotEmpty(origTrustName)) {
                    trustName = WfUtils.isNotEmpty(trustName) ? (!origTrustName.toString().contains(trustName.toString()) ? WfMultiLangUtils.jointILocaleString(origTrustName, trustName, "\uff0c") : origTrustName) : origTrustName;
                }
                targetIdentityLink.setTrustName(trustName);
                Boolean isReceiveTodoTask = delegate.isReceiveTodoTask();
                if (isReceiveTodoTask != null && !isReceiveTodoTask.booleanValue()) {
                    targetIdentityLink.setDisplay(Boolean.FALSE);
                    LocalVariables localVariables = LocalVariables.get();
                    if (localVariables != null && localVariables.isViewOperate()) {
                        List<String> compensationDataTypes = localVariables.getCompensationDataTypes();
                        compensationDataTypes.remove("tohandle");
                    }
                }
                commandContext.getIdentityLinkEntityManager().update(targetIdentityLink);
                HistoricIdentityLinkEntity hiIdentityLink = (HistoricIdentityLinkEntity)commandContext.getHistoricIdentityLinkEntityManager().findById(targetIdentityLink.getId());
                if (hiIdentityLink == null) continue;
                hiIdentityLink.setTrustName(trustName);
                hiIdentityLink.setTrustNameFormat(trustNameFormat);
                hiIdentityLink.setDisplay(targetIdentityLink.isDisplay());
                commandContext.getHistoricIdentityLinkEntityManager().update(hiIdentityLink);
            }
        }
    }

    private static void recordOpLogForTaskDelegate(TaskEntity task, Map<Long, Set<Long>> assignorIdAndTrusteeIds) {
        for (Map.Entry<Long, Set<Long>> entry : assignorIdAndTrusteeIds.entrySet()) {
            Long assignorId = entry.getKey();
            Set<Long> trusteeIds = entry.getValue();
            if (trusteeIds == null || trusteeIds.isEmpty()) continue;
            OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
            operationLog.setActivityId(task.getTaskDefinitionKey());
            operationLog.setActivityName(task.getName());
            TaskDelegateCalculateUtil.setAssignee(operationLog, trusteeIds);
            operationLog.setBillNo(task.getBillNo());
            operationLog.setBusinessKey(task.getBusinessKey());
            operationLog.setOwnerId(assignorId);
            operationLog.setOwner(WfUtils.findUserName(assignorId));
            operationLog.setProcDefId(task.getProcessDefinitionId());
            operationLog.setProcInstId(task.getProcessInstanceId());
            operationLog.setTaskId(task.getId());
            operationLog.setType("delegate");
            WfOperationLogUtil.recordOperationLog(Context.getCommandContext(), operationLog);
        }
    }

    private static void setAssignee(OperationLogEntity operationLog, Set<Long> trusteeIds) {
        StringBuilder assigneeIdSb = new StringBuilder();
        for (Long trusteeId : trusteeIds) {
            assigneeIdSb.append(trusteeId).append(",");
        }
        String assigneeId = WfUtils.substring(assigneeIdSb.toString(), assigneeIdSb.length() - 1, null);
        operationLog.setAssigneeId(assigneeId);
        operationLog.setAssignee(TaskBehaviorUtil.getMultiNameById(assigneeId));
    }
}

