/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateTaskEventProperties;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.TaskDelegateCalculateUtil;
import kd.bos.workflow.engine.task.delegatesetting.TaskDelegateCalculateResult;
import kd.bos.workflow.service.WorkflowService;

public class TaskDelegateUtil {
    public static final String ENTRUST = "entrust";
    public static final String REPLACE = "replace";
    public static final String RECOVERTASK = "recoverTask";
    public static final String RECOVERTRANSFERTASK = "recoverTransferTask";

    private TaskDelegateUtil() {
    }

    public static boolean isContainDelegateTask(Long taskId) {
        QFilter filter1 = new QFilter("taskId", "=", (Object)taskId);
        QFilter filter2 = new QFilter("type", "=", (Object)"participant");
        QFilter filter3 = new QFilter("delegateid", "!=", (Object)0L);
        QFilter[] qFilters = new QFilter[]{filter1, filter2, filter3};
        return QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])qFilters);
    }

    public static boolean isContainDelegateTask(List<Long> taskIds, Long userId) {
        QFilter filter1 = new QFilter("taskId", "in", taskIds);
        QFilter filter2 = new QFilter("type", "=", (Object)"participant");
        QFilter filter3 = new QFilter("userId", "=", (Object)userId);
        QFilter filter4 = new QFilter("delegateid", "!=", (Object)0L);
        QFilter[] qFilters = new QFilter[]{filter1, filter2, filter3, filter4};
        return QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])qFilters);
    }

    public static boolean isDelegateTask(Long taskId, Long userId) {
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(userId)) {
            return false;
        }
        QFilter[] qFilters = TaskDelegateUtil.getDelegateTaskQFilters(taskId, userId);
        return QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])qFilters);
    }

    public static Long getDelegateTaskOwnerId(Long taskId, Long userId) {
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(userId)) {
            return null;
        }
        if (TaskDelegateUtil.isDelegateTask(taskId, userId)) {
            QFilter[] qFilters = TaskDelegateUtil.getDelegateTaskQFilters(taskId, userId);
            DynamicObject delegateIdentity = QueryServiceHelper.queryOne((String)"wf_hiparticipant", (String)"id,ownerid", (QFilter[])qFilters);
            if (delegateIdentity != null) {
                return delegateIdentity.getLong("ownerid");
            }
        } else {
            return userId;
        }
        return null;
    }

    private static QFilter[] getDelegateTaskQFilters(Long taskId, Long userId) {
        QFilter filter1 = new QFilter("taskId", "=", (Object)taskId);
        QFilter filter2 = new QFilter("type", "=", (Object)"participant");
        QFilter filter3 = new QFilter("userId", "=", (Object)userId);
        QFilter filter4 = new QFilter("delegateid", "!=", (Object)0L);
        return new QFilter[]{filter1, filter2, filter3, filter4};
    }

    public static String getDelegateAssigneeName(String assignorName, String trusteeName, String showType) {
        String delegateAssigneeName = "";
        if (ENTRUST.equals(showType)) {
            delegateAssigneeName = String.format(ResManager.loadKDString((String)"%1$s \u59d4\u6258 %2$s", (String)"TaskDelegateUtil_0", (String)"bos-wf-engine", (Object[])new Object[0]), assignorName, trusteeName);
        } else if (REPLACE.equals(showType)) {
            delegateAssigneeName = String.format(ResManager.loadKDString((String)"%1$s \u4ee3 %2$s", (String)"TaskDelegateUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), trusteeName, assignorName);
        }
        return delegateAssigneeName;
    }

    public static String getDelegateSettingStatusByTaskIdAndUserId(Long taskId, Long userId) {
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(userId)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fstatus status from t_wf_delegatesetting a inner join t_wf_participant b on a.fid = b.fdelegateid ");
        sql.append("where b.ftaskid = ? and b.ftype = 'participant' and b.fuserid = ? and b.fdelegateid != 0 ");
        Object[] params = new Object[]{taskId, userId};
        try (DataSet ds = DB.queryDataSet((String)"TaskDelegateUtil.getDelegateSettingStatusByTaskIdAndUserId", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            DynamicObjectCollection dynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            if (dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
                String string = dynamicObject.getString("status");
                return string;
            }
        }
        return null;
    }

    public static boolean existSameDelegateSetting(Long delegateId) {
        WorkflowService wfService = WfUtils.getWfService();
        DelegateSettingEntity delegate = (DelegateSettingEntity)wfService.getRepositoryService().findEntityById(delegateId, "wf_delegatesetting");
        if (delegate != null) {
            List<DelegateSettingEntity> enableDelegates = wfService.getManagementService().getEnableDelegateSettingEntities(delegateId);
            for (DelegateSettingEntity enableDelegate : enableDelegates) {
                if (!TaskDelegateUtil.delegateSettingEquals(delegate, enableDelegate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean delegateSettingEquals(DelegateSettingEntity delegate, DelegateSettingEntity enableDelegate) {
        String enableDelegateRule;
        String delegateRule;
        Long enableProcDefId;
        Long procDefId;
        String enableEntraBillId;
        String entraBillId;
        String enableScope;
        Long assignorId = delegate.getAssignorId();
        Long enableAssignorId = enableDelegate.getAssignorId();
        Long trusteeId = delegate.getTrusteeId();
        Long enableTrusteeId = enableDelegate.getTrusteeId();
        String scop = delegate.getScope();
        if (WfUtils.isEmpty(scop)) {
            scop = "";
        }
        if (WfUtils.isEmpty(enableScope = enableDelegate.getScope())) {
            enableScope = "";
        }
        if (WfUtils.isEmpty(entraBillId = delegate.getEntraBillId())) {
            entraBillId = "";
        }
        if (WfUtils.isEmpty(enableEntraBillId = enableDelegate.getEntraBillId())) {
            enableEntraBillId = "";
        }
        if (WfUtils.isEmpty(procDefId = delegate.getProcessDefinitionId())) {
            procDefId = 0L;
        }
        if (WfUtils.isEmpty(enableProcDefId = enableDelegate.getProcessDefinitionId())) {
            enableProcDefId = 0L;
        }
        if (WfUtils.isEmpty(delegateRule = delegate.getDelegateRule())) {
            delegateRule = "";
        }
        if (WfUtils.isEmpty(enableDelegateRule = enableDelegate.getDelegateRule())) {
            enableDelegateRule = "";
        }
        Date startTime = delegate.getStartTime();
        Date enableStartTime = enableDelegate.getStartTime();
        Date endTime = delegate.getEndTime();
        Date enableEndTime = enableDelegate.getEndTime();
        Boolean isSendMsgToAssignor = delegate.isSendMsgToAssignor();
        Boolean enableSendMsgToAssignor = enableDelegate.isSendMsgToAssignor();
        Boolean isReceiveTodoTask = delegate.isReceiveTodoTask();
        Boolean enableReceiveTodoTask = enableDelegate.isReceiveTodoTask();
        Boolean isDelegateTodo = delegate.isDelegateTodo();
        Boolean enableDelegateTodo = enableDelegate.isDelegateTodo();
        return assignorId.equals(enableAssignorId) && trusteeId.equals(enableTrusteeId) && scop.equals(enableScope) && entraBillId.equals(enableEntraBillId) && procDefId.equals(enableProcDefId) && delegateRule.equals(enableDelegateRule) && startTime.equals(enableStartTime) && endTime.equals(enableEndTime) && isSendMsgToAssignor.equals(enableSendMsgToAssignor) && isReceiveTodoTask.equals(enableReceiveTodoTask) && isDelegateTodo.equals(enableDelegateTodo);
    }

    public static void recoverTaskDelegate(CommandContext commandContext, Long taskId, Boolean fireEvent, String scene) {
        TaskDelegateCalculateResult taskDelegateCalculateResult;
        Map<Long, List<DelegateSettingEntity>> assignorIdAndDelegateSetting;
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (task == null) {
            return;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), task.getProcessInstanceId());
        FlowElement flowElement = null;
        if (bpmnModel != null) {
            flowElement = bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        }
        if (flowElement == null || BpmnModelUtil.isFirstNodeByModel((FlowNode)flowElement)) {
            return;
        }
        List<Long> nodeParticipantIds = new ArrayList<Long>();
        if ("YunzhijiaTask".equalsIgnoreCase(flowElement.getType())) {
            Iterator<IdentityLinkEntity> teamMemberIdsObj;
            TaskEntity parentTask = task.getParentTaskInstance();
            if (parentTask != null && (teamMemberIdsObj = parentTask.getVariable("teamMembers")) != null) {
                nodeParticipantIds = (List)WfUtils.stringToCollection((String)((Object)teamMemberIdsObj), ",");
            }
        } else {
            List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
            if (identityLinks == null || identityLinks.isEmpty()) {
                return;
            }
            for (IdentityLinkEntity identityLink : identityLinks) {
                nodeParticipantIds.add(identityLink.getUserId());
            }
        }
        List<Long> autoCoordinatorIds = new ArrayList<Long>();
        if (flowElement instanceof UserTask) {
            autoCoordinatorIds = TaskBehaviorUtil.calcAutoCoordinatorIds(commandContext, task.getExecution(), task, (UserTask)flowElement);
        }
        if ((assignorIdAndDelegateSetting = (taskDelegateCalculateResult = TaskDelegateCalculateUtil.getTrusteeIds(task, nodeParticipantIds, autoCoordinatorIds)).getAssignorIdAndDelegateSettingEntitys()) == null || assignorIdAndDelegateSetting.isEmpty()) {
            return;
        }
        ArrayList<Long> trustees = new ArrayList<Long>(10);
        Set<Map.Entry<Long, List<DelegateSettingEntity>>> assignorIdAndDelegateEntrySet = assignorIdAndDelegateSetting.entrySet();
        for (Map.Entry<Long, List<DelegateSettingEntity>> assignorIdAndDelegateEntry : assignorIdAndDelegateEntrySet) {
            List<DelegateSettingEntity> delegateSettingEntityList = assignorIdAndDelegateEntry.getValue();
            if (delegateSettingEntityList == null || delegateSettingEntityList.isEmpty()) continue;
            for (DelegateSettingEntity delegateSettingEntity : delegateSettingEntityList) {
                if (delegateSettingEntity == null) continue;
                trustees.add(delegateSettingEntity.getTrusteeId());
            }
        }
        if (trustees.isEmpty()) {
            return;
        }
        TaskDelegateCalculateUtil.taskDelegate(task, nodeParticipantIds, taskDelegateCalculateResult.getAssignorIdAndDelegateSettingEntitys());
        if (fireEvent.booleanValue()) {
            ArrayList<IdentityLinkEntity> delegateIdentitys = new ArrayList<IdentityLinkEntity>();
            List<IdentityLinkEntity> identityLinksAfterRecover = task.getIdentityLinks();
            for (IdentityLinkEntity identityLinkEntity : identityLinksAfterRecover) {
                Long ownerId = identityLinkEntity.getOwnerId();
                Long delegateId = identityLinkEntity.getDelegateId();
                if (!WfUtils.isNotEmpty(ownerId) || !WfUtils.isNotEmpty(delegateId)) continue;
                delegateIdentitys.add(identityLinkEntity);
            }
            TaskDelegateUtil.dispatchTaskDelegateListener(task, delegateIdentitys, scene);
        }
        commandContext.getMessageService().createWithdrawTransferToDo(taskId, trustees);
    }

    public static void dispatchTaskDelegateResumeListener(TaskEntity taskEntity, List<IdentityLinkEntity> delegateIdentitys, String scene, Map<String, Object> params) {
        TaskDelegateUtil.dispatchListener(taskEntity, delegateIdentitys, scene, params);
    }

    public static void dispatchTaskDelegateListener(TaskEntity taskEntity, List<IdentityLinkEntity> delegateIdentitys, String scene) {
        TaskDelegateUtil.dispatchListener(taskEntity, delegateIdentitys, scene, null);
    }

    private static void dispatchListener(TaskEntity taskEntity, List<IdentityLinkEntity> delegateIdentitys, String scene, Map<String, Object> params) {
        if ("task complete".equalsIgnoreCase(scene)) {
            return;
        }
        List<DelegateTaskEventProperties> eventProerpties = null;
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ActivitiEventType type = ActivitiEventType.TASK_DELEGATERESUME;
            if (RECOVERTASK.equals(scene) || RECOVERTRANSFERTASK.equals(scene)) {
                type = ActivitiEventType.TASK_DELEGATE;
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createDelegateTaskEvent(type, taskEntity, eventProerpties, scene));
        }
    }

    public static boolean isContainDeleTaskAndNotTrustee(Long taskId, Long userId) {
        QFilter filter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter filter2 = new QFilter("ownerid", "=", (Object)userId);
        QFilter filter3 = new QFilter("type", "=", (Object)"participant");
        QFilter filter4 = new QFilter("delegateid", ">", (Object)0L);
        QFilter[] qFilters = new QFilter[]{filter1, filter2, filter3, filter4};
        return QueryServiceHelper.exists((String)"wf_participant", (QFilter[])qFilters);
    }
}

