/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BatchApproveModel;
import kd.bos.workflow.bpmn.model.BatchRejectModel;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.history.HistoricActivityInstance;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.procinst.CalculateProcInstCycleCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.Task;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class TaskUtils {
    private static final String PARENT_TASK_ID = "parentTaskId";
    private static final String ACT_TYPE = "actType";
    private static final String ALGOKEY = "kd.bos.workflow.engine.task.TaskUtils";
    public static final String BILLSUMMARY = "billSummary";
    private static final String USEROPENID = "useropenid";
    private static final String BOS_USER = "bos_user";
    private static final String ASSIGNEEID = "assigneeId";
    private static final String ID = "id";
    private static final String ACTID = "actId";
    private static final String CYCLE = "cycle";
    private static final String STEP = "step";
    private static final String SOURCEID = "sourceId";
    private static final String TASKID = "taskId";
    private static final String COMMENTID = "commentId";
    private static final String DECISIONTYPE = "decisionType";
    private static final String EXECUTIONTYPE = "executionType";
    private static final String RESULTNUMBER = "resultNumber";
    private static final String CYCLEFLAG = "cycleFlag";
    private static final String JOINFLAG = "joinFlag";
    private static Log logger = LogFactory.getLog(TaskUtils.class);

    public static List<String> getOpenIds(List<Long> userIds) {
        ArrayList<String> openIds = new ArrayList<String>();
        if (userIds.isEmpty()) {
            return openIds;
        }
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", userIds)};
        DynamicObjectCollection dc = QueryServiceHelper.query((String)ALGOKEY, (String)BOS_USER, (String)"id, useropenid", (QFilter[])filters, null);
        for (DynamicObject obj : dc) {
            String openid = obj.getString(USEROPENID);
            if (!WfUtils.isNotEmpty(openid)) continue;
            openIds.add(openid);
        }
        return openIds;
    }

    public static Map<String, Object> getUserInfo(Long userId) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        QFilter[] filters = new QFilter[]{new QFilter(ID, "=", (Object)userId)};
        DynamicObjectCollection dc = QueryServiceHelper.query((String)ALGOKEY, (String)BOS_USER, (String)"id,picturefield,name,useropenid", (QFilter[])filters, null);
        if (null != dc && dc.size() > 0) {
            for (DynamicObject obj : dc) {
                String picturefield = WfUtils.getAbsAvatarPath(obj.get("picturefield"));
                Object name = obj.get("name");
                Object useropenid = obj.get(USEROPENID);
                userInfo.put("avatar", picturefield);
                userInfo.put("username", WfUtils.isEmptyString(name) ? "" : name);
                userInfo.put("openid", WfUtils.isEmptyString(useropenid) ? "" : useropenid);
            }
        }
        return userInfo;
    }

    public static List<Long> getParticipantIdsByTaskId(Long taskId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        List<HistoricIdentityLinkEntity> entities = TaskUtils.getParticipantEntities(taskId);
        if (null == entities) {
            return null;
        }
        if (0 != entities.size()) {
            for (HistoricIdentityLinkEntity entity : entities) {
                userIds.add(entity.getUserId());
            }
        }
        return userIds;
    }

    public static List<HistoricIdentityLinkEntity> getParticipantEntities(Long taskId) {
        List<HistoricIdentityLinkEntity> entities = null;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        Task taskEntity = taskService.getTask(taskId);
        if (null != taskEntity) {
            Long parentTaskId = taskEntity.getParentTaskId();
            entities = !WfUtils.isEmpty(parentTaskId) ? taskService.getHiParticipantByParentTaskId(parentTaskId) : taskService.getHiParticipantByTaskId(taskId);
        }
        return entities;
    }

    public static List<Long> getParticipantIdsByTaskIdWithoutYzj(Long taskId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        List<HistoricIdentityLinkEntity> entities = null;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        entities = taskService.getHiParticipantByTaskId(taskId);
        if (0 < entities.size()) {
            for (HistoricIdentityLinkEntity entity : entities) {
                userIds.add(entity.getUserId());
            }
        }
        return userIds;
    }

    public static void insertRuleTaskRelationByTaskIdAndType(CommandContext commandContext, Long taskId, Long userId, String type) {
        TaskUtils.insertRuleTaskRelationByTaskIdAndType(commandContext, taskId, userId, type, null);
    }

    public static Map<String, Object> getUserInfoByOpenId(String openId) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)BOS_USER, (String)"id,name,picturefield", (QFilter[])new QFilter[]{new QFilter(USEROPENID, "=", (Object)openId)});
        if (obj != null) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("userid", obj.getLong(ID));
            userInfo.put("username", obj.getString("name"));
            userInfo.put("avatar", obj.get("picturefield"));
            return userInfo;
        }
        return null;
    }

    public static void insertRuleTaskRelationByTaskIdAndType(CommandContext commandContext, Long taskId, Long userId, String type, ILocaleString currentSubject) {
        RuleTaskRelationEntity relationEntity = null;
        logger.debug("kd.bos.workflow.engine.task.TaskUtils.insertRuleTaskRelationByTaskIdAndType taskId : " + taskId + "; userId :" + userId + "; type : " + type);
        if (!"coordinate".equals(type)) {
            relationEntity = commandContext.getRuleTaskRelationEntityManager().getRelationEntityByTaskIdAndType(taskId, type, userId);
        }
        if (relationEntity == null) {
            TaskMarkEntity entity = commandContext.getTaskMarkEntityManager().getTaskMarkEntityByNumber(type);
            logger.debug("kd.bos.workflow.engine.task.TaskUtils.insertRuleTaskRelationByTaskIdAndType entity : " + entity);
            if (entity != null) {
                relationEntity = new RuleTaskRelationEntityImpl();
                relationEntity.setTaskid(taskId);
                relationEntity.setMarkid(entity.getId());
                relationEntity.setRuletype(entity.getNumber());
                relationEntity.setUserid(userId);
                String priority = entity.getValue();
                logger.debug("kd.bos.workflow.engine.task.TaskUtils.insertRuleTaskRelationByTaskIdAndType priority : " + priority + "; currentSubject : " + currentSubject);
                if (WfUtils.isNotEmpty(priority)) {
                    relationEntity.setPriority(Integer.valueOf(priority));
                }
                if (WfUtils.isNotEmpty(currentSubject)) {
                    relationEntity.setCurrentSubject(currentSubject);
                }
                commandContext.getRuleTaskRelationEntityManager().insert(relationEntity);
            }
        }
    }

    public static void deleteRuleTaskRelationByTaskIdAndType(CommandContext commandContext, Long taskId, Long userId, String type) {
        RuleTaskRelationEntityManager ruleTaskRelationEntityManager = commandContext.getRuleTaskRelationEntityManager();
        if (WfUtils.isNotEmpty(userId)) {
            ruleTaskRelationEntityManager.deleteEntitiesByTaskIdAndTypeAndUserId(taskId, type, userId.toString());
        }
    }

    public static List<Map<String, String>> getRepeaterApprovalAllNumber(List<Long> userIds, Long processInstanceId, Long prodefid, ExecutionEntity execution, Map<String, String> remainSourceIdKeyMap) {
        return TaskUtils.getRepeaterApprovalAllNumber(userIds, new HashSet<Long>(), processInstanceId, prodefid, execution, remainSourceIdKeyMap);
    }

    public static List<Map<String, String>> getRepeaterApprovalAllNumber(List<Long> userIds, Set<Long> trusteeIds, Long processInstanceId, Long prodefid, ExecutionEntity execution, Map<String, String> remainSourceIdKeyMap) {
        Object iter;
        if (!WfConfigurationUtil.checkRepeaterControl()) {
            return TaskUtils.getRepeaterApprovalNumberByCycle(userIds, trusteeIds, processInstanceId);
        }
        String actSql = "SELECT a.FID id,a.FACTID actId,a.FTASKID taskId,a.FSOURCEELEMENTID sourceId,a.FSTEP step,a.Fexecutiontype executionType,a.FCYCLE cycle,a.FACTTYPE actType,a.FPARENTTASKID parentTaskId,a.FJOINFLAG joinFlag FROM t_wf_hiactinst a WHERE a.FPROCINSTID = ? ORDER BY a.FSTEP DESC ";
        HashMap taskMapDatas = new HashMap();
        HashMap<String, Map<String, String>> sourceIdKeyMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> cycleKeyMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> allDataMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Set<String>> joinNodeMap = new HashMap<String, Set<String>>(16);
        HashSet<Long> parentTaskIdSet = new HashSet<Long>();
        HistoricActivityInstance instance = (HistoricActivityInstance)Context.getCommandContext().getHistoricActivityInstanceEntityManager().findById(execution.getCurrentActInstId());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (instance == null) {
            return result;
        }
        HashMap<String, String> firstVal = new HashMap<String, String>();
        firstVal.put(ID, instance.getId().toString());
        firstVal.put(ACTID, instance.getActivityId());
        firstVal.put(CYCLE, instance.getCycle());
        firstVal.put(STEP, instance.getStep() + "");
        firstVal.put(SOURCEID, instance.getSourceElementId().toString());
        firstVal.put(JOINFLAG, instance.getJoinFlag());
        try (DataSet ds = DB.queryDataSet((String)"wf_task.getApprovalUserInst", (DBRoute)DBRoute.workflow, (String)actSql, (Object[])new Object[]{processInstanceId});){
            iter = ds.iterator();
            while (iter.hasNext()) {
                HashMap<String, String> valMap = new HashMap<String, String>();
                Object r = (Row)iter.next();
                String actId = r.getString(ACTID);
                valMap.put(ACTID, actId);
                valMap.put(ACT_TYPE, r.getString(ACT_TYPE));
                Long parentTaskId = r.getLong(PARENT_TASK_ID);
                valMap.put(PARENT_TASK_ID, String.valueOf(parentTaskId));
                if (WfUtils.isNotEmpty(parentTaskId)) {
                    parentTaskIdSet.add(parentTaskId);
                }
                valMap.put(TASKID, r.getLong(TASKID) == null ? "" : r.getLong(TASKID).toString());
                String id = r.getLong(ID).toString();
                valMap.put(ID, id);
                String sourceId = r.getLong(SOURCEID) == null ? "" : r.getLong(SOURCEID).toString();
                valMap.put(SOURCEID, sourceId);
                valMap.put(STEP, String.valueOf(r.get(STEP)));
                String cycle = r.getString(CYCLE);
                valMap.put(CYCLE, cycle);
                String executionType = r.getString(EXECUTIONTYPE);
                valMap.put(EXECUTIONTYPE, executionType);
                Long taskId = r.getLong(TASKID);
                if (WfUtils.isNotEmpty(taskId)) {
                    taskMapDatas.put(taskId, valMap);
                }
                if (remainSourceIdKeyMap == null) {
                    sourceIdKeyMap.put(id, valMap);
                    cycleKeyMap.put(cycle, valMap);
                } else {
                    sourceIdKeyMap.put(id, valMap);
                    cycleKeyMap.put(cycle, valMap);
                    remainSourceIdKeyMap.put(id, sourceId);
                }
                String joinFlag = r.getString(JOINFLAG);
                if (WfUtils.isNotEmpty(joinFlag)) {
                    valMap.put(JOINFLAG, joinFlag);
                    HashSet<String> joinActIds = (HashSet<String>)joinNodeMap.get(joinFlag);
                    if (joinActIds == null) {
                        joinActIds = new HashSet<String>(16);
                    }
                    joinActIds.add(id);
                    joinNodeMap.put(joinFlag, joinActIds);
                }
                allDataMap.put(id, valMap);
            }
        }
        if (!taskMapDatas.isEmpty()) {
            String sql = "SELECT fid commentId,FUSERID assigneeId,ftaskId taskId, FRESULTNUMBER resultNumber,FDECISIONTYPE decisionType from t_wf_hicomment where fprocinstid = ? and ftype = 'comment' ";
            DataSet ds = DB.queryDataSet((String)"wf_task.getApprovalUserComment", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{processInstanceId});
            iter = null;
            try {
                for (Object r : ds) {
                    Long taskId = r.getLong(TASKID);
                    Map valMap = (Map)taskMapDatas.get(taskId);
                    if (valMap == null) continue;
                    String commentId = r.getLong(COMMENTID) == null ? "" : r.getLong(COMMENTID).toString();
                    valMap.put(COMMENTID, commentId);
                    valMap.put(ASSIGNEEID, r.getLong(ASSIGNEEID) == null ? "" : r.getLong(ASSIGNEEID).toString());
                    String decisionType = r.getString(DECISIONTYPE);
                    valMap.put(DECISIONTYPE, decisionType);
                    valMap.put(RESULTNUMBER, r.getString(RESULTNUMBER));
                    String actId = (String)valMap.get(ACTID);
                    if ("reject".equals(decisionType) && !actId.contains("YunzhijiaTask")) continue;
                    String id = (String)valMap.get(ID);
                    String cycle = (String)valMap.get(CYCLE);
                    String sourceId = (String)valMap.get(SOURCEID);
                    if (remainSourceIdKeyMap == null) {
                        sourceIdKeyMap.put(id, valMap);
                        cycleKeyMap.put(cycle, valMap);
                        continue;
                    }
                    sourceIdKeyMap.put(id, valMap);
                    cycleKeyMap.put(cycle, valMap);
                    remainSourceIdKeyMap.put(id, sourceId);
                }
            }
            catch (Throwable iter2) {
                iter = iter2;
                throw iter2;
            }
            finally {
                if (ds != null) {
                    if (iter != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iter2) {
                            ((Throwable)iter).addSuppressed(iter2);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        HashMap<String, String> totalDecisionTypeMap = new HashMap<String, String>();
        QFilter filter = new QFilter(TASKID, "in", parentTaskIdSet);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection parentHicomment = QueryServiceHelper.query((String)"wf_hicomment", (String)"taskId , resultNumber", (QFilter[])filters);
        for (DynamicObject hicomment : parentHicomment) {
            totalDecisionTypeMap.put(hicomment.getString(TASKID), hicomment.getString(RESULTNUMBER));
        }
        HashMap<String, Map<String, String>> preNodes = new HashMap<String, Map<String, String>>();
        if (WfUtils.isNotEmpty((String)firstVal.get(JOINFLAG))) {
            DynamicObjectCollection executionList = QueryServiceHelper.query((String)"wf_execution", (String)"currentActInstId", (QFilter[])new QFilter[]{new QFilter("parentId", "=", (Object)execution.getParentId())});
            if (executionList != null) {
                for (DynamicObject dynamicObject : executionList) {
                    String joinActId;
                    Map joinAct;
                    if (!WfUtils.isNotEmpty(dynamicObject.getLong("currentActInstId")) || (joinAct = (Map)allDataMap.get(joinActId = String.valueOf(dynamicObject.getLong("currentActInstId")))) == null) continue;
                    TaskUtils.getPreNodes(sourceIdKeyMap, cycleKeyMap, allDataMap, joinAct, preNodes, instance.getActivityId(), remainSourceIdKeyMap, totalDecisionTypeMap, joinNodeMap);
                }
            }
        } else {
            TaskUtils.getPreNodes(sourceIdKeyMap, cycleKeyMap, allDataMap, firstVal, preNodes, instance.getActivityId(), remainSourceIdKeyMap, totalDecisionTypeMap, joinNodeMap);
        }
        TaskUtils.putRepeaterApprovalResult(preNodes, userIds, result);
        if (!(result != null && !result.isEmpty() || trusteeIds == null || trusteeIds.isEmpty() || WfConfigurationUtil.isTrustHandle())) {
            TaskUtils.putRepeaterApprovalResult(preNodes, new ArrayList<Long>(trusteeIds), result);
        }
        return result;
    }

    private static void putRepeaterApprovalResult(Map<String, Map<String, String>> preNodes, List<Long> userIds, List<Map<String, String>> result) {
        for (Map<String, String> preNode : preNodes.values()) {
            String assigneeId = preNode.get(ASSIGNEEID);
            if (!WfUtils.isNotEmpty(assigneeId) || !userIds.contains(Long.valueOf(assigneeId))) continue;
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put(COMMENTID, preNode.get(COMMENTID));
            tmp.put(RESULTNUMBER, preNode.get(RESULTNUMBER));
            tmp.put(ASSIGNEEID, assigneeId);
            result.add(tmp);
        }
    }

    private static List<Map<String, String>> getRepeaterApprovalNumberByCycle(List<Long> userIds, Set<Long> trusteeIds, Long processInstanceId) {
        List<HistoricActivityInstanceEntity> activityInsts = Context.getProcessEngineConfiguration().getCommandExecutor().execute(new CalculateProcInstCycleCmd(processInstanceId));
        return TaskUtils.getRepeaterList(userIds, trusteeIds, processInstanceId, activityInsts);
    }

    public static List<Map<String, String>> getRepeaterList(List<Long> userIds, Long processInstanceId, List<HistoricActivityInstanceEntity> activityInsts) {
        return TaskUtils.getRepeaterList(userIds, new HashSet<Long>(), processInstanceId, activityInsts);
    }

    private static void getPreNodes(Map<String, Map<String, String>> sourceIdKeyMap, Map<String, Map<String, String>> cycleKeyMap, Map<String, Map<String, String>> allDataMap, Map<String, String> val, Map<String, Map<String, String>> preNodes, String currentActId, Map<String, String> remainSourceIdKeyMap, Map<String, String> totalDecisionTypeMap, Map<String, Set<String>> joinNodeMap) {
        String sourceId = val.get(SOURCEID);
        if (WfUtils.isEmpty(sourceId)) {
            return;
        }
        if ("reject".equalsIgnoreCase(totalDecisionTypeMap.get(val.get(PARENT_TASK_ID)))) {
            return;
        }
        if (sourceIdKeyMap.containsKey(sourceId)) {
            Map<String, String> beforeNode;
            String actId = val.get(ACTID);
            String id = val.get(ID);
            if (preNodes.get(actId + id) != null) {
                return;
            }
            if (TaskUtils.isPassMuster(remainSourceIdKeyMap, val, actId, id, preNodes, currentActId)) {
                preNodes.put(actId + id, val);
            }
            if ((beforeNode = TaskUtils.getLastedCycleNode(cycleKeyMap, allDataMap, val)) == null) {
                if (remainSourceIdKeyMap == null) {
                    val = sourceIdKeyMap.get(sourceId);
                } else {
                    remainSourceIdKeyMap.remove(val.get(ID));
                    String key = TaskUtils.checkoutSameSourceId(remainSourceIdKeyMap, sourceId);
                    val = WfUtils.isNotEmpty(val.get(CYCLEFLAG)) || WfUtils.isEmpty(key) ? sourceIdKeyMap.get(sourceId) : sourceIdKeyMap.get(key);
                }
            } else {
                Map<String, String> tmp = beforeNode;
                while (tmp != null) {
                    val = tmp;
                    tmp = TaskUtils.getLastedCycleNode(cycleKeyMap, allDataMap, tmp);
                }
            }
            if (val != null) {
                String joinFlag = val.get(JOINFLAG);
                if (WfUtils.isNotEmpty(val.get(JOINFLAG)) && joinNodeMap != null) {
                    Set<String> joinActIds = joinNodeMap.get(joinFlag);
                    if (joinActIds != null) {
                        for (String joinActId : joinActIds) {
                            Map<String, String> joinVal = allDataMap.get(joinActId);
                            TaskUtils.getPreNodes(sourceIdKeyMap, cycleKeyMap, allDataMap, joinVal, preNodes, currentActId, remainSourceIdKeyMap, totalDecisionTypeMap, joinNodeMap);
                        }
                    }
                } else {
                    TaskUtils.getPreNodes(sourceIdKeyMap, cycleKeyMap, allDataMap, val, preNodes, currentActId, remainSourceIdKeyMap, totalDecisionTypeMap, joinNodeMap);
                }
            }
        }
    }

    private static boolean isPassMuster(Map<String, String> remainSourceIdKeyMap, Map<String, String> val, String actId, String id, Map<String, Map<String, String>> preNodes, String currentActId) {
        boolean result;
        boolean bl = result = WfUtils.isNotEmpty(val.get(ASSIGNEEID)) && WfUtils.isNotEmpty(val.get(DECISIONTYPE)) && !preNodes.containsKey(actId + id) && !currentActId.equals(val.get(ACTID));
        if (remainSourceIdKeyMap == null) {
            result = result && !val.get(ACT_TYPE).equalsIgnoreCase("YunzhijiaTask");
        }
        return result;
    }

    private static String checkoutSameSourceId(Map<String, String> remainSourceIdKeyMap, String sourceId) {
        if (remainSourceIdKeyMap == null || remainSourceIdKeyMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> map : remainSourceIdKeyMap.entrySet()) {
            if (!sourceId.equals(map.getValue())) continue;
            return map.getKey();
        }
        return null;
    }

    public static List<Map<String, String>> getRepeaterApprovalAuditNumber(List<Long> userIds, Long processInstanceId, Long prodefid, ExecutionEntity execution) {
        return TaskUtils.getRepeaterApprovalAllNumber(userIds, processInstanceId, prodefid, execution, null);
    }

    private static Map<String, String> getLastedCycleNode(Map<String, Map<String, String>> cycleKeyMap, Map<String, Map<String, String>> allDataMap, Map<String, String> val) {
        if (val.get(ACTID).contains("SequenceFlow")) {
            return null;
        }
        String flowId = val.get(SOURCEID);
        if (WfUtils.isNotEmpty(flowId)) {
            String cycle;
            Map<String, String> flow = allDataMap.get(flowId);
            if (flow == null) {
                return null;
            }
            Map<String, String> beforeNode = allDataMap.get(flow.get(SOURCEID));
            if (("reject".equals(beforeNode.get(DECISIONTYPE)) || "jump".equals(beforeNode.get(EXECUTIONTYPE)) && beforeNode.get(CYCLE).split("\\_").length < val.get(CYCLE).split("\\_").length) && (cycle = val.get(CYCLE)).contains("_")) {
                Map<String, String> temp;
                String step = val.get(STEP);
                String newCycle = cycle.substring(0, cycle.lastIndexOf("_" + step));
                String[] cycleStr = newCycle.split("_");
                int length = cycleStr.length - 1;
                boolean insert = false;
                Stack<String> stack = new Stack<String>();
                for (int i = length; i >= 0; --i) {
                    if (!cycleStr[i].equals("0") && !insert) {
                        insert = true;
                    }
                    if (!insert) continue;
                    stack.push(cycleStr[i]);
                }
                StringBuilder str = new StringBuilder();
                if (!stack.isEmpty()) {
                    str.append((String)stack.pop());
                    while (!stack.isEmpty()) {
                        str.append("_").append((String)stack.pop());
                    }
                }
                if ((temp = cycleKeyMap.get(newCycle = str.toString())) != null) {
                    temp.put(CYCLEFLAG, "newCycle");
                }
                return temp;
            }
        }
        return null;
    }

    public static boolean isTaskSuspended(Long taskId) {
        boolean isTaskSuspended = false;
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        if (!ManagementConstants.ACTIVE.getStateCode().equals(taskService.getTaskSuspensionState(taskId))) {
            isTaskSuspended = true;
        }
        return isTaskSuspended;
    }

    public static void calcBatchOp(CommandContext commandContext, ExecutionEntity execution, TaskEntity task, AuditTask auditTask) {
        BatchApproveModel batchApprove = auditTask.getBatchApprove();
        BatchRejectModel batchReject = auditTask.getBatchReject();
        String batchOpL = "1";
        String batchOpR = "0";
        String key = ConditionUtil.getConInstKey(auditTask.getNumber(), "batchOpRule");
        if (null != batchApprove && (!batchApprove.isBatchApprove() && WfUtils.isNotEmpty(batchApprove.getBatchApproveDec()) || ConditionUtil.isConditionAvailable(batchApprove.getBatchApproveCond()) && !ConditionUtil.hasTrueCondition(batchApprove.getBatchApproveCond(), (VariableScope)task, key))) {
            batchOpL = "0";
        }
        if (null != batchReject && batchReject.isBatchReject() && (!ConditionUtil.isConditionAvailable(batchReject.getBatchRejectCond()) || ConditionUtil.hasTrueCondition(batchReject.getBatchRejectCond(), (VariableScope)task, key))) {
            batchOpR = "1";
        }
        task.setBatchOp(String.format("%s-%s", batchOpL, batchOpR));
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        execution.setCurrentTask(task);
        executionEntityManager.update(execution);
    }

    public static boolean handledRequest(String scene, String value) {
        boolean handledRequest = WfCacheHelper.isHandledRequest(scene, value);
        if (!handledRequest) {
            WfCacheHelper.setHandledRequest(scene, value);
        }
        return handledRequest;
    }

    public static void removeHandledRequest(String scene, String value) {
        WfCacheHelper.removeHandledRequest(scene, value);
    }

    public static List<Map<String, String>> getRepeaterAdjacentNodes(List<Long> userIds, Long processInstanceId, String currentNodeId) {
        return TaskUtils.getRepeaterAdjacentNodes(userIds, new HashSet<Long>(), processInstanceId, currentNodeId);
    }

    public static List<Map<String, String>> getRepeaterAdjacentNodes(List<Long> userIds, Set<Long> trusteeIds, Long processInstanceId, String currentNodeId) {
        List<HistoricActivityInstanceEntity> activityInsts = Context.getProcessEngineConfiguration().getCommandExecutor().execute(new CalculateProcInstCycleCmd(processInstanceId, currentNodeId, "adjacent"));
        return TaskUtils.getRepeaterList(userIds, trusteeIds, processInstanceId, activityInsts);
    }

    private static List<Map<String, String>> getRepeaterList(List<Long> userIds, Set<Long> trusteeIds, Long processInstanceId, List<HistoricActivityInstanceEntity> activityInsts) {
        Serializable taskId;
        if (activityInsts == null || activityInsts.isEmpty()) {
            return new ArrayList<Map<String, String>>();
        }
        HashMap<Long, ArrayList<Serializable>> parentTaskIds = new HashMap<Long, ArrayList<Serializable>>();
        ArrayList<Serializable> taskIds = new ArrayList<Serializable>();
        for (HistoricActivityInstanceEntity historicActivityInstanceEntity : activityInsts) {
            Long parentTaskId = historicActivityInstanceEntity.getParentTaskId();
            taskId = historicActivityInstanceEntity.getTaskId();
            if (!WfUtils.isNotEmpty((Long)taskId)) continue;
            taskIds.add(taskId);
            if (!WfUtils.isNotEmpty(parentTaskId)) continue;
            taskIds.add(parentTaskId);
            ArrayList<Serializable> tids = (ArrayList<Serializable>)parentTaskIds.get(parentTaskId);
            if (tids == null) {
                tids = new ArrayList<Serializable>();
                parentTaskIds.put(parentTaskId, tids);
            }
            tids.add(taskId);
        }
        if (!parentTaskIds.isEmpty()) {
            List hasParentActIsts = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)processInstanceId), new QFilter("parenttaskid", "in", parentTaskIds.keySet())}, "taskId, parentTaskId", "taskId desc");
            for (HistoricActivityInstanceEntity i : hasParentActIsts) {
                taskId = i.getTaskId();
                Long parentTaskId = i.getParentTaskId();
                taskIds.add(taskId);
                List tids = (List)parentTaskIds.get(parentTaskId);
                if (tids == null || tids.contains(taskId)) continue;
                tids.add(taskId);
            }
        }
        String sql = "SELECT fid commentId,FUSERID assigneeId,ftaskId taskId, FRESULTNUMBER resultNumber,FDECISIONTYPE decisionType from t_wf_hicomment where fprocinstid = ? and ftype = 'comment'";
        HashMap hashMap = new HashMap(16);
        DataSet ds = DB.queryDataSet((String)"wf_task.getApprovalUserComment", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{processInstanceId});
        taskId = null;
        try {
            for (Row r : ds) {
                HashMap<String, String> ret;
                String decisionType;
                Long taskId2 = r.getLong(TASKID);
                if (!WfUtils.isNotEmpty(taskId2) || !taskIds.contains(taskId2) || !"approve".equals(decisionType = r.getString(DECISIONTYPE))) continue;
                parentTaskIds.remove(taskId2);
                Long assigneeId = r.getLong(ASSIGNEEID);
                if (WfUtils.isNotEmpty(assigneeId) && userIds.contains(assigneeId)) {
                    ret = new HashMap<String, String>();
                    ret.put(COMMENTID, String.valueOf(r.get(COMMENTID)));
                    ret.put(RESULTNUMBER, r.getString(RESULTNUMBER));
                    ret.put(ASSIGNEEID, String.valueOf(assigneeId));
                    hashMap.put(taskId2, ret);
                }
                if (hashMap != null && !hashMap.isEmpty() || trusteeIds == null || trusteeIds.isEmpty() || WfConfigurationUtil.isTrustHandle() || !WfUtils.isNotEmpty(assigneeId) || !trusteeIds.contains(assigneeId)) continue;
                ret = new HashMap();
                ret.put(COMMENTID, String.valueOf(r.get(COMMENTID)));
                ret.put(RESULTNUMBER, r.getString(RESULTNUMBER));
                ret.put(ASSIGNEEID, String.valueOf(assigneeId));
                hashMap.put(taskId2, ret);
            }
        }
        catch (Throwable throwable) {
            taskId = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (taskId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)taskId).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!parentTaskIds.isEmpty() && !hashMap.isEmpty()) {
            for (List tids : parentTaskIds.values()) {
                for (Long tid : tids) {
                    hashMap.remove(tid);
                }
            }
        }
        return new ArrayList<Map<String, String>>(hashMap.values());
    }

    public static List<Map<String, String>> getRepeaterAdjacentNodes(List<Long> userIds, DelegateExecution execution, Long currentActInstId, boolean isRejectTask) {
        Long processInstanceId = execution.getProcessInstanceId();
        ArrayList<HistoricActivityInstanceEntity> nodeList = new ArrayList<HistoricActivityInstanceEntity>();
        TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
        if (isRejectTask) {
            Date createDate;
            String activityId = execution.getCurrentActivityId();
            List<HistoricActivityInstanceEntity> rejectNodes = taskHelper.getBackRejectNode(processInstanceId, activityId, createDate = ((ExecutionEntity)execution).getCreateDate());
            if (!rejectNodes.isEmpty()) {
                Long id = rejectNodes.get(0).getId();
                taskHelper.loopAdjacentNode(nodeList, processInstanceId, id);
            }
        } else {
            taskHelper.loopAdjacentNode(nodeList, processInstanceId, currentActInstId);
        }
        return TaskUtils.getRepeaterList(userIds, processInstanceId, nodeList);
    }

    public static TaskInfo getRealTaskInfo(Long processInstanceId) {
        logger.debug("kd.bos.workflow.engine.task.TaskUtils.getRealTaskInfo params processInstanceId :" + processInstanceId + "; userid :" + RequestContext.get().getUserId() + "; useridlong :" + Long.valueOf(RequestContext.get().getUserId()));
        CommandContext commandContext = Context.getCommandContext();
        List entities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processinstanceid", "=", (Object)processInstanceId), new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())), new QFilter("display", "=", (Object)"1"), new QFilter("taskid", "is not null", null)}, "taskid,compositetaskid", "createDate");
        if (null == entities || entities.isEmpty()) {
            return null;
        }
        Long taskId = null;
        Long compositeTaskId = null;
        TaskEntity taskEntity = null;
        for (IdentityLinkEntity entity : entities) {
            if (null == entity || null == (taskEntity = entity.getTask()) || !taskEntity.isDisplay()) continue;
            taskId = entity.getTaskId();
            compositeTaskId = entity.getCompositeTaskId();
            if (!WfUtils.isNotEmpty(compositeTaskId)) continue;
            taskId = compositeTaskId;
            break;
        }
        if (WfUtils.isEmpty(taskId)) {
            return null;
        }
        logger.debug("kd.bos.workflow.engine.task.TaskUtils.getRealTaskInfo result taskid :" + taskId);
        return (TaskInfo)commandContext.getTaskEntityManager().findById(taskId);
    }

    public static TaskInfo defaultHistoricTaskInstanceEntity(CommandContext commandContext, Long processInstanceId) {
        EntityQueryBuilder queryBuilder = commandContext.getHistoricTaskInstanceEntityManager().createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy("createDate");
        List entitiesForHis = commandContext.getHistoricTaskInstanceEntityManager().findByQueryBuilder(queryBuilder);
        if (WfUtils.isEmptyForCollection(entitiesForHis)) {
            return TaskUtils.getHiTaskEntityByProcessInstanceId(commandContext, processInstanceId);
        }
        if (WfConfigurationUtil.isOptimizeLogicForLinkMessage()) {
            return (TaskInfo)entitiesForHis.get(0);
        }
        return (TaskInfo)entitiesForHis.get(entitiesForHis.size() - 1);
    }

    public static HistoricTaskInstanceEntity getHiTaskEntityByProcessInstanceId(CommandContext commandContext, Long processInstanceId) {
        HistoricProcessInstanceEntity processInstanceEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
        if (null == processInstanceEntity) {
            return null;
        }
        HistoricTaskInstanceEntityImpl hiTaskEntity = (HistoricTaskInstanceEntityImpl)commandContext.getHistoricTaskInstanceEntityManager().create();
        String entityNumber = null;
        entityNumber = processInstanceEntity.getEntitynumber();
        hiTaskEntity.setProcessInstanceId(processInstanceId);
        hiTaskEntity.setProcessDefinitionId(processInstanceEntity.getProcessDefinitionId());
        hiTaskEntity.setEntityNumber(entityNumber);
        hiTaskEntity.setBusinessKey(processInstanceEntity.getBusinessKey());
        hiTaskEntity.setBillNo(processInstanceEntity.getBillNo());
        hiTaskEntity.setSubject(processInstanceEntity.getSubject());
        hiTaskEntity.setEntityName(processInstanceEntity.getEntraBillName());
        hiTaskEntity.setStarterId(processInstanceEntity.getStartUserId());
        hiTaskEntity.setFormKey(entityNumber);
        String mobileFormKey = entityNumber + "_mob";
        if (BillPagePluginUtil.isExistForFormId(mobileFormKey)) {
            hiTaskEntity.setMobileFormKey(mobileFormKey);
        }
        hiTaskEntity.setProcessingPage("wf_approvalbill_view");
        hiTaskEntity.setProcessingMobilePage("wf_approvalbillmob_view");
        ILocaleString startName = processInstanceEntity.getStartName();
        if (null != startName) {
            hiTaskEntity.setStartName(startName.getLocaleValue());
        }
        return hiTaskEntity;
    }

    @Deprecated
    public static boolean isAutoExeNextTask() {
        return false;
    }

    public static boolean isBizTask(String source) {
        return !"wf".equalsIgnoreCase(source) && !WfUtils.isEmpty(source);
    }
}

