/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.ExpireModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.TimeControl;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.IJobScheduleCallback;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.service.MessageLogService;
import org.apache.commons.lang.time.DateFormatUtils;

public class EntityCreateListener
implements ActivitiEventListener {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void onEvent(ActivitiEvent event) {
        if (event instanceof ActivitiEntityEvent) {
            ActivitiEntityEvent activitiEvent = (ActivitiEntityEvent)event;
            Object entity = activitiEvent.getEntity();
            ActivitiEventType eventType = activitiEvent.getType();
            MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
            CommandContext commandContext = Context.getCommandContext();
            if (entity instanceof TaskEntity) {
                this.createTaskJobs((TaskEntity)entity);
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((TaskEntity)entity));
            } else if (entity instanceof IdentityLinkEntity) {
                service.gatherQuantitySummaryInfosFromIdentityLink((IdentityLinkEntity)entity, eventType);
            } else if (entity instanceof CommentEntity) {
                service.gatherQuantitySummaryInfosFromHiComment((CommentEntity)entity, eventType);
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((CommentEntity)entity));
                if (commandContext != null) {
                    commandContext.getDetailLogEntityManager().recordDetailLogFromComment(commandContext, (CommentEntity)entity);
                    CommentEntity commentEntity = (CommentEntity)entity;
                    if ("coordinate".equals(commentEntity.getType())) {
                        QFilter q1 = new QFilter("assigneeid", "=", (Object)commentEntity.getUserId());
                        QFilter q2 = new QFilter("taskid", "=", (Object)commentEntity.getTaskId());
                        QFilter q3 = new QFilter("type", "=", (Object)"transfer");
                        List taskHandleLogEntityList = commandContext.getTaskHandleLogEntityManager().findByQueryFilters(new QFilter[]{q1, q2, q3});
                        if (taskHandleLogEntityList != null && taskHandleLogEntityList.size() > 0) {
                            for (TaskHandleLogEntity handleLogEntity : taskHandleLogEntityList) {
                                handleLogEntity.setTaskState(commentEntity.getHandleState());
                                handleLogEntity.setEndTime(commentEntity.getTime());
                                commandContext.getTaskHandleLogEntityManager().update(handleLogEntity);
                            }
                        }
                    }
                }
            } else if (entity instanceof RuleTaskRelationEntity) {
                service.gatherQuantitySummaryInfosFromRuleTaskRelation((RuleTaskRelationEntity)entity, eventType);
            } else if (entity instanceof TaskHandleLogEntity) {
                service.gatherQuantitySummaryInfosFromTaskHandleLog((TaskHandleLogEntity)entity, eventType);
                if (commandContext != null) {
                    commandContext.getDetailLogEntityManager().recordDetailLogFromTaskHandleLog(commandContext, (TaskHandleLogEntity)entity);
                }
            } else if (entity instanceof OperationLogEntity) {
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((OperationLogEntity)entity));
            } else if (entity instanceof ExecutionEntity) {
                if (((ExecutionEntity)entity).isProcessInstanceType()) {
                    WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((ExecutionEntity)entity));
                }
            } else if (entity instanceof JobEntity) {
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((JobEntity)entity));
                JobEntity jobEntity = (JobEntity)entity;
                if ("async-todo".equalsIgnoreCase(jobEntity.getJobHandlerType())) {
                    ((MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class)).createOrUpdateTaskJobFromEntity((Entity)jobEntity, ActivitiEventType.ENTITY_CREATED.getCode());
                }
            } else if (entity instanceof TimerJobEntity) {
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((TimerJobEntity)entity));
            } else if (entity instanceof DeadLetterJobEntity) {
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((DeadLetterJobEntity)entity));
            } else if (entity instanceof EvtJobEntity) {
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((EvtJobEntity)entity));
            } else if (entity instanceof EvtTimerJobEntity) {
                WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((EvtTimerJobEntity)entity));
            } else if (entity instanceof EvtDeadLetterJobEntity) {
                Long subscriptionId = ((EvtDeadLetterJobEntity)entity).getExecutionId();
                if (WfUtils.isEmpty(subscriptionId)) {
                    WorkflowDevopsService.create().exceutionDataCollectionFromEntity((Entity)((EvtDeadLetterJobEntity)entity));
                } else {
                    IndicatorInfo info = new IndicatorInfo("becAsyncMessage", (Object)"fail");
                    info.addToSpecialProperty("subscriptionId", (Object)subscriptionId);
                    info.addToSpecialProperty("procDefId", (Object)((EvtDeadLetterJobEntity)entity).getProcessDefinitionId());
                    info.addToSpecialProperty("endTime", (Object)DateFormatUtils.format((Date)Context.getProcessEngineConfiguration().getClock().getCurrentTime(), (String)"yyyyMMdd"));
                    info.addToSpecialProperty("eventId", (Object)((EvtDeadLetterJobEntity)entity).getProcessInstanceId());
                    info.addToSpecialProperty("erroredTotal", (Object)1);
                    WorkflowDevopsService.create().exceutionDataCollection(info);
                }
            }
        }
    }

    private void createTaskJobs(final TaskEntity taskEntity) {
        CommandContext commandContext = Context.getCommandContext();
        JobEntity job = commandContext.getJobManager().createTaskRuleAnalysisJobHandler(taskEntity);
        commandContext.getJobManager().scheduleAsyncJob(job, new IJobScheduleCallback(){

            @Override
            public boolean isValidate() {
                String et = taskEntity.getExecutionType();
                if (BpmnModelUtil.instanceofYunzhijiaTask(taskEntity.getCategory())) {
                    return "byHand".equalsIgnoreCase(et) && WfUtils.isNotEmpty(taskEntity.getParentTaskId());
                }
                return "byHand".equalsIgnoreCase(et);
            }
        });
        this.insertDueDateTimerJobs(taskEntity);
    }

    private void insertDueDateTimerJobs(TaskEntity task) {
        if (task.getDueDate() != null) {
            UserTask userTask;
            ExpireModel expireModel;
            CommandContext commandContext = Context.getCommandContext();
            FlowElement element = ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey());
            if (element instanceof YunzhijiaTask && WfUtils.isEmpty(task.getParentTaskId())) {
                return;
            }
            if (element instanceof UserTask && (expireModel = (userTask = (UserTask)element).getExpireModel()) != null && expireModel.isExpirebtn() && expireModel.getTimeControls() != null && !expireModel.getTimeControls().isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String expressionType = expireModel.getExpressionType();
                JobManager jobMgr = commandContext.getJobManager();
                TimerJobEntityManager tJobMsg = commandContext.getTimerJobEntityManager();
                for (TimeControl t : expireModel.getTimeControls()) {
                    Date dueDate = task.getDueDate();
                    if ("expression".equals(expireModel.getExpireType()) && WfUtils.isNotEmpty(expireModel.getExpireTime()) && ExpressionPropUtils.isExpressionDateType(expressionType)) {
                        try {
                            dueDate = "afterDuration".equals(t.getControlType()) ? dateFormat.parse(dateFormat.format(task.getDueDate()).substring(0, 10) + " 23:59:59") : dateFormat.parse(dateFormat.format(task.getDueDate()).substring(0, 10) + " 00:00:00");
                        }
                        catch (ParseException ex) {
                            this.logger.error(WfUtils.getExceptionStacktrace(ex));
                            return;
                        }
                    }
                    dueDate = this.getDueDate(t, dueDate);
                    if (t.getOperation() != null && dueDate != null) {
                        if (dueDate.after(WfUtils.now())) {
                            TimerJobEntity timerJob = jobMgr.createExpireModelTimerJob(task, t.getOperation(), dueDate);
                            tJobMsg.insert(timerJob);
                            continue;
                        }
                        this.logger.debug("Expiration date is less than current date.");
                        continue;
                    }
                    this.logger.debug("opertion is null or dueDate is null");
                }
            }
        }
    }

    private Date getDueDate(TimeControl t, Date baseDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(baseDate);
        String controlType = t.getControlType();
        String timeType = t.getTimeType();
        int ttype = 10;
        if ("day".equals(timeType)) {
            ttype = 6;
        } else if ("minute".equals(timeType)) {
            ttype = 12;
        }
        switch (controlType) {
            case "beforeDuration": {
                c.add(ttype, 0 - t.getDuration());
                break;
            }
            case "onDuration": {
                return baseDate;
            }
            case "afterDuration": {
                c.add(ttype, t.getDuration());
                break;
            }
        }
        return c.getTime();
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}

