/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center;

import java.util.List;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummary;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.service.MessageLogService;

public class EntityDeleteListener
implements ActivitiEventListener {
    @Override
    public void onEvent(ActivitiEvent event) {
        if (event instanceof ActivitiEntityEvent) {
            JobEntity jobEntity;
            ActivitiEntityEvent activitiEvent = (ActivitiEntityEvent)event;
            Object entity = activitiEvent.getEntity();
            ActivitiEventType eventType = activitiEvent.getType();
            MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
            if (entity instanceof IdentityLinkEntity) {
                service.gatherQuantitySummaryInfosFromIdentityLink((IdentityLinkEntity)entity, eventType);
            } else if (entity instanceof CommentEntity) {
                service.gatherQuantitySummaryInfosFromHiComment((CommentEntity)entity, eventType);
            } else if (entity instanceof RuleTaskRelationEntity) {
                service.gatherQuantitySummaryInfosFromRuleTaskRelation((RuleTaskRelationEntity)entity, eventType);
            } else if (entity instanceof TaskHandleLogEntity) {
                service.gatherQuantitySummaryInfosFromTaskHandleLog((TaskHandleLogEntity)entity, eventType);
            } else if (entity instanceof HistoricProcessInstanceEntity) {
                List<QuantitySummaryInfo> quantitySummaryInfos = service.gatherQuantitySummaryOfApplyed((HistoricProcessInstanceEntity)entity, QuantitySummary.MINUS);
                service.updateQuantitySummary(quantitySummaryInfos);
            } else if (entity instanceof JobEntity && "async-todo".equalsIgnoreCase((jobEntity = (JobEntity)entity).getJobHandlerType())) {
                ((MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class)).createOrUpdateTaskJobFromEntity((Entity)jobEntity, ActivitiEventType.ENTITY_DELETED.getCode());
            }
        }
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}

