/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center;

import java.util.HashMap;
import java.util.List;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.detaillog.DetailLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.task.AttributeModifyRecord;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.service.MessageLogService;

public class EntityUpdateListener
implements ActivitiEventListener {
    @Override
    public void onEvent(ActivitiEvent event) {
        if (event instanceof ActivitiEntityEvent) {
            JobEntity jobEntity;
            ActivitiEntityEvent activitiEvent = (ActivitiEntityEvent)event;
            Object entity = activitiEvent.getEntity();
            ActivitiEventType eventType = activitiEvent.getType();
            if (entity instanceof IdentityLinkEntity) {
                IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)entity;
                if (identityLinkEntity.getAttributesModifyRecords().isEmpty()) {
                    return;
                }
                HashMap<String, AttributeModifyRecord> records = new HashMap<String, AttributeModifyRecord>(identityLinkEntity.getAttributesModifyRecords());
                MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
                service.gatherQuantitySummaryInfosFromIdentityLink(identityLinkEntity, eventType);
                CommandContext commandContext = Context.getCommandContext();
                if (commandContext != null) {
                    commandContext.getTaskHandleLogEntityManager().updateTaskHandleByTaskIdAndUserId(records, identityLinkEntity.getTaskId(), identityLinkEntity.getUserId());
                }
            } else if (entity instanceof HistoricTaskInstanceEntity) {
                CommandContext commandContext = Context.getCommandContext();
                HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)entity;
                if (commandContext == null) {
                    return;
                }
                if (ModelType.NoCodeFlow.name().equalsIgnoreCase(historicTaskInstance.getProcessType())) {
                    List<DetailLogEntity> detailLogs = commandContext.getDetailLogEntityManager().findDetailLogsByTaskId(historicTaskInstance.getId());
                    detailLogs.forEach(detailLog -> {
                        detailLog.setHandleState(historicTaskInstance.getHandleState());
                        detailLog.setExecutionType(historicTaskInstance.getExecutionType());
                        commandContext.getDetailLogEntityManager().update(detailLog);
                    });
                }
                if (historicTaskInstance.getAttributesModifyRecords().isEmpty()) {
                    return;
                }
                HashMap<String, AttributeModifyRecord> records = new HashMap<String, AttributeModifyRecord>(historicTaskInstance.getAttributesModifyRecords());
                commandContext.getCommentEntityManager().updateCommentByHisTask(records, historicTaskInstance.getId());
                commandContext.getTaskHandleLogEntityManager().updateTaskHandleByTaskId(records, historicTaskInstance.getId());
            } else if (entity instanceof TaskEntity) {
                TaskEntity taskEntity = (TaskEntity)entity;
                if (taskEntity.getAttributesModifyRecords().isEmpty()) {
                    return;
                }
                HashMap<String, AttributeModifyRecord> records = new HashMap<String, AttributeModifyRecord>(taskEntity.getAttributesModifyRecords());
                CommandContext commandContext = Context.getCommandContext();
                if (commandContext != null) {
                    commandContext.getIdentityLinkEntityManager().updateIdentityLinksByTaskId(records, taskEntity.getId());
                    commandContext.getTaskHandleLogEntityManager().updateTaskHandleByTaskId(records, taskEntity.getId());
                }
            } else if (entity instanceof JobEntity && "async-todo".equalsIgnoreCase((jobEntity = (JobEntity)entity).getJobHandlerType())) {
                ((MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class)).createOrUpdateTaskJobFromEntity((Entity)jobEntity, ActivitiEventType.ENTITY_UPDATED.getCode());
            }
        }
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}

