/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.CallActivityUtil;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class ForkNodeRejectListener
implements TaskListener {
    private static final long serialVersionUID = 1L;
    public static final String ENTERTYPE_JUMP = "jump";
    public static final String ENTERTYPE_REJECT = "reject";
    public static final String ENTERTYPE_BOUNDARY = "boundary";
    public static final String ENTERTYPE_INSET = "inset";

    @Override
    public void notify(AgentTask entity) {
    }

    public static void markOtherBranchsEnd(CommandContext commandContext, ExecutionEntity destExecution, Long proinstanceId, String srcNodeId, String destNodeId, String boundaryEnterMainNodeId, String type) {
        int c;
        ArrayList<HistoricActivityInstanceEntity> willDoActInsts = new ArrayList<HistoricActivityInstanceEntity>();
        HistoricActivityInstanceEntityManager hisActMgr = commandContext.getHistoricActivityInstanceEntityManager();
        Process process = ProcessDefinitionUtil.getProcess(destExecution.getProcessDefinitionId(), proinstanceId);
        Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
        if (WfUtils.isNotEmpty(srcNodeId) && models.get(srcNodeId) != null && WfUtils.isNotEmpty(destNodeId) && models.get(destNodeId) != null && models.get(srcNodeId).getForkStructure().equals(models.get(destNodeId).getForkStructure())) {
            return;
        }
        if (WfUtils.isNotEmpty(process.getBoundaryEventId(srcNodeId))) {
            return;
        }
        ExecutionEntity proinst = destExecution.getProcessInstance();
        String forkNodeId = WfUtils.isNotEmpty(boundaryEnterMainNodeId) ? boundaryEnterMainNodeId : models.get(srcNodeId).getLatestForkNode();
        if (models.get(forkNodeId) == null) {
            return;
        }
        String forkPath = models.get(forkNodeId).getForkStructure() + "$";
        ArrayList<Long> executionIds = new ArrayList<Long>();
        List<HistoricActivityInstanceEntity> allHisActInsts = hisActMgr.findByProcessInstanceId(proinstanceId);
        for (HistoricActivityInstanceEntity i : allHisActInsts) {
            NodeForkJoinModel tm;
            if (i.getEndTime() != null || srcNodeId.equals(i.getActivityId()) || (tm = models.get(i.getActivityId())) == null || !tm.getForkStructure().startsWith(forkPath) && !forkNodeId.equals(tm.getPairForkNodeId())) continue;
            executionIds.add(i.getExecutionId());
            if (willDoActInsts.contains(i)) continue;
            willDoActInsts.add(i);
        }
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        if (WfUtils.isNotEmpty(destNodeId)) {
            String canNotWithdrawTasks = String.valueOf(destExecution.getCurrentTaskId());
            if (WfUtils.isNotEmptyString(proinst.getVariableLocal("canNotWithdrawTasks"))) {
                canNotWithdrawTasks = proinst.getVariableLocal("canNotWithdrawTasks") + "," + canNotWithdrawTasks;
            }
            proinst.setVariableLocal("canNotWithdrawTasks", canNotWithdrawTasks);
        }
        HashSet<String> otherBranchsActId = new HashSet<String>();
        HashSet<ILocaleString> otherBranchsActName = new HashSet<ILocaleString>();
        if (!ENTERTYPE_REJECT.equals(type) && (c = ForkJoinUtils.getEnterForkCycle(forkNodeId, proinst)) > 0) {
            ForkJoinUtils.removeJoinNodeRejectKey(forkNodeId, c, proinst);
        }
        for (HistoricActivityInstanceEntity historicActivityInstanceEntity : willDoActInsts) {
            int c2;
            String string = historicActivityInstanceEntity.getActivityId();
            NodeForkJoinModel m = models.get(string);
            String lastFork = m.getLatestForkNode();
            if (!forkNodeId.equals(lastFork) && (c2 = ForkJoinUtils.getEnterForkCycle(lastFork, proinst)) > 0) {
                ForkJoinUtils.removeJoinNodeRejectKey(lastFork, c2, proinst);
            }
            ArrayList<Long> parentTaskIds = new ArrayList<Long>();
            if (WfUtils.isNotEmpty(historicActivityInstanceEntity.getParentTaskId())) {
                if (!parentTaskIds.contains(historicActivityInstanceEntity.getParentTaskId())) {
                    parentTaskIds.add(historicActivityInstanceEntity.getParentTaskId());
                    executionIds.add(((TaskEntity)commandContext.getTaskEntityManager().findById(historicActivityInstanceEntity.getParentTaskId())).getExecutionId());
                    commandContext.getTaskHelper().deleteTask(historicActivityInstanceEntity.getParentTaskId(), "fork_jumpOrReject", false);
                    QFilter parentf = new QFilter("parentTaskId", "=", (Object)historicActivityInstanceEntity.getParentTaskId());
                    QFilter procinst = new QFilter("processInstanceId", "=", (Object)historicActivityInstanceEntity.getProcessInstanceId());
                    List yzjActInsts = hisActMgr.findByQueryFilters(new QFilter[]{parentf, procinst});
                    for (HistoricActivityInstanceEntity yzjActInst : yzjActInsts) {
                        yzjActInst.setEndTime(WfUtils.now());
                        yzjActInst.setExecutionType("cancel");
                        hisActMgr.update(historicActivityInstanceEntity);
                        executionIds.add(yzjActInst.getExecutionId());
                        otherBranchsActId.add(yzjActInst.getActivityId());
                        otherBranchsActName.add(yzjActInst.getActivityName());
                    }
                }
            } else if (historicActivityInstanceEntity.getTaskId() != null) {
                ForkNodeRejectListener.deleteToDoMsg(commandContext, historicActivityInstanceEntity.getTaskId());
                commandContext.getTaskHelper().deleteTask(historicActivityInstanceEntity.getTaskId(), "fork_jumpOrReject", false);
                historicActivityInstanceEntity.setEndTime(WfUtils.now());
                historicActivityInstanceEntity.setExecutionType("cancel");
                hisActMgr.update(historicActivityInstanceEntity);
                executionIds.add(historicActivityInstanceEntity.getExecutionId());
                otherBranchsActId.add(historicActivityInstanceEntity.getActivityId());
                otherBranchsActName.add(historicActivityInstanceEntity.getActivityName());
            } else {
                if ("CallActivity".equals(historicActivityInstanceEntity.getActivityType())) {
                    List<ExecutionEntity> childs = commandContext.getExecutionEntityManager().findChildExecutionsBySuperExecId(historicActivityInstanceEntity.getExecutionId());
                    ExecutionEntity exe = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(historicActivityInstanceEntity.getExecutionId());
                    if (!childs.isEmpty()) {
                        exe.getParent().setVariableLocal("endOtherBranch", "endOtherBranch");
                        LocaleString cause = null;
                        if (ENTERTYPE_REJECT.equals(type)) {
                            cause = ResManager.getLocaleString((String)"\u5176\u4ed6\u5206\u652f\u9a73\u56de\u540e\u7ec8\u6b62", (String)"ForkNodeRejectListener_1", (String)"bos-wf-engine");
                        } else if (ENTERTYPE_JUMP.equals(type)) {
                            cause = ResManager.getLocaleString((String)"\u5176\u4ed6\u5206\u652f\u8df3\u8f6c\u540e\u7ec8\u6b62", (String)"ForkNodeRejectListener_2", (String)"bos-wf-engine");
                        }
                        HashMap<String, Object> param = new HashMap<String, Object>(4);
                        param.put("isRestartProcess", "true");
                        new AbandonProcessCmd(childs.get(0).getProcessInstanceId(), (ILocaleString)cause, "forceAbort", param).execute(commandContext);
                    } else {
                        ExecutionEntity superExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(historicActivityInstanceEntity.getExecutionId());
                        CallActivityUtil.deleteAddressAndStartProcessDeadLetterJobs(commandContext, superExecution);
                    }
                }
                historicActivityInstanceEntity.setEndTime(WfUtils.now());
                historicActivityInstanceEntity.setExecutionType("cancel");
                hisActMgr.update(historicActivityInstanceEntity);
            }
            QFilter exeQf = new QFilter("executionId", "=", (Object)historicActivityInstanceEntity.getExecutionId());
            QFilter actQf = new QFilter("elementId", "=", (Object)historicActivityInstanceEntity.getActivityId());
            commandContext.getJobEntityManager().deleteByFilters(new QFilter[]{exeQf, actQf});
            commandContext.getTimerJobEntityManager().deleteByFilters(new QFilter[]{exeQf, actQf});
            String vk = String.format("%s_%s", string, "rejectToForkInnerAndSkip");
            destExecution.getProcessInstance().removeVariable(vk);
        }
        ArrayList<String> exeStrIds = new ArrayList<String>(executionIds.size());
        for (Long l : executionIds) {
            exeStrIds.add(String.valueOf(l));
        }
        List<ExecutionEntity> list = executionMgr.findChildExecutionsByProcessInstanceId(proinstanceId);
        for (ExecutionEntity e : list) {
            NodeForkJoinModel model;
            FlowElement ele;
            if (e.isScope() || !e.isActive() || exeStrIds.contains(String.valueOf(e.getId())) || (ele = e.getCurrentFlowElement()) == null || ele.getId().equals(srcNodeId) || (model = models.get(ele.getId())) == null || !model.getForkStructure().startsWith(forkPath) && !forkNodeId.equals(model.getPairForkNodeId())) continue;
            exeStrIds.add(String.valueOf(e.getId()));
            executionIds.add(e.getId());
        }
        for (ExecutionEntity e : list) {
            if (!exeStrIds.contains(String.valueOf(e.getId()))) continue;
            e.setActive(false);
            e.setVariableLocal("unActiveType", "forkJumpOrReject");
            executionMgr.update(e);
        }
        QFilter qFilter = new QFilter("jobHandlerType", "in", (Object)new String[]{"async-continuation", "multi-async-continuation", "async-todo"});
        QFilter executionFilter = new QFilter("executionId", "in", executionIds);
        commandContext.getJobEntityManager().deleteByFilters(new QFilter[]{executionFilter, qFilter});
        commandContext.getTimerJobEntityManager().deleteByFilters(new QFilter[]{executionFilter, qFilter});
        commandContext.getSuspendedJobEntityManager().deleteByFilters(new QFilter[]{executionFilter, qFilter});
        QFilter pFilter = new QFilter("currentExecutionId", "in", executionIds);
        QFilter ef = new QFilter("proInstId", "=", (Object)proinstanceId);
        QFilter endTimeF = new QFilter("endTime", "is null", null);
        List hiUserInsts = commandContext.getHiUserActInstEntityManager().findByQueryFilters(new QFilter[]{pFilter, ef, endTimeF});
        for (HiUserActInstEntity i : hiUserInsts) {
            i.setEndTime(WfUtils.now());
            i.setEndType("forkJumpOrReject");
            commandContext.getHiUserActInstEntityManager().update(i);
        }
        String allActIds = proinst.getActivityId();
        if (allActIds.contains(",")) {
            String newIds = "";
            StringBuilder sb = new StringBuilder();
            for (String s : allActIds.split(",")) {
                if (otherBranchsActId.contains(s)) continue;
                newIds = sb.append(s).append(',').toString();
            }
            if (newIds.endsWith(",")) {
                newIds = newIds.substring(0, newIds.length() - 1);
                proinst.setActivityId(newIds);
            }
        }
        ILocaleString allActNames = proinst.getActivityName();
        LocaleString newNames = new LocaleString();
        for (String key : allActNames.keySet()) {
            String localeActNames = (String)allActNames.get((Object)key);
            if (!localeActNames.contains(StandardTips.getComma())) continue;
            String localeNewNames = "";
            StringBuilder sb = new StringBuilder();
            for (String s : localeActNames.split(StandardTips.getComma())) {
                if (ForkNodeRejectListener.isSetContains(otherBranchsActName, key, s)) continue;
                localeNewNames = sb.append(s).append(StandardTips.getComma()).toString();
            }
            if (localeNewNames.endsWith(StandardTips.getComma())) {
                localeNewNames = localeNewNames.substring(0, localeNewNames.length() - 1);
            }
            newNames.put((Object)key, (Object)localeNewNames);
        }
        proinst.setActivityName((ILocaleString)newNames);
        executionMgr.update(proinst);
    }

    private static boolean isSetContains(Set<ILocaleString> set, String lang, String value) {
        for (ILocaleString element : set) {
            String val = (String)element.get((Object)lang);
            if (val == null || !val.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void deleteToDoMsg(CommandContext commandContext, Long taskId) {
        if (WfUtils.isEmpty(taskId)) {
            return;
        }
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskId(taskId);
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity iden : identityLinks) {
            userIds.add(iden.getUserId());
        }
        if (!userIds.isEmpty()) {
            commandContext.getMessageService().deleteToDo(taskId, userIds);
        }
    }
}

