/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.TaskListener;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.msg.MessageService;

public class TaskCompleteListener
implements TaskListener,
ActivitiEventListener {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 1252361324507445939L;

    @Override
    public void notify(AgentTask entity) {
        if (entity instanceof TaskEntity) {
            TaskEntity task = (TaskEntity)entity;
            if (WfUtils.isEmpty(task.getId())) {
                this.logger.debug(String.format("[%s]\u5728\u8282\u70b9[%s]\u521b\u5efa\u7684\u4efb\u52a1\u4e3a\u7a7a", task.getBillNo(), task.getTaskDefinitionKey()));
                return;
            }
            String deleteReason = (String)task.getTransientVariableLocal("deleteReason");
            boolean onlyRemoveSignleExecution = WfUtils.isNotEmpty(deleteReason) && "multiInstance delete".equalsIgnoreCase(deleteReason);
            this.deleteTaskToDo(task, onlyRemoveSignleExecution);
            this.deleteCooperateData(task);
            this.collectDevopsData(task);
        }
    }

    private void collectDevopsData(TaskEntity task) {
        Object deleteReason = task.getVariable("deleteReason");
        String executionType = task.getExecutionType();
        if ("jump".equalsIgnoreCase(executionType) || "task skip".equals(deleteReason)) {
            return;
        }
        String type = "first_usertask_skip".equals(deleteReason) || "byAuto".equals(executionType) || "byExpireAuto".equalsIgnoreCase(executionType) ? "autoApproval" : "manualApproval";
        WorkflowDevopsService.create().exceutionDataCollection(new IndicatorInfo("taskComplete", (Object)type));
    }

    private void deleteCooperateData(TaskEntity task) {
        List historicIdentityLinkEntities;
        CommandContext commandContext = Context.getCommandContext();
        Long taskId = task.getId();
        Long parentTaskId = task.getParentTaskId();
        QFilter taskFilter = new QFilter("taskid", "=", (Object)taskId);
        QFilter typeFilter = new QFilter("type", "=", (Object)"coordinate");
        QFilter[] qFilters = new QFilter[]{taskFilter, typeFilter};
        if ("YunzhijiaTask".equals(task.getCategory())) {
            QFilter partenTaskFilter = new QFilter("taskid", "=", (Object)parentTaskId);
            qFilters = new QFilter[]{taskFilter.or(partenTaskFilter), typeFilter};
        }
        if (CollectionUtil.isNotEmpty(historicIdentityLinkEntities = commandContext.getHistoricIdentityLinkEntityManager().findByQueryFilters(qFilters))) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            HashMap userIdsByTaskId = new HashMap(5);
            for (HistoricIdentityLinkEntity entity : historicIdentityLinkEntities) {
                if (entity.isDeleted() || !WfUtils.isEmptyString(entity.getEndTime())) continue;
                Long userId = entity.getUserId();
                userIds.add(userId);
                Long tId = entity.getTaskId();
                if (userIdsByTaskId.get(tId) == null) {
                    ArrayList<Long> userIdList = new ArrayList<Long>();
                    userIdList.add(userId);
                    userIdsByTaskId.put(tId, userIdList);
                    continue;
                }
                ((List)userIdsByTaskId.get(tId)).add(userId);
            }
            if (!userIds.isEmpty() && !userIdsByTaskId.isEmpty()) {
                if (userIdsByTaskId.get(taskId) != null && !((List)userIdsByTaskId.get(taskId)).isEmpty()) {
                    commandContext.getMessageService().deleteToDo(taskId, (List)userIdsByTaskId.get(taskId));
                }
                if ("YunzhijiaTask".equals(task.getCategory()) && WfUtils.isNotEmpty(parentTaskId) && userIdsByTaskId.get(parentTaskId) != null && !((List)userIdsByTaskId.get(parentTaskId)).isEmpty()) {
                    commandContext.getMessageService().deleteToDo(parentTaskId, (List)userIdsByTaskId.get(parentTaskId));
                }
                QFilter userFilter = new QFilter("userid", "in", userIds);
                IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
                List findByQueryFilters = identityLinkEntityManager.findByQueryFilters(new QFilter[]{taskFilter, typeFilter, userFilter});
                for (IdentityLinkEntity identityLinkEntity : findByQueryFilters) {
                    identityLinkEntityManager.delete(identityLinkEntity);
                }
                commandContext.getHistoricIdentityLinkEntityManager().deleteByFilters(new QFilter[]{taskFilter, typeFilter, userFilter});
                userFilter = new QFilter("userid", "in", userIds);
                QFilter ruleTypeFilter = new QFilter("ruletype", "=", (Object)"coordinate");
                commandContext.getRuleTaskRelationEntityManager().deleteByFilters(new QFilter[]{taskFilter, ruleTypeFilter, userFilter});
            }
        }
    }

    private void deleteTaskToDo(TaskEntity task, boolean onlyRemoveSignleExecution) {
        long count;
        HistoricTaskInstanceEntity taskEntity;
        if ("byAuto".equalsIgnoreCase(task.getExecutionType()) && !"YunzhijiaTask".equals(task.getCategory())) {
            return;
        }
        ArrayList<Long> ups = new ArrayList<Long>();
        HistoricTaskInstanceEntityManager manager = Context.getCommandContext().getHistoricTaskInstanceEntityManager();
        Long parentTaskId = null;
        if (!onlyRemoveSignleExecution && (taskEntity = (HistoricTaskInstanceEntity)manager.findById(task.getId())) != null && WfUtils.isEmpty(parentTaskId = taskEntity.getParentTaskId()) && (count = manager.countByFilter("id", new QFilter[]{new QFilter("parenttaskid", "=", (Object)task.getId())}, false)) > 0L) {
            parentTaskId = task.getId();
        }
        if (WfUtils.isNotEmpty(parentTaskId)) {
            String status = (String)task.getVariableLocal("auditType");
            this.logger.debug(String.format("TaskCompleteListener:taskId:%s,parentTaskId:%s", task.getId(), parentTaskId));
            if (WfConfigurationUtil.getKeepUndealTask() && "forceReject".equals(status)) {
                this.changeUndealTaskToDeal(parentTaskId, task);
                return;
            }
            List<HistoricIdentityLinkEntity> lentitys = Context.getCommandContext().getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByParentTaskId(parentTaskId);
            HistoricTaskInstanceEntity t = null;
            for (HistoricIdentityLinkEntity l : lentitys) {
                t = (HistoricTaskInstanceEntity)manager.findById(l.getTaskId());
                if (t == null) {
                    if (l.getUserId() == null || !WfUtils.isNotEmpty(l.getUserId()) || -1L == l.getUserId()) continue;
                    ups.add(l.getUserId());
                    if (l.getOwnerId() != null && WfUtils.isNotEmpty(l.getOwnerId()) && -1L != l.getOwnerId()) {
                        ups.add(l.getOwnerId());
                    }
                    Context.getCommandContext().getMessageService().deleteToDo(l.getTaskId(), ups, false);
                    ups.clear();
                    continue;
                }
                if ("coordinate".equals(l.getType()) || l.getUserId().equals(t.getAssigneeId()) || l.getUserId() == null || !WfUtils.isNotEmpty(l.getUserId()) || -1L == l.getUserId()) continue;
                ups.add(l.getUserId());
                if (l.getOwnerId() != null && WfUtils.isNotEmpty(l.getOwnerId()) && -1L != l.getOwnerId() && WfUtils.isEmpty(l.getDelegateId())) {
                    ups.add(l.getOwnerId());
                }
                Context.getCommandContext().getMessageService().deleteToDo(l.getTaskId(), ups, false);
                ups.clear();
            }
        } else {
            List<IdentityLinkEntity> users = task.getIdentityLinks();
            if (users != null && users.size() > 0) {
                for (IdentityLinkEntity user : users) {
                    if ("coordinate".equals(user.getType()) || user.getUserId() == null || user.getUserId().equals(task.getAssigneeId()) || !user.isDisplay().booleanValue()) continue;
                    if (WfUtils.isEmpty(user.getDelegateId())) {
                        if (user.getUserId() == null || !WfUtils.isNotEmpty(user.getUserId()) || -1L == user.getUserId()) continue;
                        ups.add(user.getUserId());
                        continue;
                    }
                    if (task.getAssigneeId() == null) {
                        ups.add(user.getUserId());
                        continue;
                    }
                    if (task.getAssigneeId().equals(user.getOwnerId())) continue;
                    ups.add(user.getUserId());
                }
            }
            if (ups.size() > 0) {
                this.logger.debug(String.format("TaskCompleteListener_\u4efb\u52a1[%s]\u88ab[%s]\uff0c\u5220\u9664[%s]\u7684\u5f85\u529e", task.getId(), task.getAssigneeId(), ((Object)ups).toString()));
                Context.getCommandContext().getProcessEngineConfiguration().getMessageService().deleteToDo(task.getId(), ups, false);
            }
        }
    }

    private void changeUndealTaskToDeal(Long parentTaskId, TaskEntity task) {
        CommandContext commandContext = Context.getCommandContext();
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByParentTaskId(parentTaskId);
        if (CollectionUtil.isNotEmpty(identityLinks)) {
            this.logger.debug(String.format("changeUndealTaskToDeal:taskId:%s,identityLinks size:%s,stackTrace:%s", task.getId(), identityLinks.size(), WfUtils.getExceptionStacktrace(new RuntimeException())));
            MessageService messageService = commandContext.getProcessEngineConfiguration().getMessageService();
            CommentEntityManager entityManager = commandContext.getCommentEntityManager();
            HistoricTaskInstanceEntityManager hiTaskInstanceEntityManager = commandContext.getHistoricTaskInstanceEntityManager();
            for (IdentityLinkEntity identityLink : identityLinks) {
                Long userId = identityLink.getUserId();
                if (userId == -1L || userId.equals(task.getAssigneeId()) || "coordinate".equals(identityLink.getType())) continue;
                if (identityLink.getOwnerId() != null && identityLink.getOwnerId() > 0L && identityLink.getDelegateId() != null && identityLink.getDelegateId() > 0L) {
                    HistoricIdentityLinkEntity hiIdentityLinkEntity = (HistoricIdentityLinkEntity)commandContext.getHistoricIdentityLinkEntityManager().findById(identityLink.getId());
                    hiIdentityLinkEntity.setEndTime(WfUtils.now());
                }
                Long taskId = identityLink.getTaskId();
                CommentEntity entity = (CommentEntity)entityManager.create();
                TaskHelper.updateHiCommentRedundancyFieldFromOtherTable(commandContext, task, entity);
                entity.setType("forceReject");
                entity.setResultNumber("forceReject");
                entity.setDecisionType("forceReject");
                entity.setExecutionType("forceReject");
                entity.setHandleState("forceReject");
                entity.setTime(WfUtils.now());
                entity.setUserId(userId);
                entity.setTaskId(taskId);
                entity.setEndType(task.getEndType());
                entity.setActivityId(task.getTaskDefinitionKey());
                entity.setActivityName(task.getName());
                entity.setProcessInstanceId(identityLink.getProcessInstanceId());
                entity.setGroupId(task.getParentTaskId().toString());
                entity.setBusinessKey(task.getBusinessKey());
                entity.setBillNo(task.getBillNo());
                entity.setEntityNumber(task.getEntityNumber());
                entity.setStep(commandContext.getCommentEntityManager().calculateStep(task.getProcessInstanceId()));
                entity.setTerminalWay(RequestContext.get().getClient());
                entity.setProcessType(task.getProcessType());
                entityManager.insert(entity);
                HistoricTaskInstanceEntity taskInfo = (HistoricTaskInstanceEntity)hiTaskInstanceEntityManager.findById(taskId);
                taskInfo.setHandleState("forceReject");
                messageService.dealToDo(taskInfo, userId, false);
                this.logger.debug(String.format("KeepUndealTask:userId:%s,taskId:%s", userId, taskId));
            }
        }
    }

    @Override
    public void onEvent(ActivitiEvent event) {
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}

