/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.engine.delegate.event.ActivitiEntityEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventListener;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;

public class TaskTransferListener
implements ActivitiEventListener {
    public static final String TASKHANDLELOGENTITY = "taskHandleLongEntity";

    @Override
    public void onEvent(ActivitiEvent event) {
        if (!(event instanceof ActivitiEntityEvent)) {
            return;
        }
        Object entity = ((ActivitiEntityEvent)event).getEntity();
        if (!(entity instanceof TaskHandleLogEntity || entity instanceof Map || entity instanceof List)) {
            return;
        }
        List<TaskHandleLogEntity> entities = this.getTaskHandleLogEntities(entity);
        if (entities.isEmpty()) {
            return;
        }
        this.executeAfterTaskListenersForTransfer(entities);
    }

    private List<TaskHandleLogEntity> getTaskHandleLogEntities(Object entity) {
        ArrayList<TaskHandleLogEntity> entities = new ArrayList<TaskHandleLogEntity>(1);
        TaskHandleLogEntity logEntity = null;
        if (entity instanceof TaskHandleLogEntity) {
            logEntity = (TaskHandleLogEntity)entity;
            entities.add(logEntity);
        } else if (entity instanceof Map) {
            Map params = (Map)entity;
            logEntity = (TaskHandleLogEntity)params.get(TASKHANDLELOGENTITY);
            entities.add(logEntity);
        } else if (entity instanceof List) {
            entities = (List)entity;
        }
        if (entities.isEmpty()) {
            return entities;
        }
        CommandContext commandContext = Context.getCommandContext();
        JobEntityManager jobEntityManager = commandContext.getJobEntityManager();
        JobManager jobManager = commandContext.getJobManager();
        ArrayList<JobEntity> jobs = new ArrayList<JobEntity>(entities.size());
        JobEntity job = null;
        for (TaskHandleLogEntity taskHandleLogEntity : entities) {
            job = jobManager.createTaskTransferHandler(taskHandleLogEntity);
            jobEntityManager.insert(job);
            jobs.add(job);
        }
        commandContext.getJobManager().batchScheduleAsyncJob(jobs);
        return entities;
    }

    private void executeAfterTaskListenersForTransfer(List<TaskHandleLogEntity> entities) {
        TaskHandleLogEntity entity = entities.get(0);
        Long taskId = entity.getTaskId();
        ILocaleString opinion = entity.getOpinion();
        Long targetUserId = entity.getAssigneeid();
        Long ownerId = entity.getOwnerId();
        Boolean isadminforward = entity.getIsadminforward();
        StringBuilder targetUserIds = new StringBuilder();
        for (TaskHandleLogEntity taskHandleLogEntity : entities) {
            targetUserIds.append(taskHandleLogEntity.getAssigneeid()).append(",");
        }
        CommandContext commandContext = Context.getCommandContext();
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (null == task) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("opinion", opinion);
        param.put("targetUserId", targetUserId);
        param.put("targetUserIds", 0 == targetUserIds.length() ? targetUserIds : targetUserIds.substring(0, targetUserIds.length() - 1));
        param.put("ownerId", ownerId);
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeAfterTaskListeners(task, "afterTransfer", param);
        if (isadminforward.booleanValue()) {
            BPMNUtil.updateHitaskInstPresentAssignee(task.getExecution(), null);
        }
    }

    @Override
    public boolean isFailOnException() {
        return false;
    }
}

