/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.TransactionPropagation;
import kd.bos.workflow.engine.impl.cmd.task.TaskCirculationCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.center.operation.ITaskCenterOperation;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class CirculatedOperation
implements ITaskCenterOperation {
    public static final String VALUENUMBER = "personIds";
    public static final String MSGVALUENUMBER = "message";
    private static final String VALUE = "value";

    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        Long taskId = (Long)params.get("taskId");
        Long taskOwnerId = (Long)params.get("userId");
        Object param = params.get("params");
        if (WfUtils.isNotEmptyString(param)) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)param.toString(), Map.class);
            if (paramMap == null || paramMap.size() < 1) {
                return;
            }
            Object msgObj = paramMap.get(MSGVALUENUMBER);
            String msg = msgObj == null ? "" : msgObj.toString();
            Object paramVal = paramMap.get(VALUENUMBER);
            if (paramVal instanceof List && ((List)paramVal).size() > 0) {
                List paramVals = (List)paramVal;
                ArrayList<Long> userIds = new ArrayList<Long>(paramVals.size());
                for (int i = 0; i < paramVals.size(); ++i) {
                    if (paramVals.get(i) == null || !StringUtils.isNotBlank(((Map)paramVals.get(i)).get(VALUE))) continue;
                    userIds.add(Long.valueOf(((Map)paramVals.get(i)).get(VALUE).toString()));
                }
                CommandContext commandContext = Context.getCommandContext();
                CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
                ILocaleString message = WfUtils.getMultiLangValue(msg);
                TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
                if (taskEntity != null && taskEntity.isBizTask()) {
                    CirculateOperationParam circulateOperationParam = new CirculateOperationParam();
                    ArrayList<Long> taskIds = new ArrayList<Long>();
                    taskIds.add(taskId);
                    circulateOperationParam.setTaskIds(taskIds);
                    circulateOperationParam.setOperaterId(taskOwnerId);
                    circulateOperationParam.setCirculateMsg(message);
                    circulateOperationParam.setCirculateUserIds(userIds);
                    IMessageCenterService messageService = (IMessageCenterService)ServiceFactory.getService((String)"MessageCenterService");
                    messageService.circulateBizTask(circulateOperationParam);
                } else {
                    CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
                    commandExecutor.execute(commandConfig, new TaskCirculationCmd(taskId, userIds, message, taskOwnerId, Boolean.TRUE));
                }
            }
        }
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> operation = new HashMap<String, Object>();
        operation.put("fieldCaption", String.format(ResManager.loadKDString((String)"\u5c06\u4efb\u52a1%s\u7ed9", (String)"CirculatedOperation_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
        operation.put("fieldName", "circulated");
        ArrayList values = new ArrayList();
        HashMap<String, String> circulatedUserMap = new HashMap<String, String>();
        circulatedUserMap.put("number", VALUENUMBER);
        circulatedUserMap.put("type", "user");
        circulatedUserMap.put("entityId", "bos_user");
        values.add(circulatedUserMap);
        HashMap<String, String> circulatedMsgMap = new HashMap<String, String>();
        circulatedMsgMap.put("number", MSGVALUENUMBER);
        circulatedMsgMap.put("placeholder", ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9", (String)"CirculatedOperation_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        circulatedMsgMap.put("type", "text");
        values.add(circulatedMsgMap);
        operation.put(VALUE, values);
        return operation;
    }
}

