/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.center.operation.IOperation;
import kd.bos.workflow.engine.task.center.operation.ITaskCenterOperation;
import kd.bos.workflow.engine.task.center.operation.expire.IExpireOperation;

public class OperationsRegister {
    private static final String BOS_WF_ENGINE = "bos-wf-engine";
    private static Log logger = LogFactory.getLog(OperationsRegister.class);
    private static volatile OperationsRegister instance = null;
    private final Map<String, Class<?>> operationClasses = new HashMap();
    private final Map<String, ILocaleString> operationnNames = new HashMap<String, ILocaleString>();

    private OperationsRegister() {
        this.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized OperationsRegister getInstance() {
        if (instance != null) return instance;
        Class<OperationsRegister> clazz = OperationsRegister.class;
        synchronized (OperationsRegister.class) {
            instance = new OperationsRegister();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerOpreationClass(String OperationNumber, String operationClassName) {
        this.operationClasses.computeIfAbsent(OperationNumber, k -> TypesContainer.getOrRegister((String)operationClassName));
    }

    public final void register() {
        this.registerOpreationClass("moveToFolder", "kd.bos.workflow.engine.task.center.operation.MoveToFolderOperation");
        this.registerOpreationClass("setTaskLevel", "kd.bos.workflow.engine.task.center.operation.SetTaskLevelOperation");
        this.operationnNames.put("setTaskLevel", WfUtils.getPromptWordLocaleString("\u8bbe\u7f6e\u4f18\u5148\u7ea7\u4e3a: ", "OperationsRegister_1", BOS_WF_ENGINE));
        this.registerOpreationClass("circulated", "kd.bos.workflow.engine.task.center.operation.CirculatedOperation");
        this.operationnNames.put("circulated", WfMultiLangUtils.replaceILocaleString((ILocaleString)ResManager.getLocaleString((String)"\u4efb\u52a1%s\u7ed9: ", (String)"OperationsRegister_3", (String)BOS_WF_ENGINE), WfConfigurationUtil.getLocalCirculationName()));
        this.registerOpreationClass("Transfer", "kd.bos.workflow.engine.task.center.operation.TransferOperation");
        this.operationnNames.put("Transfer", WfMultiLangUtils.replaceILocaleString((ILocaleString)ResManager.getLocaleString((String)"\u4efb\u52a1%s\u7ed9: ", (String)"OperationsRegister_3", (String)BOS_WF_ENGINE), WfConfigurationUtil.getLocalTransferName()));
        this.registerOpreationClass("sendMessageExpire", "kd.bos.workflow.engine.task.center.operation.expire.ExpireSendMessageOperation");
        this.registerOpreationClass("autoAuditExpire", "kd.bos.workflow.engine.task.center.operation.expire.ExpireAutoAuditOperation");
        this.registerOpreationClass("skipExpire", "kd.bos.workflow.engine.task.center.operation.expire.ExpireSkipOperation");
        this.registerOpreationClass("transferExpire", "kd.bos.workflow.engine.task.center.operation.expire.ExpireTransferOperation");
        this.registerOpreationClass("pluginExpire", "kd.bos.workflow.engine.task.center.operation.expire.ExpirePluginOperation");
    }

    public List<Map<String, Object>> getOperationMetas() {
        ArrayList<Map<String, Object>> operations = new ArrayList<Map<String, Object>>();
        for (Class<?> clasz : this.operationClasses.values()) {
            try {
                IOperation opreation = (IOperation)clasz.newInstance();
                if (!(opreation instanceof ITaskCenterOperation) || ((ITaskCenterOperation)opreation).getOperationMeta() == null) continue;
                operations.add(((ITaskCenterOperation)opreation).getOperationMeta());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return operations;
    }

    public List<Map<String, Object>> getExpireOperationMetasByNumbers(String numbers) {
        ArrayList<Map<String, Object>> operations = new ArrayList<Map<String, Object>>();
        if (WfUtils.isNotEmpty(numbers)) {
            try {
                String[] numberArr;
                for (String number : numberArr = numbers.split(",")) {
                    IExpireOperation op = (IExpireOperation)this.getOperationClass(number).newInstance();
                    operations.add(op.getOperationMeta());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return operations;
    }

    public Class<?> getOperationClass(String OperationNumber) {
        Class<?> clazz = this.operationClasses.get(OperationNumber);
        return clazz;
    }

    public IOperation getOperation(String OperationNumber) {
        Class<?> clazz = this.operationClasses.get(OperationNumber);
        IOperation operation = null;
        try {
            operation = (IOperation)clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return operation;
    }

    public String getOperationNameByOperationKey(String key) {
        ILocaleString operation = this.operationnNames.get(key);
        return operation != null ? (String)operation.get((Object)String.valueOf(RequestContext.get().getLang())) : "";
    }
}

