/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.RuleTaskRelationEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskMarkEntity;
import kd.bos.workflow.engine.task.center.operation.ITaskCenterOperation;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;

public class SetTaskLevelOperation
implements ITaskCenterOperation {
    public static final String RULETYPE = "priority";
    public static final String VALUENUMBER = "levelId";
    public static final Long URGENCY = 234356994822124545L;
    public static final Long IMPORTANT = 234356998068515840L;

    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        Long taskId = (Long)params.get("taskId");
        Long userId = (Long)params.get("userId");
        Long taskRuleId = (Long)params.get("taskRuleId");
        String param = params.get("params").toString().replace("'", "\"");
        Map paramsMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        String markId = (String)paramsMap.get(VALUENUMBER);
        RuleTaskRelationEntityManager manager = Context.getCommandContext().getRuleTaskRelationEntityManager();
        IdentityLinkEntityManager umanager = Context.getCommandContext().getIdentityLinkEntityManager();
        int priority = 0;
        if (URGENCY == Long.parseLong(markId)) {
            priority = 100;
        } else if (IMPORTANT == Long.parseLong(markId)) {
            priority = 60;
        }
        RuleTaskRelationEntity relationEntity = manager.getRelationEntityByTaskIdAndType(taskId, RULETYPE, userId);
        List<IdentityLinkEntity> entitys = umanager.findIdentityLinkByTaskUserAndType(taskId, userId, "participant");
        if (entitys != null && !entitys.isEmpty()) {
            IdentityLinkEntity i = entitys.get(0);
            i.setPriority(priority);
            umanager.update(i);
            HistoricIdentityLinkEntityManager humgr = Context.getCommandContext().getHistoricIdentityLinkEntityManager();
            HistoricIdentityLinkEntity hu = (HistoricIdentityLinkEntity)humgr.findById(i.getId());
            hu.setPriority(priority);
            humgr.update(hu);
        }
        if (relationEntity != null) {
            relationEntity.setMarkid(Long.valueOf(markId));
            manager.update(relationEntity);
        } else {
            relationEntity = new RuleTaskRelationEntityImpl();
            relationEntity.setTaskid(taskId);
            relationEntity.setMarkid(Long.valueOf(markId));
            relationEntity.setRuletype(RULETYPE);
            relationEntity.setUserid(userId);
            relationEntity.setRuleid(taskRuleId);
            relationEntity.setPriority(priority);
            manager.insert(relationEntity);
        }
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> operation = new HashMap<String, Object>();
        operation.put("fieldCaption", ResManager.loadKDString((String)"\u8bbe\u7f6e\u4f18\u5148\u7ea7", (String)"SetTaskLevelOperation_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        operation.put("fieldName", "setTaskLevel");
        ArrayList values = new ArrayList();
        HashMap<String, Object> levelMap = new HashMap<String, Object>();
        levelMap.put("number", VALUENUMBER);
        levelMap.put("type", "enum");
        String uid = RequestContext.get().getUserId();
        Long userId = Long.valueOf(uid);
        CommandContext commandContext = Context.getCommandContext();
        List<TaskMarkEntity> taskMarks = commandContext.getTaskMarkEntityManager().getTaskMarksByUserIdAndType(userId, RULETYPE);
        ArrayList<ValueMapItem> levels = new ArrayList<ValueMapItem>(taskMarks.size());
        for (TaskMarkEntity taskMark : taskMarks) {
            ValueMapItem level = new ValueMapItem(null, taskMark.getId() + "", new LocaleString(taskMark.getName().getLocaleValue()));
            levels.add(level);
        }
        levelMap.put("items", levels);
        values.add(levelMap);
        operation.put("value", values);
        return operation;
    }
}

