/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.TaskTransferCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.center.operation.ITaskCenterOperation;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class TransferOperation
implements ITaskCenterOperation {
    private static Log logger = LogFactory.getLog(TransferOperation.class);

    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        Object param = params.get("params");
        Long taskId = (Long)params.get("taskId");
        Long ruleOwnerId = (Long)params.get("userId");
        TaskEntity taskEntity = null;
        if (params.containsKey("taskEntity") && (taskEntity = (TaskEntity)params.get("taskEntity")).isBizTask()) {
            logger.info(String.format("bizTask[%s] is not support autoTransfer", taskEntity.getId()));
            return;
        }
        if (WfUtils.isNotEmptyString(param)) {
            QFilter filter4;
            QFilter filter3;
            QFilter filter2;
            QFilter filter1;
            boolean existsDelegate;
            if (WfConfigurationUtil.existsDelegateAndNotTransfer() && (existsDelegate = QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])new QFilter[]{filter1 = new QFilter("taskId", "=", (Object)taskId), filter2 = new QFilter("type", "=", (Object)"participant"), filter3 = new QFilter("ownerId", "=", (Object)ruleOwnerId), filter4 = new QFilter("delegateid", "!=", (Object)0L)}))) {
                logger.info("The task has been delegated and cannot be automatically transferred  ");
                return;
            }
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)param.toString(), Map.class);
            if (paramMap == null || paramMap.size() < 1) {
                return;
            }
            Object msgObj = paramMap.get("transferMsg");
            String msg = msgObj == null ? "" : msgObj.toString();
            ILocaleString msgLocale = WfUtils.getMultiLangValue(msg);
            Object transferUsers = paramMap.get("Transfer");
            if (transferUsers instanceof List && ((List)transferUsers).size() > 0) {
                Map valMap = (Map)((List)transferUsers).get(0);
                String userId = valMap.get("value").toString();
                Long transfererId = Long.valueOf(userId);
                if (!UserServiceHelper.isUserEnable((long)transfererId)) {
                    logger.debug("user is not legal, userid is: " + transfererId);
                    return;
                }
                List<Long> ownerids = TaskUtils.getParticipantIdsByTaskId(taskId);
                if (ownerids.contains(transfererId)) {
                    logger.debug(String.format("\u4efb\u52a1[%s]\u7684\u5904\u7406\u4eba\u5305\u542b\u88ab\u8f6c\u4ea4\u4eba", taskId));
                    return;
                }
                if (this.isHaveOperateTransfer(taskId, ruleOwnerId, transfererId)) {
                    return;
                }
                CommandContext commandContext = Context.getCommandContext();
                if (taskEntity == null || !taskEntity.isBizTask()) {
                    new TaskTransferCmd(taskId, transfererId, msgLocale, Boolean.FALSE, ruleOwnerId, Boolean.TRUE, Boolean.TRUE).execute(commandContext);
                    Context.getProcessEngineConfiguration().getTaskHelper().autoTransferRepeaterApproval(commandContext, taskId, transfererId);
                } else {
                    ArrayList<Long> bizTaskIds = new ArrayList<Long>();
                    bizTaskIds.add(taskId);
                    TransferOperationParam transferOperationParam = new TransferOperationParam();
                    transferOperationParam.setTaskIds(bizTaskIds);
                    transferOperationParam.setOperaterId(ruleOwnerId);
                    transferOperationParam.setTransfererId(transfererId);
                    transferOperationParam.setTransferOpinion(msgLocale);
                    transferOperationParam.setTransferSubscribe(Boolean.FALSE.booleanValue());
                    IMessageCenterService messageService = (IMessageCenterService)ServiceFactory.getService(IMessageCenterService.class);
                    messageService.transferBizTask(transferOperationParam);
                }
            }
        }
    }

    private boolean isHaveOperateTransfer(Long taskId, Long ruleOwnerId, Long transfererId) {
        OperationLogEntityManager operationLogEntityManager = Context.getProcessEngineConfiguration().getOperationLogEntityManager();
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        filter.and(new QFilter("ownerid", "=", (Object)ruleOwnerId));
        List operationLogs = operationLogEntityManager.findByQueryFilters(new QFilter[]{filter});
        boolean isAutoTransfer = false;
        boolean isWithdraw = false;
        if (operationLogs != null && !operationLogs.isEmpty()) {
            for (OperationLogEntity operationLog : operationLogs) {
                if (transfererId.toString().equals(operationLog.getAssigneeId()) && "transfer".equals(operationLog.getType())) {
                    isAutoTransfer = true;
                }
                if (!"withdraw".equals(operationLog.getType())) continue;
                isWithdraw = true;
            }
        }
        return isAutoTransfer && isWithdraw;
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> operation = new HashMap<String, Object>();
        operation.put("fieldCaption", String.format(ResManager.loadKDString((String)"\u5c06\u4efb\u52a1%s\u7ed9", (String)"TransferOperation_1", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
        operation.put("fieldName", "Transfer");
        ArrayList values = new ArrayList();
        HashMap<String, String> transferedUserMap = new HashMap<String, String>();
        transferedUserMap.put("number", "Transfer");
        transferedUserMap.put("type", "user");
        transferedUserMap.put("entityId", "bos_user");
        values.add(transferedUserMap);
        HashMap<String, String> transferedMsgMap = new HashMap<String, String>();
        transferedMsgMap.put("number", "transferMsg");
        transferedMsgMap.put("placeholder", String.format(ResManager.loadKDString((String)"%s\u610f\u89c1", (String)"TransferOperation_2", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
        transferedMsgMap.put("type", "text");
        values.add(transferedMsgMap);
        operation.put("value", values);
        return operation;
    }
}

