/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation.expire;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AutoAudit;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ExpireOperation;
import kd.bos.workflow.bpmn.model.TimeControl;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.JudgeForkTaskCanRejectCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;
import kd.bos.workflow.engine.task.center.operation.expire.IExpireOperation;

public class ExpireAutoAuditOperation
implements IExpireOperation {
    protected static Log logger = LogFactory.getLog(ExpireAutoAuditOperation.class);
    public static final String AUTO_DECISION_WHEN_MATCH = "autoDecisionWhenMatch";
    public static final String PROCESS_HANDLER = "processHandler";
    public static final String AUTO_OPINION_WHEN_MATCH = "autoOpinionWhenMatch";
    public static final String AUTOAUDITTASK = "expireAutoAuditTask";

    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        if (params != null) {
            String autoDecisionWhenMatch = (String)params.get(AUTO_DECISION_WHEN_MATCH);
            String autoOpinionWhenMatch = (String)params.get(AUTO_OPINION_WHEN_MATCH);
            Long taskId = context.getTaskId();
            TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
            if (task == null) {
                logger.debug("task Id \u4e3a\uff1a" + context.getTaskId() + "\u7684\u4efb\u52a1\u5df2\u7ecf\u88ab\u5904\u7406!");
                return;
            }
            try (DLock lock = DLock.create((String)String.format("wf/expireOperation/%s", context.getTaskId()), (String)String.format(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u671f\u8df3\u8fc7[%s]", (String)"ExpireAutoAuditOperation_1", (String)"bos-wf-engine", (Object[])new Object[0]), context.getTaskId())).fastMode();){
                boolean lockNotNeededOrSuccess = lock.tryLock(60000L);
                Long processInstanceId = context.getProcessInstanceId();
                if (lockNotNeededOrSuccess) {
                    UserTask userTask = (UserTask)ProcessDefinitionUtil.getFlowElement(context.getProcessDefinitionId(), processInstanceId, context.getElementId());
                    DecisionOption autoDecision = null;
                    for (DecisionOption d : userTask.getDecisionOptions()) {
                        if (!d.getNumber().equals(autoDecisionWhenMatch)) continue;
                        autoDecision = d;
                        break;
                    }
                    if (autoDecision != null) {
                        TaskHelper taskHelper = Context.getProcessEngineConfiguration().getTaskHelper();
                        AutoAudit autoAudit = userTask.getAutoAudit().clone();
                        autoAudit.setParticipantAsAutoAuditor((Boolean)params.get("participantAsAutoAuditor"));
                        List<TimeControl> tcs = userTask.getExpireModel().getTimeControls();
                        String id = "";
                        String cfg = "";
                        if (tcs != null && !tcs.isEmpty()) {
                            for (TimeControl tc : tcs) {
                                Map config;
                                ExpireOperation op = tc.getOperation();
                                if (op == null || !"autoAuditExpire".equals(op.getOperationNumber()) || !WfUtils.isNotEmpty(op.getConfig()) || !autoOpinionWhenMatch.equals((config = (Map)SerializationUtils.fromJsonString((String)op.getConfig(), Map.class)).get(AUTO_OPINION_WHEN_MATCH)) || !autoDecisionWhenMatch.equals(config.get(AUTO_DECISION_WHEN_MATCH))) continue;
                                id = tc.getId();
                                cfg = op.getConfig();
                                break;
                            }
                        }
                        String autoOpinionWhenMatchMultiKey = String.format("%s.expireModel.timeControls.[%s].operation.config.autoOpinionWhenMatch", task.getTaskDefinitionKey(), id);
                        String processHandlerMatchMultiKey = String.format("%s.expireModel.timeControls.[%s].operation.config.processHandler", task.getTaskDefinitionKey(), id);
                        ILocaleString localOpinion = BpmnModelUtil.getMultiLangFieldValue(task.getProcessInstanceId(), autoOpinionWhenMatchMultiKey, cfg);
                        ILocaleString processHandler = BpmnModelUtil.getMultiLangFieldValue(task.getProcessInstanceId(), processHandlerMatchMultiKey, cfg);
                        List<Long> users = TaskUtils.getParticipantIdsByTaskIdWithoutYzj(taskId);
                        CommandContext commandContext = Context.getCommandContext();
                        commandContext.getMessageService().deleteToDo(taskId, users);
                        String elementId = context.getElementId();
                        String decNumber = autoDecision.getNumber();
                        String rejectTargetId = null;
                        if (("reject".equalsIgnoreCase(decNumber) || "forceReject".equalsIgnoreCase(decNumber)) && WfUtils.isNotEmptyForCollection(autoDecision.getRejectOptions()) && autoDecision.getRejectOptions().get(0) != null) {
                            rejectTargetId = autoDecision.getRejectOptions().get(0).getItemId();
                        }
                        boolean removeReject = new JudgeForkTaskCanRejectCmd(processInstanceId, elementId, rejectTargetId).execute(commandContext);
                        if (WfUtils.isNotEmpty(decNumber) && ("reject".equalsIgnoreCase(decNumber) || "forceReject".equalsIgnoreCase(decNumber)) && removeReject) {
                            logger.debug(String.format("ExpireAutoAuditOperation stop processInstanceId:%s,decNumber:%s,removeReject:%s,taskId:%s", processInstanceId, decNumber, removeReject, taskId));
                        } else {
                            logger.debug(String.format("ExpireAutoAuditOperation execute processInstanceId:%s,decNumber:%s,removeReject:%s,taskId:%s", processInstanceId, decNumber, removeReject, taskId));
                            new ResumeDelegateTasksCmd(taskId, AUTOAUDITTASK).execute(commandContext);
                            taskHelper.doAutoAudit(task.getExecution(), autoAudit, autoDecision, localOpinion, processHandler, true);
                        }
                    }
                } else {
                    logger.debug("task Id \u4e3a\uff1a" + task.getId() + "\u7684\u4efb\u52a1\u6b63\u5728\u88ab\u5176\u4ed6\u7ebf\u7a0b\u5904\u7406\u3002");
                }
            }
        }
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("value", "autoAuditExpire");
        meta.put("name", ResManager.loadKDString((String)"\u81ea\u52a8\u5904\u7406", (String)"ExpireAutoAuditOperation_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        meta.put("formId", "wf_autoauditoperation");
        return meta;
    }
}

