/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation.expire;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;
import kd.bos.workflow.engine.task.center.operation.expire.ExpireSendMessageOperation;
import kd.bos.workflow.engine.task.center.operation.expire.IExpireOperation;

public class ExpirePluginOperation
implements IExpireOperation {
    private static Log logger = LogFactory.getLog(ExpireSendMessageOperation.class);

    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        if (params == null || params.get("plugin") == null) {
            return;
        }
        String value = (String)params.get("plugin");
        Long taskId = context.getTaskId();
        TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(taskId);
        if (task == null) {
            logger.debug(String.format("task[%s] may has been dealed.", taskId));
            return;
        }
        try (DLock lock = DLock.create((String)String.format("wf/expireOperation/%s", context.getTaskId()), (String)"ExpirePluginOperation").fastMode();){
            boolean lockNotNeededOrSuccess = lock.tryLock(60000L);
            if (lockNotNeededOrSuccess) {
                ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.EXPIREPLUGIN, value, task);
            } else {
                logger.debug(String.format("taskId[%s] is executing by other thread.", taskId));
            }
        }
        catch (Exception e) {
            logger.debug(String.format("expire plugin error, implemetation:%s,message:%s", value, WfUtils.getExceptionStacktrace(e)));
        }
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> meta = new HashMap<String, Object>(3);
        meta.put("value", "pluginExpire");
        meta.put("name", ResManager.loadKDString((String)"\u63d2\u4ef6", (String)"ExpirePluginOperation_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        meta.put("formId", "wf_pluginexpire");
        return meta;
    }
}

