/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation.expire;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.bpmn.model.ExpireOperation;
import kd.bos.workflow.bpmn.model.TimeControl;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.msg.WFMessageServiceHelper;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;
import kd.bos.workflow.engine.task.center.operation.expire.IExpireOperation;
import kd.bos.workflow.message.api.MsgTypeEnum;

public class ExpireSendMessageOperation
implements IExpireOperation {
    private static Log logger = LogFactory.getLog(ExpireSendMessageOperation.class);
    public static final String MSGCONTENT = "msgContent";
    public static final String NOTIFYTYPE = "notifyType";
    public static final String MSGCHANNEL = "msgChannel";
    public static final String MSGRECEIVER = "msgReceiver";
    public static final String MSGRECEIVERPLUGIN = "msgReceiverPlugin";

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        if (params != null) {
            JSONObject mObject;
            String msgContent = params.get(MSGCONTENT).toString();
            String notifyType = params.get(NOTIFYTYPE).toString();
            String templateNumber = (String)params.get("templateNumber");
            TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(context.getTaskId());
            if (task == null || task.getCategory().equals("YunzhijiaTask") && WfUtils.isEmpty(task.getParentTaskId())) {
                return;
            }
            UserTask userTask = (UserTask)ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey());
            List<TimeControl> tcs = userTask.getExpireModel().getTimeControls();
            String id = "";
            String cfg = "";
            if (tcs != null && !tcs.isEmpty()) {
                for (TimeControl tc : tcs) {
                    ExpireOperation op = tc.getOperation();
                    if (op == null || !"sendMessageExpire".equals(op.getOperationNumber()) || !WfUtils.isNotEmpty(op.getConfig())) continue;
                    Map config = (Map)SerializationUtils.fromJsonString((String)op.getConfig(), Map.class);
                    if (!StringUtils.isNotBlank((CharSequence)notifyType) || !StringUtils.isNotBlank((CharSequence)msgContent) || !notifyType.equals(config.get(NOTIFYTYPE)) || !((String)config.get(MSGCONTENT)).equals(params.get(MSGCONTENT))) continue;
                    id = tc.getId();
                    cfg = op.getConfig();
                    break;
                }
            }
            task.setTransientVariableLocal("currentParticipant", WfUtils.listToString(new ArrayList(task.getParticipants()), ","));
            LocaleString parsedMsgContent = new LocaleString();
            LocaleString parsedMsgTitle = new LocaleString();
            boolean isTplNewMutil = Boolean.FALSE;
            JSONObject msgContentObj = new JSONObject();
            if (WfUtils.isNotEmpty(cfg) && WfUtils.isNotEmptyForMap((Map)(mObject = JSONObject.parseObject((String)cfg))) && WfUtils.isJSONFormat(mObject.get((Object)MSGCONTENT)) && ((msgContentObj = mObject.getJSONObject(MSGCONTENT)).get((Object)"content") instanceof JSONObject || msgContentObj.get((Object)"title") instanceof JSONObject)) {
                isTplNewMutil = Boolean.TRUE;
            }
            if (isTplNewMutil) {
                JSONObject contentObj = msgContentObj.getJSONObject("content");
                HashMap wrapMsg = new HashMap(contentObj.size());
                Set entryContent = contentObj.entrySet();
                Iterator iterator = entryContent.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    HashMap msgLang = new HashMap();
                    msgLang.put("content", entry.getValue());
                    wrapMsg.put(entry.getKey(), msgLang);
                }
                JSONObject titleObj = msgContentObj.getJSONObject("title");
                Set entryTitle = titleObj.entrySet();
                for (Object entry : entryTitle) {
                    void var22_26;
                    Object var22_27 = null;
                    if (wrapMsg.get(entry.getKey()) != null) {
                        Map map = (Map)wrapMsg.get(entry.getKey());
                    } else {
                        HashMap hashMap = new HashMap();
                    }
                    var22_26.put("title", entry.getValue());
                    wrapMsg.put(entry.getKey(), var22_26);
                }
                if (!wrapMsg.isEmpty()) {
                    Set entryWrapMsg = wrapMsg.entrySet();
                    for (Map.Entry entry : entryWrapMsg) {
                        Object title;
                        Map msgLang = (Map)entry.getValue();
                        String lang = (String)entry.getKey();
                        Object content = msgLang.get("content");
                        if (WfUtils.isNotEmptyString(content)) {
                            parsedMsgContent.put((Object)lang, (Object)ExpressionCalculatorUtil.contentParser((String)content, task.getBusinessKey(), task.getEntityNumber(), task, lang, true));
                        }
                        if (!WfUtils.isNotEmptyString(title = msgLang.get("title"))) continue;
                        parsedMsgTitle.put((Object)lang, (Object)ExpressionCalculatorUtil.contentParser((String)title, task.getBusinessKey(), task.getEntityNumber(), task, lang, true));
                    }
                }
            } else {
                String configMultiKey = String.format("%s.expireModel.timeControls.[%s].operation.config", task.getTaskDefinitionKey(), id);
                ILocaleString info = BpmnModelUtil.getMultiLangFieldValue(task.getProcessInstanceId(), configMultiKey, cfg);
                if (WfUtils.isNotEmpty(info)) {
                    for (Map.Entry entry : info.entrySet()) {
                        void var22_32;
                        Map msg;
                        String msgInfo;
                        String data = (String)entry.getValue();
                        if (!WfUtils.isNotEmpty(data) || !WfUtils.isNotEmpty(msgInfo = (String)(msg = (Map)SerializationUtils.fromJsonString((String)data, Map.class)).get(MSGCONTENT))) continue;
                        Object var22_33 = null;
                        String title = null;
                        try {
                            Map mct = (Map)SerializationUtils.fromJsonString((String)msgInfo, Map.class);
                            String string = StringUtils.isNotBlank(mct.get("content")) ? (String)mct.get("content") : null;
                            title = StringUtils.isNotBlank(mct.get("title")) ? (String)mct.get("title") : null;
                        }
                        catch (Exception e) {
                            String string = msgInfo;
                        }
                        if (WfUtils.isNotEmpty((String)var22_32)) {
                            parsedMsgContent.put(entry.getKey(), (Object)ExpressionCalculatorUtil.contentParser((String)var22_32, task.getBusinessKey(), task.getEntityNumber(), task, (String)entry.getKey(), true));
                        }
                        if (!WfUtils.isNotEmpty(title)) continue;
                        parsedMsgTitle.put(entry.getKey(), (Object)ExpressionCalculatorUtil.contentParser(title, task.getBusinessKey(), task.getEntityNumber(), task, (String)entry.getKey(), true));
                    }
                }
            }
            boolean isYunzhijiaNodeAndeParallel = task.getCategory().equals("YunzhijiaTask") && "parallelAudit".equalsIgnoreCase(((YunzhijiaTask)userTask).getSignType());
            Long taskId = context.getTaskId();
            boolean onlyCalculatorParticipant = false;
            if (isYunzhijiaNodeAndeParallel) {
                onlyCalculatorParticipant = WfCacheHelper.getSendExpireMessage(String.valueOf(task.getParentTaskId()));
            }
            List<Long> userIds = this.getUserId(params, onlyCalculatorParticipant, task).stream().distinct().collect(Collectors.toList());
            String type = this.getMsgType(notifyType);
            String channelInfos = this.getMsgchannel(params.get(MSGCHANNEL), type);
            logger.debug("send Message type :" + type + "channelInfo:" + channelInfos + "userId :" + WfUtils.listToString(userIds, ","));
            boolean carryUrl = WfConfigurationUtil.expireSendMsgCarryUrl();
            WFMessageServiceHelper.sendMessageForWarning(taskId, (ILocaleString)parsedMsgContent, (ILocaleString)parsedMsgTitle, userIds, null, channelInfos, type, templateNumber, carryUrl);
            if (isYunzhijiaNodeAndeParallel) {
                WfCacheHelper.putSendExpireMessage(String.valueOf(task.getParentTaskId()));
            }
        }
    }

    private String getMsgchannel(Object channels, String type) {
        if (channels == null) {
            return MessageCenterServiceHelper.getChannelsOfMsgType((String)type);
        }
        return (String)channels;
    }

    private String getMsgType(String notifyType) {
        if ("afterDuration".equals(notifyType)) {
            return MsgTypeEnum.ALARM.getNumber();
        }
        return MsgTypeEnum.WARNING.getNumber();
    }

    private List<Long> getUserId(Map<String, Object> params, boolean onlyCalculatorParticipant, TaskEntity task) {
        ParticipantCalculator participantCalculator;
        List<Long> participants;
        Object userType = params.get(MSGRECEIVER);
        HashSet<Long> userIds = new HashSet<Long>();
        if (userType == null) {
            return TaskUtils.getParticipantIdsByTaskIdWithoutYzj(task.getId());
        }
        String[] types = ((String)userType).split(",");
        ArrayList<ParticipantModelEntityImpl> pmes = new ArrayList<ParticipantModelEntityImpl>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isEmpty()) continue;
            ParticipantModelEntityImpl p = new ParticipantModelEntityImpl();
            if ("plugin".equals(types[i])) {
                p.setType("plugin");
                p.setValue((String)params.get(MSGRECEIVERPLUGIN));
                pmes.add(p);
                continue;
            }
            if ("processstart".equals(types[i])) {
                p.setRelationType("person");
                p.setPersonRelation("self");
                p.setReportType("admin_org");
                p.setReferenceOrg("ENTI_orgfield");
                p.setType("relation");
                p.setReferencePerson("PROC_initiator");
                p.setValue(ResManager.loadKDString((String)"\u6d41\u7a0b-\u53d1\u8d77\u4eba\u672c\u4eba", (String)"ExpireSendMessageOperation_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                pmes.add(p);
                continue;
            }
            if (!"curparticipant".equals(types[i])) continue;
            userIds.addAll(TaskUtils.getParticipantIdsByTaskIdWithoutYzj(task.getId()));
        }
        if (pmes.size() > 0 && (participants = (participantCalculator = Context.getProcessEngineConfiguration().getParticipantCalculator()).getUserIds(task.getBusinessKey(), task.getExecution(), pmes)).size() > 0) {
            if (onlyCalculatorParticipant) {
                for (Long id : participants) {
                    userIds.remove(id);
                }
            } else {
                userIds.addAll(participants);
            }
        }
        return new ArrayList<Long>(userIds);
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("value", "sendMessageExpire");
        meta.put("name", ResManager.loadKDString((String)"\u53d1\u9001\u9884\u8b66\u6d88\u606f", (String)"ExpireSendMessageOperation_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        meta.put("formId", "wf_sendmsgoperation");
        return meta;
    }
}

