/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.task.center.operation.expire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cmd.task.AdminTransferTaskCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.center.operation.ctx.OperationContext;
import kd.bos.workflow.engine.task.center.operation.expire.IExpireOperation;
import kd.bos.workflow.exception.WFErrorCode;

public class ExpireTransferOperation
implements IExpireOperation {
    private static final String VALUE = "value";
    public static final String OPINION = "opinion";
    public static final String TRANSFER_PERSION = "transferpersion";
    public static final Long EXPIRE_TRANSFERERID = -1L;

    @Override
    public void execute(OperationContext context, Map<String, Object> params) {
        if (params != null) {
            TaskEntity task = (TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(context.getTaskId());
            if (task == null) {
                return;
            }
            ArrayList<ParticipantModelEntityImpl> pmes = new ArrayList<ParticipantModelEntityImpl>();
            ParticipantModelEntityImpl p = new ParticipantModelEntityImpl();
            if (WfUtils.isNotEmptyString(params.get("reportType"))) {
                p.setReportType((String)params.get("reportType"));
            }
            if (WfUtils.isNotEmptyString(params.get("valueshowtext"))) {
                p.setShowValue((String)params.get("valueshowtext"));
            }
            if (WfUtils.isNotEmptyString(params.get("referencePerson"))) {
                p.setReferencePerson((String)params.get("referencePerson"));
            }
            if (WfUtils.isNotEmptyString(params.get("type"))) {
                p.setType((String)params.get("type"));
            }
            if (WfUtils.isNotEmptyString(params.get(VALUE))) {
                p.setValue((String)params.get(VALUE));
            }
            if (WfUtils.isNotEmptyString(params.get("personRelation"))) {
                p.setPersonRelation((String)params.get("personRelation"));
            }
            if (WfUtils.isNotEmptyString(params.get("businessOrgField"))) {
                p.setBusinessOrgField((String)params.get("businessOrgField"));
            }
            if (WfUtils.isNotEmptyString(params.get("roleId"))) {
                p.setRoleId(Long.valueOf(params.get("roleId") + ""));
            }
            if (!WfUtils.isNullObject(params.get("orgUnitId"))) {
                p.setOrgUnitId(Long.valueOf(params.get("orgUnitId") + ""));
            }
            if ("position".equals(params.get("reportType")) && WfUtils.isNotNullObject(params.get("reportTo"))) {
                p.setReportTo((String)params.get("reportTo"));
            }
            pmes.add(p);
            ParticipantCalculator participantCalculator = Context.getProcessEngineConfiguration().getParticipantCalculator();
            List<Long> userIds = participantCalculator.getUserIds(context.getBusinessKey(), ((TaskEntity)Context.getCommandContext().getTaskEntityManager().findById(context.getTaskId())).getExecution(), pmes);
            if (!userIds.isEmpty()) {
                StringBuilder transferIds = new StringBuilder();
                for (Long userId : userIds) {
                    transferIds.append(String.valueOf(userId)).append(',');
                }
                String suggestion = WfUtils.isEmptyString(params.get(OPINION)) ? "" : params.get(OPINION).toString();
                Long taskId = context.getTaskId();
                String taskIds = String.format("%s,", String.valueOf(taskId));
                new AdminTransferTaskCmd(taskIds, transferIds.toString(), (ILocaleString)new LocaleString(suggestion), Boolean.FALSE, Boolean.TRUE).execute(Context.getCommandContext());
            } else {
                throw new KDException(WFErrorCode.participantParseError(), new Object[]{ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"ExpireTransferOperation_1", (String)"bos-wf-engine", (Object[])new Object[0])});
            }
        }
    }

    @Override
    public Map<String, Object> getOperationMeta() {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put(VALUE, "transferExpire");
        meta.put("name", WfConfigurationUtil.getTransferName());
        meta.put("formId", "wf_transferoperation");
        return meta;
    }
}

