/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.timing;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ProcessInstanceHelper;
import kd.bos.workflow.engine.timing.IProcessStarter;
import kd.bos.workflow.engine.timing.StartProcessBillInfo;
import kd.bos.workflow.engine.timing.TimingStartProcessParam;
import kd.bos.workflow.exception.WFEngineException;

public abstract class AbstractProcessStarter
implements IProcessStarter {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public void startProcess(CommandContext commandContext, TimingStartProcessParam param) {
        ProcessDefinitionEntity processDefinition = param.getProcessDefinition();
        Long processDefinitionId = processDefinition.getId();
        Process process = ProcessDefinitionUtil.getProcessByProcDefId(processDefinitionId);
        String startActivityId = param.getStartActivityId();
        this.log.debug(String.format("timer Start Process: %s, %s", processDefinitionId, startActivityId));
        if (startActivityId != null) {
            FlowElement flowElement = process.getFlowElement(startActivityId, true);
            if (flowElement == null) {
                throw new WFEngineException("Could not find matching FlowElement for activityId " + startActivityId);
            }
            List<StartProcessBillInfo> billInfos = this.getStartProcessBillInfos(processDefinition, flowElement);
            if (billInfos == null || billInfos.isEmpty()) {
                this.log.debug("The StartProcessBillInfos is null or empty.");
                return;
            }
            this.log.debug(String.format("StartProcessBillInfos: %s", SerializationUtils.toJsonString(billInfos)));
            List<DynamicConfigSchemeEntity> processSchemes = commandContext.getDynamicConfigSchemeEntityManager().getSchemesByProcDefId(processDefinitionId, false);
            Long schemeId = processSchemes.get(0).getId();
            ProcessInstanceHelper processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
            for (StartProcessBillInfo billInfo : billInfos) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                String businessKey = billInfo.getBusinessKey();
                variables.put("entityNumber", billInfo.getEntityNumber());
                variables.put("SCHEMEID", schemeId);
                variables.put("_initiator_", billInfo.getInitiator());
                processInstanceHelper.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, null, flowElement, process, variables, null, true);
            }
        } else {
            this.log.debug("startActivityId is null, Not currently supported.");
        }
    }

    protected abstract List<StartProcessBillInfo> getStartProcessBillInfos(ProcessDefinitionEntity var1, FlowElement var2);
}

