/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.timing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.timing.AbstractProcessStarter;
import kd.bos.workflow.engine.timing.StartProcessBillInfo;
import kd.bos.workflow.engine.timing.TimingStartProcessParam;

public class NoCodeProcessStarter
extends AbstractProcessStarter {
    private static final String KEY_NUMBER = "number";
    private static final String KEY_VALUE = "value";
    private static final String KEY_ENTITYNUMBER = "entityNumber";
    private static final String KEY_BUSINESSKEY = "businessKey";
    private static final String KEY_INITIATOR = "initiator";
    private static final String KEY_SEPARATESTORAGE = "separateStorageKey";

    @Override
    public void startProcess(CommandContext commandContext, TimingStartProcessParam param) {
        try {
            ThreadTruck.put((Object)KEY_SEPARATESTORAGE, (Object)"nocode");
            super.startProcess(commandContext, param);
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("timer-start-nocode-process"){

                @Override
                public void closed(CommandContext commandContext) {
                    ThreadTruck.remove((Object)NoCodeProcessStarter.KEY_SEPARATESTORAGE);
                }
            });
        }
        catch (Exception e) {
            ThreadTruck.remove((Object)KEY_SEPARATESTORAGE);
            throw e;
        }
    }

    @Override
    protected List<StartProcessBillInfo> getStartProcessBillInfos(ProcessDefinitionEntity processDefinition, FlowElement startElement) {
        ArrayList<StartProcessBillInfo> billInfos = null;
        String appId = this.getAutoServiceConfig(startElement, "appId");
        String cloudId = this.getAutoServiceConfig(startElement, "cloudId");
        String methodName = this.getAutoServiceConfig(startElement, "methodName");
        String serviceName = this.getAutoServiceConfig(startElement, "serviceName");
        String paramStr = startElement.getAttributeValue("extData.noCode_params");
        JSONArray inParams = JSON.parseArray((String)paramStr);
        HashMap<String, Object> param = new HashMap<String, Object>();
        for (Object parameter : inParams) {
            JSONObject inParam = (JSONObject)parameter;
            String number = inParam.getString(KEY_NUMBER);
            Object value = inParam.get((Object)KEY_VALUE);
            param.put(number, value);
        }
        this.log.debug(String.format("invoke-biz-service cloudId: %s, appId: %s, sreviceName: %s, methodName: %s, parameter: %s", cloudId, appId, serviceName, methodName, param));
        Object result = DispatchServiceHelper.invokeService((String)"kd.bos.nocode.servicehelper", (String)cloudId, (String)serviceName, (String)methodName, (Object[])new Object[]{param});
        if (result instanceof List) {
            List list = (List)result;
            int size = list.size();
            int max = 1000;
            billInfos = new ArrayList<StartProcessBillInfo>(Math.min(size, max));
            for (int i = 0; i < size; ++i) {
                if (i >= max) {
                    this.log.debug("The maximum processing value (1000) has been reached, and no further processing will be carried out.");
                    break;
                }
                Map map = (Map)list.get(i);
                StartProcessBillInfo billInfo = new StartProcessBillInfo();
                billInfo.setEntityNumber(String.valueOf(map.get(KEY_ENTITYNUMBER)));
                billInfo.setBusinessKey(String.valueOf(map.get(KEY_BUSINESSKEY)));
                billInfo.setInitiator(String.valueOf(map.get(KEY_INITIATOR)));
                billInfos.add(billInfo);
            }
        }
        return billInfos;
    }

    private String getAutoServiceConfig(FlowElement element, String key) {
        return element.getAttributeValue(String.format("extData.noCode_autoService.%s", key));
    }
}

