/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.timing;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.TimingModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.timing.ITimingProcessor;

public class TimingModelUtil {
    private static final Log log = LogFactory.getLog(TimingModelUtil.class);

    public static void execute(ITimingProcessor processor, CommandContext commandContext, ExecutionEntity execution, String elementId) {
        String type;
        TimingModel model = processor.getTimingModel(execution.getProcessDefinitionId(), execution.getProcessInstanceId(), elementId);
        if (model == null) {
            log.warn("TimingModel is null, execute failed!");
            return;
        }
        switch (type = model.getType()) {
            case "delay": 
            case "timing": {
                TimingModelUtil.executeByTime(processor, commandContext, execution, model);
                break;
            }
            case "event": {
                TimingModelUtil.executeByEvent(processor, commandContext, execution, model);
                break;
            }
        }
    }

    private static void executeByTime(ITimingProcessor processor, CommandContext commandContext, ExecutionEntity execution, TimingModel model) {
        if (model.getCondition() == null || "delay".equals(model.getType())) {
            log.debug("no condition, begin execute...");
            processor.execute(model, execution);
        } else {
            String key = ConditionUtil.getConInstKey(execution.getCurrentActivityId(), ConditionalRuleType.timingWait.name());
            boolean result = ConditionUtil.hasTrueCondition(model.getCondition(), (VariableScope)execution, key);
            if (result) {
                log.debug("condition is true, begin execute...");
                processor.execute(model, execution);
            } else {
                log.debug("continue waiting...");
                TimingModelUtil.asyncExecuteByTime(model, processor.getType(), commandContext, execution);
            }
        }
    }

    private static void executeByEvent(ITimingProcessor processor, CommandContext commandContext, ExecutionEntity execution, TimingModel model) {
        log.debug("execute by event...");
        processor.execute(model, execution);
    }

    public static void asyncExecuteByTime(TimingModel model, String timingType, CommandContext commandContext, ExecutionEntity execution) {
        QFilter[] filters = new QFilter[]{new QFilter("jobHandlerType", "=", (Object)"async-timing"), new QFilter("executionId", "=", (Object)execution.getId()), new QFilter("elementId", "=", (Object)execution.getCurrentActivityId())};
        List timerJobs = commandContext.getTimerJobEntityManager().findByQueryFilters(filters);
        if (timerJobs == null || timerJobs.isEmpty()) {
            Date dueDate = TimingModelUtil.getExpiredTime(model.getDuration(), model.getCalendarUnit());
            TimerJobEntity timerJob = commandContext.getJobManager().createTimingModelTimerJob(timingType, execution, dueDate);
            commandContext.getTimerJobEntityManager().insert(timerJob);
            log.debug(String.format("timejobid:%s", timerJob.getId()));
        } else {
            log.debug(String.format("exist timer job[%s]", timerJobs != null ? ((TimerJobEntity)timerJobs.get(0)).getId() : ""));
        }
    }

    public static Date getExpiredTime(String duration, int unit) {
        int result = 0;
        if (duration.matches("^\\d+$")) {
            result = Integer.parseInt(duration);
        } else {
            log.warn(String.format("the duration: %s is not a valid number!", duration));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(WfUtils.now());
        calendar.add(unit, result);
        return calendar.getTime();
    }

    public static Date getExpiredTime(TimingModel model) {
        return TimingModelUtil.getExpiredTime(model.getDuration(), model.getCalendarUnit());
    }
}

