/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.exception;

import java.util.Arrays;
import java.util.List;
import kd.bos.bec.engine.exception.EVTIgnoreRetryException;
import kd.bos.bec.engine.persistence.job.AbstractEvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BpmnError;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorCtx;
import kd.bos.workflow.engine.impl.bpm.calculator.billconvert.pojo.BillCalculatorResult;
import kd.bos.workflow.engine.impl.bpmn.helper.ErrorPropagation;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.ErrorHandlerStrategy;
import kd.bos.workflow.engine.impl.jobexecutor.IErrorHandlerStrategy;
import kd.bos.workflow.engine.impl.jobexecutor.RetryType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractWfJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableScopeImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.exception.BizErrorInfo;
import kd.bos.workflow.exception.WFAddSignNoElementException;
import kd.bos.workflow.exception.WFBillCalcException;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFBotpCalcExecption;
import kd.bos.workflow.exception.WFConditionParseException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.exception.WFNullParticipantException;
import kd.bos.workflow.exception.WFOutSetException;
import kd.bos.workflow.exception.WFRequestTimeoutException;
import kd.bos.workflow.exception.WFVoteParticipantException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ExceptionUtil {
    private static Log logger = LogFactory.getLog(ExceptionUtil.class);

    public static WFEngineException createContextException(Throwable exception, Job job) {
        if (exception instanceof WFNullParticipantException || exception instanceof WFVoteParticipantException || exception instanceof WFConditionParseException || exception instanceof WFBizException) {
            return (WFEngineException)((Object)exception);
        }
        WFEngineException engineException = null;
        engineException = exception instanceof WFEngineException ? (WFEngineException)((Object)exception) : new WFEngineException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ea7\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"ExceptionUtil_1", (String)"bos-wf-engine", (Object[])new Object[0]), exception.getMessage()), exception);
        ExceptionUtil.setExpContext(engineException, job, null);
        return engineException;
    }

    public static WFNullParticipantException createWFNullParticipantException(DelegateExecution execution) {
        FlowElement element = execution.getCurrentFlowElement();
        if (element != null && element.isAddSign()) {
            WFAddSignNoElementException exp = new WFAddSignNoElementException(null, WFErrorCode.participantParseError(), new Object[]{ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u52a0\u7b7e\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ExceptionUtil_23", (String)"bos-wf-engine", (Object[])new Object[0])});
            ExceptionUtil.setExpContext(exp, execution, null);
            return exp;
        }
        WFNullParticipantException exp = new WFNullParticipantException(null, WFErrorCode.participantIsNull(), new Object[]{String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e%s\u8282\u70b9\u7684\u53c2\u4e0e\u4eba\u3002", (String)"ExceptionUtil_20", (String)"bos-wf-engine", (Object[])new Object[0]), element == null ? "" : element.getName())});
        ExceptionUtil.setExpContext(exp, execution, null);
        return exp;
    }

    public static WFNullParticipantException createWFNullParticipantException(WFNullParticipantException exp, VariableScope execution) {
        ExceptionUtil.setExpContext(exp, execution, null);
        return exp;
    }

    public static WFVoteParticipantException createWFVoteParticipantException(DelegateExecution execution, int num) {
        FlowElement element = execution.getCurrentFlowElement();
        WFVoteParticipantException exp = new WFVoteParticipantException(null, WFErrorCode.voteParticipantError(), new Object[]{String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e%1$s\u8282\u70b9\u7684\u53c2\u4e0e\u4eba\uff0c\u76ee\u524d\u6709%2$s\u4e2a\u53c2\u4e0e\u4eba\u3002", (String)"ExceptionUtil_21", (String)"bos-wf-engine", (Object[])new Object[0]), element.getName(), num)});
        ExceptionUtil.setExpContext(exp, execution, null);
        return exp;
    }

    public static WFConditionParseException createWFConditionParseException(String expression, VariableScope variableScope, Throwable e) {
        WFConditionParseException exp = new WFConditionParseException(e, WFErrorCode.conditionParseError(), String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u201c%s\u201d\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6761\u4ef6\u89c4\u5219\u3002", (String)"ExceptionUtil_22", (String)"bos-wf-engine", (Object[])new Object[0]), expression), e.getMessage());
        ExceptionUtil.setExpContext(exp, variableScope, e);
        return exp;
    }

    public static WFBizException createBusinessException(String opNum, String entityNumber, Object[] params, Object context, Throwable e, ErrorCode errCode) {
        WFBizException bizExp = new WFBizException(e, errCode, e.getMessage());
        return ExceptionUtil.createBusinessException(opNum, entityNumber, params, context, (Throwable)((Object)bizExp));
    }

    public static WFBizException createBusinessException(String opNum, String entityNumber, Object[] params, Object context, Throwable e) {
        WFBizException bizExp = null;
        if (e instanceof WFBizException) {
            bizExp = (WFBizException)((Object)e);
        } else {
            KDBizException t = new KDBizException(e, new ErrorCode("bizOperationUnKnowError", "%s"), new Object[]{e.getMessage()});
            bizExp = new WFBizException(t, WFErrorCode.businessUnknowOperationError(), e.getMessage());
        }
        ExceptionUtil.setExpContext(bizExp, context, e);
        StringBuilder msg = new StringBuilder();
        if (params != null && params.length > 0) {
            msg.append(StringUtils.join((Object[])params, (char)','));
        }
        bizExp.setContextMsg(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u8c03\u7528\u5b9e\u4f53\u64cd\u4f5c\u65f6\u7684\u4fe1\u606f\u5982\u4e0b\uff1a\u5b9e\u4f53\u7f16\u7801\uff1a%2$s\uff0c\u64cd\u4f5c\u7f16\u7801\uff1a%3$s\uff0c\u53c2\u6570\uff1a%4$s\u3002", (String)"ExceptionUtil_8", (String)"bos-wf-engine", (Object[])new Object[0]), bizExp.getContextMsg(), entityNumber, opNum, msg));
        return bizExp;
    }

    public static WFBizException createBusinessException(Object context, Throwable e, String listener, ErrorCode errCode) {
        WFBizException bizExp = new WFBizException(e, errCode, e.getMessage());
        return ExceptionUtil.createBusinessException(context, (Throwable)((Object)bizExp), listener);
    }

    public static WFBizException createBusinessException(Object context, Throwable e, String listener) {
        WFBizException bizExp = null;
        if (e instanceof WFBizException) {
            bizExp = (WFBizException)((Object)e);
        } else {
            KDBizException t = new KDBizException(e, new ErrorCode("bizOperationUnKnowError", "%s"), new Object[]{e.getMessage()});
            bizExp = new WFBizException(t, WFErrorCode.businessUnknowOperationError(), e.getMessage());
        }
        ExceptionUtil.setExpContext(bizExp, context, e);
        StringBuilder msg = new StringBuilder();
        msg.append(bizExp.getContextMsg()).append(',');
        msg.append(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63d2\u4ef6[%s]", (String)"ExceptionUtil_12", (String)"bos-wf-engine", (Object[])new Object[0]), listener));
        bizExp.setContextMsg(msg.toString());
        return bizExp;
    }

    public static WFMessageServiceException createWFMessageServiceException(Object context, Throwable cause, ErrorCode errorCode, Object ... args) {
        WFMessageServiceException exception = args == null || args.length == 0 ? new WFMessageServiceException(cause, errorCode, null != cause ? cause.getMessage() : "") : new WFMessageServiceException(cause, errorCode, args);
        ExceptionUtil.setExpContext(exception, context, null);
        exception.setContextMsg(WFMultiLangConstants.getNoSolutionTip());
        return exception;
    }

    public static WFMessageServiceException createWFMessageServiceException(Object context, KDException kdException) {
        WFMessageServiceException exception = new WFMessageServiceException(kdException, kdException.getErrorCode(), kdException.getArgs());
        ExceptionUtil.setExpContext(exception, context, null);
        exception.setContextMsg(WFMultiLangConstants.getNoSolutionTip());
        return exception;
    }

    private static void setExpContext(WFEngineException exp, Object context, Throwable e1) {
        VariableScopeImpl execution;
        String actId = null;
        String businessKey = null;
        String entityNumber = null;
        Long processDefId = null;
        Long processInstanceId = null;
        Long taskId = null;
        ProcessDefinition def = null;
        FlowElement element = null;
        if (context instanceof ExecutionEntityImpl) {
            execution = (ExecutionEntityImpl)context;
            actId = ((ExecutionEntityImpl)execution).getActivityId();
            businessKey = ((ExecutionEntityImpl)execution).getBusinessKey();
            processDefId = ((ExecutionEntityImpl)execution).getProcessDefinitionId();
            processInstanceId = ((ExecutionEntityImpl)execution).getProcessInstanceId();
            def = ProcessDefinitionUtil.getProcessDefinition(((ExecutionEntityImpl)execution).getProcessDefinitionId());
            element = ProcessDefinitionUtil.getFlowElement(((ExecutionEntityImpl)execution).getProcessDefinitionId(), ((ExecutionEntityImpl)execution).getProcessInstanceId(), ((ExecutionEntityImpl)execution).getActivityId());
            taskId = ((ExecutionEntityImpl)execution).getCurrentTaskId();
        } else if (context instanceof PreComputatorExecutionEntityImpl) {
            execution = (PreComputatorExecutionEntityImpl)context;
            actId = ((PreComputatorExecutionEntityImpl)execution).getActivityId();
            businessKey = ((PreComputatorExecutionEntityImpl)execution).getBusinessKey();
            processDefId = ((PreComputatorExecutionEntityImpl)execution).getProcessDefinitionId();
            processInstanceId = ((PreComputatorExecutionEntityImpl)execution).getProcessInstanceId();
            def = ProcessDefinitionUtil.getProcessDefinition(((PreComputatorExecutionEntityImpl)execution).getProcessDefinitionId());
            element = ProcessDefinitionUtil.getFlowElement(((PreComputatorExecutionEntityImpl)execution).getProcessDefinitionId(), ((PreComputatorExecutionEntityImpl)execution).getProcessInstanceId(), ((PreComputatorExecutionEntityImpl)execution).getActivityId());
            taskId = ((PreComputatorExecutionEntityImpl)execution).getCurrentTaskId();
        } else if (context instanceof TaskEntityImpl) {
            TaskEntityImpl task = (TaskEntityImpl)context;
            actId = task.getTaskDefinitionKey();
            businessKey = task.getBusinessKey();
            processDefId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            def = ProcessDefinitionUtil.getProcessDefinition(task.getProcessDefinitionId());
            element = ProcessDefinitionUtil.getFlowElement(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getTaskDefinitionKey());
            taskId = task.getId();
        } else if (context instanceof HistoricTaskInstanceEntityImpl) {
            HistoricTaskInstanceEntityImpl hisTask = (HistoricTaskInstanceEntityImpl)context;
            actId = hisTask.getTaskDefinitionKey();
            businessKey = hisTask.getBusinessKey();
            processDefId = hisTask.getProcessDefinitionId();
            processInstanceId = hisTask.getProcessInstanceId();
            def = ProcessDefinitionUtil.getProcessDefinition(hisTask.getProcessDefinitionId());
            element = ProcessDefinitionUtil.getFlowElement(hisTask.getProcessDefinitionId(), hisTask.getProcessInstanceId(), hisTask.getTaskDefinitionKey());
            taskId = hisTask.getId();
        } else if (context instanceof BusinessModelVariableScope) {
            BusinessModelVariableScope bm = (BusinessModelVariableScope)context;
            businessKey = bm.getBusinessKey();
            entityNumber = bm.getEntityNumber();
        } else if (context instanceof JobEntity) {
            AbstractJobEntity job = (AbstractJobEntity)context;
            businessKey = job.getBusinessKey();
            entityNumber = job.getEntityNumber();
            processDefId = job.getProcessDefinitionId();
            processInstanceId = job.getProcessInstanceId();
            if (WfUtils.isNotEmpty(processDefId)) {
                def = ProcessDefinitionUtil.getProcessDefinition(job.getProcessDefinitionId());
            }
            if (WfUtils.isNotEmpty(actId = job.getElementId())) {
                element = ProcessDefinitionUtil.getFlowElement(job.getProcessDefinitionId(), job.getProcessInstanceId(), actId);
            }
        } else if (context instanceof MessageContext) {
            MessageContext mc = (MessageContext)context;
            actId = mc.getElementId();
            businessKey = mc.getBusinessKey();
            processDefId = mc.getProcessDefinitionId();
            processInstanceId = mc.getProcessInstanceId();
            def = ProcessDefinitionUtil.getProcessDefinition(mc.getProcessDefinitionId());
            element = ProcessDefinitionUtil.getFlowElement(mc.getProcessDefinitionId(), mc.getProcessInstanceId(), mc.getElementId());
            taskId = mc.getTaskId();
        }
        exp.setElementId(actId);
        exp.setBusinessKey(businessKey);
        exp.setProcessDefId(processDefId);
        exp.setProcessInstanceId(processInstanceId);
        StringBuilder msg = new StringBuilder();
        if (def != null) {
            msg.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u4fe1\u606f:[%1$s,%2$s,%3$s]", (String)"ExceptionUtil_13", (String)"bos-wf-engine", (Object[])new Object[0]), def.getKey(), def.getName(), def.getVersion()));
        }
        if (element != null) {
            msg.append(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f:[%s]", (String)"ExceptionUtil_14", (String)"bos-wf-engine", (Object[])new Object[0]), element.getName()));
        }
        if (businessKey != null) {
            msg.append(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e3b\u952e:[%1$s,\u5b9e\u4f53\u7f16\u7801:%2$s]", (String)"ExceptionUtil_15", (String)"bos-wf-engine", (Object[])new Object[0]), businessKey, entityNumber));
        }
        if (taskId != null) {
            msg.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1id:[%d]", (String)"ExceptionUtil_17", (String)"bos-wf-engine", (Object[])new Object[0]), taskId));
        }
        if (processInstanceId != null) {
            msg.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b:[%1$d],\u6d41\u7a0b\u5b9a\u4e49:[%2$d]", (String)"ExceptionUtil_18", (String)"bos-wf-engine", (Object[])new Object[0]), processInstanceId, processDefId));
        }
        exp.setContextMsg(msg.toString());
    }

    public static BizErrorInfo getErrorCodeAndMsg(Throwable exception) {
        BizErrorInfo errorInfo = ExceptionUtil.getBizErrorCodeAndMsg(exception);
        if (WfUtils.isEmpty(errorInfo.getErrCode()) && WfUtils.isEmpty(errorInfo.getErrMsg())) {
            return ExceptionUtil.buildErrorInfo(exception);
        }
        return errorInfo;
    }

    public static BizErrorInfo getBizErrorCodeAndMsg(Throwable exception) {
        BizErrorInfo errorInfo = new BizErrorInfo();
        if (!(exception instanceof KDException)) {
            return errorInfo;
        }
        Throwable actualException = exception.getCause();
        List<String> codeList = Arrays.asList("bec.invokeEventPlugin", "wf.invokeBizPlugin", "wf.invokeBillRelationMethod", "wf.invokeParseExpression", "bos.wf.biz.businessBizOperationError", "bizOperationUnKnowError", "businessBizOperationError");
        if (actualException instanceof KDBizException && ((KDBizException)actualException).getErrorCode() != null && codeList.contains(((KDBizException)actualException).getErrorCode().getCode())) {
            actualException = actualException.getCause();
            errorInfo = ExceptionUtil.buildErrorInfo(actualException);
            logger.debug(String.format("errorInfo from plugin:%s", errorInfo.toString()));
            return errorInfo;
        }
        if (actualException instanceof KDException) {
            errorInfo = ExceptionUtil.buildErrorInfo(actualException);
            logger.debug(String.format("errorInfo from KDException:%s", errorInfo.toString()));
        } else {
            errorInfo = ExceptionUtil.buildErrorInfo(actualException);
            logger.debug(String.format("errorInfo from otherException:%s", errorInfo.toString()));
        }
        return errorInfo;
    }

    private static BizErrorInfo buildErrorInfo(Throwable actualException) {
        BizErrorInfo errorInfo = new BizErrorInfo();
        if (actualException == null) {
            return errorInfo;
        }
        String code = null;
        String message = null;
        if (actualException instanceof KDException && ((KDException)actualException).getErrorCode() != null) {
            code = ((KDException)actualException).getErrorCode().getCode();
        }
        message = actualException.getMessage();
        if (WfUtils.isNotEmpty(code)) {
            errorInfo.setErrCode(code);
        }
        if (WfUtils.isNotEmpty(message)) {
            errorInfo.setErrMsg(message);
        }
        return errorInfo;
    }

    public static AbstractJobEntity handleJobStrategy(CommandContext commandContext, JobEntity job, Throwable exception) {
        Object val;
        AbstractWfJobEntity newJobEntity = null;
        boolean alwaysRetry = ExceptionUtil.isAlwaysRetryError(job, exception);
        newJobEntity = !alwaysRetry && (job.getRetries() <= 1 || !ExceptionUtil.retry(exception)) ? commandContext.getJobManager().moveJobToDeadLetterJob(job, exception) : ((val = WfConfigurationUtil.getConfigCenterVal("denyRetry")) != null && "true".equalsIgnoreCase(val.toString()) ? commandContext.getJobManager().moveJobToDeadLetterJob(job, exception) : commandContext.getJobManager().moveJobToTimerJob(job));
        return newJobEntity;
    }

    private static boolean isAlwaysRetryError(JobEntity job, Throwable exception) {
        BizErrorInfo errorInfo = ExceptionUtil.getBizErrorCodeAndMsg(exception);
        if (WfUtils.isEmpty(errorInfo.getErrCode())) {
            return false;
        }
        String alwaysErrorCode = WfConfigurationUtil.getAlwaysRetryErrorCode();
        if (WfUtils.isEmpty(alwaysErrorCode)) {
            return false;
        }
        int count = WfConfigurationUtil.getAlwaysRetryCount();
        if (count <= 0) {
            count = 500;
        }
        if (Math.abs(job.getRetries()) > count) {
            logger.info(String.format("retryCount reach the max threshold.%s", Math.abs(job.getRetries())));
            return false;
        }
        return WfUtils.stringToStringCollection(alwaysErrorCode, ",").stream().anyMatch(errorInfo.getErrCode()::equalsIgnoreCase);
    }

    public static AbstractJobEntity handleEventJobStrategy(CommandContext commandContext, EvtJobEntity job, Throwable exception, String errorStrategy) {
        if ("donothing".equals(errorStrategy)) {
            return null;
        }
        if (exception instanceof EVTIgnoreRetryException) {
            if (((EVTIgnoreRetryException)((Object)exception)).isIfDothing()) {
                return null;
            }
            return commandContext.getEvtJobManager().moveEvtJobToDeadLetterJob(job, exception);
        }
        if (exception instanceof WFRequestTimeoutException) {
            return commandContext.getEvtJobManager().moveEvtJobToDeadLetterJob(job, exception);
        }
        AbstractEvtJobEntity newJobEntity = null;
        newJobEntity = "retry".equals(errorStrategy) ? (job.getRetries() <= 1 ? commandContext.getEvtJobManager().moveEvtJobToDeadLetterJob(job, exception) : commandContext.getEvtJobManager().moveEvtJobToTimerJob(job)) : commandContext.getEvtJobManager().moveEvtJobToDeadLetterJob(job, exception);
        return newJobEntity;
    }

    private static boolean retry(Throwable exception) {
        if (WfUtils.isTesting()) {
            return false;
        }
        if (exception instanceof WFEngineException) {
            return ((WFEngineException)((Object)exception)).needsRetry();
        }
        return true;
    }

    public static WFOutSetException createWFOutSetException(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, DelegateExecution execution) {
        StringBuilder flows = new StringBuilder();
        for (SequenceFlow s : outgoingSequenceFlows) {
            if (WfUtils.isNotEmpty(s.getName())) {
                flows.append(s.getName()).append(',');
                continue;
            }
            flows.append(s.getId()).append(',');
        }
        WFOutSetException exp = new WFOutSetException(WFErrorCode.outSetError(), new String[]{flowNode.getName(), flows.toString()});
        ExceptionUtil.setExpContext(exp, execution, null);
        return exp;
    }

    public static Throwable getRealBizException(Throwable t) {
        while (t instanceof WFEngineException) {
            t = t.getCause();
        }
        return t;
    }

    public static boolean matchBoundryException(KDBizException e, ExecutionEntity execution) {
        boolean matchError = false;
        String errorCode = "WF_INNER_CODE";
        String message = "";
        if (e != null && e.getErrorCode() != null && WfUtils.isNotEmpty(e.getErrorCode().getCode())) {
            errorCode = e.getErrorCode().getCode();
            message = e.getMessage();
        }
        if (matchError = ErrorPropagation.propagateError(new BpmnError(errorCode, message), execution, e)) {
            logger.debug(String.format("\u6ee1\u8db3\u8fb9\u754c\u5f02\u5e38\u6761\u4ef6\uff0c\u5f02\u5e38\u7f16\u7801[%1$s],\u5f02\u5e38\u4fe1\u606f[%2$s]", errorCode, WfUtils.getExceptionStacktrace(e)));
        }
        return matchError;
    }

    public static ErrorHandlerStrategy getErrorHandleStrategy(ExecuteJob job, Throwable e) {
        if (job instanceof JobEntity) {
            JobEntity jobEntity = (JobEntity)job;
            Long procInstId = jobEntity.getProcessInstanceId();
            RepositoryService repositoryService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
            HistoricProcessInstanceEntity historicProcess = (HistoricProcessInstanceEntity)repositoryService.findEntityById(procInstId, "wf_hiprocinst", "processtype");
            if (historicProcess != null && ModelType.NoCodeFlow.name().equals(historicProcess.getProcessType()) && RuntimeUtil.needHandleException(job.getJobHandlerType())) {
                ErrorHandlerStrategy strategy = new ErrorHandlerStrategy();
                strategy.setRetryType(RetryType.TERMINATE.getCode());
                return strategy;
            }
        }
        Throwable t1 = ExceptionUtil.getRealBizException(e);
        String errCode = null;
        if (t1 instanceof KDException && ((KDException)t1).getErrorCode() != null) {
            errCode = ((KDException)t1).getErrorCode().getCode();
            String errors = WfConfigurationUtil.getErrorCodeStrategy();
            if (WfUtils.isNotEmpty(errCode) && WfUtils.isNotEmpty(errors)) {
                try {
                    List es = SerializationUtils.fromJsonStringToList((String)errors, ErrorHandlerStrategy.class);
                    if (es != null && !es.isEmpty()) {
                        for (ErrorHandlerStrategy strategy : es) {
                            if (!errCode.equalsIgnoreCase(strategy.getErrorCode())) continue;
                            return strategy;
                        }
                    }
                }
                catch (Exception e1) {
                    logger.error(String.format("error format for confcenterval ERRORCodeStrategy [%s],msg[%s]", errors, WfUtils.getExceptionStacktrace(e1)));
                }
            }
        }
        if (e instanceof IErrorHandlerStrategy) {
            return ((IErrorHandlerStrategy)((Object)e)).getErrorHandlerStrategy();
        }
        return new ErrorHandlerStrategy(errCode, RetryType.RETRY.getCode(), -1, -1);
    }

    public static WFBotpCalcExecption createBotpCalcExeption(Exception e, ExecutionEntity execution, BillCalculatorCtx context) {
        FlowElement element = execution.getCurrentFlowElement();
        WFBotpCalcExecption exp = new WFBotpCalcExecption(WFErrorCode.botpCalcExcpetion(), new Object[]{context.getType(), context.getSrcEntityNumber(), WfUtils.listToString(context.getSrcPkIds(), ","), context.getTagEntityNumber(), element == null ? "" : element.getNumber(), context.getTargetFlowElement() == null ? "" : context.getTargetFlowElement().getNumber(), WfUtils.getExceptionStacktrace(e)});
        ExceptionUtil.setExpContext(exp, execution, null);
        return exp;
    }

    public static RuntimeException createBillCalcExeption(Exception e, ExecutionEntity execution, BillCalculatorResult result, FlowElement elem) {
        FlowElement element = execution.getCurrentFlowElement();
        WFBillCalcException exp = new WFBillCalcException(WFErrorCode.billCalcExcpetion(), new Object[]{result.getConversionType(), execution.getEntityNumber(), execution.getBusinessKey(), elem instanceof IEntitySupport ? ((IEntitySupport)((Object)elem)).getEntityNumber() : null, element == null ? "" : element.getNumber(), elem == null ? null : elem.getNumber(), WfUtils.getExceptionStacktrace(e)});
        ExceptionUtil.setExpContext(exp, execution, null);
        return exp;
    }
}

