/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.exception;

import java.util.HashSet;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.BizErrorInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.Solution;
import kd.bos.workflow.exception.WFEngineException;

public class WFBizException
extends WFEngineException {
    private static final long serialVersionUID = 3031460542939107839L;

    public WFBizException(Throwable cause, ErrorCode errorCode, Object ... args) {
        super(cause, errorCode, args);
        this.type = "business";
        this.solution = Solution.BIZ.getDesc();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean needsRetry() {
        BizErrorInfo info = ExceptionUtil.getBizErrorCodeAndMsg((Throwable)((Object)this));
        if (WfUtils.isEmpty(info.getErrCode()) && WfUtils.isEmpty(info.getErrMsg())) {
            return false;
        }
        String errMsg = info.getErrMsg();
        String errCode = info.getErrCode();
        if (WfUtils.isNotEmpty(errCode)) {
            if (this.getWhileListCodes().stream().anyMatch(errCode::contains)) {
                return true;
            }
        }
        boolean bl = false;
        boolean match = bl;
        if (match) return match;
        if (!WfUtils.isNotEmpty(errMsg)) return false;
        if (!this.getWhileListErrorMsg().stream().anyMatch(errMsg::contains)) return false;
        return true;
    }

    private Set<String> getWhileListErrorMsg() {
        HashSet<String> set = new HashSet<String>();
        String codes = WfConfigurationUtil.getRetryErrorMsgs();
        if (WfUtils.isNotEmpty(codes)) {
            set.addAll(WfUtils.stringToStringCollection(codes, "#"));
        }
        return set;
    }

    private Set<String> getWhileListCodes() {
        HashSet<String> set = new HashSet<String>();
        set.add("datamutex");
        set.add("writeback_datamutex");
        String codes = WfConfigurationUtil.getRetryErrorCodes();
        if (WfUtils.isNotEmpty(codes)) {
            set.addAll(WfUtils.stringToStringCollection(codes, ","));
        }
        return set;
    }
}

