/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.exception;

import kd.bos.exception.ErrorCode;
import kd.bos.workflow.exception.Solution;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class WFEngineException
extends WFException {
    private static final long serialVersionUID = 1L;
    public static final String EXCEPTION_TYPE_SYSTEM = "system";
    public static final String EXCEPTION_TYPE_BUSINESS = "business";
    public static final String EXCEPTION_TYPE_SUBPROCESS = "subProcess";
    public static final String EXCEPTION_TYPE_ENGINE = "engine";
    public static final String EXCEPTION_TYPE_RPA = "rpa";
    public static final String EXCEPTION_TYPE_OUTSET = "outSet";
    public static final String EXCEPTION_TYPE_MODELDEF = "modelDefine";
    public static final String EXCEPTION_TYPE_NULLPARTICI = "nullParticipant";
    public static final String EXCEPTION_TYPE_CONDITIONPARSE = "conditionParse";
    public static final String EXCEPTION_TYPE_NOTFINDSUBPROCESS = "notFindSubprocess";
    public static final String EXCEPTION_TYPE_MESSAGESERVICE = "messageService";
    public static final String EXCEPTION_TYPE_HTTPREQUEST = "httpRequest";
    public static final String EXCEPTION_TYPE_CONFIGURATION = "configuration";
    public static final String EXCEPTION_TYPE_CIRCULATEPARSER = "circulateParse";
    public static final String EXCEPTION_TYPE_JOINTAUDITRESULT = "jointAuditResult";
    public static final String EXCEPTION_TYPE_BILLCALC = "billCalc";
    public static final String EXCEPTION_TYPE_MOUNT = "mountBiz";
    public static final String EXCEPTION_TYPE_CYCLENUMBERSEXCEED = "cycleNumbersExceed";
    public static final String EXCEPTION_TYPE_TARGETBILLFILTER = "targetBillFilter";
    public static final String EXCEPTION_TYPE_ADDSIGN = "addSignNoEelement";
    protected String type = "engine";
    protected String solution;
    protected Long processDefId;
    protected Long processInstanceId;
    protected String businessKey;
    protected String elementId;
    private String contextMsg;

    public WFEngineException(Throwable cause, ErrorCode errorCode, Object ... args) {
        super(cause, errorCode, args);
        this.solution = WFErrorCode.configurationError().equals((Object)errorCode) ? Solution.CONFIG_CENTER.getDesc() : (WFErrorCode.jobUnKnowError().equals((Object)errorCode) ? Solution.JOB_UNKNOWN.getDesc() : Solution.MODIFY_PROCESS.getDesc());
    }

    public WFEngineException(ErrorCode errorCode, Object[] args) {
        super((Throwable)null, errorCode, args);
    }

    public WFEngineException(String message, Throwable cause) {
        super(cause, WFErrorCode.engineError(), message);
    }

    public WFEngineException(String message) {
        super(new Exception(), WFErrorCode.engineError(), message);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSolution() {
        if (this.contextMsg != null) {
            return String.format(Solution.DEFAULT.getDesc(), this.solution, this.contextMsg);
        }
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public Long getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(Long processDefId) {
        this.processDefId = processDefId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setElementId(String actId) {
        this.elementId = actId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setContextMsg(String msg) {
        this.contextMsg = msg;
    }

    public String getContextMsg() {
        return this.contextMsg;
    }

    public boolean needsRetry() {
        return !WFErrorCode.licenseVerifyException().equals((Object)this.errorCode) && !WFErrorCode.licenseExceedLimitException().equals((Object)this.errorCode) && (this.errorCode == null || !WFErrorCode.noOutgoingSequenceError().getCode().equalsIgnoreCase(this.errorCode.getCode()));
    }

    public boolean needsSuspendProinstance() {
        return true;
    }

    public boolean needsSendAlarmMsg() {
        return true;
    }
}

