/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.exception;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.lang.Lang;
import kd.bos.workflow.engine.WFLicenseUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.service.WfTraceType;

public class WFErrorCode {
    public static final String DEFAULTINNERCODE = "WF_INNER_CODE";

    private WFErrorCode() {
    }

    public static ErrorCode engineStartErrored() {
        return WFErrorCode.createEngineStateErrorCode("engineStartErrored", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5f15\u64ce\u542f\u52a8\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u201c%s\u201d\u3002\u5982\u679c\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WFErrorCode_1", (String)"bos-wf-engine"));
    }

    public static ErrorCode engineStopErrord() {
        return WFErrorCode.createEngineStateErrorCode("engineStopErrord", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5f15\u64ce\u505c\u6b62\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u201c%s\u201d\u3002\u5982\u679c\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WFErrorCode_2", (String)"bos-wf-engine"));
    }

    public static ErrorCode workflowEngineNotInService() {
        return WFErrorCode.createEngineStateErrorCode("workflowEngineNotInService", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u79df\u6237\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u6d41\u7a0b\u5f15\u64ce\u201c%2$s\u201d\u7684\u670d\u52a1\u8303\u56f4\u3002", (String)"WFErrorCode_3", (String)"bos-wf-engine"));
    }

    public static ErrorCode scheduleNotInService() {
        return WFErrorCode.createEngineStateErrorCode("scheduleNotInService", (ILocaleString)ResManager.getLocaleString((String)"\u4f9d\u8d56\u7684\u540e\u53f0\u4e8b\u52a1\u672a\u542f\u52a8\u6216\u8005\u542f\u52a8\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_4", (String)"bos-wf-engine"));
    }

    public static ErrorCode workflowEngineNotConfiguration() {
        return WFErrorCode.createEngineStateErrorCode("workflowEngineNotConfiguration", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u672a\u914d\u7f6e\u6d41\u7a0b\u5f15\u64ce\u3002", (String)"WFErrorCode_5", (String)"bos-wf-engine"));
    }

    public static ErrorCode workflowEngineUnStarted() {
        return WFErrorCode.createEngineStateErrorCode("workflowEngineUnStarted", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u672a\u914d\u7f6e\u6d41\u7a0b\u5f15\u64ce\u6216\u6d41\u7a0b\u5f15\u64ce\u542f\u52a8\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"WFErrorCode_6", (String)"bos-wf-engine"));
    }

    public static ErrorCode startRPAProcessError() {
        return WFErrorCode.createRPAErrorCode("startRPAProcessError", (ILocaleString)ResManager.getLocaleString((String)"\u542f\u52a8RPA\u6d41\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%1$s", (String)"WFErrorCode_156", (String)"bos-wf-engine"));
    }

    public static ErrorCode ormQuerySetErrord() {
        return WFErrorCode.create("ormQuerySetErrord", (ILocaleString)ResManager.getLocaleString((String)"ORM Query SET\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_7", (String)"bos-wf-engine"));
    }

    public static ErrorCode dbQueryErrord() {
        return WFErrorCode.create("dbQueryErrord", "DB Query Error occurs on %s, msg is %s");
    }

    public static ErrorCode licenseVerifyException() {
        return WFErrorCode.create("licenseVerifyException", WFLicenseUtil.getVersionTooLowNotice());
    }

    public static ErrorCode participantParserNotFoundError() {
        return WFErrorCode.createParticipantErrorCode("participantParserNotFoundError", (ILocaleString)ResManager.getLocaleString((String)"\u53c2\u4e0e\u4eba\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53c2\u4e0e\u4eba\u89e3\u6790\u7c7b\u672a\u627e\u5230\u3002", (String)"WFErrorCode_9", (String)"bos-wf-engine"));
    }

    public static ErrorCode saveParticipantModelError() {
        return WFErrorCode.createParticipantErrorCode("saveParticipantModelError", (ILocaleString)ResManager.getLocaleString((String)"\u53c2\u4e0e\u4eba\u6a21\u578b\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_10", (String)"bos-wf-engine"));
    }

    public static ErrorCode pluginParticipantParserError() {
        return WFErrorCode.createParticipantErrorCode("pluginParticipantParserError", (ILocaleString)ResManager.getLocaleString((String)"\u63d2\u4ef6\u7c7b\u53c2\u4e0e\u4eba\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_11", (String)"bos-wf-engine"));
    }

    public static ErrorCode participantIsNull() {
        return WFErrorCode.createParticipantErrorCode("participantNull", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba\u4e3a\u7a7a\u3002", (String)"WFErrorCode_12", (String)"bos-wf-engine"));
    }

    public static ErrorCode findNotSubProcess() {
        return WFErrorCode.create("findNotSubProcess", (ILocaleString)ResManager.getLocaleString((String)"\u542f\u52a8\u5b50\u6d41\u7a0b\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u5b50\u6d41\u7a0b\u3002", (String)"WFErrorCode_119", (String)"bos-wf-engine"));
    }

    public static ErrorCode compensateError() {
        return WFErrorCode.create("compensateerror ", "%s");
    }

    public static ErrorCode subprocessDisabled() {
        return WFErrorCode.create("subprocessDisabled", (ILocaleString)ResManager.getLocaleString((String)"\u542f\u52a8\u5b50\u6d41\u7a0b\u5931\u8d25\uff0c\u5b50\u6d41\u7a0b\u672a\u542f\u7528\u3002", (String)"WFErrorCode_120", (String)"bos-wf-engine"));
    }

    public static ErrorCode participantParseError() {
        return WFErrorCode.createParticipantErrorCode("participantParseError", (ILocaleString)ResManager.getLocaleString((String)"\u53c2\u4e0e\u4eba\u89e3\u6790\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_13", (String)"bos-wf-engine"));
    }

    public static ErrorCode participantEnabled() {
        return WFErrorCode.createParticipantErrorCode("participantEnabledError", (ILocaleString)ResManager.getLocaleString((String)"\u53c2\u4e0e\u4eba\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"WFErrorCode_14", (String)"bos-wf-engine"));
    }

    public static ErrorCode participantExistForTransferError() {
        LocaleString wfErrorCode_15 = ResManager.getLocaleString((String)"\u8be5\u4eba\u5458\u5df2\u7ecf\u4e3a\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u53ef\u4ee5\u201c%s\u201d\u7ed9\u6b64\u4eba\u3002", (String)"WFErrorCode_15", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_15);
        return WFErrorCode.createTaskErrorCode("participantExistForTransferError", String.format(adminLangError, WfConfigurationUtil.getTransferName()));
    }

    public static ErrorCode participantExistForWorksTransferError() {
        return WFErrorCode.createTaskErrorCode("participantExistForWorksTransferError", (ILocaleString)ResManager.getLocaleString((String)"\u8be5\u4eba\u5458\u5df2\u7ecf\u4e3a\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\u6216\u534f\u529e\u4eba\uff0c\u4e0d\u53ef\u4ee5\u79fb\u4ea4\u7ed9\u6b64\u4eba\u3002", (String)"WFErrorCode_139", (String)"bos-wf-engine"));
    }

    public static ErrorCode coordinateRequestNotContainsParticipantError() {
        return WFErrorCode.createTaskErrorCode("participantExistForWorksTransferError", (ILocaleString)ResManager.getLocaleString((String)"\u65e0\u6cd5\u53d1\u8d77\u534f\u529e\uff0c\u60a8\u4e0d\u662f\u5f53\u524d\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\u3002", (String)"WFErrorCode_141", (String)"bos-wf-engine"));
    }

    public static ErrorCode participantExistForCoordinateError() {
        LocaleString wfErrorCode_16 = ResManager.getLocaleString((String)"\u9009\u62e9\u7684\u4eba\u5458\u5df2\u7ecf\u4e3a\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u53ef\u4ee5\u201c%s\u201d\u3002", (String)"WFErrorCode_16", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_16);
        return WFErrorCode.createTaskErrorCode("participantExistForCoordinateError", String.format(adminLangError, WfConfigurationUtil.getCoordinateName()));
    }

    public static ErrorCode canNotWithdraw() {
        return WFErrorCode.create("canNotWithdraw", (ILocaleString)ResManager.getLocaleString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_17", (String)"bos-wf-engine"));
    }

    public static ErrorCode concurrentUpdateError() {
        return WFErrorCode.create("concurrentUpdateError", (ILocaleString)ResManager.getLocaleString((String)"\u5e76\u53d1\u66f4\u65b0\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_144", (String)"bos-wf-engine"));
    }

    public static ErrorCode withoutDefaultDecisionError() {
        return WFErrorCode.createTaskErrorCode("withoutDefaultDecisionError", (ILocaleString)ResManager.getLocaleString((String)"\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u51b3\u7b56\u9879\uff1a\u201c%s\u201d\u3002", (String)"WFErrorCode_18", (String)"bos-wf-engine"));
    }

    public static ErrorCode businessUnknowOperationError() {
        return WFErrorCode.createBizErrorCode("businessUnknowOperationError", (ILocaleString)ResManager.getLocaleString((String)"\u6267\u884c\u4e1a\u52a1\u63d2\u4ef6\u903b\u8f91\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u539f\u56e0\uff1a %s", (String)"WFErrorCode_106", (String)"bos-wf-engine"));
    }

    public static ErrorCode businessBizOperationError() {
        return WFErrorCode.createBizErrorCode("businessBizOperationError", "%s");
    }

    public static ErrorCode businessBizOperationValidateError() {
        return new ErrorCode("bizOperationValidateError", "%s");
    }

    public static ErrorCode businessBizOperationValidateError(String errorCode) {
        if (WfUtils.isEmpty(errorCode)) {
            errorCode = "bizOperationValidateError";
        }
        return new ErrorCode(errorCode, "%s");
    }

    public static ErrorCode billCalculateError() {
        return WFErrorCode.create("billCalculateError", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u8ba1\u7b97\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_130", (String)"bos-wf-engine"));
    }

    public static ErrorCode saveBillPageAttributeConfigError() {
        return WFErrorCode.create("saveBillPageAttributeConfigError", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u754c\u9762\u5c5e\u6027\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_20", (String)"bos-wf-engine"));
    }

    public static ErrorCode invalidateResourceContentError() {
        return WFErrorCode.create("invalidateResourceContentError", (ILocaleString)ResManager.getLocaleString((String)"\u53d1\u5e03\u65f6\u8d44\u6e90\u8f6c\u5316\u4e3aUTF-8\u65f6\u51fa\u9519\uff0c\u539f\u56e0:%s", (String)"WFErrorCode_21", (String)"bos-wf-engine"));
    }

    public static ErrorCode billExceptionError() {
        return WFErrorCode.create("billExceptionError", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u4f8b\u5916\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_142", (String)"bos-wf-engine"));
    }

    public static ErrorCode getNextNodeErrorProcessDesigenEr() {
        return WFErrorCode.create("getNextNodeErrorProcessDesigenEr", (ILocaleString)ResManager.getLocaleString((String)"\u8ba1\u7b97\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba\u5f02\u5e38\uff0c\u6d41\u7a0b\u8bbe\u8ba1\u95ee\u9898\uff0c\u8282\u70b9\u6ca1\u6709\u62c6\u5206\uff0c\u4f46\u662f\u7b97\u51fa\u6709\u591a\u6761\u7ebf\u80fd\u591f\u6d41\u51fa\uff0c\u8282\u70b9ID\uff1a%s\u3002", (String)"WFErrorCode_22", (String)"bos-wf-engine"));
    }

    public static ErrorCode modelSaveError() {
        return WFErrorCode.create("modelSaveError", (ILocaleString)ResManager.getLocaleString((String)"\u6a21\u578b\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_23", (String)"bos-wf-engine"));
    }

    public static ErrorCode modelConvertError() {
        return WFErrorCode.create("modelConvertError", (ILocaleString)ResManager.getLocaleString((String)"\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_24", (String)"bos-wf-engine"));
    }

    public static ErrorCode jsonConvertError() {
        return WFErrorCode.create("jsonConvertError", (ILocaleString)ResManager.getLocaleString((String)"JSON\u8f6c\u6362\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_25", (String)"bos-wf-engine"));
    }

    public static ErrorCode startEventInitError() {
        return WFErrorCode.create("startEventInitError", (ILocaleString)ResManager.getLocaleString((String)"\u5f00\u59cb\u8282\u70b9\u521d\u59cb\u5316\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_26", (String)"bos-wf-engine"));
    }

    public static ErrorCode publishSubProcessError() {
        return WFErrorCode.create("publishSubProcessError", (ILocaleString)ResManager.getLocaleString((String)"\u5b50\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_27", (String)"bos-wf-engine"));
    }

    public static ErrorCode procInstIdOrBillIdIsNullError() {
        return WFErrorCode.create("procInstIdOrBillIdIsNullError", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u6216\u4e1a\u52a1\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_28", (String)"bos-wf-engine"));
    }

    public static ErrorCode idIsNull() {
        return WFErrorCode.create("idIsNull", (ILocaleString)ResManager.getLocaleString((String)"SQL\u8fc7\u6ee4\u6761\u4ef6\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_29", (String)"bos-wf-engine"));
    }

    public static final ErrorCode transferToEntityError() {
        return WFErrorCode.create("transferToEntityError", (ILocaleString)ResManager.getLocaleString((String)"\u8f6c\u6362\u5b9e\u4f53\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_30", (String)"bos-wf-engine"));
    }

    public static ErrorCode findBussinessObjectError() {
        return WFErrorCode.create("findBussinessObjectError", (ILocaleString)ResManager.getLocaleString((String)"\u67e5\u8be2\u4e1a\u52a1\u5bf9\u8c61\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_31", (String)"bos-wf-engine"));
    }

    public static ErrorCode circulateParserError() {
        LocaleString wfErrorCode_104 = ResManager.getLocaleString((String)"\u81ea\u52a8%1$s\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"WFErrorCode_104", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_104);
        return WFErrorCode.create("circulateParserError", adminLangError);
    }

    public static ErrorCode processInContinuingFlow() {
        return WFErrorCode.createAddressingProcessErrorCode("processInContinuingFlow", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u201c%s\u201d\u5bf9\u5e94\u7684\u6d41\u7a0b\u6b63\u5728\u6d41\u8f6c\u4e2d\uff0c\u6216\u8005\u5df2\u7ecf\u53d1\u751f\u5f02\u5e38\u3002", (String)"WFErrorCode_32", (String)"bos-wf-engine"));
    }

    public static ErrorCode wrongParameterOnAddressProcess() {
        return WFErrorCode.createAddressingProcessErrorCode("wrongParameterOnAddressProcess", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5bfb\u5740\u65f6\u8f93\u5165\u53c2\u6570\u5b58\u5728\u7a7a\u503c\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_33", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskHasBeenHandled() {
        return WFErrorCode.createAddressingProcessErrorCode("taskHasBeenHandled", (ILocaleString)ResManager.getLocaleString((String)"\u4efb\u52a1\u201c%s\u201d\u53ef\u80fd\u5df2\u5904\u7406\u5b8c\u6210\u3002", (String)"WFErrorCode_34", (String)"bos-wf-engine"));
    }

    public static ErrorCode getMainProcessFromBpmnModel() {
        return WFErrorCode.create("getMainProcessFromBpmnModel", (ILocaleString)ResManager.getLocaleString((String)"\u4eceBpmnModel\u4e2d\u89e3\u6790\u4e3b\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_35", (String)"bos-wf-engine"));
    }

    public static final ErrorCode addressProcessUnknowException() {
        return WFErrorCode.create("addressProcessUnknowException", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5bfb\u5740\u65f6\u53d1\u9001\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_36", (String)"bos-wf-engine"));
    }

    public static ErrorCode processIsRunningException() {
        return WFErrorCode.create("processIsRunningException", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u6d41\u7a0b\u6b63\u5728\u8fd0\u884c\uff0c\u5b9a\u65f6\u7b49\u5f85\u8fd0\u884c\u5b8c\u6210\u540e\u6267\u884c\uff0c\u4e1a\u52a1\u4e3b\u952e:%s", (String)"WFErrorCode_37", (String)"bos-wf-engine"));
    }

    public static ErrorCode processIsStartingException() {
        return WFErrorCode.create("processIsStartingException", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u6d41\u7a0b\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u5b9a\u65f6\u7b49\u5f85\u5b8c\u6210\u4e4b\u540e\u624d\u80fd\u8fd0\u884c\u3002\u4e1a\u52a1\u4e3b\u952e\uff1a\u201c%s\u201d\u3002", (String)"WFErrorCode_38", (String)"bos-wf-engine"));
    }

    public static ErrorCode addressMsgAddJobException() {
        return WFErrorCode.create("addressMsgAddJobException", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u5bfb\u5740\u6d88\u606f\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u5b9a\u65f6\u7b49\u5f85\u5b8c\u6210\u4e4b\u540e\u624d\u80fd\u8fd0\u884c\uff0c\u4e1a\u52a1\u4e3b\u952e:%s", (String)"WFErrorCode_39", (String)"bos-wf-engine"));
    }

    public static ErrorCode addressMsgOtherOperationJobException() {
        return WFErrorCode.create("addressMsgOtherOperationJobException", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u5355\u636e\u7684\u53e6\u5916\u4e00\u4e2a\u5de5\u4f5c\u6d41\u6d88\u606f\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u5b9a\u65f6\u7b49\u5f85\u5b8c\u6210\u4e4b\u540e\u624d\u80fd\u8fd0\u884c\uff0c\u4e1a\u52a1\u4e3b\u952e:%s", (String)"WFErrorCode_40", (String)"bos-wf-engine"));
    }

    public static ErrorCode asyncYunzhijiaGroupJobException() {
        return WFErrorCode.create("asyncYunzhijiaGroupJobException", (ILocaleString)ResManager.getLocaleString((String)"YunzhijiaGroupJob\u5c1d\u8bd5\u521b\u5efa\u7fa4\u7ec4\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"WFErrorCode_41", (String)"bos-wf-engine"));
    }

    public static ErrorCode eventArgsParseJsonError() {
        return WFErrorCode.create("conditionParseError", (ILocaleString)ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u53c2\u6570\u683c\u5f0f\u5316\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_116", (String)"bos-wf-engine"));
    }

    public static ErrorCode bizEventError() {
        return WFErrorCode.create("bizEventError", (ILocaleString)ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_117", (String)"bos-wf-engine"));
    }

    public static ErrorCode conditionParseError() {
        return WFErrorCode.create("conditionParseError", (ILocaleString)ResManager.getLocaleString((String)"\u6761\u4ef6\u89c4\u5219\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_42", (String)"bos-wf-engine"));
    }

    public static ErrorCode conditionSaveError() {
        return WFErrorCode.create("conditionSaveError", (ILocaleString)ResManager.getLocaleString((String)"\u6761\u4ef6\u89c4\u5219\u8868\u8fbe\u5f0f\u4fdd\u5b58\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_43", (String)"bos-wf-engine"));
    }

    public static ErrorCode engineError() {
        return WFErrorCode.create("engineError", (ILocaleString)ResManager.getLocaleString((String)"\u5de5\u4f5c\u6d41\u8fd0\u884c\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_103", (String)"bos-wf-engine"));
    }

    public static ErrorCode precomputorError(IPreComputorRecordItem node) {
        return WFErrorCode.create("precomputorError", node.getErrMsg().getLocaleValue());
    }

    public static ErrorCode viewFlowchartBillIdError() {
        return WFErrorCode.create("viewFlowchartBillIdIsNull", (ILocaleString)ResManager.getLocaleString((String)"\u4f7f\u7528\u67e5\u770b\u6d41\u7a0b\u56fe\u63a5\u53e3\u5fc5\u987b\u4f20\u9012billID\u53c2\u6570\u3002", (String)"WFErrorCode_45", (String)"bos-wf-engine"));
    }

    public static ErrorCode illegAlargumentException() {
        return WFErrorCode.create("illegAlargumentException", (ILocaleString)ResManager.getLocaleString((String)"\u975e\u6cd5\u53c2\u6570\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_46", (String)"bos-wf-engine"));
    }

    public static ErrorCode withdrawError() {
        return WFErrorCode.create("withdrawError", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u5df2\u7ecf\u8fdb\u5165\u6d41\u7a0b\uff0c\u4e14\u540e\u7eed\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"WFErrorCode_47", (String)"bos-wf-engine"));
    }

    public static ErrorCode withdrawErrorWithMessage() {
        return WFErrorCode.create("withdrawError", (ILocaleString)ResManager.getLocaleString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_48", (String)"bos-wf-engine"));
    }

    public static ErrorCode findhiActivitInstanceIsNull() {
        return WFErrorCode.create("findhiActivitInstanceIsNull", (ILocaleString)ResManager.getLocaleString((String)"\u5386\u53f2\u6d3b\u52a8\u5b9e\u4f8b\u4e3a\u7a7a\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_49", (String)"bos-wf-engine"));
    }

    public static ErrorCode withdrawLater() {
        return WFErrorCode.create("withdrawLater", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u4ecd\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u64a4\u56de\u3002", (String)"WFErrorCode_50", (String)"bos-wf-engine"));
    }

    public static ErrorCode processSuspend() {
        return WFErrorCode.create("processSuspend", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5df2\u7ecf\u6302\u8d77\uff0c%s", (String)"WFErrorCode_51", (String)"bos-wf-engine"));
    }

    public static ErrorCode processSuspendSimple() {
        return WFErrorCode.create("processSuspendSimple", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5df2\u7ecf\u6302\u8d77\u3002", (String)"WFErrorCode_51_1", (String)"bos-wf-engine"));
    }

    public static ErrorCode processend() {
        return WFErrorCode.create("processSuspend", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"WFErrorCode_52", (String)"bos-wf-engine"));
    }

    public static ErrorCode findPreActivitInstance() {
        return WFErrorCode.create("findPreActivitInstance", (ILocaleString)ResManager.getLocaleString((String)"\u67e5\u627e\u4e0a\u4e00\u6d3b\u52a8\u5b9e\u4f8b\u8282\u70b9\u5f02\u5e38\uff0c\u5f53\u524d\u6d3b\u52a8\u5b9e\u4f8b\u8282\u70b9\uff1a%s\u3002", (String)"WFErrorCode_53", (String)"bos-wf-engine"));
    }

    public static ErrorCode emptyErrorCode() {
        return WFErrorCode.create("emptyErrorCode", "%s");
    }

    public static ErrorCode dispatchToDoError() {
        return WFErrorCode.create("dispatchToDoError", (ILocaleString)ResManager.getLocaleString((String)"\u53d1\u9001\u5f85\u529e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_54", (String)"bos-wf-engine"));
    }

    public static ErrorCode updateBpmnModelDynamicPartialError() {
        return WFErrorCode.create("updateBpmnModelDynamicPartialError", (ILocaleString)ResManager.getLocaleString((String)"\u66f4\u65b0BpmnModel\u52a8\u6001\u6a21\u578b\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_55", (String)"bos-wf-engine"));
    }

    public static ErrorCode generateDiffsError() {
        return WFErrorCode.create("generateDiffsError", (ILocaleString)ResManager.getLocaleString((String)"\u8ba1\u7b97\u914d\u7f6e\u65b9\u6848\u5dee\u91cf\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_56", (String)"bos-wf-engine"));
    }

    public static ErrorCode mergeDiffsError() {
        return WFErrorCode.create("mergeDiffsError", (ILocaleString)ResManager.getLocaleString((String)"\u914d\u7f6e\u65b9\u6848\u5408\u6210\u5dee\u91cf\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_57", (String)"bos-wf-engine"));
    }

    public static ErrorCode fixArrayElementIdError() {
        return WFErrorCode.create("fixArrayElementIdError", (ILocaleString)ResManager.getLocaleString((String)"\u4fee\u590d\u914d\u7f6e\u65b9\u6848\u5dee\u91cfID\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_58", (String)"bos-wf-engine"));
    }

    public static ErrorCode jsonPatchToBpmnPatchError() {
        return WFErrorCode.create("jsonPatchToBpmnPatchError", (ILocaleString)ResManager.getLocaleString((String)"JsonPatch\u8f6cBpmnPatch\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_59", (String)"bos-wf-engine"));
    }

    public static ErrorCode sendMQException() {
        return WFErrorCode.create("sendMQException", (ILocaleString)ResManager.getLocaleString((String)"\u53d1\u9001\u5f02\u6b65\u6d88\u606f\u5931\u8d25,\u53ef\u80fd\u53cd\u9988\u5f02\u5e38\uff0c\u4e5f\u53ef\u80fd\u53d1\u9001\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0:%s", (String)"WFErrorCode_60", (String)"bos-wf-engine"));
    }

    public static ErrorCode deleteJobError() {
        return WFErrorCode.create("deleteJobException", (ILocaleString)ResManager.getLocaleString((String)"\u5220\u9664Job\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_61", (String)"bos-wf-engine"));
    }

    public static ErrorCode updateJobError() {
        return WFErrorCode.create("updateJobException", (ILocaleString)ResManager.getLocaleString((String)"\u66f4\u65b0Job\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_62", (String)"bos-wf-engine"));
    }

    public static ErrorCode autoTaskError() {
        return WFErrorCode.create("autoTaskError", (ILocaleString)ResManager.getLocaleString((String)"\u81ea\u52a8\u8282\u70b9\u5728\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_63", (String)"bos-wf-engine"));
    }

    public static ErrorCode voteParticipantError() {
        return WFErrorCode.create("voteParticipantError", (ILocaleString)ResManager.getLocaleString((String)"\u4f1a\u7b7e\u6295\u7968\u6a21\u5f0f\u65f6\uff0c\u53c2\u4e0e\u4eba\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u3002", (String)"WFErrorCode_64", (String)"bos-wf-engine"));
    }

    public static ErrorCode businessKeynullError() {
        return WFErrorCode.create("businessKeynullError", (ILocaleString)ResManager.getLocaleString((String)"\u201c%s\u201d\u65f6,\u4f20\u5165\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WFErrorCode_65", (String)"bos-wf-engine"));
    }

    public static ErrorCode cannotFindSignal() {
        return WFErrorCode.create("cannotFindSignal", (ILocaleString)ResManager.getLocaleString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u4fe1\u53f7\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_66", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskRuleAnalysisError() {
        return WFErrorCode.create("taskRuleAnalysisError", (ILocaleString)ResManager.getLocaleString((String)"\u8ba1\u7b97\u4efb\u52a1\u89c4\u5219\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_67", (String)"bos-wf-engine"));
    }

    public static ErrorCode outSetError() {
        return WFErrorCode.createRuntimeErrorCode("outSetError", (ILocaleString)ResManager.getLocaleString((String)"\u8bf7\u68c0\u67e5\u7ebf\u4e0a\u6761\u4ef6\u914d\u7f6e\u3002\u8282\u70b9\u201c%s\u201d\u51fa\u53e3\u8bbe\u7f6e\u4e3a\u201c\u53ea\u80fd\u4ece\u4e00\u6761\u7ebf\u6d41\u51fa\uff0c\u5f53\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u591a\u6761\u7ebf\u65f6\uff0c\u505c\u6b62\u6d41\u8f6c\u201d\uff0c\u73b0\u5728\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u6761\u4ef6\u7684\u7ebf\u3002", (String)"WFErrorCode_68", (String)"bos-wf-engine"));
    }

    public static ErrorCode continueError() {
        return WFErrorCode.createRuntimeErrorCode("continueError", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u8f6c\u5f02\u5e38\uff0c\u539f\u56e0:%s", (String)"WFErrorCode_69", (String)"bos-wf-engine"));
    }

    public static ErrorCode configurationError() {
        return WFErrorCode.createConfigErrorCode("ConfigurationError", (ILocaleString)ResManager.getLocaleString((String)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_70", (String)"bos-wf-engine"));
    }

    public static ErrorCode getMessageServiceError() {
        return WFErrorCode.createErrorCodeForMessage("getMessageServiceError", (ILocaleString)ResManager.getLocaleString((String)"\u89e3\u6790\u6d88\u606f\u670d\u52a1\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_71", (String)"bos-wf-engine"));
    }

    public static ErrorCode buildMessageModelError() {
        return WFErrorCode.createErrorCodeForMessage("buildMessageModelError", (ILocaleString)ResManager.getLocaleString((String)"\u6784\u5efa\u6d88\u606f\u6a21\u578b\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_72", (String)"bos-wf-engine"));
    }

    public static ErrorCode messageJobHandlerException() {
        return WFErrorCode.createErrorCodeForMessage("messageJobHandlerUnknownException", (ILocaleString)ResManager.getLocaleString((String)"\u5728\u6267\u884c\u5f02\u6b65\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_73", (String)"bos-wf-engine"));
    }

    public static ErrorCode httpRequestError() {
        return WFErrorCode.createErrorCodeForMessage("httpRequestError", "%s");
    }

    public static ErrorCode encodingException() {
        return WFErrorCode.createErrorCodeForMessage("encodingException", (ILocaleString)ResManager.getLocaleString((String)"URL\u53c2\u6570\u7f16\u7801\u6216\u89e3\u7801\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_74", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjAuthError() {
        return WFErrorCode.createErrorCodeForMessage("yzjAuthError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u83b7\u53d6\u6388\u6743\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_75", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjDataError() {
        return WFErrorCode.createErrorCodeForMessage("yzjDataError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u83b7\u53d6data\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_76", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjTicketInvalidError() {
        return WFErrorCode.createErrorCodeForMessage("yzjTicketInvalidError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6ticket\u65e0\u6548\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_77", (String)"bos-wf-engine"));
    }

    public static ErrorCode httpRequestException() {
        return WFErrorCode.createErrorCodeForMessage("httpRequestException", (ILocaleString)ResManager.getLocaleString((String)"\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25\uff0c\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_78", (String)"bos-wf-engine"));
    }

    public static ErrorCode httpRequestWrongResponse() {
        return WFErrorCode.createErrorCodeForMessage("httpRequestWrongResponse", (ILocaleString)ResManager.getLocaleString((String)"\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25\uff0c\u672a\u8fd4\u56de\u9884\u671f\u7684\u54cd\u5e94\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_79", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjSendMessageError() {
        return WFErrorCode.createErrorCodeForMessage("yzjSendMessageError", (ILocaleString)ResManager.getLocaleString((String)"\u53d1\u9001\u4e91\u4e4b\u5bb6\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_80", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjCreateGroupError() {
        return WFErrorCode.createErrorCodeForMessage("yzjCreateGroupError", (ILocaleString)ResManager.getLocaleString((String)"\u521b\u5efa\u4e91\u4e4b\u5bb6\u7fa4\u7ec4\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_81", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjAddToGroupError() {
        return WFErrorCode.createErrorCodeForMessage("yzjAddToGroupError", (ILocaleString)ResManager.getLocaleString((String)"\u5f80\u7fa4\u7ec4\u4e2d\u6dfb\u52a0\u65b0\u6210\u5458\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_82", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjSendTodoError() {
        return WFErrorCode.createErrorCodeForMessage("yzjSendTodoError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u5f85\u529e\u521b\u5efa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_83", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjdealTodoError() {
        return WFErrorCode.createErrorCodeForMessage("yzjdealTodoError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u66f4\u6539\u4e3a\u201c\u5df2\u529e\u201d\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_84", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjdeleteTodoError() {
        return WFErrorCode.createErrorCodeForMessage("yzjdeleteTodoError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u5f85\u529e\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_85", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjcheckTodoError() {
        return WFErrorCode.createErrorCodeForMessage("yzjcheckTodoError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_86", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjsendMsgError() {
        return WFErrorCode.createErrorCodeForMessage("yzjsendTxtMsgError", (ILocaleString)ResManager.getLocaleString((String)"\u4e91\u4e4b\u5bb6\u53d1\u9001\u6587\u672c\u6d88\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_87", (String)"bos-wf-engine"));
    }

    public static ErrorCode yzjCheckUserOpenIdError() {
        return WFErrorCode.createErrorCodeForMessage("yzjCheckUserOpenIdError", (ILocaleString)ResManager.getLocaleString((String)"\u7528\u6237\u201c%s\u201d\u6ca1\u6709openID\u3002", (String)"WFErrorCode_122", (String)"bos-wf-engine"));
    }

    public static ErrorCode emailSendMsgError() {
        return WFErrorCode.createErrorCodeForMessage("emailSendMsgError", "%s");
    }

    public static ErrorCode emailSendTodoError() {
        return WFErrorCode.createErrorCodeForMessage("emailSendTodoError", "%s");
    }

    public static ErrorCode smsSendMsgError() {
        return WFErrorCode.createErrorCodeForMessage("smsSendMsgError", "%s");
    }

    public static ErrorCode smsSendTodoError() {
        return WFErrorCode.createErrorCodeForMessage("smsSendTodoError", "%s");
    }

    public static ErrorCode dingdingMsgError() {
        return WFErrorCode.createErrorCodeForMessage("dingdingSendMsgError", "%s");
    }

    public static ErrorCode weixinqyMsgError() {
        return WFErrorCode.createErrorCodeForMessage("weixinqySendMsgError", "%s");
    }

    public static ErrorCode sendMsgErrorCode(String channel) {
        return WFErrorCode.createErrorCodeForMessage(String.format("[%s] SendMsgError", channel), "%s");
    }

    public static ErrorCode weLinkCreateTodoError() {
        return WFErrorCode.createErrorCodeForMessage("weLinkCreateTodoError", (ILocaleString)ResManager.getLocaleString((String)"welink\u521b\u5efa\u5f85\u529e\u5f02\u5e38\uff1a%s", (String)"WFErrorCode_111", (String)"bos-wf-engine"));
    }

    public static ErrorCode weLinkDealTodoError() {
        return WFErrorCode.createErrorCodeForMessage("weLinkDealTodoError", (ILocaleString)ResManager.getLocaleString((String)"welink\u5904\u7406\u5f85\u529e\u5f02\u5e38\uff1a%s", (String)"WFErrorCode_112", (String)"bos-wf-engine"));
    }

    public static ErrorCode weLinkDeleteTodoError() {
        return WFErrorCode.createErrorCodeForMessage("weLinkDeleteTodoError", (ILocaleString)ResManager.getLocaleString((String)"welink\u5220\u9664\u5f85\u529e\u5f02\u5e38\uff1a%s", (String)"WFErrorCode_113", (String)"bos-wf-engine"));
    }

    public static ErrorCode weLinkSendMsgError() {
        return WFErrorCode.createErrorCodeForMessage("weLinkSendMsgError", (ILocaleString)ResManager.getLocaleString((String)"welink\u63a8\u9001\u6d88\u606f\u5f02\u5e38\uff1a%s", (String)"WFErrorCode_114", (String)"bos-wf-engine"));
    }

    public static ErrorCode sendMsgWithoutContentError() {
        return WFErrorCode.createErrorCodeForMessage("sendMsgWithoutContentError", "messagecontent is blank");
    }

    public static ErrorCode dealMessageError() {
        return WFErrorCode.createErrorCodeForMessage("dealMessageError", (ILocaleString)ResManager.getLocaleString((String)"%1$s\u6e20\u9053\u6807\u8bb0\u5df2\u8bfb\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"WFErrorCode_150", (String)"bos-wf-engine"));
    }

    public static ErrorCode sendWorkflowMsgError() {
        return WFErrorCode.create("sendWorkflowMsgError", (ILocaleString)ResManager.getLocaleString((String)"\u521b\u5efa\u5de5\u4f5c\u6d41\u6d88\u606f\u65f6\u51fa\u9519\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u4e1a\u52a1\u64cd\u4f5c\u3002\u539f\u56e0\uff1a%s", (String)"WFErrorCode_88", (String)"bos-wf-engine"));
    }

    public static ErrorCode lockError() {
        return WFErrorCode.createRuntimeErrorCode("lockError", (ILocaleString)ResManager.getLocaleString((String)"\u9501\u5b9ajob\u5931\u8d25\uff0c\u539f\u56e0:%s", (String)"WFErrorCode_89", (String)"bos-wf-engine"));
    }

    public static ErrorCode noOutgoingSequenceError() {
        return WFErrorCode.createRuntimeErrorCode("noOutgoingSequenceError", (ILocaleString)ResManager.getLocaleString((String)"\u8282\u70b9\u201c%s\u201d\u6ca1\u6709\u5b9a\u4e49\u51fa\u53e3\u7ebf\u6216\u65e0\u6cd5\u8ba1\u7b97\u51fa\u53e3\u7ebf\u3002", (String)"WFErrorCode_90", (String)"bos-wf-engine"));
    }

    public static ErrorCode jobHandledError() {
        return WFErrorCode.createJobErrorCode("handledError", (ILocaleString)ResManager.getLocaleString((String)"Job\u201c%1$s\u201d\u5904\u7406\u65f6\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_91", (String)"bos-wf-engine"));
    }

    public static ErrorCode jobExecutingError() {
        return WFErrorCode.createJobErrorCode("executeError", (ILocaleString)ResManager.getLocaleString((String)"Job\u201c%1$s\u201d\u6267\u884c\u8fc7\u7a0b\u4e2d\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"WFErrorCode_92", (String)"bos-wf-engine"));
    }

    public static ErrorCode jobUnKnowError() {
        return WFErrorCode.createJobErrorCode("unknowError", (ILocaleString)ResManager.getLocaleString((String)"Job\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_93", (String)"bos-wf-engine"));
    }

    public static ErrorCode deleteWfRoleError() {
        return WFErrorCode.createJobErrorCode("deleteWfRoleError", (ILocaleString)ResManager.getLocaleString((String)"\u5220\u9664\u5de5\u4f5c\u6d41\u89d2\u8272\u9519\u8bef\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_94", (String)"bos-wf-engine"));
    }

    public static ErrorCode getToHandleTasksMessageError() {
        return WFErrorCode.createJobErrorCode("getToHandleTasksMessageError", (ILocaleString)ResManager.getLocaleString((String)"\u83b7\u53d6\u5f85\u529e\u4efb\u52a1\u6d88\u606f\u51fa\u9519\u201c%s\u201d\u3002", (String)"WFErrorCode_95", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskLockError() {
        return WFErrorCode.createTaskErrorCode("taskLockError", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u4efb\u52a1\u6b63\u5728\u88ab\u522b\u7684\u7528\u6237\u5904\u7406\u3002", (String)"WFErrorCode_96", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskNotFound() {
        return WFErrorCode.createTaskErrorCode("taskNotFound", (ILocaleString)ResManager.getLocaleString((String)"\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u4efb\u52a1\u53ef\u80fd\u5df2\u5904\u7406\u3002", (String)"WFErrorCode_97", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskCompleted() {
        return WFErrorCode.createTaskErrorCode("taskCompleted", (ILocaleString)ResManager.getLocaleString((String)"\u4efb\u52a1\u5df2\u88ab\u5904\u7406\u3002", (String)"WFErrorCode_164", (String)"bos-wf-engine"));
    }

    public static ErrorCode completedTaskError() {
        return WFErrorCode.createTaskErrorCode("completedTaskError", (ILocaleString)ResManager.getLocaleString((String)"\u4efb\u52a1\u5f02\u5e38\uff0c%s", (String)"WFErrorCode_148", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskUnFinished() {
        return WFErrorCode.createTaskErrorCode("taskUnFinished", (ILocaleString)ResManager.getLocaleString((String)"\u201c%1$s\u201d\u8282\u70b9\u7684\u4efb\u52a1\u201c%2$s\u201d\u8fd8\u672a\u5b8c\u6210\u3002", (String)"WFErrorCode_98", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskRepeated() {
        return WFErrorCode.createTaskErrorCode("taskRepeated", (ILocaleString)ResManager.getLocaleString((String)"\u8282\u70b9[%1$s]\u7684\u4efb\u52a1[%2$s]\u8fd8\u5b58\u5728\u4efb\u52a1\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"WFErrorCode_99", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskNotExist() {
        return WFErrorCode.createTaskErrorCode("taskNotExist", (ILocaleString)ResManager.getLocaleString((String)"\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"WFErrorCode_100", (String)"bos-wf-engine"));
    }

    public static ErrorCode decisionOptionsNotExist() {
        return WFErrorCode.createTaskErrorCode("decisionOptionsNotExist", (ILocaleString)ResManager.getLocaleString((String)"\u51b3\u7b56\u9879\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u3002", (String)"WFErrorCode_126", (String)"bos-wf-engine"));
    }

    public static ErrorCode sscApproverJumpError() {
        return WFErrorCode.createBizErrorCode("sscApproverJumpError", (ILocaleString)ResManager.getLocaleString((String)"\u5171\u4eab\u8282\u70b9\u6682\u65f6\u4e0d\u652f\u6301\u8df3\u8f6c\uff0c\u53ef\u4ee5\u5728\u5171\u4eab\u4e2d\u5fc3\u6253\u56de\u5904\u7406\u3002", (String)"WFErrorCode_101", (String)"bos-wf-engine"));
    }

    public static ErrorCode subProcessException() {
        return WFErrorCode.create("subProcessError", (ILocaleString)ResManager.getLocaleString((String)"\u5b50\u6d41\u7a0b %s", (String)"WFErrorCode_118", (String)"bos-wf-engine"));
    }

    public static ErrorCode metaNotFoundError() {
        return WFErrorCode.createMetaErrorCode("metaNotFound", "");
    }

    public static ErrorCode entityMetaDataNotExistError() {
        return WFErrorCode.createMetaErrorCode("entityMetaDataNotExist", "");
    }

    public static ErrorCode appMetaDataNotExistError() {
        return WFErrorCode.createMetaErrorCode("appMetaDataNotExist", "");
    }

    private static ErrorCode create(String code, String message) {
        return new ErrorCode("bos.wf." + code, message);
    }

    private static ErrorCode create(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf." + code, adminLangError);
    }

    private static ErrorCode createMetaErrorCode(String code, String message) {
        return new ErrorCode("bos." + code, message);
    }

    private static ErrorCode createJobErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.job." + code, message);
    }

    private static ErrorCode createJobErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.job." + code, adminLangError);
    }

    private static ErrorCode createRPAErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.rpa." + code, message);
    }

    private static ErrorCode createRPAErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.rpa." + code, adminLangError);
    }

    private static ErrorCode createErrorCodeForMessage(String code, String message) {
        return new ErrorCode("bos.wf.msg." + code, message);
    }

    private static ErrorCode createErrorCodeForMessage(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.msg." + code, adminLangError);
    }

    private static ErrorCode createConfigErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.config." + code, message);
    }

    private static ErrorCode createConfigErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.config." + code, adminLangError);
    }

    private static ErrorCode createRuntimeErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.runtime." + code, message);
    }

    private static ErrorCode createRuntimeErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.runtime." + code, adminLangError);
    }

    private static ErrorCode createEngineStateErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.engineState." + code, message);
    }

    private static ErrorCode createEngineStateErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.engineState." + code, adminLangError);
    }

    private static ErrorCode createAddressingProcessErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.addressing." + code, message);
    }

    private static ErrorCode createAddressingProcessErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.addressing." + code, adminLangError);
    }

    private static ErrorCode createParticipantErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.participant." + code, message);
    }

    private static ErrorCode createParticipantErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.participant." + code, adminLangError);
    }

    private static ErrorCode createBizErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.biz." + code, message);
    }

    private static ErrorCode createBizErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.biz." + code, adminLangError);
    }

    private static ErrorCode createTaskErrorCode(String code, String message) {
        return new ErrorCode("bos.wf.task." + code, message);
    }

    private static ErrorCode createTaskErrorCode(String code, ILocaleString message) {
        String adminLangError = WFErrorCode.getAdminLangError(message);
        return new ErrorCode("bos.wf.task." + code, adminLangError);
    }

    public static ErrorCode businessOperationError() {
        return WFErrorCode.createBizErrorCode("businessOperationError", (ILocaleString)ResManager.getLocaleString((String)"\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c\u201c%1$s\u201d\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"WFErrorCode_105", (String)"bos-wf-engine"));
    }

    public static ErrorCode parseFreeFlowProcessError() {
        return WFErrorCode.createTaskErrorCode("parseFreeFlowProcessError", (ILocaleString)ResManager.getLocaleString((String)"\u81ea\u7531\u6d41\u7a0b\u6a21\u578b\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"WFErrorCode_115", (String)"bos-wf-engine"));
    }

    public static ErrorCode objectNotFoundError() {
        return WFErrorCode.create("objectNotFoundError", (ILocaleString)ResManager.getLocaleString((String)"\u4e1a\u52a1\u5bf9\u8c61\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u67e5\u8be2\u4e0d\u5230\uff1a%1$s\uff0c%2$s\u3002", (String)"WFErrorCode_121", (String)"bos-wf-engine"));
    }

    public static ErrorCode stopProcessWhenNextPersonEmptyConfigError() {
        return WFErrorCode.createRuntimeErrorCode("stopProcessWhenNextPersonEmptyConfigError", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u6307\u5b9a\u8282\u70b9\u53c2\u4e0e\u4eba\u914d\u7f6e\u6709\u8bef\u3002", (String)"WFErrorCode_127", (String)"bos-wf-engine"));
    }

    public static ErrorCode stopProcessWhenNextPersonEmptyError() {
        return WFErrorCode.createRuntimeErrorCode("StopProcessWhenNextPersonEmptyError", (ILocaleString)ResManager.getLocaleString((String)"\u4e0b\u4e00\u6b65\u8282\u70b9\u53c2\u4e0e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u5165\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u6d41\u7a0b\u7ba1\u7406\u5458\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a\u6d41\u7a0b\u7f16\u7801\u201c%1$s\u201d\uff0c\u8282\u70b9\u540d\u79f0\u201c%2$s\u201d\u3002", (String)"WFErrorCode_123", (String)"bos-wf-engine"));
    }

    public static ErrorCode stopProcessWhenAfterPersonStrategyNotNodes() {
        return WFErrorCode.createRuntimeErrorCode("checkAssignPersonRul", (ILocaleString)ResManager.getLocaleString((String)"\u5f53\u524d\u8282\u70b9\u672a\u914d\u7f6e\u8981\u6307\u5b9a\u4eba\u5458\u7684\u540e\u7eed\u8282\u70b9\uff0c\u8bf7\u8054\u7cfb\u6d41\u7a0b\u7ba1\u7406\u5458\u3002", (String)"WFErrorCode_136", (String)"bos-wf-engine"));
    }

    public static ErrorCode stopProcessWhenAfterPersonStrategyNotSingle() {
        return WFErrorCode.createRuntimeErrorCode("checkAssignPersonRul", (ILocaleString)ResManager.getLocaleString((String)"\u8282\u70b9\u53c2\u4e0e\u4eba\u591a\u4e8e\u4e00\u4eba\u65f6\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u8282\u70b9\u53c2\u4e0e\u4eba\u63a7\u5236\u7b56\u7565\u3002", (String)"WFErrorCode_125", (String)"bos-wf-engine"));
    }

    public static ErrorCode stopProcessWhenAfterPersonStrategyIsEmpty() {
        return WFErrorCode.createRuntimeErrorCode("checkAssignPersonRul", (ILocaleString)ResManager.getLocaleString((String)"\u8282\u70b9\u53c2\u4e0e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u8282\u70b9\u53c2\u4e0e\u4eba\u63a7\u5236\u7b56\u7565\u3002", (String)"WFErrorCode_128", (String)"bos-wf-engine"));
    }

    public static ErrorCode billPageAttributeConfigErrorForMetadataNotExist() {
        return WFErrorCode.create("billPageAttributeConfigErrorForMetadataNotExist", (ILocaleString)ResManager.getLocaleString((String)"\u8bf7\u914d\u7f6e\u201c%s\u201d\u7684\u5143\u6570\u636e\u3002", (String)"WFErrorCode_129", (String)"bos-wf-engine"));
    }

    public static ErrorCode existsSameEntityMBSummaryError(String mBillSummaryCfgNumbers) {
        LocaleString wfErrorCode_131 = ResManager.getLocaleString((String)"\u5355\u636e\u6458\u8981\u8bbe\u7f6e\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\u3002", (String)"WFErrorCode_131", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_131);
        return WFErrorCode.create("sameEntityMobileBillSummaryCfgExist", String.format(adminLangError, mBillSummaryCfgNumbers));
    }

    public static ErrorCode existsNotSameEntityMBSummaryError(String notSamemBillSummaryCfgNumbers) {
        LocaleString wfErrorCode_132 = ResManager.getLocaleString((String)"\u5355\u636e\u6458\u8981\u8bbe\u7f6e\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u4f46\u5bf9\u5e94\u7684\u5355\u636e\u5b9e\u4f53\u6216\u6458\u8981\u6a21\u677f\u4e0d\u76f8\u540c\u3002", (String)"WFErrorCode_132", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_132);
        return WFErrorCode.create("notSameEntityMobileBillSummaryCfgExist", String.format(adminLangError, notSamemBillSummaryCfgNumbers));
    }

    public static ErrorCode participantIsNullForCoordinateError() {
        LocaleString wfErrorCode_133 = ResManager.getLocaleString((String)"\u534f\u529e\u53c2\u4e0e\u4eba\u4e3a\u7a7a\u3002", (String)"WFErrorCode_133", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_133);
        return WFErrorCode.createTaskErrorCode("participantIsNullForCoordinateError", String.format(adminLangError, WfConfigurationUtil.getCoordinateName()));
    }

    public static ErrorCode existsMutualDelegateError(String assignorName, String trusteeName) {
        LocaleString wfErrorCode_134 = ResManager.getLocaleString((String)"\u201c%1$s\u201d\u5df2\u7ecf\u662f\u201c%2$s\u201d\u7684\u53d7\u6258\u4eba\uff0c\u4e0d\u80fd\u518d\u59d4\u6258\u201c%3$s\u201d", (String)"WFErrorCode_134", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_134);
        return WFErrorCode.create("existsMutualDelegate", String.format(adminLangError, assignorName, trusteeName, trusteeName));
    }

    public static ErrorCode existsDelegateRingError(String assignorName, String trusteeName) {
        LocaleString wfErrorCode_135 = ResManager.getLocaleString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u59d4\u6258\u201c%2$s\u201d\uff0c\u539f\u56e0\uff1a\u59d4\u6258\u8bbe\u7f6e\u4e0d\u80fd\u5f62\u6210\u59d4\u6258\u5173\u7cfb\u4e4b\u95f4\u7684\u95ed\u73af\uff0c\u5982\uff1aA\u59d4\u6258B\uff0cB\u59d4\u6258C\uff0c\u6b64\u65f6C\u4e0d\u80fd\u59d4\u6258A\u3002", (String)"WFErrorCode_135", (String)"bos-wf-engine");
        String adminLangError = WFErrorCode.getAdminLangError((ILocaleString)wfErrorCode_135);
        return WFErrorCode.create("existsDelegateRing", String.format(adminLangError, assignorName, trusteeName));
    }

    public static ErrorCode bizTraceNoDuplicated() {
        return WFErrorCode.create("bizTraceNoDuplicated", (ILocaleString)ResManager.getLocaleString((String)"\u4e1a\u52a1\u8ddf\u8e2a\u53f7\u91cd\u590d\uff0c\u8bf7\u5728\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u4e2d\u68c0\u67e5\u4e1a\u52a1\u8ddf\u8e2a\u53f7\u8bbe\u7f6e\u3002entityNumber:%1$s,businessKey:%2$s,bizTraceNo:%3$s\u3002", (String)"WFErrorCode_124", (String)"bos-wf-engine"));
    }

    public static ErrorCode aggregationError() {
        return WFErrorCode.create("botpCalcExcpetion", (ILocaleString)ResManager.getLocaleString((String)"\u6570\u636e\u805a\u5408\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0%s", (String)"WFErrorCode_163", (String)"bos-wf-engine"));
    }

    public static ErrorCode botpCalcExcpetion() {
        return WFErrorCode.create("botpCalcExcpetion", (ILocaleString)ResManager.getLocaleString((String)"BOTP\u8f6c\u6362\u65f6\u51fa\u73b0\u5f02\u5e38\u3002\u8f6c\u6362\u7c7b\u578b\u201c%1$s\u201d\uff0c\u6e90\u5355\u201c%2$s-%3$s\u201d\uff0c\u76ee\u6807\u5355\u201c%4$s\u201d\uff0c\u6e90\u8282\u70b9\u201c%5$s\u201d\uff0c\u76ee\u6807\u8282\u70b9\u201c%6$s\u201d\u3002\u9519\u8bef\u539f\u56e0\uff1a%7$s", (String)"WFErrorCode_151", (String)"bos-wf-engine"));
    }

    public static ErrorCode billCalcExcpetion() {
        return WFErrorCode.create("billCalcExcpetion", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38\u3002\u8f6c\u6362\u7c7b\u578b\u201c%1$s\u201d\uff0c\u6e90\u5355\u201c%2$s-%3$s\u201d\uff0c\u76ee\u6807\u5355\u201c%4$s\u201d\uff0c\u6e90\u8282\u70b9\u201c%5$s\u201d\uff0c\u76ee\u6807\u8282\u70b9\u201c%6$s\u201d\u3002\u9519\u8bef\u539f\u56e0:%7$s\u3002", (String)"WFErrorCode_152", (String)"bos-wf-engine"));
    }

    public static ErrorCode targetBillFilterException() {
        return WFErrorCode.create("targetBillFilterException", (ILocaleString)ResManager.getLocaleString((String)"\u76ee\u6807\u5355\u8fc7\u6ee4\u5f02\u5e38\uff0c\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u5355\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u3002\u5355\u636e\u8ba1\u7b97\u7c7b\u578b\u201c%1$s\u201d\uff0c\u8fc7\u6ee4\u6761\u4ef6\u5b9e\u4f53\u7f16\u7801\u201c%2$s\u201d\uff0c\u8fc7\u6ee4\u6761\u4ef6\u201c%3$s\u201d\uff0c\u8fc7\u6ee4\u4e4b\u524d\u7684\u6570\u91cf\u201c%4$s\u201d\uff0c\u8fc7\u6ee4\u540e\u7684\u6570\u91cf\u201c%5$s\u201d\u3002", (String)"WFErrorCode_162", (String)"bos-wf-engine"));
    }

    public static ErrorCode entityNotMatchError() {
        return WFErrorCode.create("entityNotMatchError", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u8f6c\u5355\u636e\u201c%1$s\u201d\u548c\u76ee\u6807\u8282\u70b9\u201c%2$s\u201d\u7684\u5355\u636e\u201c%3$s\u201d\u4e0d\u4e00\u81f4\uff0c\u53ef\u80fd\u672a\u914d\u7f6e\u5355\u636e\u8ba1\u7b97\u6216\u5355\u636e\u8f6c\u6362\u3002", (String)"WFErrorCode_153", (String)"bos-wf-engine"));
    }

    public static ErrorCode taskSuspendedError() {
        return WFErrorCode.create("taskSuspendedError", WFMultiLangConstants.getTaskSuspendedInfo());
    }

    public static ErrorCode createProcessNotExistError() {
        return WFErrorCode.create("processNotExistError", (ILocaleString)ResManager.getLocaleString((String)"\u8282\u70b9\u201c%1$s\u201d\u7ed1\u5b9a\u7684\u5b50\u6d41\u7a0b\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"WFErrorCode_154", (String)"bos-wf-engine"));
    }

    public static ErrorCode createProcessEmptyError() {
        return WFErrorCode.create("createProcessEmptyError", (ILocaleString)ResManager.getLocaleString((String)"\u8282\u70b9[%s]\u672a\u7ed1\u5b9a\u6d41\u7a0b.", (String)"WFErrorCode_140", (String)"bos-wf-engine"));
    }

    public static ErrorCode createEngineSuspendError() {
        return WFErrorCode.create("createEngineSuspendError", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u5df2\u7ecf\u6302\u8d77\uff0c\u4e0d\u80fd\u6dfb\u52a0\u4fe1\u606f\u3002", (String)"WFErrorCode_143", (String)"bos-wf-engine"));
    }

    public static ErrorCode billCalcEmptyExcpetion() {
        return WFErrorCode.create("billCalcEmptyExcpetion", (ILocaleString)ResManager.getLocaleString((String)"\u672a\u8ba1\u7b97\u51fa\u76ee\u6807\u5355\uff0c\u8f6c\u6362\u7c7b\u578b\u201c%1$s\u201d\uff0c\u6e90\u5355\u201c%2$s-%3$s\u201d\uff0c\u76ee\u6807\u5355\u201c%4$s\u201d\uff0c\u6e90\u8282\u70b9\u201c%5$s\u201d\uff0c\u76ee\u6807\u8282\u70b9\u201c%6$s\u201d\uff0c\u9519\u8bef\u539f\u56e0:\u201c%7$s\u201d\u3002", (String)"WFErrorCode_155", (String)"bos-wf-engine"));
    }

    public static ErrorCode cannotCloseAuditFlowTask() {
        return WFErrorCode.create("cannotCloseAuditFlowTask", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u201c%s\u201d\u7684\u5ba1\u6279\u6d41\u4eba\u5de5\u4efb\u52a1\u4e0d\u80fd\u5173\u95ed\u3002", (String)"WFErrorCode_145", (String)"bos-wf-engine"));
    }

    public static ErrorCode getMountException() {
        return WFErrorCode.create("mountException", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u201c%1$s-%2$s-%3$s\u201d\u5c1d\u8bd5\u6302\u8f7d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u201c%4$s\u201d\u3002", (String)"WFErrorCode_146", (String)"bos-wf-engine"));
    }

    public static ErrorCode getMountRelationException() {
        return WFErrorCode.create("mountRelationException", (ILocaleString)ResManager.getLocaleString((String)"\u5355\u636e\u201c%1$s-%2$s\u201d\u6302\u8f7d\u5173\u7cfb\u56fe\u65f6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u201c%3$s\u201d\u3002", (String)"WFErrorCode_147", (String)"bos-wf-engine"));
    }

    public static ErrorCode createCycleNumbersExceedError() {
        return WFErrorCode.create("createCycleNumbersExceedError", (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u201c%1$s\u201d\u9a73\u56de\u6210\u5708\u5faa\u73af\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230%2$s\u6b21\uff0c\u8d85\u8fc7\u9608\u503c\u3002\u5728\u8282\u70b9\u201c%3$s\u201d\u5f02\u5e38\u6302\u8d77\u3002", (String)"WFErrorCode_149", (String)"bos-wf-engine"));
    }

    public static ErrorCode licenseExceedLimitException() {
        return WFErrorCode.create("licenseExceedLimitException", WFLicenseUtil.getExceedLimitNotice());
    }

    public static ErrorCode executeLifecycleListenerException() {
        return WFErrorCode.create("executeLifecycleListenerException", (ILocaleString)ResManager.getLocaleString((String)"\u6267\u884c\u751f\u547d\u5468\u671f\u76d1\u542c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"WFErrorCode_160", (String)"bos-wf-engine"));
    }

    public static ErrorCode executeCleanerException() {
        return WFErrorCode.create("executeCleanerException", (ILocaleString)ResManager.getLocaleString((String)"\u6846\u67b6\u6e05\u7406\u6267\u884c\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"WFErrorCode_161", (String)"bos-wf-engine"));
    }

    public static ErrorCode createErrorJSONFormat() {
        return WFErrorCode.create("errorJSONFormat", (ILocaleString)ResManager.getLocaleString((String)"\u9519\u8bef\u7684JSON\u683c\u5f0f[%s].", (String)"WFErrorCode_165", (String)"bos-wf-engine"));
    }

    public static ErrorCode verifyNotPassError() {
        return WFErrorCode.createTaskErrorCode("verifyNotPassError", (ILocaleString)ResManager.getLocaleString((String)"[%1$s]\u4efb\u52a1[%2$s]\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0[%3$s]\u3002", (String)"TaskErrorCode_21", (String)"bos-wf-engine"));
    }

    public static ErrorCode crossTenantTokenCheckError() {
        return WFErrorCode.create("crossTenant", (ILocaleString)ResManager.getLocaleString((String)"\u8de8\u79df\u6237\u6821\u9a8ctoken\u6709\u6548\u6027\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"WFErrorCode_166", (String)"bos-wf-engine"));
    }

    public static ErrorCode crossTenantTokenGetError() {
        return WFErrorCode.create("crossTenant", (ILocaleString)ResManager.getLocaleString((String)"\u8de8\u79df\u6237\u83b7\u53d6token\u51fa\u9519\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"WFErrorCode_167", (String)"bos-wf-engine"));
    }

    public static ErrorCode sendMessageLimitedError() {
        return WFErrorCode.create("sendMessageLimited", (ILocaleString)ResManager.getLocaleString((String)"\u7cfb\u7edf\u5185\u4e1a\u52a1\u53d1\u9001\u6d88\u606f\u5e76\u53d1\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"WFErrorCode_168", (String)"bos-wf-engine"));
    }

    public static ErrorCode isNotFlowTask() {
        return WFErrorCode.create("isNotFlowTask", (ILocaleString)ResManager.getLocaleString((String)"[%1$s]\u4e0d\u662f\u6d41\u7a0b\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8%2$s\u3002", (String)"WFErrorCode_169", (String)"bos-wf-engine"));
    }

    public static String getAdminLangError(ILocaleString msg) {
        if (msg == null) {
            return "";
        }
        WfTraceType orCreate = WfTraceType.getOrCreate();
        if (orCreate == null) {
            return msg.toString();
        }
        if (orCreate.getJobInfo() == null) {
            return msg.toString();
        }
        Lang wfAdminLang = WfConfigurationUtil.getWFAdminLang();
        if (wfAdminLang == null) {
            wfAdminLang = Lang.defaultLang();
        }
        return (String)msg.getOrDefault((Object)wfAdminLang.name(), (Object)msg.toString());
    }

    public static ErrorCode conditonSaveError() {
        return WFErrorCode.createRuntimeErrorCode("conditonSaveError", ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u6b64Job\u53ef\u80fd\u5df2\u7ecf\u88ab\u6267\u884c\u6216\u88ab\u5220\u9664\u3002", (String)"WFConditonSaveException_1", (String)"bos-wf-engine", (Object[])new Object[0]));
    }
}

