/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.feature.taskfield;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.feature.taskfield.TaskBusinessFieldInfo;
import kd.bos.workflow.feature.taskfield.TaskExtendFieldsFactory;
import kd.bos.workflow.feature.taskfield.datasource.ITaskExtendFieldsDataSource;

public class TaskExtendFieldHelper {
    private static Log logger = LogFactory.getLog(TaskExtendFieldHelper.class);
    private static final String STR_ISFORMAT = "isFormat";
    private static final String[] BUSINESSPRESETSTRFIELD = new String[]{"biz_str1", "biz_str2"};
    private static final String[] BUSINESSMULFIELD = new String[]{"biz_strmul1", "biz_strmul2"};

    public static void setTaskBizField(TaskEntity entity) {
        TaskExtendFieldHelper.setTaskBizField(entity, "wf_task");
    }

    public static void setTaskBizField(Entity entity, String scope) {
        DynamicObject dynamicObject = entity.getDynamicObject();
        BillSubjectModelEntity billSubjectModel = Context.getCommandContext().getBillSubjectModelEntityManager().findBillSubjectByEntityNumber(dynamicObject.getString("entityNumber"));
        if (billSubjectModel == null) {
            return;
        }
        String billId = billSubjectModel.getBillId();
        String businessFieldMappingInfo = billSubjectModel.getBusinessFieldMappingInfo();
        if (StringUtils.isBlank((CharSequence)businessFieldMappingInfo)) {
            return;
        }
        try {
            ITaskExtendFieldsDataSource extendFieldsDataSource = TaskExtendFieldsFactory.getInstance().createTaskExtendFieldsDataSource("dynobject");
            HashMap<String, Object> params = new HashMap<String, Object>();
            HashMap entryArr = new HashMap(3);
            params.put("entry", entryArr);
            params.put("entityId", billId);
            List mappingInfos = (List)SerializationUtils.fromJsonString((String)businessFieldMappingInfo, List.class);
            JSONObject fieldFormat = new JSONObject();
            mappingInfos.forEach(map -> {
                String businessFields = (String)map.get("mapping");
                String taskField = (String)map.get("fieldlist");
                Boolean isMulField = ArrayUtils.contains((Object[])BUSINESSMULFIELD, (Object)taskField) ? Boolean.TRUE : Boolean.FALSE;
                params.put("isMulField", isMulField);
                Boolean isFormat = map.get(STR_ISFORMAT) != null ? (Boolean)map.get(STR_ISFORMAT) : Boolean.FALSE;
                params.put(STR_ISFORMAT, isFormat);
                String[] arr = businessFields.split(";");
                TaskBusinessFieldInfo info = extendFieldsDataSource.getValue(dynamicObject.getString("entityNumber"), dynamicObject.getString("businessKey"), params, arr);
                Object value = info.getValue();
                if (StringUtils.isNotBlank((Object)value) && ArrayUtils.contains((Object[])BUSINESSPRESETSTRFIELD, (Object)taskField)) {
                    value = StringUtils.substring((String)((String)value), (int)0, (int)255);
                }
                if (StringUtils.isNotBlank((Object)value) && isMulField.booleanValue()) {
                    TaskExtendFieldHelper.removeNoUseLanguage((ILocaleString)value);
                    value = WfUtils.subILocaleString((ILocaleString)value, 255);
                }
                dynamicObject.set(taskField, value);
                if (!info.getFormat().isEmpty()) {
                    fieldFormat.put(taskField, (Object)info.getFormat());
                }
            });
            String cacheKey = String.format("findbizobj_%s.%s", dynamicObject.getString("entityNumber"), dynamicObject.getString("businessKey"));
            Context.getCommandContext().getCachedDynamicObj().remove(cacheKey);
            if (!fieldFormat.isEmpty()) {
                dynamicObject.set("bizformat", (Object)SerializationUtils.toJsonString((Object)fieldFormat));
            }
        }
        catch (Exception e) {
            logger.info("setTaskBizField_fail: " + e.getMessage());
        }
    }

    private static void removeNoUseLanguage(ILocaleString ls) {
        Object[] supportLangs = WfUtils.getSupportLangs();
        Iterator iterator = ls.keySet().iterator();
        while (iterator.hasNext()) {
            if (!ArrayUtils.contains((Object[])supportLangs, iterator.next())) continue;
            iterator.remove();
        }
    }
}

