/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.feature.taskfield.datasource;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.feature.taskfield.TaskBusinessFieldInfo;
import kd.bos.workflow.feature.taskfield.datasource.ITaskExtendFieldsDataSource;

public class TaskExtendFieldsFromDynamicObject
implements ITaskExtendFieldsDataSource {
    private static Log logger = LogFactory.getLog(TaskExtendFieldsFromDynamicObject.class);
    private static final String STR_VALUE = "value";
    private static final String STR_FORMAT = "format";
    private static final String STR_TYPE = "type";
    private static final String STR_SCALE = "scale";
    private static final String STR_CURRENCYNUMBER = "currencyNumber";
    private static final String STR_NUMBER = "number";
    private static final String STR_ZEROSHOW = "zeroShow";

    @Override
    public TaskBusinessFieldInfo getValue(String entityNumber, String businessKey, Map<String, Object> params, String ... fields) {
        Object value;
        TaskBusinessFieldInfo info = new TaskBusinessFieldInfo();
        DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber);
        if (dynObj == null) {
            return info;
        }
        Boolean isFormat = (Boolean)params.get("isFormat");
        Boolean isMulField = (Boolean)Optional.ofNullable(params.get("isMulField")).orElse(Boolean.FALSE);
        ArrayList<Object> valueList = new ArrayList<Object>();
        JSONObject formatObj = new JSONObject();
        for (String string : fields) {
            try {
                Map<String, Object> result = this.calcValue(dynObj, string, entityNumber, isFormat, isMulField);
                valueList.add(result.get(STR_VALUE));
                if (!StringUtils.isNotBlank((Object)result.get(STR_FORMAT))) continue;
                formatObj.putAll((Map)result.get(STR_FORMAT));
            }
            catch (Exception e) {
                logger.info("calc field [" + string + "],errorinfo is :" + e.getMessage());
                if (isFormat.booleanValue()) {
                    formatObj.put(string, (Object)new JSONObject());
                }
                valueList.add(null);
            }
        }
        info.setFormat(formatObj);
        if (valueList.size() > 1) {
            if (isMulField.booleanValue()) {
                LocaleString tmp = new LocaleString();
                for (Object e : valueList) {
                    tmp = WfMultiLangUtils.jointILocaleString((ILocaleString)tmp, (ILocaleString)e, ";");
                }
                value = tmp;
            } else {
                value = valueList.stream().filter(StringUtils::isNotBlank).map(String::valueOf).collect(Collectors.joining(";"));
            }
        } else {
            value = valueList.get(0);
        }
        info.setValue(value);
        return info;
    }

    private Map<String, Object> calcValue(DynamicObject dynObj, String fieldName, String entityNumber, Boolean isFormat, Boolean isMulField) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String fieldn = null;
        String fieldp = null;
        if (fieldName.contains(".")) {
            fieldn = fieldName.split("\\.")[0];
            fieldp = fieldName.replaceFirst(fieldn + ".", "");
        } else {
            fieldn = fieldName;
        }
        Object tmp = dynObj.get(fieldn);
        JSONObject format = new JSONObject();
        IDataEntityProperty property = (IDataEntityProperty)dynObj.getDynamicObjectType().getProperties().get((Object)fieldn);
        FormatObject userFormat = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        if (tmp instanceof BigDecimal && isFormat.booleanValue()) {
            if (property instanceof AmountProp) {
                AmountProp p = (AmountProp)property;
                String controlPropName = p.getControlPropName();
                if (StringUtils.isNotBlank((CharSequence)controlPropName)) {
                    DynamicObject currency = (DynamicObject)dynObj.get(controlPropName);
                    if (currency != null) {
                        Integer scale = (Integer)currency.get("amtprecision");
                        if (property instanceof PriceProp) {
                            scale = (Integer)currency.get("priceprecision");
                        }
                        format.put(STR_SCALE, (Object)scale);
                        format.put(STR_CURRENCYNUMBER, currency.get(STR_NUMBER));
                        format.put("currencySign", currency.get("sign"));
                    }
                } else {
                    format.put("currencySign", (Object)"\uffe5");
                    format.put(STR_CURRENCYNUMBER, (Object)"CNY");
                    format.put(STR_SCALE, (Object)(property instanceof PriceProp ? 4 : 2));
                }
                format.put(STR_TYPE, (Object)"amountProp");
                format.put(STR_ZEROSHOW, (Object)p.isZeroShow());
            } else if (property instanceof QtyProp) {
                QtyProp p = (QtyProp)property;
                String controlPropName = p.getControlPropName();
                if (StringUtils.isNotBlank((CharSequence)controlPropName)) {
                    DynamicObject currency = (DynamicObject)dynObj.get(controlPropName);
                    if (currency != null) {
                        format.put(STR_SCALE, currency.get("precision"));
                        format.put(STR_CURRENCYNUMBER, currency.get(STR_NUMBER));
                    }
                } else {
                    format.put(STR_SCALE, (Object)2);
                }
                format.put(STR_TYPE, (Object)"qtyProp");
                format.put(STR_ZEROSHOW, (Object)p.isZeroShow());
            } else {
                DecimalProp p = (DecimalProp)property;
                format.put(STR_ZEROSHOW, (Object)p.isZeroShow());
                format.put(STR_SCALE, (Object)p.getScale());
                format.put(STR_TYPE, (Object)"numberProp");
                tmp = p.getScale() > 10 ? ((BigDecimal)tmp).setScale(10) : tmp;
                tmp = p.getPrecision() > 23 ? ((BigDecimal)tmp).round(new MathContext(23, RoundingMode.HALF_UP)) : tmp;
            }
        } else if (tmp instanceof Date && isFormat.booleanValue()) {
            DateTimeProp p = (DateTimeProp)property;
            format.put(STR_FORMAT, (Object)p.getDisplayFormatString());
            format.put("mask", (Object)p.getMask());
            format.put("regionType", (Object)p.getRegionType());
            format.put("timeZone", (Object)p.getTimeZoneTransType());
            format.put(STR_TYPE, (Object)"dateProp");
            if (userFormat.getDateFormat().getTimeArea() != null) {
                format.put("timeArea", (Object)userFormat.getDateFormat().getTimeArea());
            }
        } else if (tmp instanceof DynamicObject) {
            Map<String, Object> tmpMap2;
            if (property instanceof ItemClassProp) {
                fieldp = ((BasedataProp)property).getDisplayProp();
            }
            if ((tmpMap2 = this.calcValue((DynamicObject)tmp, fieldp, entityNumber, isFormat, isMulField)) != null) {
                tmp = tmpMap2.get(STR_VALUE);
                format.putAll((Map)tmpMap2.get(STR_FORMAT));
            }
        } else if (tmp instanceof DynamicObjectCollection) {
            HashSet set = new HashSet(20);
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)tmp;
            for (int i = 0; i < dynamicObjectCollection.size() && i != 20; ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                Map<String, Object> resultMap = this.calcValue(dynamicObject, fieldp, entityNumber, isFormat, isMulField);
                Optional.ofNullable(resultMap).ifPresent(tmpMap -> {
                    if (StringUtils.isNotBlank(tmpMap.get(STR_VALUE))) {
                        set.add(tmpMap.get(STR_VALUE));
                    }
                });
            }
            if (isMulField.booleanValue()) {
                LocaleString ls = new LocaleString();
                for (Object value : set) {
                    ls = WfMultiLangUtils.jointILocaleString((ILocaleString)ls, (ILocaleString)value, ",");
                }
                tmp = ls;
            } else {
                tmp = StringUtils.join((Object[])set.toArray(), (char)',');
            }
        } else if (tmp instanceof Boolean) {
            tmp = (Boolean)tmp != false ? ResManager.loadResFormat((String)"\u662f", (String)"TaskBusinessFieldInfo_0", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadResFormat((String)"\u5426", (String)"TaskBusinessFieldInfo_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        } else if ((tmp instanceof Long || tmp instanceof Integer) && isFormat.booleanValue()) {
            DecimalProp p = (DecimalProp)property;
            format.put(STR_ZEROSHOW, (Object)p.isZeroShow());
            format.put(STR_SCALE, (Object)0);
            format.put(STR_TYPE, (Object)"numberProp");
            tmp = tmp instanceof Long ? new BigDecimal((Long)tmp) : new BigDecimal((Integer)tmp);
        } else if (tmp instanceof ILocaleString) {
            tmp = isMulField != false ? (ILocaleString)tmp : ((ILocaleString)tmp).getLocaleValue();
        } else if (property instanceof MulComboProp || property instanceof ComboProp) {
            ComboProp p = (ComboProp)property;
            tmp = this.getDisPlayCaptionOfComboxByKey(p, tmp);
        }
        if (isMulField.booleanValue() && !(tmp instanceof ILocaleString)) {
            tmp = new LocaleString(tmp != null ? tmp.toString() : "");
        }
        map.put(STR_VALUE, tmp);
        map.put(STR_FORMAT, format);
        return map;
    }

    private String getDisPlayCaptionOfComboxByKey(ComboProp property, Object key) {
        StringJoiner sj = new StringJoiner(",");
        List comboItems = property.getComboItems();
        if (comboItems != null && !comboItems.isEmpty() && StringUtils.isNotBlank((Object)key)) {
            String[] keys = ((String)key).split(",");
            for (int i = 0; i < keys.length; ++i) {
                for (ValueMapItem map : comboItems) {
                    if (!StringUtils.isNotBlank((CharSequence)keys[i]) || !keys[i].equals(map.getValue())) continue;
                    sj.add(map.getName().toString());
                }
            }
        }
        return sj.toString();
    }
}

