/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.feature.taskfield.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class TaskExtendFieldUtil {
    private static final String STR_ITEMS = "items";
    private static final String STR_ITEM = "item";
    private static final String STR_FORMAT = "_format";
    private static final String STR_A = "A";
    private static Log logger = LogFactory.getLog(TaskExtendFieldUtil.class);
    private static final String[] DEFAULT_BUSINESSFIELD = new String[]{"biz_date", "biz_number", "biz_str1", "biz_str2", "biz_date2", "biz_number2", "biz_strmul1", "biz_strmul2"};
    private static final String[] BUSINESSMULFIELD = new String[]{"biz_strmul1", "biz_strmul2"};

    public static Object getDateFormaByEntityNumber(String entityNumber, String fieldName, String property) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadata = metaService.loadClientFormMeta(entityNumber);
        JSONObject json = (JSONObject)SerializationUtils.fromJsonString((String)metadata, JSONObject.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (json.get((Object)STR_ITEMS) != null) {
            TaskExtendFieldUtil.getPropertyByFieldName(json.get((Object)STR_ITEMS), fieldName, map);
            if (!map.isEmpty()) {
                Map item = (Map)map.get(STR_ITEM);
                return item.get(property);
            }
        }
        return null;
    }

    private static void getPropertyByFieldName(Object jsonObj, String fieldName, Map<String, Object> result) {
        if (jsonObj instanceof List) {
            List obj = (List)jsonObj;
            for (Map map : obj) {
                Object item = map.get(STR_ITEMS);
                if (item != null) {
                    TaskExtendFieldUtil.getPropertyByFieldName(item, fieldName, result);
                }
                if (map.get(STR_ITEM) == null || !fieldName.equals((String)map.get("id"))) continue;
                result.putAll(map);
            }
        }
    }

    @Deprecated
    public static Object formatValue(Object value, Map<String, Object> formatInfo) {
        if (StringUtils.isBlank((Object)value) || formatInfo == null || formatInfo.isEmpty()) {
            return value;
        }
        Object copyValue = value;
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        String type = (String)formatInfo.get("type");
        int scale = formatInfo.get("scale") != null ? (Integer)formatInfo.get("scale") : 0;
        String zeroShow = formatInfo.get("zeroShow") != null ? String.valueOf(formatInfo.get("zeroShow")) : "false";
        FormatTypes formatTypes = null;
        if ("dateProp".equals(type)) {
            formatTypes = FormatTypes.Date;
            Object format = formatInfo.get("format");
            Object regionType = formatInfo.get("regionType");
            Object mask = formatInfo.get("mask");
            DateFormatObject userSettingDateFormat = formatObject.getDateFormat();
            Object dateFormat = StringUtils.isNotBlank((Object)format) ? formatInfo.get("format") : (StringUtils.isNotBlank((Object)mask) ? formatInfo.get("mask") : (StringUtils.isNotBlank((Object)regionType) && 2 == (Integer)regionType ? userSettingDateFormat.getDateFormat() + " " + formatObject.getTimeFormat().getTimeFormat() : userSettingDateFormat.getDateFormat()));
            formatObject.getDateFormat().setDateFormat((String)dateFormat);
        } else if ("qtyProp".equals(type) || "numberProp".equals(type)) {
            formatTypes = FormatTypes.Number;
            formatObject.getNumberFormat().setMinimumFractionDigits(scale);
            formatObject.getNumberFormat().setZeroShow(zeroShow);
        } else if ("amountProp".equals(type)) {
            Object currencySign;
            formatTypes = FormatTypes.Currency;
            Object currencyNumber = formatInfo.get("currencyNumber");
            if (StringUtils.isNotBlank((Object)currencyNumber)) {
                formatObject.getCurrencyFormat().setCurrencyNumber((String)currencyNumber);
            }
            if (StringUtils.isNotBlank((Object)(currencySign = formatInfo.get("currencySign")))) {
                formatObject.getCurrencyFormat().setCurrencySymbols((String)currencySign);
            }
            formatObject.getCurrencyFormat().setMinimumFractionDigits(scale);
            formatObject.getCurrencyFormat().setZeroShow(zeroShow);
        } else {
            if (copyValue instanceof BigDecimal && ((BigDecimal)copyValue).doubleValue() == 0.0) {
                return null;
            }
            return value;
        }
        try {
            Format format = FormatFactory.get((FormatTypes)formatTypes).getFormat(formatObject);
            Object object = value = format == null ? value : format.format(value);
            if ("false".equals(zeroShow) && copyValue instanceof BigDecimal && ((BigDecimal)copyValue).doubleValue() == 0.0) {
                return null;
            }
        }
        catch (Exception e) {
            logger.info("format value is error:" + value + e.getMessage());
        }
        return value;
    }

    public static Object formatValue(Object value, Map<String, Object> formatInfo, FormatObject formatObject) {
        if (StringUtils.isBlank((Object)value) || formatInfo == null || formatInfo.isEmpty()) {
            return value;
        }
        FormatObject tmpFormatObject = new FormatObject();
        Object copyValue = value;
        String type = (String)formatInfo.get("type");
        int scale = formatInfo.get("scale") != null ? (Integer)formatInfo.get("scale") : 0;
        String zeroShow = formatInfo.get("zeroShow") != null ? String.valueOf(formatInfo.get("zeroShow")) : "false";
        FormatTypes formatTypes = null;
        if ("dateProp".equals(type)) {
            formatTypes = FormatTypes.Date;
            Object format = formatInfo.get("format");
            Object regionType = formatInfo.get("regionType");
            Object mask = formatInfo.get("mask");
            DateFormatObject userSettingDateFormat = formatObject.getDateFormat();
            Object dateFormat = StringUtils.isNotBlank((Object)format) ? formatInfo.get("format") : (StringUtils.isNotBlank((Object)mask) ? formatInfo.get("mask") : (StringUtils.isNotBlank((Object)regionType) && 2 == (Integer)regionType ? userSettingDateFormat.getDateFormat() + " " + formatObject.getTimeFormat().getTimeFormat() : userSettingDateFormat.getDateFormat()));
            DateFormatObject tmp = new DateFormatObject((String)dateFormat, userSettingDateFormat.getTimeArea(), userSettingDateFormat.getLocaleStr());
            tmpFormatObject.setDateFormat(tmp);
        } else if ("qtyProp".equals(type) || "numberProp".equals(type)) {
            formatTypes = FormatTypes.Number;
            NumberFormatObject userSettingNumberFormat = formatObject.getNumberFormat();
            NumberFormatObject tmp = new NumberFormatObject(userSettingNumberFormat.getDecimalPoint(), userSettingNumberFormat.getNumSeparator(), zeroShow, userSettingNumberFormat.getNumGroupFormat(), userSettingNumberFormat.getNegativeFormat());
            tmp.setGroupingUsed(userSettingNumberFormat.isGroupingUsed());
            tmp.setMaximumFractionDigits(userSettingNumberFormat.getMaximumFractionDigits());
            tmp.setMinimumFractionDigits(scale);
            tmpFormatObject.setNumberFormat(tmp);
        } else if ("amountProp".equals(type)) {
            Object currencySign;
            formatTypes = FormatTypes.Currency;
            CurrencyFormatObject userSettingCurrencyFormat = formatObject.getCurrencyFormat();
            CurrencyFormatObject tmp = new CurrencyFormatObject(userSettingCurrencyFormat.getCnyShowPrefix(), userSettingCurrencyFormat.getCurrPosFormat(), userSettingCurrencyFormat.getDecimalPoint(), userSettingCurrencyFormat.getNumSeparator(), zeroShow, userSettingCurrencyFormat.getNumGroupFormat(), userSettingCurrencyFormat.getNegativeFormat());
            Object currencyNumber = formatInfo.get("currencyNumber");
            if (StringUtils.isNotBlank((Object)currencyNumber)) {
                tmp.setCurrencyNumber((String)currencyNumber);
            }
            if (StringUtils.isNotBlank((Object)(currencySign = formatInfo.get("currencySign")))) {
                tmp.setCurrencySymbols((String)currencySign);
            }
            tmp.setGroupingUsed(userSettingCurrencyFormat.isGroupingUsed());
            tmp.setMaximumFractionDigits(userSettingCurrencyFormat.getMaximumFractionDigits());
            tmp.setMinimumFractionDigits(scale);
            tmpFormatObject.setCurrencyFormat(tmp);
        } else {
            if (copyValue instanceof BigDecimal && ((BigDecimal)copyValue).doubleValue() == 0.0) {
                return null;
            }
            return value;
        }
        try {
            Format format = FormatFactory.get((FormatTypes)formatTypes).getFormat(tmpFormatObject);
            Object object = value = format == null ? value : format.format(value);
            if ("false".equals(zeroShow) && copyValue instanceof BigDecimal && ((BigDecimal)copyValue).doubleValue() == 0.0) {
                return null;
            }
        }
        catch (Exception e) {
            logger.info("format value is error:" + value + e.getMessage());
        }
        return value;
    }

    public static void setExtendTaskBusinessField(DynamicObject target, DynamicObject source) {
        if (target == null || source == null) {
            return;
        }
        try {
            if (WfConfigurationUtil.isAllowExtendTaskFields().booleanValue()) {
                String isv = AppMetaServiceHelper.getDeveloperInfo();
                StringJoiner sj = new StringJoiner("_");
                sj.add(isv).add("biz");
                DataEntityPropertyCollection properties = source.getDataEntityType().getProperties();
                properties.forEach(p -> {
                    if (p.getName().contains(sj.toString()) && STR_A.equals(p.getTableGroup())) {
                        target.set(p.getName(), source.get(p.getName()));
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("WfUtils_setExtendTaskBusinessField:\u4efb\u52d9\u5be6\u9ad4\u8a2d\u7f6e\u4e8c\u958b\u7684\u696d\u52d9\u5b57\u6bb5\u51fa\u932f\uff0c\u8acb\u6aa2\u67e5:" + e.getMessage());
        }
    }

    public static String getExtBusinessFieldByEntityNumber(String entityNumber) {
        StringJoiner extBusinessFieldStr = new StringJoiner(",");
        if (WfUtils.isNotEmpty(entityNumber) && WfConfigurationUtil.isAllowExtendTaskFields().booleanValue()) {
            String isv = AppMetaServiceHelper.getDeveloperInfo();
            StringJoiner sj = new StringJoiner("_");
            sj.add(isv).add("biz");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            dataEntityType.getProperties().forEach(p -> {
                if (p.getName().contains(sj.toString()) && STR_A.equals(p.getTableGroup())) {
                    extBusinessFieldStr.add(p.getName());
                }
            });
        }
        if (extBusinessFieldStr.length() > 0) {
            return "," + extBusinessFieldStr.toString();
        }
        return extBusinessFieldStr.toString();
    }

    public static JSONObject getTaskBusinessSelectFields(String entityNumber, String tableAlias) {
        return TaskExtendFieldUtil.getTaskBusinessSelectFields(entityNumber, null, tableAlias, null, null);
    }

    public static JSONObject getTaskBusinessSelectFields(String entityNumber, String billEntityNumber, String tableAlias, String mulTableAlias, String groupTableAlias) {
        JSONObject result = new JSONObject();
        JSONObject fieldRelateFormatField = new JSONObject();
        JSONObject businessFiledMap = new JSONObject();
        StringBuilder sb = new StringBuilder();
        if (WfUtils.isNotEmpty(entityNumber)) {
            Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map allFields = dataEntityType.getAllFields();
            Map<String, String> notRepairedBusinessMappingField = TaskExtendFieldUtil.getNotRepairedBusinessMappingField(entityNumber, billEntityNumber);
            String isv = AppMetaServiceHelper.getDeveloperInfo();
            for (Map.Entry entry : allFields.entrySet()) {
                if (!TaskExtendFieldUtil.isBusinessMappingField((IDataEntityProperty)entry.getValue()) && (!allowExtendTaskFields.booleanValue() || !TaskExtendFieldUtil.isBusinessMappingExtField(isv, (IDataEntityProperty)entry.getValue())) || notRepairedBusinessMappingField.containsKey(entry.getKey())) continue;
                businessFiledMap.put((String)entry.getKey(), entry.getKey());
                IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
                if (ArrayUtils.contains((Object[])BUSINESSMULFIELD, entry.getKey())) {
                    sb.append(WfMultiLangUtils.getGeneralLangSQL(entityNumber, tableAlias, mulTableAlias, property.getAlias(), (String)entry.getKey(), (String)entry.getKey())).append(",");
                } else {
                    sb.append(((IDataEntityProperty)entry.getValue()).getTableGroup() != null ? groupTableAlias : tableAlias);
                    sb.append(".").append(property.getAlias()).append(" ").append((String)entry.getKey()).append(", ");
                }
                if (!(property instanceof DecimalProp) && !(property instanceof DateTimeProp)) continue;
                sb.append(tableAlias).append(".").append("fbillno").append(" ").append((String)entry.getKey()).append(STR_FORMAT).append(", ");
                fieldRelateFormatField.put((String)entry.getKey(), (Object)((String)entry.getKey() + STR_FORMAT));
            }
        }
        result.put("fieldRelateFormatField", (Object)fieldRelateFormatField);
        result.put("taskBusinessFieldStr", (Object)sb.toString());
        result.put("businessFiledMap", (Object)businessFiledMap);
        return result;
    }

    public static boolean isNeedQueryBusinessField(String entitynumber) {
        String fields = WfCacheHelper.getBusinessField(entitynumber);
        return !WfUtils.isEmpty(fields);
    }

    public static JSONObject getTaskBusinessEntityFields(String entityNumber, String billEntityNumber) {
        JSONObject result = new JSONObject();
        JSONObject fieldRelateFormatField = new JSONObject();
        JSONObject businessFiledMap = new JSONObject();
        StringBuilder sb = new StringBuilder();
        if (WfUtils.isNotEmpty(entityNumber)) {
            Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map allFields = dataEntityType.getAllFields();
            Map<String, String> notRepairedBusinessMappingField = TaskExtendFieldUtil.getNotRepairedBusinessMappingField(entityNumber, billEntityNumber);
            for (Map.Entry entry : allFields.entrySet()) {
                if (!TaskExtendFieldUtil.isBusinessMappingField((IDataEntityProperty)entry.getValue()) && (!allowExtendTaskFields.booleanValue() || !TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)entry.getValue())) || notRepairedBusinessMappingField.containsKey(entry.getKey())) continue;
                businessFiledMap.put((String)entry.getKey(), entry.getKey());
                IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
                sb.append((String)entry.getKey()).append(",");
                if (!(property instanceof DecimalProp) && !(property instanceof DateTimeProp)) continue;
                sb.append("billno").append(" ").append((String)entry.getKey()).append(STR_FORMAT).append(", ");
                fieldRelateFormatField.put((String)entry.getKey(), (Object)((String)entry.getKey() + STR_FORMAT));
            }
        }
        result.put("fieldRelateFormatField", (Object)fieldRelateFormatField);
        result.put("taskBusinessFieldStr", (Object)sb.toString());
        result.put("businessFiledMap", (Object)businessFiledMap);
        return result;
    }

    @Deprecated
    public static void formatTaskBusinessFieldVlue(DynamicObject dynObject, JSONObject params) {
        String bizFormat = dynObject.getString("bizformat");
        Map map = (Map)SerializationUtils.fromJsonString((String)bizFormat, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (entry.getValue() == null || !params.containsKey((Object)key)) continue;
            Map formatInfo = (Map)entry.getValue();
            Object formatValue = TaskExtendFieldUtil.formatValue(dynObject.get(key), formatInfo);
            if (params.get((Object)key) == null) continue;
            dynObject.set((String)params.get((Object)key), formatValue);
        }
    }

    public static void formatTaskBusinessFieldVlue(DynamicObject dynObject, JSONObject params, FormatObject formatObject) {
        String bizFormat = dynObject.getString("bizformat");
        Map map = (Map)SerializationUtils.fromJsonString((String)bizFormat, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (entry.getValue() == null || !params.containsKey((Object)key)) continue;
            Map formatInfo = (Map)entry.getValue();
            Object formatValue = TaskExtendFieldUtil.formatValue(dynObject.get(key), formatInfo, formatObject);
            if (params.get((Object)key) == null) continue;
            dynObject.set((String)params.get((Object)key), formatValue);
        }
    }

    public static final boolean isBusinessMappingField(IDataEntityProperty p) {
        if (p != null) {
            return ArrayUtils.contains((Object[])DEFAULT_BUSINESSFIELD, (Object)p.getName());
        }
        return false;
    }

    public static final boolean isBusinessMappingExtField(String isv, IDataEntityProperty p) {
        if (p != null) {
            return STR_A.equals(p.getTableGroup()) && p.getName().contains(isv + "_biz_") && (p.getClass().isAssignableFrom(DecimalProp.class) || DateTimeProp.class.isAssignableFrom(p.getClass()) || p.getClass().isAssignableFrom(TextProp.class) && !p.getName().endsWith("_tag"));
        }
        return false;
    }

    @Deprecated
    public static final boolean isBusinessMappingExtField(IDataEntityProperty p) {
        String isv = AppMetaServiceHelper.getDeveloperInfo();
        return TaskExtendFieldUtil.isBusinessMappingExtField(isv, p);
    }

    public static boolean isRepaireParticipantFinish(String entityNumber) {
        Map entityMap;
        Map tempMap;
        Object entityObj;
        String configCenterVal;
        return !WfUtils.isNotEmpty(entityNumber) || (configCenterVal = WfConfigurationUtil.getNeedUpdateExtFieldEntitynumbers()) == null || !((entityObj = (tempMap = (Map)Optional.ofNullable(SerializationUtils.fromJsonString((String)configCenterVal, Map.class)).orElseGet(HashMap::new)).get(entityNumber)) instanceof Map) || (entityMap = (Map)entityObj).get("wf_participant") == null;
    }

    public static Map<String, String> getNotRepairedBusinessMappingField(String scope, String entityNumber) {
        String configCenterVal;
        if (StringUtils.isNotBlank((CharSequence)scope) && StringUtils.isNotBlank((CharSequence)entityNumber) && StringUtils.isNotBlank((Object)(configCenterVal = WfConfigurationUtil.getNeedUpdateExtFieldEntitynumbers()))) {
            Map entityMap;
            String currentScope = scope.equalsIgnoreCase("wf_hicomment") ? "wf_hitaskinst" : scope;
            Map tempMap = (Map)Optional.ofNullable(SerializationUtils.fromJsonString((String)configCenterVal, Map.class)).orElseGet(HashMap::new);
            Object entityObj = tempMap.get(entityNumber);
            if (entityObj instanceof Map && (entityMap = (Map)entityObj).get(currentScope) != null) {
                Map tMap = (Map)entityMap.get(currentScope);
                return tMap;
            }
        }
        return Collections.emptyMap();
    }

    public static Boolean isSpecialPropNeedRemove(String entityNumber, IDataEntityProperty fieldProp) {
        if (fieldProp == null) {
            return Boolean.FALSE;
        }
        if (("wf_task".equals(entityNumber) || "wf_hitaskinst".equals(entityNumber) || "wf_hicomment".equals(entityNumber)) && (TaskExtendFieldUtil.isBusinessMappingField(fieldProp) || TaskExtendFieldUtil.isBusinessMappingExtField(fieldProp) || "bizformat".equals(fieldProp.getName()))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Map<String, IDataEntityProperty> filterTaskBusinessField(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || !"wf_task".equals(entityNumber) && !"wf_hitaskinst".equals(entityNumber) && !"wf_hicomment".equals(entityNumber)) {
            return Collections.emptyMap();
        }
        HashMap<String, IDataEntityProperty> afterFilter = new HashMap<String, IDataEntityProperty>(50);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainType.getAllFields();
        allFields.forEach((key, property) -> {
            if (!TaskExtendFieldUtil.isSpecialPropNeedRemove(entityNumber, property).booleanValue()) {
                afterFilter.put((String)key, (IDataEntityProperty)property);
            }
        });
        return afterFilter;
    }
}

