/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.nocode.express.NoCodeExpBillCtx;
import kd.bos.nocode.express.NoCodeExpCtx;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.nocode.NoCodeBillInfo;
import kd.bos.workflow.nocode.NoCodeExpressionType;
import kd.bos.workflow.nocode.converter.INoCodeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeJsonConverterFactory;

public class NoCodeFlowUtil {
    private static Log log = LogFactory.getLog(NoCodeFlowUtil.class);

    public static JSONObject convertNoCodeJsonToWorkflowJson(JSONObject noCodeJson) {
        INoCodeJsonConverter processConverter = NoCodeJsonConverterFactory.getConverter("BPMNDiagram");
        NoCodeJsonConvertContext context = new NoCodeJsonConvertContext();
        return processConverter.convertToWorkflowJson(context, noCodeJson);
    }

    public static JSONObject convertWorkflowJsonToNoCodeJson(JSONObject workflowJson) {
        INoCodeJsonConverter processConverter = NoCodeJsonConverterFactory.getConverter("BPMNDiagram");
        NoCodeJsonConvertContext context = new NoCodeJsonConvertContext();
        return processConverter.convertToNoCodeJson(context, workflowJson);
    }

    public static Object parseNoCodeCommonExpression(String expression, VariableScope scope, boolean userFormat, DynamicObject dynObj) {
        return NoCodeFlowUtil.parseNoCodeExpression(expression, scope, userFormat, dynObj, NoCodeExpressionType.COMMONEXPRESSION);
    }

    public static String parseNoCodeContentExpression(String expression, VariableScope scope, boolean userFormat, DynamicObject dynObj) {
        return String.valueOf(NoCodeFlowUtil.parseNoCodeExpression(expression, scope, userFormat, dynObj, NoCodeExpressionType.CONTENTEXPRESSION));
    }

    public static boolean parseNoCodeConditionExpression(String expression, VariableScope scope, boolean userFormat) {
        Object ret;
        NoCodeBillInfo billInfo = NoCodeFlowUtil.getNoCodeBillInfo(scope);
        DynamicObject dynObj = null;
        if (WfUtils.isNotEmpty(billInfo.getEntityNumber()) && WfUtils.isNotEmpty(billInfo.getBusinessKey())) {
            dynObj = WfUtils.findBusinessObject(billInfo.getBusinessKey(), billInfo.getEntityNumber());
        }
        if ((ret = NoCodeFlowUtil.parseNoCodeExpression(expression, scope, userFormat, dynObj, NoCodeExpressionType.CONDITIONEXPRESSION)) instanceof Boolean) {
            return (Boolean)ret;
        }
        return false;
    }

    private static Object parseNoCodeExpression(String expression, VariableScope scope, boolean userFormat, DynamicObject dynObj, NoCodeExpressionType expressionType) {
        String content = expression;
        Pattern pattern = Pattern.compile(String.format("(%s)", "\\$?\\{\\s*proc\\..+?\\}"));
        Matcher matcher = pattern.matcher(expression);
        HashMap<String, String> expressionMap = new HashMap<String, String>(16);
        while (matcher.find()) {
            String exp = matcher.group();
            expressionMap.put(exp, ExpressionCalculatorUtil.parseContent(exp, dynObj, scope, null, userFormat));
        }
        int size = expressionMap.size();
        if (size > 0) {
            for (Map.Entry entry : expressionMap.entrySet()) {
                String key = ((String)entry.getKey()).replace("$", "\\$").replace("{", "\\{").replace("}", "\\}");
                String val = entry.getValue() != null ? String.valueOf(entry.getValue()) : "";
                content = content.replaceAll(key, val.replace("$", "\\$"));
            }
        }
        content = content.replaceFirst("#NOCODE#", "");
        String entityNumber = null;
        String businessKey = null;
        try {
            NoCodeBillInfo billInfo = NoCodeFlowUtil.getNoCodeBillInfo(scope);
            entityNumber = billInfo.getEntityNumber();
            businessKey = billInfo.getBusinessKey();
            Object result = NoCodeFlowUtil.getNoCodeExpressionValue(content, dynObj, entityNumber, businessKey, expressionType);
            log.debug(String.format("getNoCodeExpressionValue, expression: %s, entityNumber: %s, businessKey: %s, expressionResult: %s", expression, entityNumber, businessKey, result));
            return result;
        }
        catch (Exception e) {
            log.error(String.format("NoCodeRuntimeService parse expression failed. %s %s %s %s", expression, entityNumber, businessKey, WfUtils.getExceptionStacktrace(e)));
            return content;
        }
    }

    private static Object getNoCodeExpressionValue(final String expression, final DynamicObject dynObj, final String entityNumber, final String businessKey, NoCodeExpressionType expressionType) {
        NoCodeExpBillCtx ctx = new NoCodeExpBillCtx(){

            public Object getVarValue(String key) {
                if (dynObj.containsProperty(key)) {
                    return dynObj.get(key);
                }
                return key;
            }

            public String getExpression() {
                return expression;
            }

            public Object getPkId() {
                return businessKey;
            }

            public String getEntityNumber() {
                return entityNumber;
            }
        };
        NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        switch (expressionType) {
            case CONTENTEXPRESSION: {
                return service.getNotifyExpression((NoCodeExpCtx)ctx);
            }
            case CONDITIONEXPRESSION: {
                return service.getConditionExpressionValue((NoCodeExpCtx)ctx);
            }
        }
        return service.getExpressionValue((NoCodeExpCtx)ctx);
    }

    private static NoCodeBillInfo getNoCodeBillInfo(VariableScope scope) {
        String entityNumber = null;
        String businessKey = null;
        if (scope instanceof ExecutionEntity) {
            entityNumber = ((ExecutionEntity)scope).getEntityNumber();
            businessKey = ((ExecutionEntity)scope).getBusinessKey();
        } else if (scope instanceof TaskEntity) {
            ExecutionEntity execution = ((TaskEntity)scope).getExecution();
            entityNumber = execution.getEntityNumber();
            businessKey = execution.getBusinessKey();
        } else {
            entityNumber = (String)GraphCodecUtils.safeGetPropertyValue(scope, "entityNumber");
            businessKey = (String)GraphCodecUtils.safeGetPropertyValue(scope, "businessKey");
        }
        return new NoCodeBillInfo(entityNumber, businessKey);
    }

    public static Map<Long, String> getProcessDefinitionInfoByProcessCode(String processCode) {
        HashMap<Long, String> processDefinitionMap = new HashMap<Long, String>(1);
        QFilter qFilter = new QFilter("key", "=", (Object)processCode);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"wf_processdefinition", (String)"id,name", (QFilter[])new QFilter[]{qFilter}, (String)"createdate asc");
        if (WfUtils.isEmptyForArrays(objects)) {
            return processDefinitionMap;
        }
        for (DynamicObject obj : objects) {
            String name = WfMultiLangUtils.getValueFromLocalString(obj.getLocaleString("name"), RequestContext.get().getLang().toString());
            processDefinitionMap.put(obj.getLong("id"), name);
        }
        return processDefinitionMap;
    }

    public static boolean hasNoCodeLicense() {
        if (RequestContext.get() == null) {
            return false;
        }
        LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)640L);
        return licenseCheckResult != null ? licenseCheckResult.getHasLicense() : false;
    }
}

