/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class NoCodeParticipantParser
implements IWorkflowPlugin {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_FORMAT = "%s:%s";
    private static final String KEY_BILLID = "billId";
    private static final String KEY_FIELDS = "fields";
    private static final String KEY_PERSONRELATION = "personRelation";
    private static final String KEY_ORGRELATION = "orgRelation";
    private static final String KEY_PARTICIPANT_ENTITYPREFIX = "ENTI_%s";
    private static final String KEY_PARTICIPANT_ID = "id";
    private static final String KEY_PARTICIPANT_TYPE = "type";
    private static final String KEY_PARTICIPANT_VALUE = "value";
    private static final String KEY_PARTICIPANT_PROPERTY = "property";
    private static final String KEY_PARTICIPANT_RELATIONTYPE = "relationType";
    private static final String KEY_PARTICIPANT_REFERENCEPERSON = "referencePerson";
    private static final String KEY_PARTICIPANT_REPORTTYPE = "reportType";
    private static final String KEY_PARTICIPANT_PERSONRELATION = "personRelation";
    private static final String KEY_PARTICIPANT_REFERENCEORG = "referenceOrg";
    private static final String KEY_PARTICIPANT_ORGRELATION = "orgRelation";
    private static final String KEY_PARTICIPANT_TYPE_RELATION = "relation";
    private static final String KEY_PARTICIPANT_RELATIONTYPE_ORG = "org";
    private static final String KEY_PARTICIPANT_RELATIONTYPE_PERSON = "person";

    public List<Long> calcUserIds(AgentExecution execution, DynamicObject pme, DynamicObject businessModel) {
        Object participants;
        String entityBillId;
        JSONObject item;
        String key;
        ArrayList<Long> result = new ArrayList<Long>(32);
        ExecutionEntity executionEntity = null;
        if (execution instanceof ExecutionEntity) {
            executionEntity = (ExecutionEntity)execution;
        }
        if (businessModel == null) {
            businessModel = WfUtils.findBusinessObject(execution.getBusinessKey(), execution.getEntityNumber());
        }
        String value = pme.getString(KEY_PARTICIPANT_VALUE);
        this.log.debug(String.format("parser nocode extend participant: %s", value));
        JSONObject extendParticipant = JSON.parseObject((String)value);
        JSONObject participant = extendParticipant.getJSONObject("participant");
        String property = participant.getString(KEY_PARTICIPANT_PROPERTY);
        JSONObject personRelation = participant.getJSONObject("personRelation");
        JSONObject orgRelation = participant.getJSONObject("orgRelation");
        JSONObject personConfig = new JSONObject();
        if (personRelation != null) {
            this.handleParticipantRelation(executionEntity, businessModel, personRelation, personConfig, "oneself");
            this.handleParticipantRelation(executionEntity, businessModel, personRelation, personConfig, "indirectSuperior");
            this.handleParticipantRelation(executionEntity, businessModel, personRelation, personConfig, "superior");
            this.handleParticipantRelation(executionEntity, businessModel, personRelation, personConfig, "equal");
            this.handleParticipantRelation(executionEntity, businessModel, personRelation, personConfig, "subordinate");
        }
        this.log.debug(String.format("personConfig: %s", personConfig));
        JSONObject orgConfig = new JSONObject();
        if (orgRelation != null) {
            this.handleParticipantRelation(executionEntity, businessModel, orgRelation, orgConfig, "all");
            this.handleParticipantRelation(executionEntity, businessModel, orgRelation, orgConfig, "manager");
            this.handleParticipantRelation(executionEntity, businessModel, orgRelation, orgConfig, "direct");
        }
        this.log.debug(String.format("orgConfig: %s", orgConfig));
        JSONObject ret = new JSONObject();
        for (Object entry : personConfig.entrySet()) {
            key = (String)entry.getKey();
            item = ret.getJSONObject(key);
            if (item == null) {
                item = new JSONObject();
                ret.put(key, (Object)item);
            }
            item.put("personRelation", entry.getValue());
        }
        for (Object entry : orgConfig.entrySet()) {
            key = (String)entry.getKey();
            item = ret.getJSONObject(key);
            if (item == null) {
                item = new JSONObject();
                ret.put(key, (Object)item);
            }
            item.put("orgRelation", entry.getValue());
        }
        this.log.debug(String.format("ret: %s", ret));
        HashMap<String, List> participantMap = new HashMap<String, List>(ret.size());
        for (Map.Entry entry : ret.entrySet()) {
            Object orgRelConfig;
            entityBillId = (String)entry.getKey();
            JSONObject config = (JSONObject)entry.getValue();
            participants = new JSONArray();
            JSONObject personRelConfig = config.getJSONObject("personRelation");
            if (personRelConfig != null && !personRelConfig.isEmpty()) {
                this.addPersonRelationParticipants((JSONArray)participants, personRelConfig, "oneself", property);
                this.addPersonRelationParticipants((JSONArray)participants, personRelConfig, "indirectSuperior", property);
                this.addPersonRelationParticipants((JSONArray)participants, personRelConfig, "superior", property);
                this.addPersonRelationParticipants((JSONArray)participants, personRelConfig, "equal", property);
                this.addPersonRelationParticipants((JSONArray)participants, personRelConfig, "subordinate", property);
            }
            if ((orgRelConfig = config.getJSONObject("orgRelation")) != null && !orgRelConfig.isEmpty()) {
                this.addOrgRelationParticipants((JSONArray)participants, (JSONObject)orgRelConfig, "all", property);
                this.addOrgRelationParticipants((JSONArray)participants, (JSONObject)orgRelConfig, "manager", property);
                this.addOrgRelationParticipants((JSONArray)participants, (JSONObject)orgRelConfig, "direct", property);
            }
            if (participants.isEmpty()) continue;
            List entities = JSON.parseArray((String)participants.toJSONString(), ParticipantModelEntityImpl.class);
            participantMap.put(entityBillId, entities);
        }
        JSONArray appRole = participant.getJSONArray("appRole");
        if (appRole != null && !appRole.isEmpty()) {
            JSONArray roleOrgParticipants = new JSONArray();
            entityBillId = String.format(KEY_FORMAT, execution.getEntityNumber(), execution.getBusinessKey());
            for (Object roleId : appRole) {
                RolePerm noCodeRole = NoCodePermissionServiceHelper.getRolePerm((String)String.valueOf(roleId));
                if (noCodeRole == null) {
                    this.log.debug(String.format("role %s has no personnel.", roleId));
                    continue;
                }
                this.log.debug(String.format("roleId: %s, Role UserIds: %s", roleId, noCodeRole.getAssignUserIds()));
                result.addAll(noCodeRole.getAssignUserIds());
                this.log.debug(String.format("roleId: %s, Role OrgIds: %s", roleId, noCodeRole.getAssignOrgIds()));
                for (Long orgId : noCodeRole.getAssignOrgIds()) {
                    roleOrgParticipants.add((Object)this.createFixedOrgAllStaffParticipantJson(orgId, property));
                }
            }
            if (!roleOrgParticipants.isEmpty()) {
                this.log.debug(String.format("Parsing Organizations in Roles: %s", roleOrgParticipants));
                List entities = JSON.parseArray((String)roleOrgParticipants.toJSONString(), ParticipantModelEntityImpl.class);
                participants = (List)participantMap.get(entityBillId);
                if (participants == null) {
                    participantMap.put(entityBillId, entities);
                } else {
                    participants.addAll(entities);
                }
            }
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        for (Map.Entry entry : participantMap.entrySet()) {
            String key2 = (String)entry.getKey();
            String[] items = key2.split(":");
            if (items.length < 2) continue;
            String entityNumber = items[0];
            String businessKey = items[1];
            BusinessModelVariableScope variableScope = new BusinessModelVariableScope(businessKey, entityNumber);
            List<Long> userIds = service.getRuntimeService().getUserIdsByCalculate(businessKey, variableScope, (List)entry.getValue());
            this.log.debug(String.format("entityNumber: %s, businessKey: %s, getUserIdsByCalculate: %s", entityNumber, businessKey, userIds));
            result.addAll(userIds);
        }
        return result;
    }

    private void handleParticipantRelation(ExecutionEntity executionEntity, DynamicObject businessModel, JSONObject participantRelation, JSONObject relationConfig, String relationType) {
        JSONObject relation = participantRelation.getJSONObject(relationType);
        if (relation == null || relation.isEmpty()) {
            return;
        }
        for (Map.Entry entry : relation.entrySet()) {
            String entityNumber = (String)entry.getKey();
            JSONArray datas = (JSONArray)entry.getValue();
            for (Object item : datas) {
                String[] ids;
                JSONObject data = (JSONObject)item;
                JSONArray fields = data.getJSONArray(KEY_FIELDS);
                String billId = data.getString(KEY_BILLID);
                String businessKey = null;
                String expression = billId.replace("$", "");
                businessKey = "${execution.businessKey}".equals(billId) ? executionEntity.getBusinessKey() : ExpressionCalculatorUtil.parseContent(expression, businessModel, executionEntity, null, false);
                if (WfUtils.isEmpty(businessKey)) {
                    KDException exception = new KDException(WFErrorCode.participantParseError(), new Object[]{this.getNullBusinessKeyExceptionMsg(entityNumber, executionEntity.getProcessInstanceId())});
                    this.log.debug(WfUtils.getExceptionStacktrace(exception));
                }
                for (String id : ids = businessKey.split(",")) {
                    JSONArray cfgs;
                    String key = String.format(KEY_FORMAT, entityNumber, id);
                    JSONObject config = relationConfig.getJSONObject(key);
                    if (config == null) {
                        config = new JSONObject();
                        relationConfig.put(key, (Object)config);
                    }
                    if ((cfgs = config.getJSONArray(relationType)) == null) {
                        cfgs = new JSONArray();
                        config.put(relationType, (Object)cfgs);
                    }
                    cfgs.addAll((Collection)fields);
                }
            }
        }
    }

    private void addPersonRelationParticipants(JSONArray participants, JSONObject personRelation, String relationType, String property) {
        JSONArray personFields = personRelation.getJSONArray(relationType);
        if (personFields == null || personFields.isEmpty()) {
            return;
        }
        for (Object personField : personFields) {
            switch (relationType) {
                case "oneself": {
                    participants.add((Object)this.createPersonRelationSelfParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, personField), property));
                    break;
                }
                case "indirectSuperior": {
                    participants.add((Object)this.createPersonRelationIndirectSuperiorParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, personField), property));
                    break;
                }
                case "superior": {
                    participants.add((Object)this.createPersonRelationSuperiorParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, personField), property));
                    break;
                }
                case "equal": {
                    participants.add((Object)this.createPersonRelationEqualParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, personField), property));
                    break;
                }
                case "subordinate": {
                    participants.add((Object)this.createPersonRelationSubordinateParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, personField), property));
                    break;
                }
            }
        }
    }

    private JSONObject createPersonRelationSelfParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "self", property);
    }

    private JSONObject createPersonRelationIndirectSuperiorParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "indirectSuperior", property);
    }

    private JSONObject createPersonRelationSuperiorParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "superior", property);
    }

    private JSONObject createPersonRelationEqualParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "equal", property);
    }

    private JSONObject createPersonRelationSubordinateParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "subordinate", property);
    }

    private JSONObject createPersonRelationParticipantJson(String referencePerson, String personRelation, String property) {
        JSONObject participant = new JSONObject();
        participant.put(KEY_PARTICIPANT_ID, (Object)BpmnDiffUtil.getListElementId("participant"));
        participant.put(KEY_PARTICIPANT_TYPE, (Object)KEY_PARTICIPANT_TYPE_RELATION);
        participant.put(KEY_PARTICIPANT_RELATIONTYPE, (Object)KEY_PARTICIPANT_RELATIONTYPE_PERSON);
        participant.put(KEY_PARTICIPANT_REFERENCEPERSON, (Object)referencePerson);
        participant.put("personRelation", (Object)personRelation);
        participant.put(KEY_PARTICIPANT_REPORTTYPE, (Object)"admin_org");
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        return participant;
    }

    private void addOrgRelationParticipants(JSONArray participants, JSONObject orgRelation, String relationType, String property) {
        JSONArray orgFields = orgRelation.getJSONArray(relationType);
        if (orgFields != null && !orgFields.isEmpty()) {
            for (Object orgField : orgFields) {
                switch (relationType) {
                    case "all": {
                        participants.add((Object)this.createOrgRelationAllStaffParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, orgField), property));
                        break;
                    }
                    case "manager": {
                        participants.add((Object)this.createOrgRelationManagerParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, orgField), property));
                        break;
                    }
                    case "direct": {
                        participants.add((Object)this.createOrgRelationDirectParticipantJson(String.format(KEY_PARTICIPANT_ENTITYPREFIX, orgField), property));
                        break;
                    }
                }
            }
        }
    }

    private JSONObject createFixedOrgAllStaffParticipantJson(Long orgId, String property) {
        JSONObject participant = new JSONObject();
        participant.put(KEY_PARTICIPANT_ID, (Object)BpmnDiffUtil.getListElementId("participant"));
        participant.put(KEY_PARTICIPANT_TYPE, (Object)KEY_PARTICIPANT_TYPE_RELATION);
        participant.put(KEY_PARTICIPANT_RELATIONTYPE, (Object)KEY_PARTICIPANT_RELATIONTYPE_ORG);
        participant.put(KEY_PARTICIPANT_VALUE, (Object)orgId);
        participant.put("orgRelation", (Object)"all");
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        return participant;
    }

    private JSONObject createOrgRelationAllStaffParticipantJson(String referenceOrg, String property) {
        return this.createOrgRelationParticipantJson(referenceOrg, "all", property);
    }

    private JSONObject createOrgRelationManagerParticipantJson(String referenceOrg, String property) {
        return this.createOrgRelationParticipantJson(referenceOrg, "manager", property);
    }

    private JSONObject createOrgRelationDirectParticipantJson(String referenceOrg, String property) {
        return this.createOrgRelationParticipantJson(referenceOrg, "direct", property);
    }

    private JSONObject createOrgRelationParticipantJson(String referenceOrg, String orgRelation, String property) {
        JSONObject participant = new JSONObject();
        participant.put(KEY_PARTICIPANT_ID, (Object)BpmnDiffUtil.getListElementId("participant"));
        participant.put(KEY_PARTICIPANT_TYPE, (Object)KEY_PARTICIPANT_TYPE_RELATION);
        participant.put(KEY_PARTICIPANT_RELATIONTYPE, (Object)KEY_PARTICIPANT_RELATIONTYPE_ORG);
        participant.put(KEY_PARTICIPANT_REFERENCEORG, (Object)referenceOrg);
        participant.put("orgRelation", (Object)orgRelation);
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        return participant;
    }

    private String getNullBusinessKeyExceptionMsg(String entityNumber, Long procInstId) {
        return String.format("Business primary key is empty, entity code: %1$s, process instance: %2$s", entityNumber, procInstId);
    }
}

