/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;

public class NoCodeProcessPlugin
implements IWorkflowPlugin {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String LOCKSTATUS = "LockStatus";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notify(AgentExecution execution) {
        String event = execution.getEventName();
        String entityNumber = execution.getEntityNumber();
        String businessKey = execution.getBusinessKey();
        DynamicObject dynObj = WfUtils.findBusinessObject(businessKey, entityNumber);
        if (dynObj == null) {
            this.log.debug(String.format("%s %s may have been deleted.", entityNumber, businessKey));
            return;
        }
        if (dynObj.getDynamicObjectType().getProperty(LOCKSTATUS) == null) {
            this.log.debug(String.format("%s has no attribute %s", entityNumber, LOCKSTATUS));
            return;
        }
        Object lockStatus = dynObj.get(LOCKSTATUS);
        switch (event) {
            case "start": {
                if ("1".equals(lockStatus)) {
                    this.log.debug(String.format("The value of lockstatus is already 1. %s-%s", entityNumber, businessKey));
                    return;
                }
                dynObj.set(LOCKSTATUS, (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
                return;
            }
            case "end": 
            case "terminate": 
            case "procInstWithdraw": {
                if ("0".equals(lockStatus)) {
                    this.log.debug(String.format("The value of lockstatus is already 0. %s-%s", entityNumber, businessKey));
                    return;
                }
                QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)businessKey), new QFilter("scope", "=", (Object)true)};
                DynamicObjectCollection result = QueryServiceHelper.query((String)"wf_execution", (String)"activityid,processinstanceid", (QFilter[])filters);
                int size = result.size();
                if (size > 1) {
                    int count = 0;
                    for (DynamicObject execEntity : result) {
                        String actId;
                        long procInstId = execEntity.getLong("processinstanceid");
                        if (procInstId == execution.getProcessInstanceId() || (actId = execEntity.getString("activityid")) == null || !actId.matches(".+(EndTerminateEvent|EndNoneEvent)\\d+")) continue;
                        ++count;
                    }
                    if (count == size - 1) {
                        this.log.debug(String.format("lock and update billState. %s-%s", entityNumber, businessKey));
                        String lockKey = String.format("wf/nocode/updateBillLockState/%s", businessKey);
                        try (DLock lock = DLock.create((String)lockKey, (String)"update bill lockState 0").fastMode();){
                            boolean canLock = lock.tryLock(60000L);
                            if (!canLock) return;
                            dynObj.set(LOCKSTATUS, (Object)"0");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
                            return;
                        }
                    } else {
                        this.log.debug(String.format("There are other processes for this bill. %s-%s", entityNumber, businessKey));
                    }
                    return;
                }
                dynObj.set(LOCKSTATUS, (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
                return;
            }
        }
    }
}

