/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeNodeJsonConverter;

public abstract class AbstractNoCodeArtificialTaskJsonConverter
extends NoCodeNodeJsonConverter {
    protected static final String KEY_PROCESSINGPAGE = "processingPage";
    protected static final String KEY_SUBJECT = "subject";
    protected static final String KEY_SUBJECT_ID = "id";
    protected static final String KEY_SUBJECT_TYPE = "type";
    protected static final String KEY_SUBJECT_TIMING = "timing";
    protected static final String KEY_SUBJECT_CUSTOMSUBJECT = "customSubject";
    private static final String KEY_PARTICIPANT_GROUP = "participant";
    private static final String KEY_PARTICIPANT_PROPERTY = "participant";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        properties.put("allowSendTodo", (Object)false);
        properties.put(KEY_PROCESSINGPAGE, (Object)"bos_nocode_approvalpage");
        this.convertParticipantsToWorkflowJson(noCodeJson, properties);
        this.convertSubjectsToWorkflowJson(noCodeJson, properties);
        return workflowJson;
    }

    private void convertParticipantsToWorkflowJson(JSONObject noCodeJson, JSONObject properties) {
        Object noCodeParticipant = noCodeJson.get((Object)this.getNoCodeParticipantProperty());
        if (noCodeParticipant == null) {
            return;
        }
        JSONObject participantGroup = new JSONObject();
        this.setNoCodePropertyValue(properties, "participant", noCodeParticipant);
        JSONArray participants = this.createParticipantJson(noCodeParticipant, "participant");
        participantGroup.put("participant", (Object)participants);
        properties.put("participant", (Object)participantGroup);
    }

    protected String getNoCodeParticipantProperty() {
        return "participant";
    }

    protected void convertSubjectsToWorkflowJson(JSONObject noCodeJson, JSONObject properties) {
        String subject = noCodeJson.getString("taskSubject");
        if (WfUtils.isNotEmpty(subject)) {
            String content = this.getContentExpression(subject);
            JSONArray subjects = new JSONArray();
            subjects.add((Object)this.createSubjectJson("normal", content));
            subjects.add((Object)this.createSubjectJson("reject", content));
            properties.put(KEY_SUBJECT, (Object)subjects);
            this.setNoCodePropertyValue(properties, KEY_SUBJECT, subject);
        }
    }

    private JSONObject createSubjectJson(String timing, String subject) {
        JSONObject taskSubject = new JSONObject();
        taskSubject.put(KEY_SUBJECT_ID, (Object)BpmnDiffUtil.getListElementId(KEY_SUBJECT));
        taskSubject.put(KEY_SUBJECT_TYPE, (Object)"expression");
        taskSubject.put(KEY_SUBJECT_TIMING, (Object)timing);
        taskSubject.put(KEY_SUBJECT_CUSTOMSUBJECT, (Object)subject);
        return taskSubject;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        this.convertParticipantsToNoCodeJson(noCodeJson, properties);
        this.convertSubjectsToNoCodeJson(noCodeJson, properties);
        return noCodeJson;
    }

    private void convertParticipantsToNoCodeJson(JSONObject noCodeJson, JSONObject properties) {
        JSONObject participantGroup = properties.getJSONObject("participant");
        if (participantGroup == null || participantGroup.isEmpty()) {
            return;
        }
        JSONArray participants = participantGroup.getJSONArray("participant");
        if (participants == null || participants.isEmpty()) {
            return;
        }
        Object noCodeParticipant = this.getNoCodeParticipant(participants, "participant", properties);
        noCodeJson.put(this.getNoCodeParticipantProperty(), noCodeParticipant);
    }

    private void convertSubjectsToNoCodeJson(JSONObject noCodeJson, JSONObject properties) {
        String taskSubject = (String)this.getNoCodePropertyValue(properties, KEY_SUBJECT);
        if (taskSubject == null) {
            taskSubject = (String)this.getNoCodePropertyValue(properties, this.getOriginalContentKey(KEY_SUBJECT));
        }
        if (taskSubject != null) {
            noCodeJson.put("taskSubject", (Object)taskSubject);
        }
    }
}

