/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.nocode.converter.INoCodeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;

public abstract class AbstractNoCodeJsonConverter
implements INoCodeJsonConverter {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = new JSONObject();
        String itemId = noCodeJson.getString("itemId");
        String number = noCodeJson.getString("number");
        String type = noCodeJson.getString("_Type_");
        String stencilType = this.getStencilType(type);
        workflowJson.put("stencil", (Object)this.createStencilJson(stencilType));
        workflowJson.put("resourceId", (Object)itemId);
        JSONObject properties = new JSONObject();
        properties.put("itemId", (Object)itemId);
        properties.put("number", (Object)number);
        Long templateId = this.getTemplateId();
        if (templateId != null) {
            properties.put("template", (Object)type);
            properties.put("templateId", (Object)templateId);
        }
        workflowJson.put("properties", (Object)properties);
        return workflowJson;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject noCodeJson = new JSONObject();
        JSONObject properties = workflowJson.getJSONObject("properties");
        JSONObject stencil = workflowJson.getJSONObject("stencil");
        String resourceId = workflowJson.getString("resourceId");
        noCodeJson.put("id", (Object)resourceId);
        noCodeJson.put("itemId", (Object)resourceId);
        String number = properties.getString("number");
        noCodeJson.put("number", (Object)number);
        String stencilType = this.getStencilIdFromJson(stencil);
        String template = properties.getString("template");
        if (WfUtils.isNotEmpty(template)) {
            stencilType = template;
        }
        noCodeJson.put("_Type_", (Object)stencilType);
        return noCodeJson;
    }

    protected JSONObject createStencilJson(String stencilType) {
        JSONObject result = new JSONObject();
        result.put("id", (Object)stencilType);
        return result;
    }

    protected String getStencilIdFromJson(JSONObject stencil) {
        return stencil.getString("id");
    }

    protected JSONArray createOutgoingJson(String ... resourceIds) {
        JSONArray outgoings = new JSONArray();
        for (String resourceId : resourceIds) {
            outgoings.add((Object)this.createResourceIdJson(resourceId));
        }
        return outgoings;
    }

    protected JSONObject createResourceIdJson(String resourceId) {
        JSONObject result = new JSONObject();
        result.put("resourceId", (Object)resourceId);
        return result;
    }

    protected String getResourceIdFromJson(JSONObject json) {
        return json.getString("resourceId");
    }

    protected String getStencilType(String type) {
        return type;
    }

    protected Long getTemplateId() {
        return null;
    }
}

