/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.nocode.converter.AbstractNoCodeArtificialTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeConverterConstants;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;

public class NoCodeAuditTaskJsonConverter
extends AbstractNoCodeArtificialTaskJsonConverter {
    private static final String KEY_DECISIONOPTIONS = "decisionOptions";
    private static final String KEY_DECISION_ID = "id";
    private static final String KEY_DECISION_NAME = "name";
    private static final String KEY_DECISION_NUMBER = "number";
    private static final String KEY_DECISION_AUDITTYPE = "auditType";
    private static final String KEY_DECISION_DEFAULTDECISION = "defaultDecision";
    private static final String KEY_ENTITYID = "entityId";
    private static final String KEY_ENTITYNAME = "entityName";
    private static final String KEY_ENTITYNUMBER = "entityNumber";
    private static final String KEY_ENDTYPE = "endType";
    private static final String KEY_BILLSETTING = "billSetting";
    private static final String KEY_BILLSETTING_FORMKEY = "formKey";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        this.convertDecisionOptions(noCodeJson, properties);
        properties.put(KEY_ENTITYID, (Object)context.getEntityId());
        properties.put(KEY_ENTITYNAME, (Object)context.getEntityName());
        properties.put(KEY_ENTITYNUMBER, (Object)context.getEntityNumber());
        properties.put(KEY_ENDTYPE, (Object)"pc");
        JSONObject billSetting = new JSONObject();
        billSetting.put(KEY_BILLSETTING_FORMKEY, (Object)context.getEntityNumber());
        properties.put(KEY_BILLSETTING, (Object)billSetting);
        Boolean allowTransfer = noCodeJson.getBoolean("allowTransfer");
        properties.put("allowTransfer", (Object)Boolean.TRUE.equals(allowTransfer));
        this.convertInMessages(noCodeJson, properties);
        String approveMsgRequired = noCodeJson.getString("notifyMsgMustInput");
        this.setNoCodePropertyValue(properties, "notifyMsgMustInput", approveMsgRequired);
        return workflowJson;
    }

    private void convertDecisionOptions(JSONObject noCodeJson, JSONObject properties) {
        JSONArray decisionOptions = null;
        JSONArray decisionItems = noCodeJson.getJSONArray(KEY_DECISIONOPTIONS);
        if (decisionItems == null) {
            decisionOptions = this.createDecisionOptionsJson();
        } else {
            for (Object item : decisionItems) {
                JSONObject decisionItem = (JSONObject)item;
                String id = decisionItem.getString(KEY_DECISION_ID);
                if (WfUtils.isEmpty(id)) {
                    id = BpmnDiffUtil.getListElementId(KEY_DECISIONOPTIONS);
                    decisionItem.put(KEY_DECISION_ID, (Object)id);
                }
                this.convertOutMessages(noCodeJson, properties, decisionItem);
                if (decisionItem.get((Object)"terminateFlow") == null || !decisionItem.getBoolean("terminateFlow").booleanValue()) continue;
                String originAuditType = decisionItem.getString(KEY_DECISION_AUDITTYPE);
                decisionItem.put("originAuditType", (Object)originAuditType);
                decisionItem.put(KEY_DECISION_AUDITTYPE, (Object)"terminate");
            }
            decisionOptions = decisionItems;
        }
        properties.put(KEY_DECISIONOPTIONS, (Object)decisionOptions);
    }

    private void convertInMessages(JSONObject noCodeJson, JSONObject properties) {
        JSONArray inMsgs = new JSONArray();
        String content = noCodeJson.getString("notifyApproverMsg");
        if (WfUtils.isNotEmpty(content)) {
            JSONObject inMsg = super.createInMsgJson(noCodeJson, "notifyApproverMsg", "taskReceived");
            JSONArray receivers = new JSONArray();
            receivers.add((Object)this.createPersonRelationSelfParticipantJson("PROC_currentParticipant", "inMsg.receiver"));
            inMsg.put("receiver", (Object)receivers);
            inMsgs.add((Object)inMsg);
        }
        properties.put("inMsg", (Object)inMsgs);
    }

    private void convertOutMessages(JSONObject noCodeJson, JSONObject properties, JSONObject decisionItem) {
        String content;
        JSONArray outMsgs;
        JSONArray jSONArray = outMsgs = properties.getJSONArray("outMsg") == null || properties.getJSONArray("outMsg").isEmpty() ? new JSONArray() : properties.getJSONArray("outMsg");
        if (decisionItem.get((Object)"sendMessage") != null && decisionItem.getBoolean("sendMessage").booleanValue() && WfUtils.isNotEmpty(content = decisionItem.getString("message"))) {
            String auditType = decisionItem.getString(KEY_DECISION_AUDITTYPE);
            outMsgs.add((Object)this.createNotifyProcInitiatorMsgJson(decisionItem, "message", decisionItem.getString(KEY_DECISION_NUMBER)));
        }
        properties.put("outMsg", (Object)outMsgs);
    }

    private JSONObject createNotifyProcInitiatorMsgJson(JSONObject noCodeJson, String contentProperty, String sendEvent) {
        JSONObject outMsg = super.createOutMsgJson(noCodeJson, contentProperty, sendEvent);
        JSONArray receivers = new JSONArray();
        receivers.add((Object)this.createPersonRelationSelfParticipantJson("PROC_initiator", "outMsg.receiver"));
        outMsg.put("receiver", (Object)receivers);
        return outMsg;
    }

    private JSONArray createDecisionOptionsJson() {
        JSONArray decisionOptions = new JSONArray();
        String name = WFMultiLangConstants.getAgreeName().toString();
        decisionOptions.add((Object)this.createDecisionJson(name, "Consent", "approve", true));
        name = WFMultiLangConstants.getRejectTerminalName().toString();
        decisionOptions.add((Object)this.createDecisionJson(name, "Terminate", "terminate", false));
        return decisionOptions;
    }

    private JSONObject createDecisionJson(String name, String number, String type, boolean isDefault) {
        JSONObject decision = new JSONObject();
        decision.put(KEY_DECISION_ID, (Object)BpmnDiffUtil.getListElementId(KEY_DECISIONOPTIONS));
        decision.put(KEY_DECISION_NAME, (Object)name);
        decision.put(KEY_DECISION_NUMBER, (Object)number);
        decision.put(KEY_DECISION_AUDITTYPE, (Object)type);
        if (isDefault) {
            decision.put(KEY_DECISION_DEFAULTDECISION, (Object)true);
        }
        return decision;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject notifyInitiatorRejectMsg;
        JSONObject notifyInitiatorPassMsg;
        JSONObject notifyApproverMsg;
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        Boolean allowTransfer = properties.getBoolean("allowTransfer");
        noCodeJson.put("allowTransfer", (Object)Boolean.TRUE.equals(allowTransfer));
        JSONArray decisionOptions = properties.getJSONArray(KEY_DECISIONOPTIONS);
        if (decisionOptions != null && !decisionOptions.isEmpty()) {
            for (Object decisionOption : decisionOptions) {
                JSONObject decisionItem = (JSONObject)decisionOption;
                if (decisionItem.get((Object)"terminateFlow") == null || !decisionItem.getBoolean("terminateFlow").booleanValue()) continue;
                decisionItem.put(KEY_DECISION_AUDITTYPE, (Object)decisionItem.getString("originAuditType"));
                decisionItem.remove((Object)"originAuditType");
            }
            noCodeJson.put(KEY_DECISIONOPTIONS, (Object)decisionOptions);
        }
        if ((notifyApproverMsg = this.getOriginalMsgInfo(properties.getJSONArray("inMsg"), "taskReceived", "notifyApproverMsg")) != null) {
            noCodeJson.put("notifyApproverMsg", (Object)notifyApproverMsg);
        }
        if ((notifyInitiatorPassMsg = this.getOriginalMsgInfo(properties.getJSONArray("outMsg"), "Consent", "notifyInitiatorPassMsg")) != null) {
            noCodeJson.put("notifyInitiatorPassMsg", (Object)notifyInitiatorPassMsg);
        }
        if ((notifyInitiatorRejectMsg = this.getOriginalMsgInfo(properties.getJSONArray("outMsg"), "Terminate", "notifyInitiatorRejectMsg")) != null) {
            noCodeJson.put("notifyInitiatorRejectMsg", (Object)notifyInitiatorRejectMsg);
        }
        String approveMsgRequired = (String)this.getNoCodePropertyValue(properties, "notifyMsgMustInput");
        noCodeJson.put("notifyMsgMustInput", (Object)approveMsgRequired);
        return noCodeJson;
    }

    private JSONObject getOriginalMsgInfo(JSONArray msgs, String sendEvt, String contentProperty) {
        if (msgs == null || msgs.isEmpty()) {
            return null;
        }
        for (Object item : msgs) {
            JSONObject msg = (JSONObject)item;
            if (!sendEvt.equals(msg.getString("sendevt"))) continue;
            JSONObject ret = new JSONObject();
            ret.put("check", (Object)msg.getBoolean("notify"));
            ret.put("content", (Object)msg.getString(this.getOriginalContentKey(contentProperty)));
            return ret;
        }
        return null;
    }

    @Override
    protected String getStencilType(String type) {
        return "AuditTask";
    }

    @Override
    protected Long getTemplateId() {
        return NoCodeConverterConstants.TEMPLATEID_NOCODEAUDITTASK;
    }
}

