/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.nocode.NoCodeEntityInfo;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeNodeJsonConverter;

public class NoCodeAutoMicroServiceJsonConverter
extends NoCodeNodeJsonConverter {
    private static final String AUTOSERVICE = "autoService";
    private static final String FETCHTYPE = "fetchType";
    private static final String INPARAMS = "inParams";
    private static final String OUTPARAMS = "outParams";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String entityNumber = noCodeJson.getString("formId");
        if (WfUtils.isNotEmpty(entityNumber)) {
            try {
                NoCodeEntityInfo entityInfo = context.getEntityInfo(entityNumber);
                properties.put("entityId", (Object)entityInfo.getEntityId());
                properties.put("entityNumber", (Object)entityInfo.getEntityNumber());
                properties.put("entityName", (Object)entityInfo.getEntityName());
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        JSONObject autoService = noCodeJson.getJSONObject(AUTOSERVICE);
        properties.put(AUTOSERVICE, (Object)autoService);
        String fetchType = noCodeJson.getString(FETCHTYPE);
        properties.put(FETCHTYPE, (Object)fetchType);
        JSONArray inParams = noCodeJson.getJSONArray(INPARAMS);
        properties.put(INPARAMS, (Object)inParams);
        JSONArray outParams = noCodeJson.getJSONArray(OUTPARAMS);
        properties.put(OUTPARAMS, (Object)outParams);
        JSONArray settings = noCodeJson.getJSONArray("setting");
        if (settings != null) {
            this.setNoCodePropertyValue(properties, "setting", settings);
        }
        return workflowJson;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject autoService;
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String entityNumber = properties.getString("entityNumber");
        if (WfUtils.isNotEmpty(entityNumber)) {
            noCodeJson.put("formId", (Object)entityNumber);
        }
        if ((autoService = properties.getJSONObject(AUTOSERVICE)) != null) {
            autoService.put("_Type_", (Object)"AutoService");
        }
        noCodeJson.put(AUTOSERVICE, (Object)autoService);
        String fetchType = properties.getString(FETCHTYPE);
        noCodeJson.put(FETCHTYPE, (Object)fetchType);
        JSONArray inParams = properties.getJSONArray(INPARAMS);
        noCodeJson.put(INPARAMS, (Object)inParams);
        JSONArray outParams = properties.getJSONArray(OUTPARAMS);
        noCodeJson.put(OUTPARAMS, (Object)outParams);
        JSONArray settings = (JSONArray)this.getNoCodePropertyValue(properties, "setting");
        if (settings != null) {
            noCodeJson.put("setting", (Object)settings);
        }
        return noCodeJson;
    }
}

