/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.nocode.converter.INoCodeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeApiInvokeAutoTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeAuditTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeCalculateTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeEdgeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeEndEventJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeGatewayJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeJudgeTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeNewBillAutoTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeNodeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeNotifyTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeProcessJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeQueryDataTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeStartEventJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeUpdateBillAutoTaskJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeUserTaskJsonConverter;

public class NoCodeJsonConverterFactory {
    private static Map<String, INoCodeJsonConverter> converters = new HashMap<String, INoCodeJsonConverter>();

    private NoCodeJsonConverterFactory() {
    }

    public static INoCodeJsonConverter getConverter(String type) {
        INoCodeJsonConverter converter = converters.get(type);
        if (converter != null) {
            return converter;
        }
        return new NoCodeNodeJsonConverter();
    }

    static {
        converters.put("BPMNDiagram", new NoCodeProcessJsonConverter());
        converters.put("SequenceFlow", new NoCodeEdgeJsonConverter());
        converters.put("StartSignalEvent", new NoCodeStartEventJsonConverter());
        converters.put("StartTimerEvent", new NoCodeStartEventJsonConverter());
        converters.put("EndNoneEvent", new NoCodeEndEventJsonConverter());
        converters.put("NoCodeAuditTask", new NoCodeAuditTaskJsonConverter());
        converters.put("NoCodeUserTask", new NoCodeUserTaskJsonConverter());
        converters.put("NoCodeNotifyTask", new NoCodeNotifyTaskJsonConverter());
        converters.put("NoCodeGateway", new NoCodeGatewayJsonConverter());
        converters.put("NoCodeJudgeTask", new NoCodeJudgeTaskJsonConverter());
        converters.put("QueryDataAutoTask", new NoCodeQueryDataTaskJsonConverter());
        converters.put("CalculateAutoTask", new NoCodeCalculateTaskJsonConverter());
        converters.put("NewBillAutoTask", new NoCodeNewBillAutoTaskJsonConverter());
        converters.put("UpdateBillAutoTask", new NoCodeUpdateBillAutoTaskJsonConverter());
        converters.put("ApiInvokeAutoTask", new NoCodeApiInvokeAutoTaskJsonConverter());
    }
}

