/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSONObject;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.nocode.converter.NoCodeConverterConstants;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;
import kd.bos.workflow.nocode.converter.NoCodeNodeJsonConverter;

public class NoCodeJudgeTaskJsonConverter
extends NoCodeNodeJsonConverter {
    private static final String JUDGECONDITION = "judgeCondition";
    private static final String JUDGECONDITION_TYPE = "type";
    private static final String JUDGECONDITION_PROPERTY = "property";
    private static final String JUDGECONDITION_ELEMENTID = "elementid";
    private static final String JUDGECONDITION_EXPRESSION = "expression";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        Object filter;
        Integer seq;
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String expression = noCodeJson.getString(JUDGECONDITION_EXPRESSION);
        if (WfUtils.isNotEmpty(expression)) {
            String itemId = noCodeJson.getString("itemId");
            JSONObject judgeCondition = this.createJudgeConditionJson(itemId, expression);
            properties.put(JUDGECONDITION, (Object)judgeCondition);
        }
        if ((seq = noCodeJson.getInteger("seq")) != null) {
            properties.put("seq", (Object)seq);
        }
        if ((filter = noCodeJson.get((Object)"filter")) != null) {
            this.setNoCodePropertyValue(properties, "filter", filter);
        }
        return workflowJson;
    }

    private JSONObject createJudgeConditionJson(String elementId, String expression) {
        JSONObject condition = new JSONObject();
        condition.put(JUDGECONDITION_ELEMENTID, (Object)elementId);
        this.setNoCodePropertyValue(condition, JUDGECONDITION_EXPRESSION, expression);
        condition.put(JUDGECONDITION_EXPRESSION, (Object)this.getContentExpression(expression, false));
        condition.put(JUDGECONDITION_TYPE, (Object)ConditionalRuleType.JUDGECONDITION.name());
        condition.put(JUDGECONDITION_PROPERTY, (Object)JUDGECONDITION);
        return condition;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        Integer seq;
        Object filter;
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        JSONObject judgeCondition = properties.getJSONObject(JUDGECONDITION);
        if (judgeCondition != null && !judgeCondition.isEmpty()) {
            String expression = (String)this.getNoCodePropertyValue(judgeCondition, JUDGECONDITION_EXPRESSION);
            if (expression == null) {
                expression = (String)this.getNoCodePropertyValue(judgeCondition, this.getOriginalContentKey(JUDGECONDITION_EXPRESSION));
            }
            noCodeJson.put(JUDGECONDITION_EXPRESSION, (Object)expression);
        }
        if ((filter = this.getNoCodePropertyValue(properties, "filter")) != null) {
            noCodeJson.put("filter", filter);
        }
        if ((seq = properties.getInteger("seq")) != null) {
            noCodeJson.put("seq", (Object)seq);
        }
        return noCodeJson;
    }

    @Override
    protected String getStencilType(String type) {
        return "JudgeTask";
    }

    @Override
    protected Long getTemplateId() {
        return NoCodeConverterConstants.TEMPLATEID_NOCODEJUDGETASK;
    }
}

