/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.nocode.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.lang.Lang;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.nocode.converter.AbstractNoCodeJsonConverter;
import kd.bos.workflow.nocode.converter.NoCodeJsonConvertContext;

public class NoCodeNodeJsonConverter
extends AbstractNoCodeJsonConverter {
    protected static final String KEY_EXTENDED_DATA = "extData";
    protected static final String KEY_NOCODE_DATA = "noCodeData";
    protected static final String KEY_NOCODEPROP_TPL = "noCode_%s";
    protected static final String KEY_PARTICIPANT_ID = "id";
    protected static final String KEY_PARTICIPANT_TYPE = "type";
    protected static final String KEY_PARTICIPANT_VALUE = "value";
    protected static final String KEY_PARTICIPANT_PROPERTY = "property";
    protected static final String KEY_PARTICIPANT_RELATIONTYPE = "relationType";
    protected static final String KEY_PARTICIPANT_REFERENCEPERSON = "referencePerson";
    protected static final String KEY_PARTICIPANT_REPORTTYPE = "reportType";
    protected static final String KEY_PARTICIPANT_PERSONRELATION = "personRelation";
    protected static final String KEY_PARTICIPANT_REFERENCEORG = "referenceOrg";
    protected static final String KEY_PARTICIPANT_ORGRELATION = "orgRelation";
    protected static final String KEY_PARTICIPANT_ENTITYPREFIX = "ENTI_%s";
    protected static final String KEY_PARTICIPANT_PROCPREFIX = "PROC_%s";
    protected static final String KEY_PARTICIPANT_TYPE_PERSON = "person";
    protected static final String KEY_PARTICIPANT_TYPE_RELATION = "relation";
    protected static final String KEY_PARTICIPANT_RELATIONTYPE_ORG = "org";
    protected static final String KEY_PARTICIPANT_RELATIONTYPE_PERSON = "person";
    protected static final String KEY_INMSG = "inMsg";
    protected static final String KEY_OUTMSG = "outMsg";
    protected static final String KEY_MSG_ID = "id";
    protected static final String KEY_MSG_NOTIFY = "notify";
    protected static final String KEY_MSG_CONTENT = "content";
    protected static final String KEY_MSG_SENDEVT = "sendevt";
    protected static final String KEY_MSG_RECEIVER = "receiver";
    protected static final String KEY_MSG_NOTIFYTYPE = "notifytype";
    protected static final String KEY_MSG_MESSAGETYPE = "messagetype";
    protected static final String KEY_EXPRESSION_ORIGINALCONTENT_TPL = "_%s_";
    protected static final String KEY_PROPERTY_INMSG_RECEIVER = "inMsg.receiver";
    protected static final String KEY_PROPERTY_OUTMSG_RECEIVER = "outMsg.receiver";

    @Override
    public JSONObject convertToWorkflowJson(NoCodeJsonConvertContext context, JSONObject noCodeJson) {
        Object designerData;
        JSONObject workflowJson = super.convertToWorkflowJson(context, noCodeJson);
        JSONObject bounds = this.convertWorkflowBounds(noCodeJson);
        if (!bounds.isEmpty()) {
            workflowJson.put("bounds", (Object)bounds);
        }
        JSONObject properties = workflowJson.getJSONObject("properties");
        String name = noCodeJson.getString("name");
        properties.put("name", (Object)name);
        String documentation = noCodeJson.getString("documentation");
        properties.put("documentation", (Object)documentation);
        String parentId = noCodeJson.getString("parentId");
        this.setNoCodePropertyValue(properties, "parentId", parentId);
        String parentIds = noCodeJson.getString("parentIds");
        if (parentIds != null) {
            this.setNoCodePropertyValue(properties, "parentIds", parentIds);
        }
        if ((designerData = noCodeJson.get((Object)"designerData")) != null) {
            this.setNoCodePropertyValue(properties, "designerData", designerData);
        }
        return workflowJson;
    }

    private JSONObject convertWorkflowBounds(JSONObject noCodeJson) {
        JSONObject bounds = new JSONObject();
        JSONObject size = noCodeJson.getJSONObject("size");
        JSONObject position = noCodeJson.getJSONObject("position");
        if (size == null || position == null) {
            return bounds;
        }
        double width = size.getDoubleValue("width");
        double height = size.getDoubleValue("height");
        double x = position.getDoubleValue("x");
        double y = position.getDoubleValue("y");
        JSONObject upperLeft = new JSONObject();
        upperLeft.put("x", (Object)x);
        upperLeft.put("y", (Object)y);
        bounds.put("upperLeft", (Object)upperLeft);
        JSONObject lowerRight = new JSONObject();
        lowerRight.put("x", (Object)(x + width));
        lowerRight.put("y", (Object)(y + height));
        bounds.put("lowerRight", (Object)lowerRight);
        return bounds;
    }

    @Override
    public JSONObject convertToNoCodeJson(NoCodeJsonConvertContext context, JSONObject workflowJson) {
        JSONObject bounds;
        Object designerData;
        JSONObject noCodeJson = super.convertToNoCodeJson(context, workflowJson);
        JSONObject properties = workflowJson.getJSONObject("properties");
        String name = properties.getString("name");
        noCodeJson.put("name", (Object)name);
        String documentation = properties.getString("documentation");
        if (documentation != null) {
            noCodeJson.put("documentation", (Object)documentation);
        }
        String parentId = (String)this.getNoCodePropertyValue(properties, "parentId");
        noCodeJson.put("parentId", (Object)parentId);
        Object parentIds = this.getNoCodePropertyValue(properties, "parentIds");
        if (parentIds != null) {
            noCodeJson.put("parentIds", parentIds);
        }
        if ((designerData = this.getNoCodePropertyValue(properties, "designerData")) != null) {
            noCodeJson.put("designerData", designerData);
        }
        if ((bounds = workflowJson.getJSONObject("bounds")) != null) {
            this.convertBounds(noCodeJson, bounds);
        }
        return noCodeJson;
    }

    private void convertBounds(JSONObject noCodeJson, JSONObject bounds) {
        JSONObject upperLeft = bounds.getJSONObject("upperLeft");
        JSONObject lowerRight = bounds.getJSONObject("lowerRight");
        if (upperLeft == null || lowerRight == null) {
            return;
        }
        double ulX = upperLeft.getDoubleValue("x");
        double ulY = upperLeft.getDoubleValue("y");
        JSONObject position = new JSONObject();
        position.put("x", (Object)ulX);
        position.put("y", (Object)ulY);
        position.put("_Type_", (Object)"PositionInfo");
        noCodeJson.put("position", (Object)position);
        double lrX = lowerRight.getDoubleValue("x");
        double lrY = lowerRight.getDoubleValue("y");
        JSONObject size = new JSONObject();
        size.put("width", (Object)(lrX - ulX));
        size.put("height", (Object)(lrY - ulY));
        size.put("_Type_", (Object)"SizeInfo");
        noCodeJson.put("size", (Object)size);
    }

    protected Object getNoCodePropertyValue(JSONObject properties, String property) {
        JSONObject noCodeData;
        Object value = null;
        String oriProperty = property;
        if (property.indexOf(46) > -1) {
            property = property.replace('.', '#');
        }
        String noCodeProperty = String.format(KEY_NOCODEPROP_TPL, property);
        JSONObject extData = properties.getJSONObject(KEY_EXTENDED_DATA);
        if (extData != null && (value = extData.get((Object)noCodeProperty)) == null) {
            value = extData.get((Object)String.format(KEY_NOCODEPROP_TPL, oriProperty));
        }
        if (value == null && (noCodeData = properties.getJSONObject(KEY_NOCODE_DATA)) != null) {
            value = noCodeData.get((Object)property);
        }
        return value;
    }

    protected void setNoCodePropertyValue(JSONObject properties, String property, Object value) {
        JSONObject extDataData = properties.getJSONObject(KEY_EXTENDED_DATA);
        if (extDataData == null) {
            extDataData = new JSONObject();
            properties.put(KEY_EXTENDED_DATA, (Object)extDataData);
        }
        if (property.indexOf(46) > -1) {
            property = property.replace('.', '#');
        }
        String noCodeProperty = String.format(KEY_NOCODEPROP_TPL, property);
        extDataData.put(noCodeProperty, value);
    }

    protected JSONArray createParticipantJson(Object noCodeParticipants, String property) {
        JSONArray participants = new JSONArray();
        if (noCodeParticipants instanceof JSONObject) {
            String extParticipantJson;
            JSONObject orgRelation;
            JSONObject personRelation;
            JSONObject noCodeParticipant = JSON.parseObject((String)((JSONObject)noCodeParticipants).toJSONString());
            JSONArray persons = noCodeParticipant.getJSONArray("person");
            if (persons != null && !persons.isEmpty()) {
                for (Object item : persons) {
                    String personId = (String)item;
                    participants.add((Object)this.createPersonParticipantJson(personId, property));
                }
            }
            if ((personRelation = noCodeParticipant.getJSONObject(KEY_PARTICIPANT_PERSONRELATION)) != null && !personRelation.isEmpty()) {
                this.addPersonRelationMacroParticipants(participants, personRelation, "oneself", property);
                this.addPersonRelationMacroParticipants(participants, personRelation, "indirectSuperior", property);
                this.addPersonRelationMacroParticipants(participants, personRelation, "superior", property);
                this.addPersonRelationMacroParticipants(participants, personRelation, "equal", property);
                this.addPersonRelationMacroParticipants(participants, personRelation, "subordinate", property);
            }
            if ((orgRelation = noCodeParticipant.getJSONObject(KEY_PARTICIPANT_ORGRELATION)) != null && !orgRelation.isEmpty()) {
                this.addOrgRelationFixedOrgParticipants(participants, orgRelation, "all", property);
                this.addOrgRelationFixedOrgParticipants(participants, orgRelation, "manager", property);
                this.addOrgRelationFixedOrgParticipants(participants, orgRelation, "direct", property);
            }
            if ((extParticipantJson = this.getExtendParticipantJsonString(noCodeParticipant, property)) != null) {
                JSONObject extendParticipant = new JSONObject();
                extendParticipant.put("id", (Object)BpmnDiffUtil.getListElementId("participant"));
                extendParticipant.put(KEY_PARTICIPANT_TYPE, (Object)"NoCodeParticipant");
                extendParticipant.put(KEY_PARTICIPANT_VALUE, (Object)extParticipantJson);
                extendParticipant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
                participants.add((Object)extendParticipant);
            }
        } else {
            this.log.warn(String.format("invalid value: %s, %s", noCodeParticipants != null ? noCodeParticipants.getClass() : "null", noCodeParticipants));
        }
        return participants;
    }

    private String getExtendParticipantJsonString(JSONObject noCodeParticipant, String property) {
        JSONObject personRelation = noCodeParticipant.getJSONObject(KEY_PARTICIPANT_PERSONRELATION);
        JSONObject orgRelation = noCodeParticipant.getJSONObject(KEY_PARTICIPANT_ORGRELATION);
        JSONArray appRole = noCodeParticipant.getJSONArray("appRole");
        if (!(personRelation != null && !personRelation.isEmpty() || orgRelation != null && !orgRelation.isEmpty() || appRole != null && !appRole.isEmpty())) {
            return null;
        }
        JSONObject data = new JSONObject();
        JSONObject participant = new JSONObject();
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        participant.put(KEY_PARTICIPANT_PERSONRELATION, (Object)personRelation);
        participant.put(KEY_PARTICIPANT_ORGRELATION, (Object)orgRelation);
        participant.put("appRole", (Object)appRole);
        data.put("participant", (Object)participant);
        return data.toJSONString();
    }

    private void addPersonRelationMacroParticipants(JSONArray participants, JSONObject personRelation, String relationType, String property) {
        JSONObject config = personRelation.getJSONObject(relationType);
        if (config == null) {
            return;
        }
        JSONArray macros = (JSONArray)config.remove((Object)"_macros_");
        if (macros == null || macros.isEmpty()) {
            return;
        }
        switch (relationType) {
            case "oneself": {
                for (Object macro : macros) {
                    participants.add((Object)this.createPersonRelationSelfParticipantJson(String.format(KEY_PARTICIPANT_PROCPREFIX, macro), property));
                }
                break;
            }
            case "indirectSuperior": {
                for (Object macro : macros) {
                    participants.add((Object)this.createPersonRelationIndirectSuperiorParticipantJson(String.format(KEY_PARTICIPANT_PROCPREFIX, macro), property));
                }
                break;
            }
            case "superior": {
                for (Object macro : macros) {
                    participants.add((Object)this.createPersonRelationSuperiorParticipantJson(String.format(KEY_PARTICIPANT_PROCPREFIX, macro), property));
                }
                break;
            }
            case "equal": {
                for (Object macro : macros) {
                    participants.add((Object)this.createPersonRelationEqualParticipantJson(String.format(KEY_PARTICIPANT_PROCPREFIX, macro), property));
                }
                break;
            }
            case "subordinate": {
                for (Object macro : macros) {
                    participants.add((Object)this.createPersonRelationSubordinateParticipantJson(String.format(KEY_PARTICIPANT_PROCPREFIX, macro), property));
                }
                break;
            }
        }
    }

    protected JSONObject createPersonRelationSelfParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "self", property);
    }

    private JSONObject createPersonRelationIndirectSuperiorParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "indirectSuperior", property);
    }

    private JSONObject createPersonRelationSuperiorParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "superior", property);
    }

    private JSONObject createPersonRelationEqualParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "equal", property);
    }

    private JSONObject createPersonRelationSubordinateParticipantJson(String referencePerson, String property) {
        return this.createPersonRelationParticipantJson(referencePerson, "subordinate", property);
    }

    private JSONObject createPersonRelationParticipantJson(String referencePerson, String personRelation, String property) {
        JSONObject participant = new JSONObject();
        participant.put("id", (Object)BpmnDiffUtil.getListElementId("participant"));
        participant.put(KEY_PARTICIPANT_TYPE, (Object)KEY_PARTICIPANT_TYPE_RELATION);
        participant.put(KEY_PARTICIPANT_RELATIONTYPE, (Object)"person");
        participant.put(KEY_PARTICIPANT_REFERENCEPERSON, (Object)referencePerson);
        participant.put(KEY_PARTICIPANT_PERSONRELATION, (Object)personRelation);
        participant.put(KEY_PARTICIPANT_REPORTTYPE, (Object)"admin_org");
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        return participant;
    }

    protected String getParticipantSourceDataKey(String property) {
        return String.format("%s_%s", property.replace(".", "_"), "sourceData");
    }

    protected Object getNoCodeParticipant(JSONArray participants, String property, JSONObject properties) {
        Object noCodeParticipants = this.getNoCodePropertyValue(properties, property);
        if (noCodeParticipants != null) {
            return noCodeParticipants;
        }
        JSONArray persons = new JSONArray();
        JSONArray selfPersons = new JSONArray();
        JSONArray orgAllPersons = new JSONArray();
        block8: for (Object item : participants) {
            JSONObject participant = (JSONObject)item;
            String type = participant.getString(KEY_PARTICIPANT_TYPE);
            String value = participant.getString(KEY_PARTICIPANT_VALUE);
            String perfix = String.format(KEY_PARTICIPANT_ENTITYPREFIX, "");
            switch (type) {
                case "person": {
                    persons.add((Object)value);
                    break;
                }
                case "relation": {
                    String relationType = participant.getString(KEY_PARTICIPANT_RELATIONTYPE);
                    if ("person".equals(relationType)) {
                        String personRelation = participant.getString(KEY_PARTICIPANT_PERSONRELATION);
                        String referencePerson = participant.getString(KEY_PARTICIPANT_REFERENCEPERSON);
                        if (!"self".equals(personRelation)) continue block8;
                        selfPersons.add((Object)referencePerson.replace(perfix, ""));
                        break;
                    }
                    if (!KEY_PARTICIPANT_RELATIONTYPE_ORG.equals(relationType)) break;
                    String orgRelation = participant.getString(KEY_PARTICIPANT_ORGRELATION);
                    String referenceOrg = participant.getString(KEY_PARTICIPANT_REFERENCEORG);
                    if (!"all".equals(orgRelation)) continue block8;
                    orgAllPersons.add((Object)referenceOrg.replace(perfix, ""));
                    break;
                }
            }
        }
        JSONObject noCodeParticipant = new JSONObject();
        noCodeParticipant.put("person", (Object)persons);
        if (!selfPersons.isEmpty()) {
            JSONObject personRelation = new JSONObject();
            personRelation.put("self", (Object)selfPersons);
            noCodeParticipant.put(KEY_PARTICIPANT_PERSONRELATION, (Object)personRelation);
        }
        if (!orgAllPersons.isEmpty()) {
            JSONObject orgRelation = new JSONObject();
            orgRelation.put("all", (Object)orgAllPersons);
            noCodeParticipant.put(KEY_PARTICIPANT_ORGRELATION, (Object)orgRelation);
        }
        Object sourceData = this.getNoCodePropertyValue(properties, this.getParticipantSourceDataKey(property));
        noCodeParticipant.put("sourceData", sourceData);
        return noCodeParticipant;
    }

    private void addOrgRelationFixedOrgParticipants(JSONArray participants, JSONObject orgRelation, String relationType, String property) {
        JSONObject config = orgRelation.getJSONObject(relationType);
        if (config == null) {
            return;
        }
        JSONArray orgs = (JSONArray)config.remove((Object)"_orgs_");
        if (orgs == null || orgs.isEmpty()) {
            return;
        }
        switch (relationType) {
            case "all": {
                for (Object org : orgs) {
                    participants.add((Object)this.createOrgRelationFixedOrgAllStaffParticipantJson(String.valueOf(org), property));
                }
                break;
            }
            case "manager": {
                for (Object org : orgs) {
                    participants.add((Object)this.createOrgRelationFixedOrgManagerParticipantJson(String.valueOf(org), property));
                }
                break;
            }
            case "direct": {
                for (Object org : orgs) {
                    participants.add((Object)this.createOrgRelationFixedOrgDirectParticipantJson(String.valueOf(org), property));
                }
                break;
            }
        }
    }

    protected JSONObject createPersonParticipantJson(String personId, String property) {
        JSONObject participant = new JSONObject();
        participant.put("id", (Object)BpmnDiffUtil.getListElementId("participant"));
        participant.put(KEY_PARTICIPANT_TYPE, (Object)"person");
        participant.put(KEY_PARTICIPANT_VALUE, (Object)personId);
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        return participant;
    }

    private JSONObject createOrgRelationFixedOrgAllStaffParticipantJson(String orgId, String property) {
        return this.createOrgRelationParticipantJson(orgId, "all", property);
    }

    private JSONObject createOrgRelationFixedOrgManagerParticipantJson(String orgId, String property) {
        return this.createOrgRelationParticipantJson(orgId, "manager", property);
    }

    private JSONObject createOrgRelationFixedOrgDirectParticipantJson(String orgId, String property) {
        return this.createOrgRelationParticipantJson(orgId, "direct", property);
    }

    private JSONObject createOrgRelationParticipantJson(String orgId, String orgRelation, String property) {
        JSONObject participant = new JSONObject();
        participant.put("id", (Object)BpmnDiffUtil.getListElementId("participant"));
        participant.put(KEY_PARTICIPANT_TYPE, (Object)KEY_PARTICIPANT_TYPE_RELATION);
        participant.put(KEY_PARTICIPANT_RELATIONTYPE, (Object)KEY_PARTICIPANT_RELATIONTYPE_ORG);
        participant.put(KEY_PARTICIPANT_VALUE, (Object)orgId);
        participant.put(KEY_PARTICIPANT_ORGRELATION, (Object)orgRelation);
        participant.put(KEY_PARTICIPANT_PROPERTY, (Object)property);
        return participant;
    }

    protected String getParticipantId(JSONArray participants) {
        if (participants == null || participants.isEmpty()) {
            return null;
        }
        JSONObject participant = participants.getJSONObject(0);
        return participant.getString(KEY_PARTICIPANT_VALUE);
    }

    protected JSONObject createInMsgJson(JSONObject noCodeJson, String contentProperty, String sendEvent) {
        return this.createMsgJson(noCodeJson, contentProperty, sendEvent, true);
    }

    protected JSONObject createOutMsgJson(JSONObject noCodeJson, String contentProperty, String sendEvent) {
        return this.createMsgJson(noCodeJson, contentProperty, sendEvent, false);
    }

    private JSONObject createMsgJson(JSONObject noCodeJson, String contentProperty, String sendEvent, boolean isInMsg) {
        JSONObject item = new JSONObject();
        item.put("id", (Object)BpmnDiffUtil.getListElementId(isInMsg ? KEY_INMSG : KEY_OUTMSG));
        boolean notify = true;
        String content = null;
        Object contentValue = noCodeJson.get((Object)contentProperty);
        if (contentValue instanceof JSONObject) {
            JSONObject contentInfo = (JSONObject)contentValue;
            content = contentInfo.getString(KEY_MSG_CONTENT);
            notify = contentInfo.getBooleanValue("check");
        } else {
            content = String.valueOf(contentValue);
        }
        item.put(KEY_MSG_NOTIFY, (Object)notify);
        item.put(this.getOriginalContentKey(contentProperty), (Object)content);
        JSONObject jsonContent = new JSONObject();
        jsonContent.put(Lang.get().name(), (Object)this.getContentExpression(content));
        item.put(KEY_MSG_CONTENT, (Object)jsonContent.toJSONString());
        String notifyType = noCodeJson.getString(KEY_MSG_NOTIFYTYPE);
        item.put(KEY_MSG_NOTIFYTYPE, (Object)notifyType);
        item.put(KEY_MSG_SENDEVT, (Object)sendEvent);
        item.put(KEY_MSG_MESSAGETYPE, (Object)KEY_MSG_NOTIFY);
        return item;
    }

    protected String getContentExpression(String content) {
        return this.getContentExpression(content, true);
    }

    protected String getContentExpression(String content, boolean substring) {
        content = String.format("%s%s", "#NOCODE#", content);
        if (!substring) {
            return this.replaceDollarSymbol(content);
        }
        int index = content.indexOf("@@");
        if (index > -1) {
            return this.replaceDollarSymbol(content.substring(0, index));
        }
        return this.replaceDollarSymbol(content);
    }

    protected String getOriginalContentKey(String contentProperty) {
        return String.format(KEY_EXPRESSION_ORIGINALCONTENT_TPL, contentProperty.toUpperCase());
    }

    private String replaceDollarSymbol(String content) {
        content = content.replaceAll("\\$(\\{proc\\..+?\\})", "$1");
        return content;
    }
}

